/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.protocol.actions;

import com.google.common.base.Preconditions;
import fr.ifremer.tutti.persistence.entities.protocol.TuttiProtocol;
import fr.ifremer.tutti.service.protocol.ProtocolCaracteristicsImportExportService;
import fr.ifremer.tutti.ui.swing.content.protocol.EditProtocolCaracteristicsRowModel;
import fr.ifremer.tutti.ui.swing.content.protocol.EditProtocolUI;
import fr.ifremer.tutti.ui.swing.content.protocol.EditProtocolUIHandler;
import fr.ifremer.tutti.ui.swing.content.protocol.EditProtocolUIModel;
import fr.ifremer.tutti.ui.swing.util.actions.LongActionSupport;
import java.io.File;
import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;

public class ImportProtocolCaracteristicAction
extends LongActionSupport<EditProtocolUIModel, EditProtocolUI, EditProtocolUIHandler> {
    private static final Log log = LogFactory.getLog(ImportProtocolCaracteristicAction.class);
    private File file;
    protected TuttiProtocol protocol;

    public ImportProtocolCaracteristicAction(EditProtocolUIHandler handler) {
        super(handler, true);
    }

    public boolean prepareAction() throws Exception {
        boolean doAction = super.prepareAction();
        if (doAction) {
            this.file = this.chooseFile(I18n.t((String)"tutti.editProtocol.title.choose.caracteristicImportFile", (Object[])new Object[0]), I18n.t((String)"tutti.editProtocol.action.importProtocolCaracteristicFile", (Object[])new Object[0]), new String[]{"^.*\\.csv", I18n.t((String)"tutti.common.file.csv", (Object[])new Object[0])});
            doAction = this.file != null;
        }
        return doAction;
    }

    public void releaseAction() {
        this.file = null;
        super.releaseAction();
    }

    @Override
    public void doAction() throws Exception {
        Preconditions.checkNotNull((Object)this.file);
        if (log.isInfoEnabled()) {
            log.info((Object)("Will import protocol caracteristic file: " + this.file));
        }
        EditProtocolUIModel model = (EditProtocolUIModel)this.getModel();
        this.protocol = model.toEntity();
        ProtocolCaracteristicsImportExportService service = this.getContext().getProtocolCaracteristicsImportExportService();
        service.importProtocolCaracteristic(this.file, this.protocol, model.getAllCaracteristic());
    }

    public void postSuccessAction() {
        super.postSuccessAction();
        ((EditProtocolUIHandler)this.handler).addDoubleListListeners();
        try {
            ((EditProtocolUIModel)this.getModel()).fromEntity(this.protocol);
        }
        finally {
            ((EditProtocolUIHandler)this.handler).removeDoubleListListeners();
        }
        List caracteristicMapping = this.protocol.getCaracteristicMapping();
        List<EditProtocolCaracteristicsRowModel> caracteristicsRowModels = ((EditProtocolUIHandler)this.getHandler()).toProtocolCaracteristicRows(caracteristicMapping);
        ((EditProtocolUIModel)this.getModel()).setCaracteristicMappingRows(Collections.emptyList());
        ((EditProtocolUIModel)this.getModel()).setCaracteristicMappingRows(caracteristicsRowModels);
        ((EditProtocolUIHandler)this.getHandler()).getCaracteristicMappingTableModel().setRows(caracteristicsRowModels);
        this.sendMessage(I18n.t((String)"tutti.flash.info.caracteristic.imported.in.protocol", (Object[])new Object[]{this.file}));
    }
}

