/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.protocol.zones.actions;

import fr.ifremer.tutti.ui.swing.content.protocol.EditProtocolUIModel;
import fr.ifremer.tutti.ui.swing.content.protocol.zones.ZoneEditorUI;
import fr.ifremer.tutti.ui.swing.content.protocol.zones.tree.node.StrataNode;
import fr.ifremer.tutti.ui.swing.content.protocol.zones.tree.node.SubStrataNode;
import fr.ifremer.tutti.ui.swing.util.actions.SimpleActionSupport;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JTree;
import javax.swing.tree.TreePath;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RemoveStratasAction
extends SimpleActionSupport<ZoneEditorUI> {
    private static final Log log = LogFactory.getLog(RemoveStratasAction.class);

    public RemoveStratasAction(ZoneEditorUI zoneEditorUI) {
        super(zoneEditorUI);
        this.setEnabled(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void onActionPerformed(ZoneEditorUI zoneEditorUI) {
        JTree zonesTree = zoneEditorUI.getZonesTree();
        TreePath[] selectedStratas = zonesTree.getSelectionPaths();
        if (selectedStratas == null) {
            if (log.isInfoEnabled()) {
                log.info((Object)"No selected stratas, nor subStratas selected");
            }
            return;
        }
        Set<StrataNode> stratasNodeToRemove = this.getStrataNodesToRemove(selectedStratas);
        Set<SubStrataNode> subStratasNodeToRemove = this.getSubStrataNodesToRemove(selectedStratas, stratasNodeToRemove);
        EditProtocolUIModel model = zoneEditorUI.getModel();
        model.setModifyingZones(true);
        try {
            stratasNodeToRemove.forEach(model::unselectStrataNode);
            subStratasNodeToRemove.forEach(model::unselectSubStrataNode);
        }
        finally {
            model.setModifyingZones(false);
        }
        zonesTree.setSelectionPath(selectedStratas[0].getParentPath());
    }

    protected Set<StrataNode> getStrataNodesToRemove(TreePath[] selectedStratas) {
        HashSet<StrataNode> result = new HashSet<StrataNode>();
        for (TreePath selectedStrata : selectedStratas) {
            Object node = selectedStrata.getLastPathComponent();
            if (!(node instanceof StrataNode)) continue;
            StrataNode strataNode = (StrataNode)node;
            if (log.isInfoEnabled()) {
                log.info((Object)("found strata " + strataNode + " to remove"));
            }
            result.add((StrataNode)node);
        }
        return result;
    }

    protected Set<SubStrataNode> getSubStrataNodesToRemove(TreePath[] selectedStratas, Set<StrataNode> stratasNodeToRemove) {
        HashSet<SubStrataNode> result = new HashSet<SubStrataNode>();
        for (TreePath selectedStrata : selectedStratas) {
            SubStrataNode subStrataNode;
            Object node = selectedStrata.getLastPathComponent();
            if (!(node instanceof SubStrataNode) || stratasNodeToRemove.contains((subStrataNode = (SubStrataNode)node).getParent())) continue;
            if (log.isInfoEnabled()) {
                log.info((Object)("found subStrata " + subStrataNode + " to remove"));
            }
            result.add(subStrataNode);
        }
        return result;
    }
}

