/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.operation.catches.benthos.frequency.actions;

import com.google.common.collect.Lists;
import fr.ifremer.tutti.ui.swing.content.operation.catches.benthos.frequency.BenthosFrequencyLogRowModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.benthos.frequency.BenthosFrequencyLogsTableModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.benthos.frequency.BenthosFrequencyRowModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.benthos.frequency.BenthosFrequencyTableModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.benthos.frequency.BenthosFrequencyUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.benthos.frequency.BenthosFrequencyUIHandler;
import fr.ifremer.tutti.ui.swing.content.operation.catches.benthos.frequency.BenthosFrequencyUIModel;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXTable;
import org.nuiton.i18n.I18n;

public class ApplyBenthosFrequencyRafaleAction {
    private static final Log log = LogFactory.getLog(ApplyBenthosFrequencyRafaleAction.class);
    private final BenthosFrequencyUI ui;

    public ApplyBenthosFrequencyRafaleAction(BenthosFrequencyUI ui) {
        this.ui = ui;
    }

    public void applyRafaleStep(Float step, boolean fromIchtyometer) {
        int rowIndex;
        float aroundLengthStep;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Will apply rafale step: " + step));
        }
        BenthosFrequencyUIModel model = this.ui.getModel();
        BenthosFrequencyUIHandler handler = this.ui.getHandler();
        BenthosFrequencyTableModel tableModel = handler.getTableModel();
        Map<Float, BenthosFrequencyRowModel> rowsByStep = model.getRowCache();
        BenthosFrequencyRowModel row = rowsByStep.get(Float.valueOf(aroundLengthStep = model.getLengthStep(step.floatValue())));
        if (row != null) {
            Integer number = row.getNumber();
            row.setNumber((number == null ? 0 : number) + 1);
            rowIndex = tableModel.updateRow(row);
        } else {
            row = tableModel.createNewRow();
            row.setLengthStep(Float.valueOf(aroundLengthStep));
            row.setNumber(1);
            row.setValid(handler.isRowValid(row));
            ArrayList steps = Lists.newArrayList(rowsByStep.keySet());
            steps.add(Float.valueOf(aroundLengthStep));
            Collections.sort(steps);
            rowIndex = steps.indexOf(Float.valueOf(aroundLengthStep));
            tableModel.addNewRow(rowIndex, row);
        }
        Integer totalNumber = model.getTotalNumber();
        if (totalNumber == null) {
            totalNumber = 0;
        }
        model.setTotalNumber(totalNumber + 1);
        this.ui.getTable().scrollRowToVisible(rowIndex);
        if (fromIchtyometer) {
            String unit = model.getLengthStepCaracteristicUnit();
            handler.showInformationMessage(I18n.t((String)"tutti.editBenthosFrequencies.addMeasure", (Object[])new Object[]{step, Float.valueOf(aroundLengthStep), unit}));
        }
        JXTable logsTable = this.ui.getLogsTable();
        BenthosFrequencyLogsTableModel logsTableModel = (BenthosFrequencyLogsTableModel)((Object)logsTable.getModel());
        BenthosFrequencyLogRowModel newRow = logsTableModel.createNewRow();
        newRow.setDate(new Date());
        newRow.setLengthStep(step);
        logsTableModel.addNewRow(0, (Serializable)((Object)newRow));
    }
}

