package fr.ifremer.tutti.ui.swing.content.operation.fishing;

/*
 * #%L
 * Tutti :: UI
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2016 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.persistence.entities.referential.Caracteristic;
import fr.ifremer.tutti.ui.swing.content.operation.EditFishingOperationUI;
import fr.ifremer.tutti.ui.swing.util.TuttiUI;
import fr.ifremer.tutti.ui.swing.util.TuttiUIUtil;
import java.awt.Color;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.ListSelectionModel;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.Table;
import jaxx.runtime.swing.editor.bean.BeanFilterableComboBox;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXTable;
import static org.nuiton.i18n.I18n.t;

public class VesselUseFeatureTabUI extends Table implements TuttiUI<VesselUseFeatureTabUIModel, VesselUseFeatureTabUIHandler>, JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_ADD_ROW_ENABLED = "addRow.enabled";
    public static final String BINDING_NEW_ROW_KEY_ENABLED = "newRowKey.enabled";
    public static final String BINDING_REMOVE_CARACTERISTIC_MENU_ENABLED = "removeCaracteristicMenu.enabled";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAK1VS29bRRSeOLHjvCgQJS1KkRIoVYvEJCyKEAHaxMTg1EmrOEURXrTjeyf2pOOZYebc5EZWET+BnwB7NkjsWCEWrFmwQfwFhFiwRZy51/ED35IqqhdX1pxzvvOY833z7R8k7yxZOWJxTG2kQLQ53d44OLjXOOIBfMRdYIUBbUn6G8uRXJ3MhL1zB+T1etWHr3bDV0u6bbTiaiB6vUqmHZxK7lqcA5BXhyMC51ZrPfN6bCJ7htorKgv167/+zH0VfvlNjpDYYHVFbGX5vKh+JxNVkhMhkJcx0zFblUw1sQwrVBPrnfNnJcmc22Vt/jn5gkxWScEwi2BAXnv2lhOMJD42QCav7bOG5GtAKoeWikPL29xSiAAEjQR1J5idBloBglFtuGUgtKKHwrW85VPuHJcPHC9zBpHlCPagYkyCXwCSb+uQSyC7zw17xwP2E0yDr/6+NhH2suhHFHdxt5PDHa6ivvdlrEAf8xKzLABuhQMReA8gC0Oh/qwCvO3DLvWipxQ/2dMnd/kpkFtDt5qG8VDgnGmDM0U38VMWEpP4+vA6GnpTxx5oqodXYGGIeEDmh5Jv4ny0Gnadu7ZdC6yW8j5T/q4uD0X0TcNRC8ejE5QcyJK2TXqEnHkM2qQgMd0+SKw+dMng3i4NdYiMoH1G9Fd2rE7yNsJjIFfqoyTaQ1NKnyv/oY8HTKz/LM7/+sPv35fPODOJuRcyXQcoj7tsrN8YED71pZQwEQi5usPMep1MYd+oF4keXM0orNY1Y3GY7yUfTn04/YS5FkLkJ3/78afFR7+Mk1yZTEvNwjLz/hUyBS2LU9AyjM3tO0lFsydF/L7oa8MtQdvJHndeVibARjzG7q9mdN8roTH189/zte/unE1gDCt65anu/SnkPyMFoaRQPNGNriRk6sSMcTwKdZ/6WWJAPIWyF7dLoevJ982stgstLpot7Dl3ay2OvBtNWvH/1ogxiD3TSDbb76n8X7gckGL3epFqC+lV8nCItqhcXPkSUS8XOys9alLhttoGTm/cfDJaxiCHzTk9jaO4YDoUpIqXKDKObB1M+kann7PJodYt0svGjZvLKx8sq0jKJ0jdh060jeQbCRaQR52LaGFaiRvRxI1EQlJsGvjLzGy7KzXn9TyBWpROG+E2WfC4aXWksNlCp9tN31zWlp+Z5zolLVH6NqsbpbvoVXTaQqo1+UMmkQtkrhfoFdyPr4r3WBs8lLRW2f24uvWwtlXdKu1X7u1m9pKtaue1hnI4K95+V+0ofAKU35/b6fAz0brzphnvBW33EIb2Y7bBIGi9hW1w4J76PEY2vHOxJEgW0FruC7OfwLx3wVpBmMGdvd5J3mPkyN6o81bqhcQZXdrguS5tmvxZ9vZpD/Z5t42CVPTv8P6pwbt44f2QAVtuCBViWR+OJBrz30XE/BdMlIrkfgoAAA==";
    private static final Log log = LogFactory.getLog(VesselUseFeatureTabUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JButton addRow;
    protected final VesselUseFeatureTabUIHandler handler = createHandler();
    protected VesselUseFeatureTabUIModel model;
    protected BeanFilterableComboBox<Caracteristic> newRowKey;
    protected JMenuItem removeCaracteristicMenu;
    protected JPopupMenu tablePopup;
    protected JXTable vesselUseFeatureTable;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JScrollPane $JScrollPane0;
    private VesselUseFeatureTabUI $Table0 = this;

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public VesselUseFeatureTabUI(EditFishingOperationUI parentUI) {
        TuttiUIUtil.setParentUI(this, parentUI);
            $initialize();
    }

    public VesselUseFeatureTabUI() {
        $initialize();
    }

    public VesselUseFeatureTabUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doKeyPressed__on__vesselUseFeatureTable(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.openRowMenu(event, tablePopup);
    }

    public void doMouseClicked__on__vesselUseFeatureTable(MouseEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.autoSelectRowInTable(event, tablePopup);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JButton getAddRow() {
        return addRow;
    }

    public VesselUseFeatureTabUIHandler getHandler() {
        return handler;
    }

    public VesselUseFeatureTabUIModel getModel() {
        return model;
    }

    public BeanFilterableComboBox<Caracteristic> getNewRowKey() {
        return newRowKey;
    }

    public JMenuItem getRemoveCaracteristicMenu() {
        return removeCaracteristicMenu;
    }

    public JPopupMenu getTablePopup() {
        return tablePopup;
    }

    public JXTable getVesselUseFeatureTable() {
        return vesselUseFeatureTable;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JScrollPane get$JScrollPane0() {
        return $JScrollPane0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToTablePopup() {
        if (!allComponentsCreated) {
            return;
        }
        tablePopup.add(removeCaracteristicMenu);
    }

    protected void createAddRow() {
        $objectMap.put("addRow", addRow = new JButton());
        
        addRow.setName("addRow");
        addRow.putClientProperty("simpleAction", fr.ifremer.tutti.ui.swing.content.operation.fishing.actions.VesselUseFeatureAddRowAction.class);
    }

    protected VesselUseFeatureTabUIHandler createHandler() {
        return new VesselUseFeatureTabUIHandler();
    }

    protected void createModel() {
        $objectMap.put("model", model = getContextValue(VesselUseFeatureTabUIModel.class));
    }

    protected void createNewRowKey() {
        $objectMap.put("newRowKey", newRowKey = new BeanFilterableComboBox<Caracteristic>(this));
        
        newRowKey.setName("newRowKey");
        newRowKey.setProperty("selectedCaracteristic");
        newRowKey.setShowReset(true);
    }

    protected void createRemoveCaracteristicMenu() {
        $objectMap.put("removeCaracteristicMenu", removeCaracteristicMenu = new JMenuItem());
        
        removeCaracteristicMenu.setName("removeCaracteristicMenu");
        removeCaracteristicMenu.setText(t("tutti.vesselUseFeatureTable.action.removeCaracteristic"));
        removeCaracteristicMenu.setToolTipText(t("tutti.vesselUseFeatureTable.action.removeCaracteristic.tip"));
        removeCaracteristicMenu.putClientProperty("simpleAction", fr.ifremer.tutti.ui.swing.content.operation.fishing.actions.VesselUseFeatureRemoveRowAction.class);
    }

    protected void createTablePopup() {
        $objectMap.put("tablePopup", tablePopup = new JPopupMenu());
        
        tablePopup.setName("tablePopup");
    }

    protected void createVesselUseFeatureTable() {
        $objectMap.put("vesselUseFeatureTable", vesselUseFeatureTable = new JXTable());
        
        vesselUseFeatureTable.setName("vesselUseFeatureTable");
        vesselUseFeatureTable.setSortable(false);
        vesselUseFeatureTable.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyPressed", this, "doKeyPressed__on__vesselUseFeatureTable"));
        vesselUseFeatureTable.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseClicked", this, "doMouseClicked__on__vesselUseFeatureTable"));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        // inline complete setup of $Table0
        add(newRowKey, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        add(addRow, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        add($JScrollPane0, new GridBagConstraints(0, 1, 2, 1, 0.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        addChildrenToTablePopup();
        // inline complete setup of $JScrollPane0
        $JScrollPane0.getViewport().add(vesselUseFeatureTable);
        
        // apply 3 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 7 property setters
        newRowKey.setBeanType(Caracteristic.class);
        removeCaracteristicMenu.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.vesselUseFeatureTable.action.removeCaracteristic.mnemonic"),'Z'));
        removeCaracteristicMenu.setIcon(SwingUtil.createActionIcon("batch-delete"));
        addRow.setIcon(SwingUtil.createActionIcon("add"));
        vesselUseFeatureTable.setSelectionBackground(null);
        vesselUseFeatureTable.setSelectionForeground(Color.BLACK);
        vesselUseFeatureTable.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        handler.beforeInit(this);
        $objectMap.put("$Table0", $Table0);
        createModel();
        createTablePopup();
        createRemoveCaracteristicMenu();
        createNewRowKey();
        createAddRow();
        // inline creation of $JScrollPane0
        $objectMap.put("$JScrollPane0", $JScrollPane0 = new JScrollPane());
        
        $JScrollPane0.setName("$JScrollPane0");
        createVesselUseFeatureTable();
        // inline creation of $Table0
        setName("$Table0");
        
        // registers 3 data bindings
        $registerDefaultBindings();
        $completeSetup();
        handler.afterInit(this);
    }

    private void $registerDefaultBindings() {
        // register 3 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_REMOVE_CARACTERISTIC_MENU_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("removeCaracteristicEnabled", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    removeCaracteristicMenu.setEnabled(model.isRemoveCaracteristicEnabled());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("removeCaracteristicEnabled", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_NEW_ROW_KEY_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (newRowKey != null) {
                    newRowKey.addPropertyChangeListener("empty", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (newRowKey != null) {
                    newRowKey.setEnabled(!newRowKey.isEmpty());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (newRowKey != null) {
                    newRowKey.removePropertyChangeListener("empty", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_ADD_ROW_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (newRowKey != null) {
                    newRowKey.addPropertyChangeListener("selectedItem", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (newRowKey != null) {
                    addRow.setEnabled(newRowKey.getSelectedItem() != null);
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (newRowKey != null) {
                    newRowKey.removePropertyChangeListener("selectedItem", this);
                }
            }
        });
    }

}