/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.persistence.entities.referential;

import com.google.common.base.Predicate;
import fr.ifremer.tutti.persistence.entities.referential.AbstractCaracteristics;
import fr.ifremer.tutti.persistence.entities.referential.Caracteristic;
import fr.ifremer.tutti.persistence.entities.referential.CaracteristicType;

public class Caracteristics
extends AbstractCaracteristics {
    public static CaracteristicType getType(boolean isAlpha, boolean isQualitative) {
        CaracteristicType result = isAlpha ? CaracteristicType.TEXT : (isQualitative ? CaracteristicType.QUALITATIVE : CaracteristicType.NUMBER);
        return result;
    }

    public static boolean isNumberCaracteristic(Caracteristic c) {
        return CaracteristicType.NUMBER == c.getCaracteristicType();
    }

    public static boolean isTextCaracteristic(Caracteristic c) {
        return CaracteristicType.TEXT == c.getCaracteristicType();
    }

    public static boolean isQualitativeCaracteristic(Caracteristic c) {
        return CaracteristicType.QUALITATIVE == c.getCaracteristicType();
    }

    public static Predicate<Caracteristic> newSampleCategoryModelPredicate() {
        return new SampleCategoryCaracteristicPredicate();
    }

    public static class SampleCategoryCaracteristicPredicate
    implements Predicate<Caracteristic> {
        public boolean apply(Caracteristic input) {
            return !CaracteristicType.TEXT.equals((Object)input.getCaracteristicType());
        }
    }
}

