/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.operation.catches;

import com.google.common.collect.Sets;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.ui.swing.content.operation.catches.CatchCustomTab;
import fr.ifremer.tutti.ui.swing.content.operation.catches.EditCatchesSvgHandler;
import fr.ifremer.tutti.ui.swing.content.operation.catches.EditCatchesUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.EditCatchesUIModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.accidental.create.CreateAccidentalBatchUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.benthos.BenthosBatchRowModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.benthos.BenthosBatchTableModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.benthos.frequency.BenthosFrequencyCellComponent;
import fr.ifremer.tutti.ui.swing.content.operation.catches.benthos.frequency.BenthosFrequencyUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.individualobservation.create.CreateIndividualObservationBatchUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.marinelitter.create.CreateMarineLitterBatchUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.SpeciesBatchRowModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.SpeciesBatchTableModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency.SpeciesFrequencyCellComponent;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency.SpeciesFrequencyUI;
import fr.ifremer.tutti.ui.swing.util.AbstractTuttiTabContainerUIHandler;
import fr.ifremer.tutti.ui.swing.util.TuttiBeanMonitor;
import fr.ifremer.tutti.util.Weights;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.TableColumn;
import jaxx.runtime.swing.CardLayout2Ext;
import jaxx.runtime.swing.Table;
import jaxx.runtime.validator.swing.SwingValidator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.JXTitledPanel;
import org.nuiton.i18n.I18n;
import org.nuiton.jaxx.application.swing.ApplicationUI;
import org.nuiton.jaxx.application.swing.tab.TabContentModel;
import org.nuiton.jaxx.application.swing.tab.TabHandler;
import org.nuiton.validator.bean.simple.SimpleBeanValidator;

public class EditCatchesUIHandler
extends AbstractTuttiTabContainerUIHandler<EditCatchesUIModel, EditCatchesUI>
implements TabHandler {
    public static final String MAIN_CARD = "main";
    public static final String CREATE_BATCH_CARD = "createBatch";
    public static final String SPLIT_BATCH_CARD = "splitBatch";
    public static final String ADD_SAMPLE_CATEGORY_BATCH_CARD = "addSampleCategoryBatch";
    public static final String EDIT_FREQUENCY_CARD = "editFrequency";
    public static final String EDIT_CARACTERISTICS_CARD = "caracteristicsCard";
    public static final String CAROUSSEL_TREMIE_VESSEL = "carousselTremieVessel";
    public static final String CLASSIC_VESSEL = "classicVessel";
    private static final Log log = LogFactory.getLog(EditCatchesUIHandler.class);
    private TuttiBeanMonitor<EditCatchesUIModel> catchBatchMonitor;
    private final PropertyChangeListener totalWeightRejectedListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            EditCatchesUIModel source = (EditCatchesUIModel)evt.getSource();
            Float totalWeight = (Float)evt.getNewValue();
            if (totalWeight != null && Weights.isEqualWeight((float)totalWeight.floatValue(), (float)0.0f)) {
                source.setCatchTotalRejectedWeight(null);
            }
        }
    };
    private EditCatchesSvgHandler editCatchesSvgHandler;

    public void beforeInit(EditCatchesUI ui) {
        super.beforeInit((ApplicationUI)ui);
        this.catchBatchMonitor = new TuttiBeanMonitor("marineLitterTotalWeight", "speciesTotalSortedWeight", "speciesTotalInertWeight", "speciesTotalLivingNotItemizedWeight", "benthosTotalSortedWeight", "benthosTotalInertWeight", "benthosTotalLivingNotItemizedWeight");
        EditCatchesUIModel model = ui.getContextValue(EditCatchesUIModel.class);
        model.setValidationContext(this.getContext().getValidationContext());
        this.listModelIsModify(model);
        this.catchBatchMonitor.setBean(model);
        this.editCatchesSvgHandler = new EditCatchesSvgHandler(this.getContext(), ui, model);
    }

    public void afterInit(EditCatchesUI ui) {
        ui.getBenthosTabSplitBatch().getModel().setSplitMode(true);
        ui.getBenthosTabAddSampleCategoryBatch().getModel().setSplitMode(false);
        ui.getSpeciesTabSplitBatch().getModel().setSplitMode(true);
        ui.getSpeciesTabAddSampleCategoryBatch().getModel().setSplitMode(false);
        this.initUI(ui);
        EditCatchesUIModel model = (EditCatchesUIModel)this.getModel();
        this.changeValidatorContext(model.getValidationContext(), this.getValidator());
        this.listenValidationTableHasNoFatalError((SimpleBeanValidator)this.getValidator(), model);
        this.setCustomTab2(0, model, Sets.newHashSet((Object[])new String[]{"catchTotalWeight", "catchTotalRejectedWeight", "speciesTotalSortedWeight", "speciesTotalInertWeight", "speciesTotalLivingNotItemizedWeight", "benthosTotalSortedWeight", "benthosTotalInertWeight", "benthosTotalLivingNotItemizedWeight", "marineLitterTotalWeight"}));
        this.setCustomTab(1, ui.getSpeciesTabContent().getModel());
        this.setCustomTab(2, ui.getBenthosTabContent().getModel());
        this.setCustomTab(3, ui.getMarineLitterTabContent().getModel());
        this.setCustomTab(4, ui.getIndividualObservationTabContent().getModel());
        this.setCustomTab(5, ui.getAccidentalTabContent().getModel());
        this.getTabPanel().setSelectedIndex(1);
        this.getTabPanel().addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                EditCatchesUIHandler.this.closeAttachments();
            }
        });
    }

    public void setCustomTab2(int index, TabContentModel model, Set<String> modifyPropertyNames) {
        JTabbedPane tabPanel = this.getTabPanel();
        tabPanel.setTabComponentAt(index, (Component)((Object)CatchCustomTab.newCustomTab(model, this, modifyPropertyNames)));
    }

    public void closeAttachments() {
        ((EditCatchesUI)this.ui).getCatchesCaracteristicsAttachmentsButton().onCloseUI();
        ((EditCatchesUI)this.ui).getSpeciesTabContent().getSpeciesBatchAttachmentsButton().onCloseUI();
        ((EditCatchesUI)this.ui).getBenthosTabContent().getBenthosBatchAttachmentsButton().onCloseUI();
        ((EditCatchesUI)this.ui).getMarineLitterTabContent().getMarineLitterBatchAttachmentsButton().onCloseUI();
        ((EditCatchesUI)this.ui).getIndividualObservationTabContent().getIndividualObservationBatchAttachmentsButton().onCloseUI();
        ((EditCatchesUI)this.ui).getAccidentalTabContent().getAccidentalBatchAttachmentsButton().onCloseUI();
    }

    protected JComponent getComponentToFocus() {
        return null;
    }

    public void onCloseUI() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("closing: " + this.ui));
        }
        ((EditCatchesUI)this.ui).getCatchesCaracteristicsAttachmentsButton().onCloseUI();
        this.editCatchesSvgHandler.clearSVG();
        this.closeUI(((EditCatchesUI)this.ui).getSpeciesTabContent());
        this.closeUI(((EditCatchesUI)this.ui).getSpeciesTabFrequencyEditor());
        this.closeUI(((EditCatchesUI)this.ui).getBenthosTabContent());
        this.closeUI(((EditCatchesUI)this.ui).getBenthosTabFrequencyEditor());
        this.closeUI(((EditCatchesUI)this.ui).getMarineLitterTabContent());
        this.closeUI(((EditCatchesUI)this.ui).getAccidentalTabContent());
        this.closeUI(((EditCatchesUI)this.ui).getIndividualObservationTabContent());
    }

    public SwingValidator<EditCatchesUIModel> getValidator() {
        return ((EditCatchesUI)this.ui).getValidator();
    }

    @Override
    protected Set<String> getPropertiesToIgnore() {
        Set<String> result = super.getPropertiesToIgnore();
        result.addAll(Sets.newHashSet((Object[])new String[]{"catchTotalComputedWeight", "catchTotalUnsortedComputedWeight", "catchTotalSortedComputedWeight", "catchTotalSortedSortedComputedWeight", "catchTotalRejectedComputedWeight", "speciesTotalComputedWeight", "speciesTotalSortedComputedWeight", "speciesTotalUnsortedComputedWeight", "speciesTotalSampleSortedComputedWeight", "speciesTotalInertComputedWeight", "speciesTotalLivingNotItemizedComputedWeight", "benthosTotalComputedWeight", "benthosTotalSortedComputedWeight", "benthosTotalUnsortedComputedWeight", "benthosTotalSampleSortedComputedWeight", "benthosTotalInertComputedWeight", "benthosTotalLivingNotItemizedComputedWeight", "speciesDistinctSortedSpeciesCount", "benthosDistinctSortedSpeciesCount", "speciesDistinctUnsortedSpeciesCount", "benthosDistinctUnsortedSpeciesCount", "marineLitterTotalComputedWeight", "attachment"}));
        return result;
    }

    public JTabbedPane getTabPanel() {
        return ((EditCatchesUI)this.ui).getTabPane();
    }

    @Override
    public boolean onTabChanged(int currentIndex, int newIndex) {
        ((EditCatchesUI)this.ui).getCatchesCaracteristicsAttachmentsButton().onCloseUI();
        ((EditCatchesUI)this.ui).getComputeSpeciesBatchButton().setVisible(newIndex < 4);
        ((EditCatchesUI)this.ui).getCleanSpeciesBatchButton().setVisible(newIndex > 0 && newIndex < 3);
        boolean result = super.onTabChanged(currentIndex, newIndex);
        if (result && currentIndex != newIndex) {
            boolean showMainActions;
            if (currentIndex == 0) {
                this.editCatchesSvgHandler.clearSVG();
            }
            if (newIndex == 0) {
                if (((EditCatchesUI)this.getUI()).isVisible()) {
                    this.editCatchesSvgHandler.initResumeSvg();
                }
                showMainActions = true;
            } else {
                JComponent componentAt = (JComponent)this.getTabPanel().getComponentAt(newIndex);
                CardLayout2Ext layout = (CardLayout2Ext)componentAt.getLayout();
                String selectedCard = layout.getSelected();
                showMainActions = selectedCard == null || MAIN_CARD.equals(selectedCard);
            }
            ((EditCatchesUI)this.getUI()).getCreateFishingOperationActions().setVisible(showMainActions);
        }
        return result;
    }

    public boolean onHideTab(int currentIndex, int newIndex) {
        boolean result;
        this.closeAttachments();
        EditCatchesUIModel model = (EditCatchesUIModel)this.getModel();
        if (model.isModify()) {
            if (model.isValid()) {
                int answer = this.askSaveBeforeLeaving(I18n.t((String)"tutti.editCatchBatch.askSaveBeforeLeaving.saveCatchBatch", (Object[])new Object[0]));
                switch (answer) {
                    case 0: {
                        this.getContext().getActionEngine().runAction((AbstractButton)((EditCatchesUI)this.getUI()).getSaveButton());
                        result = true;
                        break;
                    }
                    case 1: {
                        this.getContext().getActionEngine().runAction((AbstractButton)((EditCatchesUI)this.getUI()).getCancelButton());
                        result = true;
                        break;
                    }
                    default: {
                        result = false;
                        break;
                    }
                }
            } else {
                result = this.askCancelEditBeforeLeaving(I18n.t((String)"tutti.editCatchBatch.askCancelEditBeforeLeaving.cancelEditCatchBatch", (Object[])new Object[0]));
                if (result) {
                    this.getContext().getActionEngine().runAction((AbstractButton)((EditCatchesUI)this.ui).getCancelButton());
                }
            }
        } else {
            result = true;
        }
        if (result) {
            this.editCatchesSvgHandler.clearSVG();
        }
        return result;
    }

    public void onShowTab(int currentIndex, int newIndex) {
        this.registerValidators();
        this.editCatchesSvgHandler.initResumeSvg();
    }

    public boolean removeTab(int i) {
        return false;
    }

    public boolean onRemoveTab() {
        return false;
    }

    public void uninstallTotalRejectWeightListener() {
        ((EditCatchesUIModel)this.getModel()).removePropertyChangeListener("catchTotalRejectedWeight", this.totalWeightRejectedListener);
    }

    public void installTotalRejectWeightListener() {
        ((EditCatchesUIModel)this.getModel()).addPropertyChangeListener("catchTotalRejectedWeight", this.totalWeightRejectedListener);
    }

    public TuttiBeanMonitor<EditCatchesUIModel> getCatchBatchMonitor() {
        return this.catchBatchMonitor;
    }

    protected void registerValidators() {
        this.registerValidators(this.getValidator(), ((EditCatchesUI)this.ui).getSpeciesTabContent().getHandler().getValidator(), ((EditCatchesUI)this.ui).getBenthosTabContent().getHandler().getValidator(), ((EditCatchesUI)this.ui).getMarineLitterTabContent().getHandler().getValidator());
    }

    public void editSpeciesFrequencies(int rowIndex) {
        JXTable speciesTable = ((EditCatchesUI)this.ui).getSpeciesTabContent().getTable();
        TableColumn frequenciesColumn = speciesTable.getColumn(SpeciesBatchTableModel.COMPUTED_NUMBER);
        int frequenciesColumnIndex = speciesTable.getColumns(false).indexOf(frequenciesColumn);
        SpeciesFrequencyCellComponent.FrequencyCellEditor frequencyCellEditor = (SpeciesFrequencyCellComponent.FrequencyCellEditor)speciesTable.getCellEditor(rowIndex, frequenciesColumnIndex);
        frequencyCellEditor.initEditor((JTable)speciesTable, rowIndex, frequenciesColumnIndex);
        frequencyCellEditor.startEdit();
    }

    public void editSpeciesFrequencies(SpeciesFrequencyCellComponent.FrequencyCellEditor editor) {
        SpeciesFrequencyUI frequencyEditor = ((EditCatchesUI)this.ui).getSpeciesTabFrequencyEditor();
        frequencyEditor.getHandler().editBatch(editor);
        this.setSpeciesSelectedCard(EDIT_FREQUENCY_CARD);
        SpeciesBatchRowModel editRow = editor.getEditRow();
        String title = this.buildReminderLabelTitle(editRow.getSpecies(), editRow, ((EditCatchesUI)this.ui).getSpeciesTabFishingOperationReminderLabel().getTitle(), I18n.t((String)"tutti.editSpeciesFrequencies.title", (Object[])new Object[0]));
        ((EditCatchesUI)this.ui).getSpeciesTabFrequencyEditorReminderLabel().setTitle(title);
    }

    public void setSpeciesSelectedCard(String card) {
        JPanel panel = ((EditCatchesUI)this.ui).getSpeciesTabPanel();
        CardLayout2Ext layout = (CardLayout2Ext)panel.getLayout();
        if (!card.equals(layout.getSelected())) {
            layout.setSelected(card);
            Table actionPanel = ((EditCatchesUI)this.getUI()).getCreateFishingOperationActions();
            if (MAIN_CARD.equals(card)) {
                this.registerValidators();
                actionPanel.setVisible(true);
            } else {
                actionPanel.setVisible(false);
                JPanel tuttiUi = null;
                JXTitledPanel titlePanel = null;
                String title = "";
                if (CREATE_BATCH_CARD.equals(card)) {
                    tuttiUi = ((EditCatchesUI)this.ui).getSpeciesTabCreateBatch();
                    titlePanel = ((EditCatchesUI)this.ui).getSpeciesTabCreateBatchReminderLabel();
                    title = I18n.n((String)"tutti.createSpeciesBatch.title", (Object[])new Object[0]);
                } else if (SPLIT_BATCH_CARD.equals(card)) {
                    tuttiUi = ((EditCatchesUI)this.ui).getSpeciesTabSplitBatch();
                } else if (ADD_SAMPLE_CATEGORY_BATCH_CARD.equals(card)) {
                    tuttiUi = ((EditCatchesUI)this.ui).getSpeciesTabAddSampleCategoryBatch();
                } else if (EDIT_FREQUENCY_CARD.equals(card)) {
                    tuttiUi = ((EditCatchesUI)this.ui).getSpeciesTabFrequencyEditor();
                }
                if (tuttiUi != null) {
                    this.registerValidators(tuttiUi.getHandler().getValidator());
                }
                if (titlePanel != null) {
                    titlePanel.setTitle(((EditCatchesUI)this.ui).getSpeciesTabFishingOperationReminderLabel().getTitle() + " - " + I18n.t((String)title, (Object[])new Object[0]));
                }
            }
        }
    }

    public void editBenthosFrequencies(int rowIndex) {
        JXTable benthosTable = ((EditCatchesUI)this.ui).getBenthosTabContent().getTable();
        TableColumn frequenciesColumn = benthosTable.getColumn(BenthosBatchTableModel.COMPUTED_NUMBER);
        int frequenciesColumnIndex = benthosTable.getColumns(false).indexOf(frequenciesColumn);
        BenthosFrequencyCellComponent.FrequencyCellEditor frequencyCellEditor = (BenthosFrequencyCellComponent.FrequencyCellEditor)benthosTable.getCellEditor(rowIndex, frequenciesColumnIndex);
        frequencyCellEditor.initEditor((JTable)benthosTable, rowIndex, frequenciesColumnIndex);
        frequencyCellEditor.startEdit();
    }

    public void editBenthosFrequencies(BenthosFrequencyCellComponent.FrequencyCellEditor editor) {
        BenthosFrequencyUI frequencyEditor = ((EditCatchesUI)this.ui).getBenthosTabFrequencyEditor();
        frequencyEditor.getHandler().editBatch(editor);
        this.setBenthosSelectedCard(EDIT_FREQUENCY_CARD);
        BenthosBatchRowModel editRow = editor.getEditRow();
        String title = this.buildReminderLabelTitle(editRow.getSpecies(), editRow, ((EditCatchesUI)this.ui).getBenthosTabFishingOperationReminderLabel().getTitle(), I18n.t((String)"tutti.editBenthosFrequencies.title", (Object[])new Object[0]));
        ((EditCatchesUI)this.ui).getBenthosTabFrequencyEditorReminderLabel().setTitle(title);
    }

    public void setBenthosSelectedCard(String card) {
        JPanel panel = ((EditCatchesUI)this.ui).getBenthosTabPanel();
        CardLayout2Ext layout = (CardLayout2Ext)panel.getLayout();
        if (!card.equals(layout.getSelected())) {
            layout.setSelected(card);
            Table actionPanel = ((EditCatchesUI)this.getUI()).getCreateFishingOperationActions();
            if (MAIN_CARD.equals(card)) {
                this.registerValidators();
                actionPanel.setVisible(true);
            } else {
                actionPanel.setVisible(false);
                JPanel tuttiUi = null;
                JXTitledPanel titlePanel = null;
                String title = "";
                if (CREATE_BATCH_CARD.equals(card)) {
                    tuttiUi = ((EditCatchesUI)this.ui).getBenthosTabCreateBatch();
                    titlePanel = ((EditCatchesUI)this.ui).getBenthosTabCreateBatchReminderLabel();
                    title = I18n.n((String)"tutti.createBenthosBatch.title", (Object[])new Object[0]);
                } else if (SPLIT_BATCH_CARD.equals(card)) {
                    tuttiUi = ((EditCatchesUI)this.ui).getBenthosTabSplitBatch();
                } else if (ADD_SAMPLE_CATEGORY_BATCH_CARD.equals(card)) {
                    tuttiUi = ((EditCatchesUI)this.ui).getBenthosTabAddSampleCategoryBatch();
                } else if (EDIT_FREQUENCY_CARD.equals(card)) {
                    tuttiUi = ((EditCatchesUI)this.ui).getBenthosTabFrequencyEditor();
                }
                if (tuttiUi != null) {
                    this.registerValidators(tuttiUi.getHandler().getValidator());
                }
                if (titlePanel != null) {
                    titlePanel.setTitle(((EditCatchesUI)this.ui).getBenthosTabFishingOperationReminderLabel().getTitle() + " - " + I18n.t((String)title, (Object[])new Object[0]));
                }
            }
        }
    }

    public void setMarineLitterSelectedCard(String card) {
        JPanel panel = ((EditCatchesUI)this.ui).getMarineLitterTabPanel();
        CardLayout2Ext layout = (CardLayout2Ext)panel.getLayout();
        if (!card.equals(layout.getSelected())) {
            layout.setSelected(card);
            Table actionPanel = ((EditCatchesUI)this.getUI()).getCreateFishingOperationActions();
            if (MAIN_CARD.equals(card)) {
                this.registerValidators();
                actionPanel.setVisible(true);
            } else {
                actionPanel.setVisible(false);
                CreateMarineLitterBatchUI tuttiUi = null;
                JXTitledPanel titlePanel = null;
                String title = "";
                if (CREATE_BATCH_CARD.equals(card)) {
                    tuttiUi = ((EditCatchesUI)this.ui).getMarineLitterTabCreateBatch();
                    titlePanel = ((EditCatchesUI)this.ui).getMarineLitterTabCreateBatchReminderLabel();
                    title = I18n.n((String)"tutti.createMarineLitterBatch.title", (Object[])new Object[0]);
                }
                if (tuttiUi != null) {
                    this.registerValidators(tuttiUi.getHandler().getValidator());
                }
                if (titlePanel != null) {
                    titlePanel.setTitle(((EditCatchesUI)this.ui).getMarineLitterTabCreateBatchReminderLabel().getTitle() + " - " + I18n.t((String)title, (Object[])new Object[0]));
                }
            }
        }
    }

    public void setIndividualObservationSelectedCard(String card) {
        this.setIndividualObservationSelectedCard(card, null);
    }

    public void setIndividualObservationSelectedCard(String card, Species species) {
        JPanel panel = ((EditCatchesUI)this.ui).getIndividualObservationTabPanel();
        CardLayout2Ext layout = (CardLayout2Ext)panel.getLayout();
        if (!card.equals(layout.getSelected())) {
            layout.setSelected(card);
            Table actionPanel = ((EditCatchesUI)this.getUI()).getCreateFishingOperationActions();
            if (MAIN_CARD.equals(card)) {
                this.registerValidators();
                actionPanel.setVisible(true);
            } else {
                actionPanel.setVisible(false);
                CreateIndividualObservationBatchUI tuttiUi = null;
                JXTitledPanel titlePanel = null;
                String title = "";
                if (CREATE_BATCH_CARD.equals(card)) {
                    tuttiUi = ((EditCatchesUI)this.ui).getIndividualObservationTabCreateBatch();
                    titlePanel = ((EditCatchesUI)this.ui).getIndividualObservationTabCreateBatchReminderLabel();
                    title = I18n.n((String)"tutti.createIndividualObservationBatch.title", (Object[])new Object[0]);
                } else if (EDIT_CARACTERISTICS_CARD.equals(card)) {
                    titlePanel = ((EditCatchesUI)this.ui).getIndividualObservationCaracteristicMapEditorReminderLabel();
                    title = I18n.n((String)"tutti.editCaracteristics.title", (Object[])new Object[0]);
                }
                if (tuttiUi != null) {
                    this.registerValidators(tuttiUi.getHandler().getValidator());
                }
                if (titlePanel != null) {
                    titlePanel.setTitle(((EditCatchesUI)this.ui).getIndividualObservationTabFishingOperationReminderLabel().getTitle() + " - " + I18n.t((String)title, (Object[])new Object[]{this.decorate((Serializable)species)}));
                }
            }
        }
    }

    public void setAccidentalSelectedCard(String card) {
        this.setAccidentalSelectedCard(card, null);
    }

    public void setAccidentalSelectedCard(String card, Species species) {
        JPanel panel = ((EditCatchesUI)this.ui).getAccidentalTabPanel();
        CardLayout2Ext layout = (CardLayout2Ext)panel.getLayout();
        if (!card.equals(layout.getSelected())) {
            layout.setSelected(card);
            Table actionPanel = ((EditCatchesUI)this.getUI()).getCreateFishingOperationActions();
            if (MAIN_CARD.equals(card)) {
                this.registerValidators();
                actionPanel.setVisible(true);
            } else {
                actionPanel.setVisible(false);
                CreateAccidentalBatchUI tuttiUi = null;
                JXTitledPanel titlePanel = null;
                String title = "";
                if (CREATE_BATCH_CARD.equals(card)) {
                    tuttiUi = ((EditCatchesUI)this.ui).getAccidentalTabCreateBatch();
                    titlePanel = ((EditCatchesUI)this.ui).getAccidentalTabCreateBatchReminderLabel();
                    title = I18n.n((String)"tutti.createAccidentalBatch.title", (Object[])new Object[0]);
                } else if (EDIT_CARACTERISTICS_CARD.equals(card)) {
                    titlePanel = ((EditCatchesUI)this.ui).getAccidentalCaracteristicMapEditorReminderLabel();
                    title = I18n.n((String)"tutti.editCaracteristics.title", (Object[])new Object[0]);
                }
                if (tuttiUi != null) {
                    this.registerValidators(tuttiUi.getHandler().getValidator());
                }
                if (titlePanel != null) {
                    titlePanel.setTitle(((EditCatchesUI)this.ui).getAccidentalTabFishingOperationReminderLabel().getTitle() + " - " + I18n.t((String)title, (Object[])new Object[]{this.decorate((Serializable)species)}));
                }
            }
        }
    }
}

