/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.service.genericformat.csv;

import com.google.common.base.Preconditions;
import fr.ifremer.tutti.persistence.entities.data.SampleCategoryModelEntry;
import fr.ifremer.tutti.persistence.entities.data.SpeciesAbleBatchFrequency;
import fr.ifremer.tutti.persistence.entities.referential.Caracteristic;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.service.genericformat.csv.ExportSampleCategory;
import fr.ifremer.tutti.service.genericformat.csv.RowWithOperationContextSupport;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class CatchRow
extends RowWithOperationContextSupport {
    private static final long serialVersionUID = 1L;
    public static final String PROPERTY_BENTHOS = "benthos";
    public static final String PROPERTY_SPECIES_TO_CONFIRM = "speciesToConfirm";
    public static final String FREQUENCY_LENGTH_STEP = "frequencyLengthStep";
    public static final String FREQUENCY_WEIGHT = "frequencyWeight";
    public static final String FREQUENCY_LENGTH_STEP_CARACTERISTIC = "frequencyLengthStepCaracteristic";
    public static final String FREQUENCY_RANK_ORDER = "frequencyRankOrder";
    public static final String SAMPLE_CATEGORY = "sampleCategory";
    public static final String REFERENCE_WEIGHT = "referenceWeight";
    public static final String RAISING_FACTOR = "raisingFactor";
    public static final String BATCH_NUMBER = "batchNumber";
    public static final String BATCH_NUMBER_COMPUTED = "batchNumberComputed";
    public static final String BATCH_WEIGHT_UNIT = "batchWeightUnit";
    public static final String FINAL_RAISING_FACTOR = "finalRaisingFactor";
    protected final List<ExportSampleCategory> sampleCategory = new ArrayList<ExportSampleCategory>();
    protected Species species;
    protected Float referenceWeight;
    protected float raisingFactor;
    protected Float finalRaisingFactor;
    protected Integer batchNumber;
    protected Boolean batchNumberComputed;
    protected String batchWeightUnit;
    protected boolean benthos;
    protected boolean vrac;
    protected boolean speciesToConfirm;
    protected Caracteristic frequencyLengthStepCaracteristic;
    protected Float frequencyLengthStep;
    protected Float frequencyWeight;
    protected Integer frequencyRankOrder;

    public static CatchRow newEmptyInstance() {
        CatchRow row = new CatchRow();
        row.forImport();
        return row;
    }

    public void setBenthos(boolean benthos) {
        this.benthos = benthos;
    }

    public void setVrac(boolean vrac) {
        this.vrac = vrac;
    }

    public void setReferenceWeight(Float referenceWeight) {
        this.referenceWeight = referenceWeight;
    }

    public void setRaisingFactor(float raisingFactor) {
        this.raisingFactor = raisingFactor;
    }

    public void setBatchNumber(Integer batchNumber) {
        this.batchNumber = batchNumber;
    }

    public void setBatchNumberComputed(Boolean batchNumberComputed) {
        this.batchNumberComputed = batchNumberComputed;
    }

    public void addSampleCategory(ExportSampleCategory sampleCategory) {
        int order = sampleCategory.getCategoryDef().getOrder();
        while (this.sampleCategory.size() <= order) {
            this.sampleCategory.add(null);
        }
        this.sampleCategory.set(order, sampleCategory);
    }

    public void setFrequency(SpeciesAbleBatchFrequency frequency) {
        Preconditions.checkNotNull((Object)frequency);
        this.setFrequencyLengthStepCaracteristic(frequency.getLengthStepCaracteristic());
        this.setFrequencyLengthStep(frequency.getLengthStep());
        this.setBatchNumber(frequency.getNumber());
        this.setBatchNumberComputed(false);
        this.setFrequencyRankOrder(frequency.getRankOrder());
        this.setFrequencyWeight(frequency.getWeight());
    }

    public void setFinalRaisingFactor(Float finalRaisingFactor) {
        this.finalRaisingFactor = finalRaisingFactor;
    }

    public void setFrequencyLengthStepCaracteristic(Caracteristic frequencyLengthStepCaracteristic) {
        this.frequencyLengthStepCaracteristic = frequencyLengthStepCaracteristic;
    }

    public void setFrequencyLengthStep(Float frequencyLengthStep) {
        this.frequencyLengthStep = frequencyLengthStep;
    }

    public void setFrequencyWeight(Float frequencyWeight) {
        this.frequencyWeight = frequencyWeight;
    }

    public void setFrequencyRankOrder(Integer frequencyRankOrder) {
        this.frequencyRankOrder = frequencyRankOrder;
    }

    public void setSpecies(Species species) {
        this.species = species;
    }

    public void setSpeciesToConfirm(boolean speciesToConfirm) {
        this.speciesToConfirm = speciesToConfirm;
    }

    public List<ExportSampleCategory> getSampleCategory() {
        return this.sampleCategory;
    }

    public ExportSampleCategory getLastSampleCategoryFilled() {
        List list = this.sampleCategory.stream().filter(Objects::nonNull).collect(Collectors.toList());
        return list.isEmpty() ? null : (ExportSampleCategory)((Object)list.get(list.size() - 1));
    }

    public Float getFinalRaisingFactor() {
        return this.finalRaisingFactor;
    }

    public Caracteristic getFrequencyLengthStepCaracteristic() {
        return this.frequencyLengthStepCaracteristic;
    }

    public Float getFrequencyLengthStep() {
        return this.frequencyLengthStep;
    }

    public Float getFrequencyWeight() {
        return this.frequencyWeight;
    }

    public Species getSpecies() {
        return this.species;
    }

    public Integer getFrequencyRankOrder() {
        return this.frequencyRankOrder;
    }

    public Float getReferenceWeight() {
        return this.referenceWeight;
    }

    public float getRaisingFactor() {
        return this.raisingFactor;
    }

    public Integer getBatchNumber() {
        return this.batchNumber;
    }

    public Boolean getBatchNumberComputed() {
        return this.batchNumberComputed;
    }

    public String getBatchWeightUnit() {
        return this.batchWeightUnit;
    }

    public boolean isSpeciesToConfirm() {
        return this.speciesToConfirm;
    }

    public void setBatchWeightUnit(String batchWeightUnit) {
        this.batchWeightUnit = batchWeightUnit;
    }

    public boolean isVrac() {
        return this.vrac;
    }

    public boolean isHorsVrac() {
        return !this.isVrac();
    }

    public boolean isBenthos() {
        return this.benthos;
    }

    public CatchRow copy() {
        CatchRow result = new CatchRow();
        result.setVrac(this.vrac);
        result.setBenthos(this.benthos);
        result.setCruise(this.getCruise());
        result.setFishingOperation(this.getFishingOperation());
        result.sampleCategory.addAll(this.sampleCategory);
        result.setFrequencyLengthStep(this.frequencyLengthStep);
        result.setFrequencyLengthStepCaracteristic(this.frequencyLengthStepCaracteristic);
        result.setFrequencyRankOrder(this.frequencyRankOrder);
        result.setFrequencyWeight(this.frequencyWeight);
        result.setSpecies(this.species);
        result.setSpeciesToConfirm(this.speciesToConfirm);
        result.setRaisingFactor(this.raisingFactor);
        result.setReferenceWeight(this.referenceWeight);
        result.setBatchNumber(this.batchNumber);
        result.setBatchWeightUnit(this.batchWeightUnit);
        result.setFinalRaisingFactor(this.finalRaisingFactor);
        return result;
    }

    public boolean withFrequency() {
        return this.frequencyLengthStep != null;
    }

    public ExportSampleCategory getSampleCategory(SampleCategoryModelEntry sampleCategoryModelEntry) {
        ExportSampleCategory exportSampleCategory;
        int categoryOrder = sampleCategoryModelEntry.getOrder();
        if (this.sampleCategory.size() == categoryOrder) {
            exportSampleCategory = new ExportSampleCategory();
            exportSampleCategory.setCategoryDef(sampleCategoryModelEntry);
            this.sampleCategory.add(categoryOrder, exportSampleCategory);
        }
        exportSampleCategory = this.sampleCategory.get(categoryOrder);
        return exportSampleCategory;
    }

    public List<ExportSampleCategory> getFilledSampleCategories() {
        ArrayList<ExportSampleCategory> result = new ArrayList<ExportSampleCategory>();
        for (ExportSampleCategory exportSampleCategory : this.sampleCategory) {
            if (!exportSampleCategory.isFilled()) continue;
            result.add(exportSampleCategory);
        }
        return result;
    }
}

