/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.operation.catches.species.actions;

import com.google.common.collect.Lists;
import fr.ifremer.tutti.persistence.entities.data.SampleCategoryModel;
import fr.ifremer.tutti.persistence.entities.data.SampleCategoryModelEntry;
import fr.ifremer.tutti.persistence.entities.referential.Caracteristic;
import fr.ifremer.tutti.persistence.entities.referential.CaracteristicQualitativeValue;
import fr.ifremer.tutti.persistence.entities.referential.CaracteristicQualitativeValues;
import fr.ifremer.tutti.ui.swing.content.operation.catches.EditCatchesUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.EditCatchesUIModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.SpeciesBatchRowModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.SpeciesBatchTableModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.SpeciesBatchUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.SpeciesBatchUIHandler;
import fr.ifremer.tutti.ui.swing.util.actions.SimpleActionSupport;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.swing.renderer.DecoratorListCellRenderer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.jaxx.widgets.number.NumberEditor;

public class ChangeSpeciesBatchSampleCategoryAction
extends SimpleActionSupport<SpeciesBatchUI> {
    private static final Log log = LogFactory.getLog(ChangeSpeciesBatchSampleCategoryAction.class);
    private static final long serialVersionUID = -6540241422935319461L;

    public ChangeSpeciesBatchSampleCategoryAction(SpeciesBatchUI ui) {
        super(ui);
    }

    @Override
    protected void onActionPerformed(SpeciesBatchUI ui) {
        Object selectedItem;
        SpeciesBatchUIHandler handler = ui.getHandler();
        SpeciesBatchTableModel tableModel = handler.getTableModel();
        int rowIndex = SwingUtil.getSelectedModelRow((JTable)ui.getTable());
        int columnIndex = SwingUtil.getSelectedModelColumn((JTable)ui.getTable());
        SpeciesBatchRowModel selectedRow = (SpeciesBatchRowModel)tableModel.getEntry(rowIndex);
        SampleCategoryModel sampleCategoryModel = handler.getSampleCategoryModel();
        Integer sampleCategoryId = tableModel.getSampleCategoryId(columnIndex);
        SampleCategoryModelEntry sampleCategoryEntry = sampleCategoryModel.getCategoryById(sampleCategoryId);
        Caracteristic caracteristic = sampleCategoryEntry.getCaracteristic();
        SpeciesBatchRowModel firstAncestorRow = selectedRow.getFirstAncestor(sampleCategoryId);
        Set<Serializable> usedValues = handler.getSampleUsedValues(firstAncestorRow, sampleCategoryId);
        String categoryDecorated = handler.getDecorator(caracteristic.getClass(), "parameterOnly").toString((Object)caracteristic);
        String dialogTitle = I18n.t((String)"tutti.editSpeciesBatch.title.changeSampleCategoryValue", (Object[])new Object[]{categoryDecorated});
        boolean numericType = caracteristic.isNumericType();
        if (numericType) {
            NumberEditor editor = new NumberEditor();
            editor.setNumberPattern("\\d{0,6}(\\.\\d{0,3})?");
            editor.setUseSign(false);
            editor.setShowPopupButton(Boolean.valueOf(false));
            editor.setShowReset(Boolean.valueOf(false));
            int response = JOptionPane.showConfirmDialog(ui, editor, dialogTitle, 2);
            selectedItem = response == 0 ? editor.getModel() : null;
            if (usedValues.contains(selectedItem)) {
                JOptionPane.showMessageDialog(handler.getTopestUI(), I18n.t((String)"tutti.editSpeciesBatch.error.sampleCategoryValue.notAvailable", (Object[])new Object[]{selectedItem, categoryDecorated}));
                selectedItem = null;
            }
        } else {
            ArrayList availableValues = Lists.newArrayList(caracteristic.getQualitativeValue());
            boolean firstCategory = sampleCategoryModel.getFirstCategoryId().equals(sampleCategoryId);
            if (firstCategory) {
                CaracteristicQualitativeValues.removeQualitativeValue(availableValues, handler.getQualitative_unsorted_id());
            }
            availableValues.removeAll(usedValues);
            JComboBox editor = new JComboBox();
            editor.setRenderer(new DecoratorListCellRenderer(handler.getDecorator(CaracteristicQualitativeValue.class, null)));
            SwingUtil.fillComboBox(editor, (Collection)availableValues, availableValues.get(0));
            int response = JOptionPane.showConfirmDialog(handler.getTopestUI(), editor, dialogTitle, 2);
            selectedItem = response == 0 ? (CaracteristicQualitativeValue)editor.getSelectedItem() : null;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("New selected category: " + selectedItem));
        }
        if (selectedItem != null) {
            Serializable oldValue = tableModel.updateSampleCategorieValue(firstAncestorRow, columnIndex, (Serializable)selectedItem);
            handler.saveRow(firstAncestorRow);
            if (!numericType) {
                EditCatchesUIModel createBatchModel = ui.getParentContainer(EditCatchesUI.class).getModel();
                createBatchModel.replaceCaracteristicValue(firstAncestorRow.getSpecies(), (CaracteristicQualitativeValue)oldValue, (CaracteristicQualitativeValue)selectedItem);
            }
        }
    }
}

