/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.doc.legacy;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import org.eclipse.birt.doc.legacy.LegacyLoader;
import org.eclipse.birt.doc.legacy.SpecChoice;
import org.eclipse.birt.doc.legacy.SpecElement;
import org.eclipse.birt.doc.legacy.SpecInheritedProperty;
import org.eclipse.birt.doc.legacy.SpecMethod;
import org.eclipse.birt.doc.legacy.SpecProperty;
import org.eclipse.birt.doc.legacy.SpecSlot;

public class SpecDumper {
    PrintStream out;

    public void dump(LegacyLoader loader) throws IOException {
        FileOutputStream stream = new FileOutputStream("log/dump.txt");
        this.out = new PrintStream(stream);
        for (SpecElement element : loader.getElements()) {
            this.dump(element);
        }
        stream.close();
    }

    private void println(String s) {
        this.out.println(s);
    }

    private void print(String s) {
        this.out.print(s);
    }

    void dump(SpecElement element) {
        this.println("\n=========================================================\n");
        this.println("Element:");
        this.print("  Name: ");
        this.println(element.name);
        this.print("  Display Name: ");
        this.println(element.displayName);
        this.print("  Summary: ");
        this.println(element.summary);
        this.print("  Design Object: ");
        this.println(element.designObjName);
        this.print("  Runtime Object: ");
        this.println(element.stateObjName);
        this.print("  Style Names: ");
        this.println(element.styleNames);
        this.print("  Since: ");
        this.println(element.since);
        this.print("  XML Element: ");
        this.println(element.xmlElement);
        this.print("  XML Summary: ");
        this.println(element.xmlSummary);
        this.print("  Description: ");
        this.println(element.description);
        this.print("    See Also: ");
        this.println(element.seeAlso);
        int i = 0;
        while (i < element.inheritedProperties.size()) {
            this.dumpInheritedProperty((SpecInheritedProperty)element.inheritedProperties.get(i));
            ++i;
        }
        i = 0;
        while (i < element.properties.size()) {
            this.dumpProperty((SpecProperty)element.properties.get(i));
            ++i;
        }
        i = 0;
        while (i < element.methods.size()) {
            this.dumpMethod((SpecMethod)element.methods.get(i));
            ++i;
        }
        i = 0;
        while (i < element.slots.size()) {
            this.dumpSlot((SpecSlot)element.slots.get(i));
            ++i;
        }
    }

    private void dumpInheritedProperty(SpecInheritedProperty prop) {
        this.println("\n  Property:");
        this.print("    Name: ");
        this.println(prop.name);
        this.print("    Description: ");
        this.println(prop.description);
    }

    private void dumpTristate(String label, int value) {
        if (value == 0) {
            return;
        }
        this.print(label);
        this.println(value == 1 ? "True" : "False");
    }

    private void dumpProperty(SpecProperty prop) {
        this.println("\n  Property:");
        this.print("    Name: ");
        this.println(prop.name);
        this.print("    Display Name: ");
        this.println(prop.displayName);
        this.print("    Summary: ");
        this.println(prop.summary);
        this.print("    Short Descrip: ");
        this.println(prop.shortDescrip);
        this.print("    Since: ");
        this.println(prop.since);
        this.print("    JS Type: ");
        this.println(prop.jsType);
        this.print("    ROM Type: ");
        this.println(prop.romType);
        this.print("    Expression Type: ");
        this.println(prop.exprType);
        this.print("    Default Value: ");
        this.println(prop.defaultValue);
        this.print("    Expression Context: ");
        this.println(prop.exprContext);
        this.dumpTristate("    Inherited: ", prop.inherited);
        this.dumpTristate("    Array: ", prop.isArray);
        this.dumpTristate("    Hidden: ", prop.hidden);
        this.dumpTristate("    Runtime Settable: ", prop.runtimeSettable);
        this.dumpTristate("    Required: ", prop.required);
        this.print("  Description: ");
        this.println(prop.description);
        this.print("    See Also: ");
        this.println(prop.seeAlso);
        this.dumpChoices(prop);
    }

    private void dumpChoices(SpecProperty prop) {
        if (prop.choices.isEmpty()) {
            return;
        }
        this.println("    Choices:");
        for (SpecChoice choice : prop.choices) {
            this.println("      Choice:");
            this.print("        Name:");
            this.println(choice.name);
            this.print("        Display Name:");
            this.println(choice.displayName);
            this.print("        Description:");
            this.println(choice.description);
        }
    }

    private void dumpMethod(SpecMethod method) {
        this.println("\n  Method:");
        this.print("    Name: ");
        this.println(method.name);
        this.print("    Display Name: ");
        this.println(method.displayName);
        this.print("    Summary: ");
        this.println(method.summary);
        this.print("    Short Descrip: ");
        this.println(method.shortDescrip);
        this.print("    Since: ");
        this.println(method.since);
        this.print("    Returns: ");
        this.println(method.returns);
        this.print("    Context: ");
        this.println(method.context);
        this.print("    Description: ");
        this.println(method.description);
        this.print("    See Also: ");
        this.println(method.seeAlso);
    }

    private void dumpSlot(SpecSlot slot) {
        this.println("\n  Slot:");
        this.print("    Name: ");
        this.println(slot.name);
        this.print("    Display Name: ");
        this.println(slot.displayName);
        this.print("    Summary: ");
        this.println(slot.summary);
        this.print("    Short Descrip: ");
        this.println(slot.shortDescrip);
        this.print("    Style: ");
        this.println(slot.styleNames);
        this.print("    Since: ");
        this.println(slot.since);
        this.print("    Contents: ");
        this.println(slot.contents);
        if (slot.cardinality == 1) {
            this.println("    Cardinality: Single");
        } else if (slot.cardinality == 2) {
            this.println("    Cardinality: Multiple");
        }
        this.print("    XML Element: ");
        this.println(slot.xmlElement);
        this.print("    Description: ");
        this.println(slot.description);
        this.print("    See Also: ");
        this.println(slot.seeAlso);
    }
}

