/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.service.genericformat.producer;

import fr.ifremer.tutti.persistence.entities.data.BatchContainer;
import fr.ifremer.tutti.persistence.entities.data.MarineLitterBatch;
import fr.ifremer.tutti.service.csv.CsvProducer;
import fr.ifremer.tutti.service.genericformat.GenericFormatExportOperationContext;
import fr.ifremer.tutti.service.genericformat.csv.MarineLitterModel;
import fr.ifremer.tutti.service.genericformat.csv.MarineLitterRow;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;

public class CsvProducerForMarineLitter
extends CsvProducer<MarineLitterRow, MarineLitterModel> {
    public CsvProducerForMarineLitter(Path file, MarineLitterModel model) {
        super(file, model);
    }

    public List<MarineLitterRow> getDataToExport(GenericFormatExportOperationContext operationExportContext) {
        ArrayList<MarineLitterRow> rows = new ArrayList<MarineLitterRow>();
        BatchContainer<MarineLitterBatch> rootMarineLitterBatch = operationExportContext.getRootMarineLitterBatch();
        List children = rootMarineLitterBatch.getChildren();
        if (CollectionUtils.isNotEmpty((Collection)children)) {
            for (MarineLitterBatch child : children) {
                MarineLitterRow row = new MarineLitterRow();
                row.setCruise(operationExportContext.getCruise());
                row.setFishingOperation(operationExportContext.getOperation());
                row.setMarineLitterBatch(child);
                rows.add(row);
            }
        }
        return rows;
    }
}

