/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.oda.consumer.helper;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import org.eclipse.datatools.connectivity.oda.IParameterMetaData;
import org.eclipse.datatools.connectivity.oda.IQuery;
import org.eclipse.datatools.connectivity.oda.IResultSet;
import org.eclipse.datatools.connectivity.oda.IResultSetMetaData;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.connectivity.oda.SortSpec;
import org.eclipse.datatools.connectivity.oda.consumer.helper.OdaConnection;
import org.eclipse.datatools.connectivity.oda.consumer.helper.OdaDataSetMetaData;
import org.eclipse.datatools.connectivity.oda.consumer.helper.OdaDriverObject;
import org.eclipse.datatools.connectivity.oda.consumer.helper.OdaParameterMetaData;
import org.eclipse.datatools.connectivity.oda.consumer.helper.OdaResultSet;
import org.eclipse.datatools.connectivity.oda.consumer.helper.OdaResultSetMetaData;
import org.eclipse.datatools.connectivity.oda.consumer.nls.Messages;
import org.eclipse.datatools.connectivity.oda.spec.QuerySpecification;
import org.eclipse.datatools.connectivity.oda.spec.util.QuerySpecificationHelper;

public class OdaQuery
extends OdaDriverObject
implements IQuery {
    private boolean m_isPreparedSuccessfully;
    private boolean m_isExecuting;
    private boolean m_isExecuted;
    private String m_dataSetType;
    private Object m_appContext;
    private String m_preparedText;
    private static final String MSG_ARG_SEPARATOR = ", ";
    private static final String MSG_LINE_SEPARATOR = " )\t";

    protected OdaQuery(IQuery statement, OdaConnection connection, String dataSetType, boolean switchContextClassloader, ClassLoader driverClassLoader) {
        super((Object)statement, connection, switchContextClassloader, driverClassLoader);
        String context = "OdaQuery.OdaQuery( " + statement + MSG_ARG_SEPARATOR + connection + MSG_ARG_SEPARATOR + dataSetType + MSG_LINE_SEPARATOR;
        this.logMethodCalled(context);
        this.m_isPreparedSuccessfully = false;
        this.m_isExecuting = false;
        this.m_isExecuted = false;
        this.m_dataSetType = dataSetType;
        this.logMethodExitWithReturn(context, this);
    }

    protected IQuery getQuery() {
        return (IQuery)this.getObject();
    }

    protected OdaDataSetMetaData getDSMetaData() throws OdaException {
        return this.getOdaConnection().doGetMetaData(this.m_dataSetType);
    }

    protected boolean isPreparedSuccessfully() {
        return this.m_isPreparedSuccessfully;
    }

    protected boolean isExecuting() {
        return this.m_isExecuting;
    }

    protected void setIsExecuting(boolean flag) {
        this.m_isExecuting = flag;
    }

    protected boolean isExecuted() {
        return this.m_isExecuted;
    }

    protected void setIsExecuted(boolean flag) {
        this.m_isExecuted = flag;
    }

    private void resetStatementStates() {
        this.getOdaConnection().removeOpenStatement(this);
        this.m_isPreparedSuccessfully = false;
        this.m_preparedText = null;
        this.resetExecuteStates();
    }

    protected void resetExecuteStates() {
        this.m_isExecuting = false;
        this.m_isExecuted = false;
    }

    /*
     * Loose catch block
     */
    public void setAppContext(Object context) throws OdaException {
        block10: {
            String contextObjInfo = context == null ? "null" : context.getClass().getName();
            this.logMethodCalled("OdaQuery.setAppContext()\t");
            if (this.m_appContext == context) {
                this.log("OdaQuery.setAppContext()\t", "Same pass-thru application context object: " + contextObjInfo);
                this.logMethodExit("OdaQuery.setAppContext()\t");
                return;
            }
            try {
                this.setContextClassloader();
                this.log("OdaQuery.setAppContext()\t", "Passing thru application context to underlying ODA query: " + contextObjInfo);
                this.getQuery().setAppContext(context);
            }
            catch (UnsupportedOperationException uoException) {
                this.logUnsupportedOp(uoException, "IQuery.setAppContext");
                this.resetContextClassloader();
                break block10;
            }
            catch (RuntimeException rtException) {
                this.handleError(rtException);
                break block10;
            }
            catch (OdaException odaException) {
                this.handleError(odaException);
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                this.resetContextClassloader();
                break block10;
            }
            {
                finally {
                    this.resetContextClassloader();
                }
            }
            this.resetContextClassloader();
        }
        this.m_appContext = context;
        this.logMethodExit("OdaQuery.setAppContext()\t");
    }

    /*
     * Loose catch block
     */
    public void prepare(String queryText) throws OdaException {
        String context;
        block9: {
            context = "OdaQuery.prepare( " + queryText + MSG_LINE_SEPARATOR;
            this.logMethodCalled(context);
            this.setAppContext(this.getOdaConnection().getAppContext());
            try {
                this.setContextClassloader();
                this.doPrepare(queryText, context);
            }
            catch (UnsupportedOperationException uoException) {
                this.handleUnsupportedOp(uoException, "IQuery.prepare( String queryText )");
                this.resetContextClassloader();
                break block9;
            }
            catch (RuntimeException rtException) {
                this.handleError(rtException);
                break block9;
            }
            catch (OdaException odaException) {
                this.handleError(odaException);
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                this.resetContextClassloader();
                break block9;
            }
            {
                finally {
                    this.resetContextClassloader();
                }
            }
            this.resetContextClassloader();
        }
        this.m_isPreparedSuccessfully = true;
        this.getOdaConnection().addOpenStatement(this);
        this.logMethodExit(context);
    }

    private void doPrepare(String queryText, String logContext) throws OdaException {
        this.resetStatementStates();
        if (queryText == null || queryText.trim().isEmpty()) {
            QuerySpecification querySpec = this.getSpecification();
            if (querySpec != null && QuerySpecificationHelper.hasAtomicQueryText((QuerySpecification)querySpec)) {
                this.log(logContext, "Applied the query text specified in the query specification's base query.");
                queryText = QuerySpecificationHelper.getAtomicQuery((QuerySpecification)querySpec).getQueryText();
            } else if (queryText == null) {
                this.log(logContext, "Converted the null queryText argument to an empty String value to comply with the ODA interfaces specification.");
                queryText = "";
            }
        }
        if (!this.getOdaConnection().canSupportMoreOpenedStatements()) {
            throw this.newOdaException(Messages.helper_maxConcurrentStatementsReached);
        }
        this.getQuery().prepare(queryText);
        this.m_preparedText = queryText;
    }

    /*
     * Loose catch block
     */
    public void setProperty(String propertyName, String propertyValue) throws OdaException {
        String context = "OdaQuery.setProperty( " + propertyName + MSG_ARG_SEPARATOR + propertyValue + MSG_LINE_SEPARATOR;
        this.logMethodCalled(context);
        try {
            try {
                this.setContextClassloader();
                this.getQuery().setProperty(propertyName, propertyValue);
                this.logMethodExit(context);
            }
            catch (UnsupportedOperationException uoException) {
                this.handleUnsupportedOp(uoException, "IQuery.setProperty( String propertyName, String propertyValue )");
                this.resetContextClassloader();
            }
            catch (RuntimeException rtException) {
                this.handleError(rtException);
                this.resetContextClassloader();
            }
            catch (OdaException odaException) {
                this.handleError(odaException);
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                this.resetContextClassloader();
            }
        }
        finally {
            this.resetContextClassloader();
        }
    }

    /*
     * Loose catch block
     */
    public void close() throws OdaException {
        this.logMethodCalled("OdaQuery.close()\t");
        try {
            try {
                this.setContextClassloader();
                this.getQuery().close();
            }
            catch (UnsupportedOperationException uoException) {
                this.handleUnsupportedOp(uoException, "IQuery.close()");
                this.resetStatementStates();
                this.m_dataSetType = null;
                this.resetContextClassloader();
                this.logMethodExit("OdaQuery.close()\t");
            }
            catch (RuntimeException rtException) {
                this.handleError(rtException);
                this.resetStatementStates();
                this.m_dataSetType = null;
                this.resetContextClassloader();
                this.logMethodExit("OdaQuery.close()\t");
            }
            catch (OdaException odaException) {
                this.handleError(odaException);
                this.resetStatementStates();
                this.m_dataSetType = null;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                this.resetContextClassloader();
                this.logMethodExit("OdaQuery.close()\t");
            }
        }
        finally {
            this.resetStatementStates();
            this.m_dataSetType = null;
            this.resetContextClassloader();
            this.logMethodExit("OdaQuery.close()\t");
        }
    }

    /*
     * Loose catch block
     */
    public void setMaxRows(int max) throws OdaException {
        String context;
        block9: {
            context = "OdaQuery.setMaxRows( " + max + MSG_LINE_SEPARATOR;
            this.logMethodCalled(context);
            try {
                this.setContextClassloader();
                this.getQuery().setMaxRows(max);
            }
            catch (UnsupportedOperationException uoException) {
                this.handleUnsupportedOp(uoException, "IQuery.setMaxRows()");
                this.resetContextClassloader();
                break block9;
            }
            catch (RuntimeException rtException) {
                this.handleError(rtException);
                break block9;
            }
            catch (OdaException odaException) {
                this.handleError(odaException);
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                this.resetContextClassloader();
                break block9;
            }
            {
                finally {
                    this.resetContextClassloader();
                }
            }
            this.resetContextClassloader();
        }
        this.logMethodExit(context);
    }

    /*
     * Loose catch block
     */
    public int getMaxRows() throws OdaException {
        int ret;
        block9: {
            this.logMethodCalled("OdaQuery.getMaxRows()\t");
            ret = 0;
            try {
                this.setContextClassloader();
                ret = this.getQuery().getMaxRows();
            }
            catch (UnsupportedOperationException uoException) {
                this.handleUnsupportedOp(uoException, "IQuery.getMaxRows()");
                this.resetContextClassloader();
                break block9;
            }
            catch (RuntimeException rtException) {
                this.handleError(rtException);
                break block9;
            }
            catch (OdaException odaException) {
                this.handleError(odaException);
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                this.resetContextClassloader();
                break block9;
            }
            {
                finally {
                    this.resetContextClassloader();
                }
            }
            this.resetContextClassloader();
        }
        this.logMethodExitWithReturn("OdaQuery.getMaxRows()\t", ret);
        return ret;
    }

    public IResultSetMetaData getMetaData() throws OdaException {
        this.logMethodCalled("OdaQuery.getMetaData()\t");
        try {
            this.setContextClassloader();
            OdaResultSetMetaData ret = this.doGetMetaData();
            this.logMethodExitWithReturn("OdaQuery.getMetaData()\t", ret);
            OdaResultSetMetaData odaResultSetMetaData = ret;
            return odaResultSetMetaData;
        }
        catch (UnsupportedOperationException uoException) {
            this.handleUnsupportedOp(uoException, "IQuery.getMetaData()");
            return null;
        }
        catch (RuntimeException rtException) {
            this.handleError(rtException);
            return null;
        }
        catch (OdaException odaException) {
            this.handleError(odaException);
            return null;
        }
        finally {
            this.resetContextClassloader();
        }
    }

    private OdaResultSetMetaData doGetMetaData() throws OdaException {
        if (!this.isPreparedSuccessfully()) {
            throw this.newOdaException(Messages.helper_cannotGetResultSetMdBeforePrepare);
        }
        this.m_isExecuting = true;
        IResultSetMetaData resultSetMetaData = this.getQuery().getMetaData();
        this.m_isExecuting = false;
        OdaResultSetMetaData ret = resultSetMetaData == null ? null : new OdaResultSetMetaData(resultSetMetaData, this.getOdaConnection(), this.switchContextClassloader(), this.getDriverClassLoader());
        return ret;
    }

    public IResultSet executeQuery() throws OdaException {
        this.logMethodCalled("OdaQuery.executeQuery()\t");
        try {
            this.setContextClassloader();
            OdaResultSet ret = this.doExecuteQuery();
            this.logMethodExitWithReturn("OdaQuery.executeQuery()\t", ret);
            OdaResultSet odaResultSet = ret;
            return odaResultSet;
        }
        catch (UnsupportedOperationException uoException) {
            this.handleUnsupportedOp(uoException, "IQuery.executeQuery()");
            return null;
        }
        catch (RuntimeException rtException) {
            this.handleError(rtException);
            return null;
        }
        catch (OdaException odaException) {
            this.handleError(odaException);
            return null;
        }
        finally {
            this.resetContextClassloader();
        }
    }

    private OdaResultSet doExecuteQuery() throws OdaException {
        this.resetExecuteStates();
        if (!this.isPreparedSuccessfully()) {
            throw this.newOdaException(Messages.helper_cannotExecuteBeforePrepare);
        }
        this.m_isExecuting = true;
        IResultSet resultSet = this.getQuery().executeQuery();
        this.m_isExecuting = false;
        this.m_isExecuted = true;
        if (resultSet == null) {
            return null;
        }
        OdaResultSet ret = this.newResultSetHelper(resultSet);
        return ret;
    }

    protected OdaResultSet newResultSetHelper(IResultSet resultSet) {
        return new OdaResultSet(resultSet, this.getOdaConnection(), this.switchContextClassloader(), this.getDriverClassLoader());
    }

    /*
     * Loose catch block
     */
    public void setInt(String parameterName, int value) throws OdaException {
        String context = "OdaQuery.setInt( " + parameterName + MSG_ARG_SEPARATOR + value + MSG_LINE_SEPARATOR;
        this.logMethodCalled(context);
        try {
            try {
                this.setContextClassloader();
                this.throwIfSetParamBeforePrepare();
                this.getQuery().setInt(parameterName, value);
                this.logMethodExit(context);
            }
            catch (UnsupportedOperationException uoException) {
                this.handleUnsupportedOp(uoException, "IQuery.setInt( String parameterName, int value )");
                this.resetContextClassloader();
            }
            catch (RuntimeException rtException) {
                this.handleError(rtException);
                this.resetContextClassloader();
            }
            catch (OdaException odaException) {
                this.handleError(odaException);
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                this.resetContextClassloader();
            }
        }
        finally {
            this.resetContextClassloader();
        }
    }

    /*
     * Loose catch block
     */
    public void setInt(int parameterId, int value) throws OdaException {
        String context = "OdaQuery.setInt( " + parameterId + MSG_ARG_SEPARATOR + value + MSG_LINE_SEPARATOR;
        this.logMethodCalled(context);
        try {
            try {
                this.setContextClassloader();
                this.throwIfSetParamBeforePrepare();
                this.getQuery().setInt(parameterId, value);
                this.logMethodExit(context);
            }
            catch (UnsupportedOperationException uoException) {
                this.handleUnsupportedOp(uoException, "IQuery.setInt( int parameterId, int value )");
                this.resetContextClassloader();
            }
            catch (RuntimeException rtException) {
                this.handleError(rtException);
                this.resetContextClassloader();
            }
            catch (OdaException odaException) {
                this.handleError(odaException);
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                this.resetContextClassloader();
            }
        }
        finally {
            this.resetContextClassloader();
        }
    }

    /*
     * Loose catch block
     */
    public void setDouble(String parameterName, double value) throws OdaException {
        String context = "OdaQuery.setDouble( " + parameterName + MSG_ARG_SEPARATOR + value + MSG_LINE_SEPARATOR;
        this.logMethodCalled(context);
        try {
            try {
                this.setContextClassloader();
                this.throwIfSetParamBeforePrepare();
                this.getQuery().setDouble(parameterName, value);
                this.logMethodExit(context);
            }
            catch (UnsupportedOperationException uoException) {
                this.handleUnsupportedOp(uoException, "IQuery.setDouble( String parameterName, double value )");
                this.resetContextClassloader();
            }
            catch (RuntimeException rtException) {
                this.handleError(rtException);
                this.resetContextClassloader();
            }
            catch (OdaException odaException) {
                this.handleError(odaException);
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                this.resetContextClassloader();
            }
        }
        finally {
            this.resetContextClassloader();
        }
    }

    /*
     * Loose catch block
     */
    public void setDouble(int parameterId, double value) throws OdaException {
        String context = "OdaQuery.setDouble( " + parameterId + MSG_ARG_SEPARATOR + value + MSG_LINE_SEPARATOR;
        this.logMethodCalled(context);
        try {
            try {
                this.setContextClassloader();
                this.throwIfSetParamBeforePrepare();
                this.getQuery().setDouble(parameterId, value);
                this.logMethodExit(context);
            }
            catch (UnsupportedOperationException uoException) {
                this.handleUnsupportedOp(uoException, "IQuery.setDouble( int parameterId, double value )");
                this.resetContextClassloader();
            }
            catch (RuntimeException rtException) {
                this.handleError(rtException);
                this.resetContextClassloader();
            }
            catch (OdaException odaException) {
                this.handleError(odaException);
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                this.resetContextClassloader();
            }
        }
        finally {
            this.resetContextClassloader();
        }
    }

    /*
     * Loose catch block
     */
    public void setBigDecimal(String parameterName, BigDecimal value) throws OdaException {
        String context = "OdaQuery.setBigDecimal( " + parameterName + MSG_ARG_SEPARATOR + value + MSG_LINE_SEPARATOR;
        this.logMethodCalled(context);
        try {
            try {
                this.setContextClassloader();
                this.throwIfSetParamBeforePrepare();
                this.getQuery().setBigDecimal(parameterName, value);
                this.logMethodExit(context);
            }
            catch (UnsupportedOperationException uoException) {
                this.handleUnsupportedOp(uoException, "IQuery.setBigDecimal( String parameterName, BigDecimal value )");
                this.resetContextClassloader();
            }
            catch (RuntimeException rtException) {
                this.handleError(rtException);
                this.resetContextClassloader();
            }
            catch (OdaException odaException) {
                this.handleError(odaException);
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                this.resetContextClassloader();
            }
        }
        finally {
            this.resetContextClassloader();
        }
    }

    /*
     * Loose catch block
     */
    public void setBigDecimal(int parameterId, BigDecimal value) throws OdaException {
        String context = "OdaQuery.setBigDecimal( " + parameterId + MSG_ARG_SEPARATOR + value + MSG_LINE_SEPARATOR;
        this.logMethodCalled(context);
        try {
            try {
                this.setContextClassloader();
                this.throwIfSetParamBeforePrepare();
                this.getQuery().setBigDecimal(parameterId, value);
                this.logMethodExit(context);
            }
            catch (UnsupportedOperationException uoException) {
                this.handleUnsupportedOp(uoException, "IQuery.setBigDecimal( int parameterId, BigDecimal value )");
                this.resetContextClassloader();
            }
            catch (RuntimeException rtException) {
                this.handleError(rtException);
                this.resetContextClassloader();
            }
            catch (OdaException odaException) {
                this.handleError(odaException);
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                this.resetContextClassloader();
            }
        }
        finally {
            this.resetContextClassloader();
        }
    }

    /*
     * Loose catch block
     */
    public void setString(String parameterName, String value) throws OdaException {
        String context = "OdaQuery.setString( " + parameterName + MSG_ARG_SEPARATOR + value + MSG_LINE_SEPARATOR;
        this.logMethodCalled(context);
        try {
            try {
                this.setContextClassloader();
                this.throwIfSetParamBeforePrepare();
                this.getQuery().setString(parameterName, value);
                this.logMethodExit(context);
            }
            catch (UnsupportedOperationException uoException) {
                this.handleUnsupportedOp(uoException, "IQuery.setString( String parameterName, String value )");
                this.resetContextClassloader();
            }
            catch (RuntimeException rtException) {
                this.handleError(rtException);
                this.resetContextClassloader();
            }
            catch (OdaException odaException) {
                this.handleError(odaException);
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                this.resetContextClassloader();
            }
        }
        finally {
            this.resetContextClassloader();
        }
    }

    /*
     * Loose catch block
     */
    public void setString(int parameterId, String value) throws OdaException {
        String context = "OdaQuery.setString( " + parameterId + MSG_ARG_SEPARATOR + value + MSG_LINE_SEPARATOR;
        this.logMethodCalled(context);
        try {
            try {
                this.setContextClassloader();
                this.throwIfSetParamBeforePrepare();
                this.getQuery().setString(parameterId, value);
                this.logMethodExit(context);
            }
            catch (UnsupportedOperationException uoException) {
                this.handleUnsupportedOp(uoException, "IQuery.setString( int parameterId, String value )");
                this.resetContextClassloader();
            }
            catch (RuntimeException rtException) {
                this.handleError(rtException);
                this.resetContextClassloader();
            }
            catch (OdaException odaException) {
                this.handleError(odaException);
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                this.resetContextClassloader();
            }
        }
        finally {
            this.resetContextClassloader();
        }
    }

    /*
     * Loose catch block
     */
    public void setDate(String parameterName, Date value) throws OdaException {
        String context = "OdaQuery.setDate( " + parameterName + MSG_ARG_SEPARATOR + value + MSG_LINE_SEPARATOR;
        this.logMethodCalled(context);
        try {
            try {
                this.setContextClassloader();
                this.throwIfSetParamBeforePrepare();
                this.getQuery().setDate(parameterName, value);
                this.logMethodExit(context);
            }
            catch (UnsupportedOperationException uoException) {
                this.handleUnsupportedOp(uoException, "IQuery.setDate( String parameterName, Date value )");
                this.resetContextClassloader();
            }
            catch (RuntimeException rtException) {
                this.handleError(rtException);
                this.resetContextClassloader();
            }
            catch (OdaException odaException) {
                this.handleError(odaException);
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                this.resetContextClassloader();
            }
        }
        finally {
            this.resetContextClassloader();
        }
    }

    /*
     * Loose catch block
     */
    public void setDate(int parameterId, Date value) throws OdaException {
        String context = "OdaQuery.setDate( " + parameterId + MSG_ARG_SEPARATOR + value + MSG_LINE_SEPARATOR;
        this.logMethodCalled(context);
        try {
            try {
                this.setContextClassloader();
                this.throwIfSetParamBeforePrepare();
                this.getQuery().setDate(parameterId, value);
                this.logMethodExit(context);
            }
            catch (UnsupportedOperationException uoException) {
                this.handleUnsupportedOp(uoException, "IQuery.setDate( int parameterId, Date value )");
                this.resetContextClassloader();
            }
            catch (RuntimeException rtException) {
                this.handleError(rtException);
                this.resetContextClassloader();
            }
            catch (OdaException odaException) {
                this.handleError(odaException);
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                this.resetContextClassloader();
            }
        }
        finally {
            this.resetContextClassloader();
        }
    }

    /*
     * Loose catch block
     */
    public void setTime(String parameterName, Time value) throws OdaException {
        String context = "OdaQuery.setTime( " + parameterName + MSG_ARG_SEPARATOR + value + MSG_LINE_SEPARATOR;
        this.logMethodCalled(context);
        try {
            try {
                this.setContextClassloader();
                this.throwIfSetParamBeforePrepare();
                this.getQuery().setTime(parameterName, value);
                this.logMethodExit(context);
            }
            catch (UnsupportedOperationException uoException) {
                this.handleUnsupportedOp(uoException, "IQuery.setTime( String parameterName, Time value )");
                this.resetContextClassloader();
            }
            catch (RuntimeException rtException) {
                this.handleError(rtException);
                this.resetContextClassloader();
            }
            catch (OdaException odaException) {
                this.handleError(odaException);
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                this.resetContextClassloader();
            }
        }
        finally {
            this.resetContextClassloader();
        }
    }

    /*
     * Loose catch block
     */
    public void setTime(int parameterId, Time value) throws OdaException {
        String context = "OdaQuery.setTime( " + parameterId + MSG_ARG_SEPARATOR + value + MSG_LINE_SEPARATOR;
        this.logMethodCalled(context);
        try {
            try {
                this.setContextClassloader();
                this.throwIfSetParamBeforePrepare();
                this.getQuery().setTime(parameterId, value);
                this.logMethodExit(context);
            }
            catch (UnsupportedOperationException uoException) {
                this.handleUnsupportedOp(uoException, "IQuery.setTime( int parameterId, Time value )");
                this.resetContextClassloader();
            }
            catch (RuntimeException rtException) {
                this.handleError(rtException);
                this.resetContextClassloader();
            }
            catch (OdaException odaException) {
                this.handleError(odaException);
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                this.resetContextClassloader();
            }
        }
        finally {
            this.resetContextClassloader();
        }
    }

    /*
     * Loose catch block
     */
    public void setTimestamp(String parameterName, Timestamp value) throws OdaException {
        String context = "OdaQuery.setTimestamp( " + parameterName + MSG_ARG_SEPARATOR + value + MSG_LINE_SEPARATOR;
        this.logMethodCalled(context);
        try {
            try {
                this.setContextClassloader();
                this.throwIfSetParamBeforePrepare();
                this.getQuery().setTimestamp(parameterName, value);
                this.logMethodExit(context);
            }
            catch (UnsupportedOperationException uoException) {
                this.handleUnsupportedOp(uoException, "IQuery.setTimestamp( String parameterName, Timestamp value )");
                this.resetContextClassloader();
            }
            catch (RuntimeException rtException) {
                this.handleError(rtException);
                this.resetContextClassloader();
            }
            catch (OdaException odaException) {
                this.handleError(odaException);
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                this.resetContextClassloader();
            }
        }
        finally {
            this.resetContextClassloader();
        }
    }

    /*
     * Loose catch block
     */
    public void setTimestamp(int parameterId, Timestamp value) throws OdaException {
        String context = "OdaQuery.setTimestamp( " + parameterId + MSG_ARG_SEPARATOR + value + MSG_LINE_SEPARATOR;
        this.logMethodCalled(context);
        try {
            try {
                this.setContextClassloader();
                this.throwIfSetParamBeforePrepare();
                this.getQuery().setTimestamp(parameterId, value);
                this.logMethodExit(context);
            }
            catch (UnsupportedOperationException uoException) {
                this.handleUnsupportedOp(uoException, "IQuery.setTimestamp( int parameterId, Timestamp value )");
                this.resetContextClassloader();
            }
            catch (RuntimeException rtException) {
                this.handleError(rtException);
                this.resetContextClassloader();
            }
            catch (OdaException odaException) {
                this.handleError(odaException);
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                this.resetContextClassloader();
            }
        }
        finally {
            this.resetContextClassloader();
        }
    }

    /*
     * Exception decompiling
     */
    public void setBoolean(String parameterName, boolean value) throws OdaException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public void setBoolean(int parameterId, boolean value) throws OdaException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public void setObject(String parameterName, Object value) throws OdaException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public void setObject(int parameterId, Object value) throws OdaException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public void setNull(String parameterName) throws OdaException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public void setNull(int parameterId) throws OdaException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Loose catch block
     */
    public void clearInParameters() throws OdaException {
        this.logMethodCalled("OdaQuery.clearInParameters()\t");
        try {
            try {
                this.setContextClassloader();
                this.getQuery().clearInParameters();
                this.logMethodExit("OdaQuery.clearInParameters()\t");
            }
            catch (UnsupportedOperationException uoException) {
                this.handleUnsupportedOp(uoException, "IQuery.clearInParameters()");
                this.resetContextClassloader();
            }
            catch (RuntimeException rtException) {
                this.handleError(rtException);
                this.resetContextClassloader();
            }
            catch (OdaException odaException) {
                this.handleError(odaException);
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                this.resetContextClassloader();
            }
        }
        finally {
            this.resetContextClassloader();
        }
    }

    public int findInParameter(String parameterName) throws OdaException {
        String context = "OdaQuery.findInParameter( " + parameterName + MSG_LINE_SEPARATOR;
        this.logMethodCalled(context);
        try {
            this.setContextClassloader();
            if (!this.isPreparedSuccessfully()) {
                throw this.newOdaException(Messages.helper_cannotGetParamMdBeforePrepare);
            }
            int ret = this.getQuery().findInParameter(parameterName);
            this.logMethodExitWithReturn(context, ret);
            int n = ret;
            return n;
        }
        catch (UnsupportedOperationException uoException) {
            int n = this.handleUnsupportedOpAndRetZero(uoException, "IQuery.findInParameter( String parameterName )");
            return n;
        }
        catch (RuntimeException rtException) {
            int n = this.handleErrorAndReturnZero(rtException);
            return n;
        }
        catch (OdaException odaException) {
            int n = this.handleErrorAndReturnZero(odaException);
            return n;
        }
        finally {
            this.resetContextClassloader();
        }
    }

    public IParameterMetaData getParameterMetaData() throws OdaException {
        this.logMethodCalled("OdaQuery.getParameterMetaData()\t");
        try {
            this.setContextClassloader();
            if (!this.isPreparedSuccessfully()) {
                throw this.newOdaException(Messages.helper_cannotGetParamMdBeforePrepare);
            }
            IParameterMetaData parameterMetaData = this.getQuery().getParameterMetaData();
            OdaParameterMetaData ret = parameterMetaData == null ? null : new OdaParameterMetaData(parameterMetaData, this.getOdaConnection(), this.switchContextClassloader(), this.getDriverClassLoader());
            this.logMethodExitWithReturn("OdaQuery.getParameterMetaData()\t", ret);
            OdaParameterMetaData odaParameterMetaData = ret;
            return odaParameterMetaData;
        }
        catch (UnsupportedOperationException uoException) {
            this.handleUnsupportedOp(uoException, "IQuery.getParameterMetaData()");
            return null;
        }
        catch (OdaException odaException) {
            this.handleError(odaException);
            return null;
        }
        catch (RuntimeException rtException) {
            this.handleError(rtException);
            return null;
        }
        finally {
            this.resetContextClassloader();
        }
    }

    /*
     * Loose catch block
     */
    public void setSortSpec(SortSpec sortBy) throws OdaException {
        String context = "OdaQuery.setSortSpec( " + sortBy + MSG_LINE_SEPARATOR;
        this.logMethodCalled(context);
        try {
            try {
                this.setContextClassloader();
                if (!this.isPreparedSuccessfully()) {
                    throw this.newOdaException(Messages.helper_cannotSetSortSpecBeforePrepare);
                }
                this.getQuery().setSortSpec(sortBy);
                this.logMethodExit(context);
            }
            catch (UnsupportedOperationException uoException) {
                this.handleUnsupportedOp(uoException, "IQuery.setSortSpec( SortSpec sortBy )");
                this.resetContextClassloader();
            }
            catch (RuntimeException rtException) {
                this.handleError(rtException);
                this.resetContextClassloader();
            }
            catch (OdaException odaException) {
                this.handleError(odaException);
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                this.resetContextClassloader();
            }
        }
        finally {
            this.resetContextClassloader();
        }
    }

    public SortSpec getSortSpec() throws OdaException {
        this.logMethodCalled("OdaQuery.getSortSpec()\t");
        try {
            this.setContextClassloader();
            SortSpec sortSpec = this.getQuery().getSortSpec();
            this.logMethodExitWithReturn("OdaQuery.getSortSpec()\t", sortSpec);
            SortSpec sortSpec2 = sortSpec;
            return sortSpec2;
        }
        catch (UnsupportedOperationException uoException) {
            this.handleUnsupportedOp(uoException, "IQuery.getSortSpec()");
        }
        catch (RuntimeException rtException) {
            this.handleError(rtException);
        }
        catch (OdaException odaException) {
            this.handleError(odaException);
        }
        finally {
            this.resetContextClassloader();
        }
        return null;
    }

    public QuerySpecification getSpecification() {
        this.logMethodCalled("OdaQuery.getSpecification()\t");
        try {
            this.setContextClassloader();
            QuerySpecification querySpec = this.getQuery().getSpecification();
            this.logMethodExitWithReturn("OdaQuery.getSpecification()\t", querySpec);
            QuerySpecification querySpecification = querySpec;
            return querySpecification;
        }
        catch (AbstractMethodError abstractMethodError) {
            String msg = this.formatMethodNotImplementedMsg("IQuery.getSpecification()");
            this.log("OdaQuery.getSpecification()\t", msg);
            return null;
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            return null;
        }
        catch (RuntimeException rtException) {
            this.handleError(rtException);
        }
        finally {
            this.resetContextClassloader();
        }
        return null;
    }

    /*
     * Exception decompiling
     */
    public void setSpecification(QuerySpecification querySpec) throws OdaException, UnsupportedOperationException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public String getEffectiveQueryText() {
        this.logMethodCalled("OdaQuery.getEffectiveQueryText()\t");
        try {
            this.setContextClassloader();
            String effectiveQuery = this.getQuery().getEffectiveQueryText();
            this.logMethodExitWithReturn("OdaQuery.getEffectiveQueryText()\t", effectiveQuery);
            String string = effectiveQuery;
            return string;
        }
        catch (AbstractMethodError abstractMethodError) {
            String msg = this.formatMethodNotImplementedMsg("IQuery.getEffectiveQueryText()");
            this.log("OdaQuery.getEffectiveQueryText()\t", msg);
            String string = this.m_preparedText;
            return string;
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            String string = this.m_preparedText;
            return string;
        }
        catch (RuntimeException rtException) {
            this.handleError(rtException);
        }
        finally {
            this.resetContextClassloader();
        }
        return this.m_preparedText;
    }

    /*
     * Exception decompiling
     */
    public void cancel() throws OdaException, UnsupportedOperationException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public String getInterfaceName() {
        return IQuery.class.getName();
    }

    private void throwIfSetParamBeforePrepare() throws OdaException {
        if (!this.isPreparedSuccessfully()) {
            throw this.newOdaException(Messages.helper_cannotSetParamBeforePrepare);
        }
    }
}

