/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.util.attachment.actions;

import fr.ifremer.tutti.persistence.entities.data.Attachment;
import fr.ifremer.tutti.persistence.entities.data.Attachments;
import fr.ifremer.tutti.ui.swing.util.actions.SimpleActionSupport;
import fr.ifremer.tutti.ui.swing.util.attachment.AttachmentEditorUI;
import fr.ifremer.tutti.ui.swing.util.attachment.AttachmentEditorUIHandler;
import fr.ifremer.tutti.ui.swing.util.attachment.AttachmentModelAware;
import java.io.File;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AddAttachmentAction
extends SimpleActionSupport<AttachmentEditorUI> {
    private static final Log log = LogFactory.getLog(AddAttachmentAction.class);
    private static final long serialVersionUID = 1L;

    public AddAttachmentAction(AttachmentEditorUI ui) {
        super(ui);
    }

    @Override
    protected void onActionPerformed(AttachmentEditorUI ui) {
        File file = ui.getFile().getSelectedFile();
        if (file != null) {
            String name = ui.getFileName().getText();
            if (StringUtils.isEmpty((CharSequence)name)) {
                name = file.getName();
            }
            if (log.isInfoEnabled()) {
                log.info((Object)("Add attachment: " + name));
            }
            AttachmentModelAware bean = ui.getBean();
            Attachment attachment = Attachments.newAttachment();
            attachment.setObjectType(bean.getObjectType());
            attachment.setObjectId(bean.getObjectId());
            attachment.setName(name);
            attachment.setComment(ui.getFileComment().getText());
            AttachmentEditorUIHandler handler = ui.getHandler();
            attachment = handler.getPersistenceService().createAttachment(attachment, file);
            bean.addAttachment(attachment);
            handler.resetFields();
            handler.addAttachment(attachment);
            ui.pack();
        }
    }
}

