package fr.ifremer.tutti.ui.swing.content.operation.catches.species.create;

/*
 * #%L
 * Tutti :: UI
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2015 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.persistence.entities.data.SampleCategoryModelEntry;
import fr.ifremer.tutti.persistence.entities.referential.CaracteristicQualitativeValue;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.ui.swing.TuttiHelpBroker;
import fr.ifremer.tutti.ui.swing.content.operation.catches.EditCatchesUI;
import fr.ifremer.tutti.ui.swing.util.TuttiUI;
import fr.ifremer.tutti.ui.swing.util.TuttiUIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.JAXXValidator;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.Table;
import jaxx.runtime.swing.editor.bean.BeanFilterableComboBox;
import jaxx.runtime.swing.help.JAXXHelpUI;
import jaxx.runtime.validator.swing.SwingValidator;
import jaxx.runtime.validator.swing.SwingValidatorUtil;
import jaxx.runtime.validator.swing.meta.Validator;
import jaxx.runtime.validator.swing.meta.ValidatorField;
import jaxx.runtime.validator.swing.ui.ImageValidationUI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXTable;
import org.nuiton.jaxx.widgets.number.NumberEditor;
import static jaxx.runtime.SwingUtil.getStringValue;
import static org.nuiton.i18n.I18n.t;

public class CreateSpeciesBatchUI extends JPanel implements JAXXHelpUI<TuttiHelpBroker>, TuttiUI<CreateSpeciesBatchUIModel, CreateSpeciesBatchUIHandler>, JAXXObject, JAXXValidator {

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_BATCH_COUNT_FIELD_NUMBER_PATTERN = "batchCountField.numberPattern";
    public static final String BINDING_BATCH_COUNT_FIELD_NUMBER_VALUE = "batchCountField.numberValue";
    public static final String BINDING_BATCH_WEIGHT_FIELD_NUMBER_VALUE = "batchWeightField.numberValue";
    public static final String BINDING_CATEGORY_COMBO_BOX_DATA = "categoryComboBox.data";
    public static final String BINDING_CATEGORY_COMBO_BOX_ENABLED = "categoryComboBox.enabled";
    public static final String BINDING_CATEGORY_COMBO_BOX_SELECTED_ITEM = "categoryComboBox.selectedItem";
    public static final String BINDING_CATEGORY_PANEL_VISIBLE = "categoryPanel.visible";
    public static final String BINDING_SAMPLE_CATEGORY_COMBO_BOX_SELECTED_ITEM = "sampleCategoryComboBox.selectedItem";
    public static final String BINDING_SAMPLE_WEIGHT_FIELD_TEXT = "sampleWeightField.text";
    public static final String BINDING_SAVE_AND_CLOSE_BUTTON_ENABLED = "saveAndCloseButton.enabled";
    public static final String BINDING_SAVE_AND_CONTINUE_BUTTON_ENABLED = "saveAndContinueButton.enabled";
    public static final String BINDING_SPECIES_COMBO_BOX_DATA = "speciesComboBox.data";
    public static final String BINDING_SPECIES_COMBO_BOX_SELECTED_ITEM = "speciesComboBox.selectedItem";
    public static final String BINDING_TABLE_ENABLED = "table.enabled";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "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";
    private static final Log log = LogFactory.getLog(CreateSpeciesBatchUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JButton addSpeciesButton;
    @ValidatorField( validatorId = "validator",  propertyName = "batchCount",  editorName = "batchCountField")
    protected NumberEditor batchCountField;
    protected JLabel batchCountLabel;
    @ValidatorField( validatorId = "validator",  propertyName = "batchWeight",  editorName = "batchWeightField")
    protected NumberEditor batchWeightField;
    protected JLabel batchWeightLabel;
    protected TuttiHelpBroker broker;
    protected JButton cancelButton;
    @ValidatorField( validatorId = "validator",  propertyName = "selectedCategory",  editorName = "categoryComboBox")
    protected BeanFilterableComboBox<SampleCategoryModelEntry> categoryComboBox;
    protected Table categoryConfigurationPanel;
    protected JLabel categoryLabel;
    protected JPanel categoryPanel;
    protected Table configurationPanel;
    protected CreateSpeciesBatchUI createSpeciesBatchTopPanel = this;
    protected final CreateSpeciesBatchUIHandler handler = createHandler();
    protected CreateSpeciesBatchUIModel model;
    @ValidatorField( validatorId = "validator",  propertyName = "sampleCategory",  editorName = "sampleCategoryComboBox")
    protected BeanFilterableComboBox<CaracteristicQualitativeValue> sampleCategoryComboBox;
    protected JLabel sampleCategoryLabel;
    @ValidatorField( validatorId = "validator",  propertyName = "sampleWeight",  editorName = "sampleWeightField")
    protected JTextField sampleWeightField;
    protected JLabel sampleWeightLabel;
    protected JButton saveAndCloseButton;
    protected JButton saveAndContinueButton;
    @ValidatorField( validatorId = "validator",  propertyName = "species",  editorName = "speciesComboBox")
    protected BeanFilterableComboBox<Species> speciesComboBox;
    protected JLabel speciesLabel;
    protected JXTable table;
    protected JScrollPane tableScrollPane;
    @Validator( validatorId = "validator")
    protected SwingValidator<CreateSpeciesBatchUIModel> validator;
    protected List<String> validatorIds = new ArrayList<String>();

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JPanel $JPanel0;
    private JSeparator $JSeparator0;

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public CreateSpeciesBatchUI(EditCatchesUI parentUI) {
        TuttiUIUtil.setParentUI(this, parentUI);
            $initialize();
    }

    public CreateSpeciesBatchUI(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public CreateSpeciesBatchUI(JAXXContext parentContext, LayoutManager param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public CreateSpeciesBatchUI() {
        $initialize();
    }

    public CreateSpeciesBatchUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public CreateSpeciesBatchUI(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public CreateSpeciesBatchUI(JAXXContext parentContext, LayoutManager param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public CreateSpeciesBatchUI(boolean param0) {
        super(param0);
        $initialize();
    }

    public CreateSpeciesBatchUI(JAXXContext parentContext, boolean param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*-------------------- JAXXValidator implementation  --------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public SwingValidator<?> getValidator(String validatorId) {
        return (SwingValidator<?>) (validatorIds.contains(validatorId) ? getObjectById(validatorId) : null);
    }

    @Override
    public List<String> getValidatorIds() {
        return validatorIds;
    }

    @Override
    public void registerValidatorFields() {
        SwingValidatorUtil.detectValidatorFields(this);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JButton getAddSpeciesButton() {
        return addSpeciesButton;
    }

    public NumberEditor getBatchCountField() {
        return batchCountField;
    }

    public JLabel getBatchCountLabel() {
        return batchCountLabel;
    }

    public NumberEditor getBatchWeightField() {
        return batchWeightField;
    }

    public JLabel getBatchWeightLabel() {
        return batchWeightLabel;
    }

    public TuttiHelpBroker getBroker() {
        return broker;
    }

    public JButton getCancelButton() {
        return cancelButton;
    }

    public BeanFilterableComboBox<SampleCategoryModelEntry> getCategoryComboBox() {
        return categoryComboBox;
    }

    public Table getCategoryConfigurationPanel() {
        return categoryConfigurationPanel;
    }

    public JLabel getCategoryLabel() {
        return categoryLabel;
    }

    public JPanel getCategoryPanel() {
        return categoryPanel;
    }

    public Table getConfigurationPanel() {
        return configurationPanel;
    }

    public CreateSpeciesBatchUIHandler getHandler() {
        return handler;
    }

    public CreateSpeciesBatchUIModel getModel() {
        return model;
    }

    public BeanFilterableComboBox<CaracteristicQualitativeValue> getSampleCategoryComboBox() {
        return sampleCategoryComboBox;
    }

    public JLabel getSampleCategoryLabel() {
        return sampleCategoryLabel;
    }

    public JTextField getSampleWeightField() {
        return sampleWeightField;
    }

    public JLabel getSampleWeightLabel() {
        return sampleWeightLabel;
    }

    public JButton getSaveAndCloseButton() {
        return saveAndCloseButton;
    }

    public JButton getSaveAndContinueButton() {
        return saveAndContinueButton;
    }

    public BeanFilterableComboBox<Species> getSpeciesComboBox() {
        return speciesComboBox;
    }

    public JLabel getSpeciesLabel() {
        return speciesLabel;
    }

    public JXTable getTable() {
        return table;
    }

    public JScrollPane getTableScrollPane() {
        return tableScrollPane;
    }

    public SwingValidator<CreateSpeciesBatchUIModel> getValidator() {
        return validator;
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Other methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void registerHelpId(TuttiHelpBroker broker, Component component, String helpId) {
        broker.installUI(component, helpId);
    }

    @Override
    public void showHelp(String helpId) {
        getBroker().showHelp(this, helpId);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JPanel get$JPanel0() {
        return $JPanel0;
    }

    protected JSeparator get$JSeparator0() {
        return $JSeparator0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToCategoryConfigurationPanel() {
        if (!allComponentsCreated) {
            return;
        }
        categoryConfigurationPanel.add($JSeparator0, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        categoryConfigurationPanel.add(categoryLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        categoryConfigurationPanel.add(SwingUtil.boxComponentWithJxLayer(categoryComboBox), new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        categoryConfigurationPanel.add(sampleWeightLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        categoryConfigurationPanel.add(SwingUtil.boxComponentWithJxLayer(sampleWeightField), new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void addChildrenToCategoryPanel() {
        if (!allComponentsCreated) {
            return;
        }
        categoryPanel.add(categoryConfigurationPanel, BorderLayout.NORTH);
        categoryPanel.add(tableScrollPane, BorderLayout.CENTER);
    }

    protected void addChildrenToConfigurationPanel() {
        if (!allComponentsCreated) {
            return;
        }
        configurationPanel.add(speciesLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        configurationPanel.add(SwingUtil.boxComponentWithJxLayer(speciesComboBox), new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        configurationPanel.add(addSpeciesButton, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        configurationPanel.add(batchWeightLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        configurationPanel.add(SwingUtil.boxComponentWithJxLayer(batchWeightField), new GridBagConstraints(1, 1, 2, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        configurationPanel.add(batchCountLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        configurationPanel.add(SwingUtil.boxComponentWithJxLayer(batchCountField), new GridBagConstraints(1, 2, 2, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        configurationPanel.add(sampleCategoryLabel, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        configurationPanel.add(SwingUtil.boxComponentWithJxLayer(sampleCategoryComboBox), new GridBagConstraints(1, 3, 2, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void addChildrenToCreateSpeciesBatchTopPanel() {
        if (!allComponentsCreated) {
            return;
        }
        add(configurationPanel, BorderLayout.NORTH);
        add(categoryPanel, BorderLayout.CENTER);
        add($JPanel0, BorderLayout.SOUTH);
    }

    protected void addChildrenToTableScrollPane() {
        if (!allComponentsCreated) {
            return;
        }
        tableScrollPane.getViewport().add(table);
    }

    protected void addChildrenToValidator() {
        if (!allComponentsCreated) {
            return;
        }
        validator.setUiClass(ImageValidationUI.class);
        validator.setBean(model);
    }

    protected void createAddSpeciesButton() {
        $objectMap.put("addSpeciesButton", addSpeciesButton = new JButton());
        
        addSpeciesButton.setName("addSpeciesButton");
        addSpeciesButton.setFocusable(false);
        addSpeciesButton.setText(t("tutti.createSpeciesBatch.action.addSpecies"));
        addSpeciesButton.setToolTipText(t("tutti.createSpeciesBatch.action.addSpecies.tip"));
        addSpeciesButton.putClientProperty("applicationAction", fr.ifremer.tutti.ui.swing.content.operation.catches.species.create.actions.SelectSpeciesForSpeciesBatchAction.class);
        addSpeciesButton.putClientProperty("help", "tutti.createSpeciesBatch.action.addSpecies.help");
    }

    protected void createBatchCountField() {
        $objectMap.put("batchCountField", batchCountField = new NumberEditor(this));
        
        batchCountField.setName("batchCountField");
        batchCountField.setProperty("batchCount");
        batchCountField.setShowReset(true);
        batchCountField.putClientProperty("help", "tutti.createSpeciesBatch.field.batchCount.help");
    }

    protected void createBatchCountLabel() {
        $objectMap.put("batchCountLabel", batchCountLabel = new JLabel());
        
        batchCountLabel.setName("batchCountLabel");
        batchCountLabel.setText(t("tutti.createSpeciesBatch.field.batchCount"));
        batchCountLabel.setToolTipText(t("tutti.createSpeciesBatch.field.batchCount.tip"));
        batchCountLabel.putClientProperty("help", "tutti.createSpeciesBatch.field.batchCount.help");
    }

    protected void createBatchWeightField() {
        $objectMap.put("batchWeightField", batchWeightField = new NumberEditor(this));
        
        batchWeightField.setName("batchWeightField");
        batchWeightField.setProperty("batchWeight");
        batchWeightField.setShowReset(true);
        batchWeightField.putClientProperty("help", "tutti.createSpeciesBatch.field.batchWeight.help");
    }

    protected void createBatchWeightLabel() {
        $objectMap.put("batchWeightLabel", batchWeightLabel = new JLabel());
        
        batchWeightLabel.setName("batchWeightLabel");
        batchWeightLabel.setText(t("tutti.createSpeciesBatch.field.batchWeight"));
        batchWeightLabel.setToolTipText(t("tutti.createSpeciesBatch.field.batchWeight.tip"));
        batchWeightLabel.putClientProperty("help", "tutti.createSpeciesBatch.field.batchWeight.help");
        batchWeightLabel.putClientProperty("addWeightUnit", handler.getConfig().getSpeciesWeightUnit());
    }

    protected void createBroker() {
        $objectMap.put("broker", broker = new TuttiHelpBroker("tutti.createSpeciesBatch.help"));
    }

    protected void createCancelButton() {
        $objectMap.put("cancelButton", cancelButton = new JButton());
        
        cancelButton.setName("cancelButton");
        cancelButton.setText(t("tutti.createSpeciesBatch.action.cancel"));
        cancelButton.setToolTipText(t("tutti.createSpeciesBatch.action.cancel.tip"));
        cancelButton.putClientProperty("help", "tutti.createSpeciesBatch.action.cancel.help");
        cancelButton.putClientProperty("simpleAction", fr.ifremer.tutti.ui.swing.content.operation.catches.species.create.actions.CreateSpeciesBatchCancelAction.class);
    }

    protected void createCategoryComboBox() {
        $objectMap.put("categoryComboBox", categoryComboBox = new BeanFilterableComboBox<SampleCategoryModelEntry>(this));
        
        categoryComboBox.setName("categoryComboBox");
        categoryComboBox.setShowDecorator(false);
        categoryComboBox.setSortable(false);
        categoryComboBox.setProperty("selectedCategory");
        categoryComboBox.setShowReset(false);
        categoryComboBox.putClientProperty("help", "tutti.createSpeciesBatch.field.categoryField.help");
    }

    protected void createCategoryConfigurationPanel() {
        $objectMap.put("categoryConfigurationPanel", categoryConfigurationPanel = new Table());
        
        categoryConfigurationPanel.setName("categoryConfigurationPanel");
    }

    protected void createCategoryLabel() {
        $objectMap.put("categoryLabel", categoryLabel = new JLabel());
        
        categoryLabel.setName("categoryLabel");
        categoryLabel.setText(t("tutti.createSpeciesBatch.field.category"));
        categoryLabel.setToolTipText(t("tutti.createSpeciesBatch.field.category.tip"));
        categoryLabel.putClientProperty("help", "tutti.createSpeciesBatch.field.categoryField.help");
    }

    protected void createCategoryPanel() {
        $objectMap.put("categoryPanel", categoryPanel = new JPanel());
        
        categoryPanel.setName("categoryPanel");
        categoryPanel.setLayout(new BorderLayout());
    }

    protected void createConfigurationPanel() {
        $objectMap.put("configurationPanel", configurationPanel = new Table());
        
        configurationPanel.setName("configurationPanel");
    }

    protected CreateSpeciesBatchUIHandler createHandler() {
        return new CreateSpeciesBatchUIHandler();
    }

    protected void createModel() {
        $objectMap.put("model", model = getContextValue(CreateSpeciesBatchUIModel.class));
    }

    protected void createSampleCategoryComboBox() {
        $objectMap.put("sampleCategoryComboBox", sampleCategoryComboBox = new BeanFilterableComboBox<CaracteristicQualitativeValue>(this));
        
        sampleCategoryComboBox.setName("sampleCategoryComboBox");
        sampleCategoryComboBox.setProperty("sampleCategory");
        sampleCategoryComboBox.setShowReset(true);
        sampleCategoryComboBox.putClientProperty("help", "tutti.createSpeciesBatch.field.sampleCategory.help");
    }

    protected void createSampleCategoryLabel() {
        $objectMap.put("sampleCategoryLabel", sampleCategoryLabel = new JLabel());
        
        sampleCategoryLabel.setName("sampleCategoryLabel");
        sampleCategoryLabel.setText(t("tutti.createSpeciesBatch.field.sampleCategory"));
        sampleCategoryLabel.setToolTipText(t("tutti.createSpeciesBatch.field.sampleCategory.tip"));
        sampleCategoryLabel.putClientProperty("help", "tutti.createSpeciesBatch.field.sampleCategory.help");
    }

    protected void createSampleWeightField() {
        $objectMap.put("sampleWeightField", sampleWeightField = new JTextField());
        
        sampleWeightField.setName("sampleWeightField");
        sampleWeightField.setColumns(15);
        sampleWeightField.putClientProperty("help", "tutti.createSpeciesBatch.field.sampleWeightField.help");
        sampleWeightField.putClientProperty("computed", true);
    }

    protected void createSampleWeightLabel() {
        $objectMap.put("sampleWeightLabel", sampleWeightLabel = new JLabel());
        
        sampleWeightLabel.setName("sampleWeightLabel");
        sampleWeightLabel.setText(t("tutti.createSpeciesBatch.field.sampleWeight"));
        sampleWeightLabel.setToolTipText(t("tutti.createSpeciesBatch.field.sampleWeight.tip"));
        sampleWeightLabel.putClientProperty("help", "tutti.createSpeciesBatch.field.sampleWeightField.help");
        sampleWeightLabel.putClientProperty("addWeightUnit", handler.getConfig().getSpeciesWeightUnit());
    }

    protected void createSaveAndCloseButton() {
        $objectMap.put("saveAndCloseButton", saveAndCloseButton = new JButton());
        
        saveAndCloseButton.setName("saveAndCloseButton");
        saveAndCloseButton.setText(t("tutti.createSpeciesBatch.action.saveAndClose"));
        saveAndCloseButton.setToolTipText(t("tutti.createSpeciesBatch.action.saveAndClose.tip"));
        saveAndCloseButton.putClientProperty("help", "tutti.createSpeciesBatch.action.saveAndClose.help");
        saveAndCloseButton.putClientProperty("simpleAction", fr.ifremer.tutti.ui.swing.content.operation.catches.species.create.actions.CreateSpeciesBatchAndCloseAction.class);
    }

    protected void createSaveAndContinueButton() {
        $objectMap.put("saveAndContinueButton", saveAndContinueButton = new JButton());
        
        saveAndContinueButton.setName("saveAndContinueButton");
        saveAndContinueButton.setText(t("tutti.createSpeciesBatch.action.saveAndContinue"));
        saveAndContinueButton.setToolTipText(t("tutti.createSpeciesBatch.action.saveAndContinue.tip"));
        saveAndContinueButton.putClientProperty("help", "tutti.createSpeciesBatch.action.saveAndContinue.help");
        saveAndContinueButton.putClientProperty("simpleAction", fr.ifremer.tutti.ui.swing.content.operation.catches.species.create.actions.CreateSpeciesBatchAndContinueAction.class);
    }

    protected void createSpeciesComboBox() {
        $objectMap.put("speciesComboBox", speciesComboBox = new BeanFilterableComboBox<Species>(this));
        
        speciesComboBox.setName("speciesComboBox");
        speciesComboBox.setProperty("species");
        speciesComboBox.setShowReset(true);
        speciesComboBox.putClientProperty("help", "tutti.createSpeciesBatch.field.species.help");
    }

    protected void createSpeciesLabel() {
        $objectMap.put("speciesLabel", speciesLabel = new JLabel());
        
        speciesLabel.setName("speciesLabel");
        speciesLabel.setText(t("tutti.createSpeciesBatch.field.species"));
        speciesLabel.setToolTipText(t("tutti.createSpeciesBatch.field.species.tip"));
        speciesLabel.putClientProperty("help", "tutti.createSpeciesBatch.field.species.help");
    }

    protected void createTable() {
        $objectMap.put("table", table = new JXTable());
        
        table.setName("table");
        table.setSortable(false);
    }

    protected void createTableScrollPane() {
        $objectMap.put("tableScrollPane", tableScrollPane = new JScrollPane());
        
        tableScrollPane.setName("tableScrollPane");
    }

    protected void createValidator() {
        $objectMap.put("validator", validator = SwingValidator.newValidator(CreateSpeciesBatchUIModel.class, null));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToCreateSpeciesBatchTopPanel();
        addChildrenToValidator();
        addChildrenToConfigurationPanel();
        addChildrenToCategoryPanel();
        addChildrenToCategoryConfigurationPanel();
        addChildrenToTableScrollPane();
        // inline complete setup of $JPanel0
        $JPanel0.add(cancelButton);
        $JPanel0.add(saveAndContinueButton);
        $JPanel0.add(saveAndCloseButton);
        
        // apply 14 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 33 property setters
        speciesComboBox.setBeanType(Species.class);
        sampleCategoryComboBox.setBeanType(CaracteristicQualitativeValue.class);
        categoryComboBox.setBeanType(SampleCategoryModelEntry.class);
        speciesLabel.setLabelFor(speciesComboBox);
        speciesComboBox.setBean(model);
        addSpeciesButton.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.createSpeciesBatch.action.addSpecies.mnemonic"),'Z'));
        batchWeightLabel.setLabelFor(batchWeightField);
        batchWeightField.setBean(model);
        batchWeightField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        batchWeightField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        batchWeightField.setNumberType(Float.class);
        batchCountLabel.setLabelFor(batchCountField);
        batchCountField.setBean(model);
        batchCountField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        batchCountField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        batchCountField.setNumberType(Integer.class);
        sampleCategoryLabel.setLabelFor(sampleCategoryComboBox);
        sampleCategoryComboBox.setBean(model);
        categoryLabel.setLabelFor(categoryComboBox);
        categoryComboBox.setBean(model);
        sampleWeightLabel.setLabelFor(sampleWeightField);
        table.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
        table.setSelectionForeground(Color.BLACK);
        table.setSelectionBackground(null);
        cancelButton.setIcon(SwingUtil.createActionIcon("cancel"));
        cancelButton.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.createSpeciesBatch.action.cancel.mnemonic"),'Z'));
        saveAndContinueButton.setIcon(SwingUtil.createActionIcon("save"));
        saveAndContinueButton.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.createSpeciesBatch.action.saveAndContinue.mnemonic"),'Z'));
        saveAndCloseButton.setIcon(SwingUtil.createActionIcon("save"));
        saveAndCloseButton.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.createSpeciesBatch.action.saveAndClose.mnemonic"),'Z'));
        // late initializer
        // help broker setup
        TuttiHelpBroker _broker = getBroker();
        registerHelpId(_broker, createSpeciesBatchTopPanel, "tutti.createSpeciesBatch.help");
        registerHelpId(_broker, speciesLabel, "tutti.createSpeciesBatch.field.species.help");
        registerHelpId(_broker, speciesComboBox, "tutti.createSpeciesBatch.field.species.help");
        registerHelpId(_broker, addSpeciesButton, "tutti.createSpeciesBatch.action.addSpecies.help");
        registerHelpId(_broker, batchWeightLabel, "tutti.createSpeciesBatch.field.batchWeight.help");
        registerHelpId(_broker, batchWeightField, "tutti.createSpeciesBatch.field.batchWeight.help");
        registerHelpId(_broker, batchCountLabel, "tutti.createSpeciesBatch.field.batchCount.help");
        registerHelpId(_broker, batchCountField, "tutti.createSpeciesBatch.field.batchCount.help");
        registerHelpId(_broker, sampleCategoryLabel, "tutti.createSpeciesBatch.field.sampleCategory.help");
        registerHelpId(_broker, sampleCategoryComboBox, "tutti.createSpeciesBatch.field.sampleCategory.help");
        registerHelpId(_broker, categoryLabel, "tutti.createSpeciesBatch.field.categoryField.help");
        registerHelpId(_broker, categoryComboBox, "tutti.createSpeciesBatch.field.categoryField.help");
        registerHelpId(_broker, sampleWeightLabel, "tutti.createSpeciesBatch.field.sampleWeightField.help");
        registerHelpId(_broker, sampleWeightField, "tutti.createSpeciesBatch.field.sampleWeightField.help");
        registerHelpId(_broker, cancelButton, "tutti.createSpeciesBatch.action.cancel.help");
        registerHelpId(_broker, saveAndContinueButton, "tutti.createSpeciesBatch.action.saveAndContinue.help");
        registerHelpId(_broker, saveAndCloseButton, "tutti.createSpeciesBatch.action.saveAndClose.help");
        _broker.prepareUI(this);
        // register 1 validator(s)
        validatorIds = SwingValidatorUtil.detectValidators(this);
        SwingValidatorUtil.installUI(this);
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        handler.beforeInit(this);
        $objectMap.put("createSpeciesBatchTopPanel", createSpeciesBatchTopPanel);
        createModel();
        createValidator();
        createBroker();
        createConfigurationPanel();
        createSpeciesLabel();
        createSpeciesComboBox();
        createAddSpeciesButton();
        createBatchWeightLabel();
        createBatchWeightField();
        createBatchCountLabel();
        createBatchCountField();
        createSampleCategoryLabel();
        createSampleCategoryComboBox();
        createCategoryPanel();
        createCategoryConfigurationPanel();
        // inline creation of $JSeparator0
        $objectMap.put("$JSeparator0", $JSeparator0 = new JSeparator());
        
        $JSeparator0.setName("$JSeparator0");
        createCategoryLabel();
        createCategoryComboBox();
        createSampleWeightLabel();
        createSampleWeightField();
        createTableScrollPane();
        createTable();
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new JPanel());
        
        $JPanel0.setName("$JPanel0");
        $JPanel0.setLayout(new GridLayout(1, 0));
        createCancelButton();
        createSaveAndContinueButton();
        createSaveAndCloseButton();
        // inline creation of createSpeciesBatchTopPanel
        setName("createSpeciesBatchTopPanel");
        setLayout(new BorderLayout());
        createSpeciesBatchTopPanel.putClientProperty("help", "tutti.createSpeciesBatch.help");
        
        // registers 14 data bindings
        $registerDefaultBindings();
        $completeSetup();
        handler.afterInit(this);
    }

    private void $registerDefaultBindings() {
        // register 14 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SPECIES_COMBO_BOX_SELECTED_ITEM, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("species", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    speciesComboBox.setSelectedItem(model.getSpecies());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("species", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SPECIES_COMBO_BOX_DATA, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("availableSpecies", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    speciesComboBox.setData(model.getAvailableSpecies());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("availableSpecies", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_BATCH_WEIGHT_FIELD_NUMBER_VALUE, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("batchWeight", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    batchWeightField.setNumberValue(model.getBatchWeight());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("batchWeight", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_BATCH_COUNT_FIELD_NUMBER_VALUE, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("batchCount", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    batchCountField.setNumberValue(model.getBatchCount());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("batchCount", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_BATCH_COUNT_FIELD_NUMBER_PATTERN, true ,"INT_6_DIGITS_PATTERN") {
        
            @Override
            public void processDataBinding() {
                batchCountField.setNumberPattern(INT_6_DIGITS_PATTERN);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SAMPLE_CATEGORY_COMBO_BOX_SELECTED_ITEM, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("sampleCategory", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    sampleCategoryComboBox.setSelectedItem(model.getSampleCategory());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("sampleCategory", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_CATEGORY_PANEL_VISIBLE, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("species", this);
                }
                if (model != null) {
                    model.addPropertyChangeListener("batchCount", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    categoryPanel.setVisible(model.getSpecies() != null && model.getBatchCount() == null);
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("species", this);
                }
                if (model != null) {
                    model.removePropertyChangeListener("batchCount", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_CATEGORY_COMBO_BOX_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("batchCount", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    categoryComboBox.setEnabled(model.getBatchCount() == null);
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("batchCount", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_CATEGORY_COMBO_BOX_SELECTED_ITEM, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("selectedCategory", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    categoryComboBox.setSelectedItem(model.getSelectedCategory());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("selectedCategory", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_CATEGORY_COMBO_BOX_DATA, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("category", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    categoryComboBox.setData(model.getCategory());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("category", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SAMPLE_WEIGHT_FIELD_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("sampleWeight", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    SwingUtil.setText(sampleWeightField, getStringValue(model.getSampleWeight()));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("sampleWeight", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_TABLE_ENABLED, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("selectedCategory", this);
                }
                if (model != null) {
                    model.addPropertyChangeListener("batchCount", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    table.setEnabled(model.getSelectedCategory() != null && model.getBatchCount() == null);
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("selectedCategory", this);
                }
                if (model != null) {
                    model.removePropertyChangeListener("batchCount", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SAVE_AND_CONTINUE_BUTTON_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("valid", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    saveAndContinueButton.setEnabled(model.isValid());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("valid", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SAVE_AND_CLOSE_BUTTON_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("valid", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    saveAndCloseButton.setEnabled(model.isValid());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("valid", this);
                }
            }
        });
    }

}