package fr.ifremer.tutti.ui.swing.content.report;

/*
 * #%L
 * Tutti :: UI
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2015 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.persistence.entities.data.FishingOperation;
import fr.ifremer.tutti.ui.swing.TuttiHelpBroker;
import fr.ifremer.tutti.ui.swing.util.TuttiUI;
import fr.ifremer.tutti.ui.swing.util.TuttiUIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.JAXXValidator;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.Table;
import jaxx.runtime.swing.editor.bean.BeanFilterableComboBox;
import jaxx.runtime.swing.help.JAXXHelpUI;
import jaxx.runtime.validator.swing.SwingValidator;
import jaxx.runtime.validator.swing.SwingValidatorUtil;
import jaxx.runtime.validator.swing.meta.Validator;
import jaxx.runtime.validator.swing.meta.ValidatorField;
import jaxx.runtime.validator.swing.ui.ImageValidationUI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static jaxx.runtime.SwingUtil.getStringValue;
import static org.nuiton.i18n.I18n.t;

public class ReportUI extends JPanel implements JAXXHelpUI<TuttiHelpBroker>, TuttiUI<ReportUIModel, ReportUIHandler>, JAXXObject, JAXXValidator {

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_DISPLAY_REPORT_BUTTON_ENABLED = "displayReportButton.enabled";
    public static final String BINDING_FISHING_OPERATION_COMBO_BOX_SELECTED_ITEM = "fishingOperationComboBox.selectedItem";
    public static final String BINDING_GENERATE_BUTTON_ENABLED = "generateButton.enabled";
    public static final String BINDING_REPORT_COMBO_BOX_SELECTED_ITEM = "reportComboBox.selectedItem";
    public static final String BINDING_SAVE_REPORT_BUTTON_ENABLED = "saveReportButton.enabled";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAK1XTU8kRRguRhgYPoSFgOwKho/dsPjRyGGNZo27sOu4EBACo9nIAWu6a6DWnq62uhqGTDD+BH+C3r2YePNkPHj24MV40ouXjfHg1fhWdU/PVE/1zOBKQkNXve/zfjxVT1V//RQNBBwtPsG1msVDT9AqsbY3Hj/eKz8htnhIAptTXzCOop++HModoREnGQ8EWj7ake5rsfvaA1b1mUe8Fu+7O2g4EBcuCU4JEQLN6x52EKwdJtN3a37IG6hJUibUL//6M/eF8/lXOYRqPmQ3DqUsdPNqVtK/g3LUEWgSIp3hNRd7J5AGp94J5Dsmxx64OAjex1XyKfoMDe6gvI85gAm01HvJCkP513yBnufEZ1yUmL+PPeIKtF7hFq1wUiXcEqEQ1AqpFZxDEpbNPAGYVuRiHag/H2z5voLLCzRQZY7EeOPKGLvSsQmUL3P2CeECrWYjleTrI/DaVLZN58IZdqmDoWaBXtG6n0zEEIfy+WFjsInQX2G8KtCs5hxHxWVXdb+QWE9XaHAKc3s+4VhQ5u3gsuzCpGSsFvttq0HpMZ04zqYdgbYy22Q1ge4YQhOHytTLBHvWJjyK1BXgCPk0/HT4kajHSeAb+nTMfKvvvG4xdHNbLYrX07Wo0RTaCfFkFWQTaAGO0ZTmEY1K26U2+HX5flOfm3Jo4Lv4IlofTe8V+bidmE0E+Ix0sRmxXRaQ1DRE4uhFrcmw6a3mpm/uyr4jNMBDGAbCjtp14gCmIoWYTSmEBFSz/8xM/fzdr98WG7IwCbGnjaYtqgbb1ecMVoagMvR4pAmhoO7aLvbvHqFCQFyQRCV5c4bEDuNpSA7iXZPulnS3HuHgFCAGBn/5/oeZj396DuWKaNhl2Cliab+FCuKUQxeY69T8e/dVRqPnQ/CcgN8cbA+5BAUarKvtfgk7DozPD0ggpbRf8JDUoB1zhnYkOZULP/49dfjN/UZL+iDF65nmzbYMfITy1HOpR5RWxjJo1MYRPyChw5pyZxJABBI4Y95MsRzcUc+32vrQB2v+OKJgzysyOwQa8nVZ/GUtlC73VFnyvw0ZZXi7RGqiSInrdEc2NNQECUmTd5UqdIEE0goVoFjIAkGnK9gFbDRWZtwhfB9TEGWnMd4eS6AXWCj8UMiAG7aUqhJjbhlD3K61DByfgkiDTNaXIgWPpV+OLhl61XYmdYvRD1LiSpErSsWfqOu6dik7CJ0X6LoWviKZiF9AJATUU6J+SVnOZ1paAg7TpKSlVEmaZXZ9rcLcQ3Gj0SojzpYgcCpNRdvOOiEiUr7bq1DjUCwWF7AKG0WNHycHXnwkLdTF7eyUlyTQM9aWOlWuxt2NetaJ2GRx2ZBV2ivN50oPPjqzrxqrb/PJ7oP5UnB1tuebbBdTiGneJ9rb0L4CXs5YAWlfbS08czcybzrdGpJPeL+hZYCVCFk29mxZ1XD0viVvlyjfGJ08xr7vUltFjGRLoO1698tphBZY77ES2+fkjLIwOLQ5ITGKZcsjBBo0Stff9HY9UmUetdNrU8vRqiZW+tp8qYOPtiSXUyToph3UpuX+063dg3CqE08eEnAaXIuXHg3UFVktt5iMOVMmjRtgio6h5riRkN0eCNECAS8xYqR/nTm51SnVTFYWOnppvNwy85IYd9BK/c58JXJmEnKiJjyEz71WhmZNOcnbcoqd/mjMyMzW1Zk5TO7jnVlZzEovkxHjklMeGhuLZjaUYTYTbd8R/ysXxi0Oqu0dxAe1xkhBzrxWofKiNnYc0KrfuHP9J0b2kjidGVnpnGQmL8Z2t/hp7KyY2Wkxz+bI9EnYw/UzDy5weYXd9jacg3ihTD0H2vVOW4g++RzuAXFIfv6ULnz1ofG7GWeuK44c/qMDwmJPCL91QFh+ZoRVQPgXqSBfwJITAAA=";
    private static final Log log = LogFactory.getLog(ReportUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected TuttiHelpBroker broker;
    protected JButton closeButton;
    protected JButton displayReportButton;
    @ValidatorField( validatorId = "validator",  propertyName = "fishingOperation",  editorName = "fishingOperationComboBox")
    protected BeanFilterableComboBox<FishingOperation> fishingOperationComboBox;
    protected JLabel fishingOperationLabel;
    protected Table form;
    protected JButton generateButton;
    protected final ReportUIHandler handler = createHandler();
    protected ReportUIModel model;
    @ValidatorField( validatorId = "validator",  propertyName = "report",  editorName = "reportComboBox")
    protected BeanFilterableComboBox<File> reportComboBox;
    protected JLabel reportLabel;
    protected ReportUI reportTopPanel = this;
    protected JButton saveReportButton;
    @Validator( validatorId = "validator")
    protected SwingValidator<ReportUIModel> validator;
    protected List<String> validatorIds = new ArrayList<String>();

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JPanel $JPanel0;
    private JPanel $JPanel1;

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public ReportUI(TuttiUI parentUI) {
        TuttiUIUtil.setParentUI(this, parentUI);
            $initialize();
    }

    public ReportUI(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public ReportUI(JAXXContext parentContext, LayoutManager param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ReportUI(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public ReportUI(JAXXContext parentContext, LayoutManager param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ReportUI() {
        $initialize();
    }

    public ReportUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ReportUI(boolean param0) {
        super(param0);
        $initialize();
    }

    public ReportUI(JAXXContext parentContext, boolean param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*-------------------- JAXXValidator implementation  --------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public SwingValidator<?> getValidator(String validatorId) {
        return (SwingValidator<?>) (validatorIds.contains(validatorId) ? getObjectById(validatorId) : null);
    }

    @Override
    public List<String> getValidatorIds() {
        return validatorIds;
    }

    @Override
    public void registerValidatorFields() {
        SwingValidatorUtil.detectValidatorFields(this);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public TuttiHelpBroker getBroker() {
        return broker;
    }

    public JButton getCloseButton() {
        return closeButton;
    }

    public JButton getDisplayReportButton() {
        return displayReportButton;
    }

    public BeanFilterableComboBox<FishingOperation> getFishingOperationComboBox() {
        return fishingOperationComboBox;
    }

    public JLabel getFishingOperationLabel() {
        return fishingOperationLabel;
    }

    public Table getForm() {
        return form;
    }

    public JButton getGenerateButton() {
        return generateButton;
    }

    public ReportUIHandler getHandler() {
        return handler;
    }

    public ReportUIModel getModel() {
        return model;
    }

    public BeanFilterableComboBox<File> getReportComboBox() {
        return reportComboBox;
    }

    public JLabel getReportLabel() {
        return reportLabel;
    }

    public JButton getSaveReportButton() {
        return saveReportButton;
    }

    public SwingValidator<ReportUIModel> getValidator() {
        return validator;
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Other methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void registerHelpId(TuttiHelpBroker broker, Component component, String helpId) {
        broker.installUI(component, helpId);
    }

    @Override
    public void showHelp(String helpId) {
        getBroker().showHelp(this, helpId);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JPanel get$JPanel0() {
        return $JPanel0;
    }

    protected JPanel get$JPanel1() {
        return $JPanel1;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToForm() {
        if (!allComponentsCreated) {
            return;
        }
        form.add(fishingOperationLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        form.add(SwingUtil.boxComponentWithJxLayer(fishingOperationComboBox), new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        form.add(reportLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        form.add(SwingUtil.boxComponentWithJxLayer(reportComboBox), new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        form.add($JPanel0, new GridBagConstraints(0, 2, 2, 1, 0.0, 0.0, 15, 1, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void addChildrenToReportTopPanel() {
        if (!allComponentsCreated) {
            return;
        }
        add(form);
    }

    protected void addChildrenToValidator() {
        if (!allComponentsCreated) {
            return;
        }
        validator.setUiClass(ImageValidationUI.class);
        validator.setBean(model);
    }

    protected void createBroker() {
        $objectMap.put("broker", broker = new TuttiHelpBroker("tutti.report.help"));
    }

    protected void createCloseButton() {
        $objectMap.put("closeButton", closeButton = new JButton());
        
        closeButton.setName("closeButton");
        closeButton.setText(t("tutti.report.action.cancel"));
        closeButton.setToolTipText(t("tutti.report.action.cancel.tip"));
        closeButton.putClientProperty("applicationAction", fr.ifremer.tutti.ui.swing.content.actions.GoToPreviousScreenAction.class);
        closeButton.putClientProperty("help", "tutti.report.action.cancel.help");
    }

    protected void createDisplayReportButton() {
        $objectMap.put("displayReportButton", displayReportButton = new JButton());
        
        displayReportButton.setName("displayReportButton");
        displayReportButton.setText(t("tutti.report.action.openReport"));
        displayReportButton.setToolTipText(t("tutti.report.action.openReport.tip"));
        displayReportButton.putClientProperty("help", "tutti.report.action.openReport.help");
        displayReportButton.putClientProperty("simpleAction", fr.ifremer.tutti.ui.swing.content.report.actions.OpenReportAction.class);
    }

    protected void createFishingOperationComboBox() {
        $objectMap.put("fishingOperationComboBox", fishingOperationComboBox = new BeanFilterableComboBox<FishingOperation>(this));
        
        fishingOperationComboBox.setName("fishingOperationComboBox");
        fishingOperationComboBox.setProperty("fishingOperation");
        fishingOperationComboBox.setShowReset(true);
        fishingOperationComboBox.putClientProperty("help", "tutti.report.field.fishingOperation.help");
        fishingOperationComboBox.putClientProperty("validatorLabel", t("tutti.report.field.fishingOperation"));
    }

    protected void createFishingOperationLabel() {
        $objectMap.put("fishingOperationLabel", fishingOperationLabel = new JLabel());
        
        fishingOperationLabel.setName("fishingOperationLabel");
        fishingOperationLabel.setText(t("tutti.report.field.fishingOperation"));
        fishingOperationLabel.setToolTipText(t("tutti.report.field.fishingOperation.tip"));
        fishingOperationLabel.putClientProperty("help", "tutti.report.field.fishingOperation.help");
    }

    protected void createForm() {
        $objectMap.put("form", form = new Table());
        
        form.setName("form");
    }

    protected void createGenerateButton() {
        $objectMap.put("generateButton", generateButton = new JButton());
        
        generateButton.setName("generateButton");
        generateButton.setText(t("tutti.report.action.generate"));
        generateButton.setToolTipText(t("tutti.report.action.generate.tip"));
        generateButton.putClientProperty("applicationAction", fr.ifremer.tutti.ui.swing.content.report.actions.GenerateReportAction.class);
        generateButton.putClientProperty("help", "tutti.report.action.generate.help");
    }

    protected ReportUIHandler createHandler() {
        return new ReportUIHandler();
    }

    protected void createModel() {
        $objectMap.put("model", model = getContextValue(ReportUIModel.class));
    }

    protected void createReportComboBox() {
        $objectMap.put("reportComboBox", reportComboBox = new BeanFilterableComboBox<File>(this));
        
        reportComboBox.setName("reportComboBox");
        reportComboBox.setProperty("report");
        reportComboBox.setShowReset(true);
        reportComboBox.putClientProperty("help", "tutti.report.field.report.help");
        reportComboBox.putClientProperty("validatorLabel", t("tutti.report.field.report"));
    }

    protected void createReportLabel() {
        $objectMap.put("reportLabel", reportLabel = new JLabel());
        
        reportLabel.setName("reportLabel");
        reportLabel.setText(t("tutti.report.field.report"));
        reportLabel.setToolTipText(t("tutti.report.field.report.tip"));
        reportLabel.putClientProperty("help", "tutti.report.field.report.help");
    }

    protected void createSaveReportButton() {
        $objectMap.put("saveReportButton", saveReportButton = new JButton());
        
        saveReportButton.setName("saveReportButton");
        saveReportButton.setText(t("tutti.report.action.save"));
        saveReportButton.setToolTipText(t("tutti.report.action.save.tip"));
        saveReportButton.putClientProperty("applicationAction", fr.ifremer.tutti.ui.swing.content.report.actions.SaveReportAction.class);
        saveReportButton.putClientProperty("help", "tutti.report.action.save.help");
    }

    protected void createValidator() {
        $objectMap.put("validator", validator = SwingValidator.newValidator(ReportUIModel.class, null));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToReportTopPanel();
        addChildrenToValidator();
        addChildrenToForm();
        // inline complete setup of $JPanel0
        $JPanel0.add(generateButton);
        $JPanel0.add($JPanel1);
        $JPanel0.add(closeButton);
        // inline complete setup of $JPanel1
        $JPanel1.add(displayReportButton);
        $JPanel1.add(saveReportButton);
        
        // apply 5 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 17 property setters
        fishingOperationComboBox.setBeanType(FishingOperation.class);
        reportComboBox.setBeanType(File.class);
        fishingOperationLabel.setLabelFor(fishingOperationComboBox);
        fishingOperationComboBox.setBean(model);
        reportLabel.setLabelFor(reportComboBox);
        reportComboBox.setBean(model);
        generateButton.setIcon(SwingUtil.createActionIcon("generate"));
        generateButton.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.report.action.generate.mnemonic"),'Z'));
        displayReportButton.setIcon(SwingUtil.createActionIcon("open-file"));
        displayReportButton.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.report.action.openReport.mnemonic"),'Z'));
        saveReportButton.setIcon(SwingUtil.createActionIcon("save"));
        saveReportButton.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.report.action.save.mnemonic"),'Z'));
        closeButton.setIcon(SwingUtil.createActionIcon("cancel"));
        closeButton.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.report.action.cancel.mnemonic"),'Z'));
        // late initializer
        // help broker setup
        TuttiHelpBroker _broker = getBroker();
        registerHelpId(_broker, reportTopPanel, "tutti.report.help");
        registerHelpId(_broker, fishingOperationLabel, "tutti.report.field.fishingOperation.help");
        registerHelpId(_broker, fishingOperationComboBox, "tutti.report.field.fishingOperation.help");
        registerHelpId(_broker, reportLabel, "tutti.report.field.report.help");
        registerHelpId(_broker, reportComboBox, "tutti.report.field.report.help");
        registerHelpId(_broker, generateButton, "tutti.report.action.generate.help");
        registerHelpId(_broker, displayReportButton, "tutti.report.action.openReport.help");
        registerHelpId(_broker, saveReportButton, "tutti.report.action.save.help");
        registerHelpId(_broker, closeButton, "tutti.report.action.cancel.help");
        _broker.prepareUI(this);
        // register 1 validator(s)
        validatorIds = SwingValidatorUtil.detectValidators(this);
        SwingValidatorUtil.installUI(this);
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        handler.beforeInit(this);
        $objectMap.put("reportTopPanel", reportTopPanel);
        createModel();
        createBroker();
        createValidator();
        createForm();
        createFishingOperationLabel();
        createFishingOperationComboBox();
        createReportLabel();
        createReportComboBox();
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new JPanel());
        
        $JPanel0.setName("$JPanel0");
        $JPanel0.setLayout(new GridLayout(0, 1));
        createGenerateButton();
        // inline creation of $JPanel1
        $objectMap.put("$JPanel1", $JPanel1 = new JPanel());
        
        $JPanel1.setName("$JPanel1");
        $JPanel1.setLayout(new GridLayout(1, 0));
        createDisplayReportButton();
        createSaveReportButton();
        createCloseButton();
        // inline creation of reportTopPanel
        setName("reportTopPanel");
        setLayout(new BorderLayout());
        reportTopPanel.putClientProperty("help", "tutti.report.help");
        
        // registers 5 data bindings
        $registerDefaultBindings();
        $completeSetup();
        handler.afterInit(this);
    }

    private void $registerDefaultBindings() {
        // register 5 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_FISHING_OPERATION_COMBO_BOX_SELECTED_ITEM, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("fishingOperation", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    fishingOperationComboBox.setSelectedItem(model.getFishingOperation());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("fishingOperation", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_REPORT_COMBO_BOX_SELECTED_ITEM, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("report", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    reportComboBox.setSelectedItem(model.getReport());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("report", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_GENERATE_BUTTON_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("valid", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    generateButton.setEnabled(model.isValid());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("valid", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_DISPLAY_REPORT_BUTTON_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("reportDone", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    displayReportButton.setEnabled(model.isReportDone());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("reportDone", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SAVE_REPORT_BUTTON_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("reportDone", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    saveReportButton.setEnabled(model.isReportDone());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("reportDone", this);
                }
            }
        });
    }

}