package fr.ifremer.tutti.ui.swing.content.operation.catches;

/*
 * #%L
 * Tutti :: UI
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2015 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.ui.swing.TuttiHelpBroker;
import fr.ifremer.tutti.ui.swing.content.operation.FishingOperationsUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.accidental.AccidentalBatchUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.accidental.create.CreateAccidentalBatchUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.benthos.BenthosBatchUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.benthos.create.CreateBenthosBatchUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.benthos.frequency.BenthosFrequencyUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.benthos.split.SplitBenthosBatchUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.individualobservation.IndividualObservationBatchUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.individualobservation.create.CreateIndividualObservationBatchUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.marinelitter.MarineLitterBatchUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.marinelitter.create.CreateMarineLitterBatchUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.SpeciesBatchUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.create.CreateSpeciesBatchUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency.SpeciesFrequencyUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.split.SplitSpeciesBatchUI;
import fr.ifremer.tutti.ui.swing.util.TuttiUI;
import fr.ifremer.tutti.ui.swing.util.TuttiUIUtil;
import fr.ifremer.tutti.ui.swing.util.attachment.ButtonAttachment;
import fr.ifremer.tutti.ui.swing.util.caracteristics.CaracteristicMapEditorUI;
import fr.ifremer.tutti.ui.swing.util.computable.ComputableDataEditor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JButton;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.JAXXValidator;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.CardLayout2Ext;
import jaxx.runtime.swing.TabInfo;
import jaxx.runtime.swing.TabInfoPropertyChangeListener;
import jaxx.runtime.swing.Table;
import jaxx.runtime.swing.help.JAXXHelpUI;
import jaxx.runtime.validator.swing.SwingValidator;
import jaxx.runtime.validator.swing.SwingValidatorUtil;
import jaxx.runtime.validator.swing.meta.Validator;
import jaxx.runtime.validator.swing.meta.ValidatorField;
import jaxx.runtime.validator.swing.ui.ImageValidationUI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXTitledPanel;
import static org.nuiton.i18n.I18n.t;

public class EditCatchesUI extends JPanel implements JAXXHelpUI<TuttiHelpBroker>, TuttiUI<EditCatchesUIModel, EditCatchesUIHandler>, JAXXObject, JAXXValidator {

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_ACCIDENTAL_TAB_FISHING_OPERATION_REMINDER_LABEL_RIGHT_DECORATION = "accidentalTabFishingOperationReminderLabel.rightDecoration";
    public static final String BINDING_BENTHOS_TAB_FISHING_OPERATION_REMINDER_LABEL_RIGHT_DECORATION = "benthosTabFishingOperationReminderLabel.rightDecoration";
    public static final String BINDING_CATCHES_CARACTERISTICS_ATTACHMENTS_BUTTON_ENABLED = "catchesCaracteristicsAttachmentsButton.enabled";
    public static final String BINDING_INDIVIDUAL_OBSERVATION_TAB_FISHING_OPERATION_REMINDER_LABEL_RIGHT_DECORATION = "individualObservationTabFishingOperationReminderLabel.rightDecoration";
    public static final String BINDING_MARINE_LITTER_TAB_FISHING_OPERATION_REMINDER_LABEL_RIGHT_DECORATION = "marineLitterTabFishingOperationReminderLabel.rightDecoration";
    public static final String BINDING_SAVE_BUTTON_ENABLED = "saveButton.enabled";
    public static final String BINDING_SPECIES_TAB_FISHING_OPERATION_REMINDER_LABEL_RIGHT_DECORATION = "speciesTabFishingOperationReminderLabel.rightDecoration";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "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";
    private static final Log log = LogFactory.getLog(EditCatchesUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected CaracteristicMapEditorUI accidentalCaracteristicMapEditor;
    protected JXTitledPanel accidentalCaracteristicMapEditorReminderLabel;
    protected TabInfo accidentalTab;
    protected AccidentalBatchUI accidentalTabContent;
    protected CreateAccidentalBatchUI accidentalTabCreateBatch;
    protected JXTitledPanel accidentalTabCreateBatchReminderLabel;
    protected JXTitledPanel accidentalTabFishingOperationReminderLabel;
    protected JPanel accidentalTabPanel;
    protected CardLayout2Ext accidentalTabPanelLayout;
    protected TabInfo benthosTab;
    protected SplitBenthosBatchUI benthosTabAddSampleCategoryBatch;
    protected JXTitledPanel benthosTabAddSampleCategoryBatchReminderLabel;
    protected BenthosBatchUI benthosTabContent;
    protected CreateBenthosBatchUI benthosTabCreateBatch;
    protected JXTitledPanel benthosTabCreateBatchReminderLabel;
    protected JXTitledPanel benthosTabFishingOperationReminderLabel;
    protected BenthosFrequencyUI benthosTabFrequencyEditor;
    protected JXTitledPanel benthosTabFrequencyEditorReminderLabel;
    protected JPanel benthosTabPanel;
    protected CardLayout2Ext benthosTabPanelLayout;
    protected SplitBenthosBatchUI benthosTabSplitBatch;
    protected JXTitledPanel benthosTabSplitBatchReminderLabel;
    protected TuttiHelpBroker broker;
    protected JButton cancelButton;
    protected ButtonAttachment catchesCaracteristicsAttachmentsButton;
    protected TabInfo catchesCaracteristicsTab;
    protected JXTitledPanel catchesCaracteristicsTabPane;
    protected JToolBar catchesCaracteristicsTabToolBar;
    protected JButton cleanSpeciesBatchButton;
    protected JButton computeSpeciesBatchButton;
    protected Table createFishingOperationActions;
    protected EditCatchesUI editCatchesTopPanel = this;
    protected JMenuItem exportFishingOperationReportButton;
    protected JMenuItem exportFishingOperationReportForSumatraButton;
    protected JMenuItem exportMultiPostButton;
    protected final EditCatchesUIHandler handler = createHandler();
    protected JMenuItem importMultiPostButton;
    protected CaracteristicMapEditorUI individualObservationCaracteristicMapEditor;
    protected JXTitledPanel individualObservationCaracteristicMapEditorReminderLabel;
    protected TabInfo individualObservationTab;
    protected IndividualObservationBatchUI individualObservationTabContent;
    protected CreateIndividualObservationBatchUI individualObservationTabCreateBatch;
    protected JXTitledPanel individualObservationTabCreateBatchReminderLabel;
    protected JXTitledPanel individualObservationTabFishingOperationReminderLabel;
    protected JPanel individualObservationTabPanel;
    protected CardLayout2Ext individualObservationTabPanelLayout;
    protected TabInfo marineLitterTab;
    protected MarineLitterBatchUI marineLitterTabContent;
    protected CreateMarineLitterBatchUI marineLitterTabCreateBatch;
    protected JXTitledPanel marineLitterTabCreateBatchReminderLabel;
    protected JXTitledPanel marineLitterTabFishingOperationReminderLabel;
    protected JPanel marineLitterTabPanel;
    protected CardLayout2Ext marineLitterTabPanelLayout;
    protected JMenuBar menu;
    protected JMenu menuAction;
    protected EditCatchesUIModel model;
    protected JButton saveButton;
    protected TabInfo speciesTab;
    protected SplitSpeciesBatchUI speciesTabAddSampleCategoryBatch;
    protected JXTitledPanel speciesTabAddSampleCategoryBatchReminderLabel;
    protected SpeciesBatchUI speciesTabContent;
    protected CreateSpeciesBatchUI speciesTabCreateBatch;
    protected JXTitledPanel speciesTabCreateBatchReminderLabel;
    protected JXTitledPanel speciesTabFishingOperationReminderLabel;
    protected SpeciesFrequencyUI speciesTabFrequencyEditor;
    protected JXTitledPanel speciesTabFrequencyEditorReminderLabel;
    protected JPanel speciesTabPanel;
    protected CardLayout2Ext speciesTabPanelLayout;
    protected SplitSpeciesBatchUI speciesTabSplitBatch;
    protected JXTitledPanel speciesTabSplitBatchReminderLabel;
    protected JPanel svgCanvasPanel;
    protected JTabbedPane tabPane;
    @Validator( validatorId = "validator")
    protected SwingValidator<EditCatchesUIModel> validator;
    protected List<String> validatorIds = new ArrayList<String>();

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public EditCatchesUI(FishingOperationsUI parentUI) {
        TuttiUIUtil.setParentUI(this, parentUI);
            $initialize();
    }

    public EditCatchesUI(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public EditCatchesUI(JAXXContext parentContext, LayoutManager param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public EditCatchesUI(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public EditCatchesUI(JAXXContext parentContext, LayoutManager param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public EditCatchesUI() {
        $initialize();
    }

    public EditCatchesUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public EditCatchesUI(boolean param0) {
        super(param0);
        $initialize();
    }

    public EditCatchesUI(JAXXContext parentContext, boolean param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*-------------------- JAXXValidator implementation  --------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public SwingValidator<?> getValidator(String validatorId) {
        return (SwingValidator<?>) (validatorIds.contains(validatorId) ? getObjectById(validatorId) : null);
    }

    @Override
    public List<String> getValidatorIds() {
        return validatorIds;
    }

    @Override
    public void registerValidatorFields() {
        SwingValidatorUtil.detectValidatorFields(this);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public CaracteristicMapEditorUI getAccidentalCaracteristicMapEditor() {
        return accidentalCaracteristicMapEditor;
    }

    public JXTitledPanel getAccidentalCaracteristicMapEditorReminderLabel() {
        return accidentalCaracteristicMapEditorReminderLabel;
    }

    public TabInfo getAccidentalTab() {
        return accidentalTab;
    }

    public AccidentalBatchUI getAccidentalTabContent() {
        return accidentalTabContent;
    }

    public CreateAccidentalBatchUI getAccidentalTabCreateBatch() {
        return accidentalTabCreateBatch;
    }

    public JXTitledPanel getAccidentalTabCreateBatchReminderLabel() {
        return accidentalTabCreateBatchReminderLabel;
    }

    public JXTitledPanel getAccidentalTabFishingOperationReminderLabel() {
        return accidentalTabFishingOperationReminderLabel;
    }

    public JPanel getAccidentalTabPanel() {
        return accidentalTabPanel;
    }

    public CardLayout2Ext getAccidentalTabPanelLayout() {
        return accidentalTabPanelLayout;
    }

    public TabInfo getBenthosTab() {
        return benthosTab;
    }

    public SplitBenthosBatchUI getBenthosTabAddSampleCategoryBatch() {
        return benthosTabAddSampleCategoryBatch;
    }

    public JXTitledPanel getBenthosTabAddSampleCategoryBatchReminderLabel() {
        return benthosTabAddSampleCategoryBatchReminderLabel;
    }

    public BenthosBatchUI getBenthosTabContent() {
        return benthosTabContent;
    }

    public CreateBenthosBatchUI getBenthosTabCreateBatch() {
        return benthosTabCreateBatch;
    }

    public JXTitledPanel getBenthosTabCreateBatchReminderLabel() {
        return benthosTabCreateBatchReminderLabel;
    }

    public JXTitledPanel getBenthosTabFishingOperationReminderLabel() {
        return benthosTabFishingOperationReminderLabel;
    }

    public BenthosFrequencyUI getBenthosTabFrequencyEditor() {
        return benthosTabFrequencyEditor;
    }

    public JXTitledPanel getBenthosTabFrequencyEditorReminderLabel() {
        return benthosTabFrequencyEditorReminderLabel;
    }

    public JPanel getBenthosTabPanel() {
        return benthosTabPanel;
    }

    public CardLayout2Ext getBenthosTabPanelLayout() {
        return benthosTabPanelLayout;
    }

    public SplitBenthosBatchUI getBenthosTabSplitBatch() {
        return benthosTabSplitBatch;
    }

    public JXTitledPanel getBenthosTabSplitBatchReminderLabel() {
        return benthosTabSplitBatchReminderLabel;
    }

    public TuttiHelpBroker getBroker() {
        return broker;
    }

    public JButton getCancelButton() {
        return cancelButton;
    }

    public ButtonAttachment getCatchesCaracteristicsAttachmentsButton() {
        return catchesCaracteristicsAttachmentsButton;
    }

    public TabInfo getCatchesCaracteristicsTab() {
        return catchesCaracteristicsTab;
    }

    public JXTitledPanel getCatchesCaracteristicsTabPane() {
        return catchesCaracteristicsTabPane;
    }

    public JToolBar getCatchesCaracteristicsTabToolBar() {
        return catchesCaracteristicsTabToolBar;
    }

    public JButton getCleanSpeciesBatchButton() {
        return cleanSpeciesBatchButton;
    }

    public JButton getComputeSpeciesBatchButton() {
        return computeSpeciesBatchButton;
    }

    public Table getCreateFishingOperationActions() {
        return createFishingOperationActions;
    }

    public JMenuItem getExportFishingOperationReportButton() {
        return exportFishingOperationReportButton;
    }

    public JMenuItem getExportFishingOperationReportForSumatraButton() {
        return exportFishingOperationReportForSumatraButton;
    }

    public JMenuItem getExportMultiPostButton() {
        return exportMultiPostButton;
    }

    public EditCatchesUIHandler getHandler() {
        return handler;
    }

    public JMenuItem getImportMultiPostButton() {
        return importMultiPostButton;
    }

    public CaracteristicMapEditorUI getIndividualObservationCaracteristicMapEditor() {
        return individualObservationCaracteristicMapEditor;
    }

    public JXTitledPanel getIndividualObservationCaracteristicMapEditorReminderLabel() {
        return individualObservationCaracteristicMapEditorReminderLabel;
    }

    public TabInfo getIndividualObservationTab() {
        return individualObservationTab;
    }

    public IndividualObservationBatchUI getIndividualObservationTabContent() {
        return individualObservationTabContent;
    }

    public CreateIndividualObservationBatchUI getIndividualObservationTabCreateBatch() {
        return individualObservationTabCreateBatch;
    }

    public JXTitledPanel getIndividualObservationTabCreateBatchReminderLabel() {
        return individualObservationTabCreateBatchReminderLabel;
    }

    public JXTitledPanel getIndividualObservationTabFishingOperationReminderLabel() {
        return individualObservationTabFishingOperationReminderLabel;
    }

    public JPanel getIndividualObservationTabPanel() {
        return individualObservationTabPanel;
    }

    public CardLayout2Ext getIndividualObservationTabPanelLayout() {
        return individualObservationTabPanelLayout;
    }

    public TabInfo getMarineLitterTab() {
        return marineLitterTab;
    }

    public MarineLitterBatchUI getMarineLitterTabContent() {
        return marineLitterTabContent;
    }

    public CreateMarineLitterBatchUI getMarineLitterTabCreateBatch() {
        return marineLitterTabCreateBatch;
    }

    public JXTitledPanel getMarineLitterTabCreateBatchReminderLabel() {
        return marineLitterTabCreateBatchReminderLabel;
    }

    public JXTitledPanel getMarineLitterTabFishingOperationReminderLabel() {
        return marineLitterTabFishingOperationReminderLabel;
    }

    public JPanel getMarineLitterTabPanel() {
        return marineLitterTabPanel;
    }

    public CardLayout2Ext getMarineLitterTabPanelLayout() {
        return marineLitterTabPanelLayout;
    }

    public JMenuBar getMenu() {
        return menu;
    }

    public JMenu getMenuAction() {
        return menuAction;
    }

    public EditCatchesUIModel getModel() {
        return model;
    }

    public JButton getSaveButton() {
        return saveButton;
    }

    public TabInfo getSpeciesTab() {
        return speciesTab;
    }

    public SplitSpeciesBatchUI getSpeciesTabAddSampleCategoryBatch() {
        return speciesTabAddSampleCategoryBatch;
    }

    public JXTitledPanel getSpeciesTabAddSampleCategoryBatchReminderLabel() {
        return speciesTabAddSampleCategoryBatchReminderLabel;
    }

    public SpeciesBatchUI getSpeciesTabContent() {
        return speciesTabContent;
    }

    public CreateSpeciesBatchUI getSpeciesTabCreateBatch() {
        return speciesTabCreateBatch;
    }

    public JXTitledPanel getSpeciesTabCreateBatchReminderLabel() {
        return speciesTabCreateBatchReminderLabel;
    }

    public JXTitledPanel getSpeciesTabFishingOperationReminderLabel() {
        return speciesTabFishingOperationReminderLabel;
    }

    public SpeciesFrequencyUI getSpeciesTabFrequencyEditor() {
        return speciesTabFrequencyEditor;
    }

    public JXTitledPanel getSpeciesTabFrequencyEditorReminderLabel() {
        return speciesTabFrequencyEditorReminderLabel;
    }

    public JPanel getSpeciesTabPanel() {
        return speciesTabPanel;
    }

    public CardLayout2Ext getSpeciesTabPanelLayout() {
        return speciesTabPanelLayout;
    }

    public SplitSpeciesBatchUI getSpeciesTabSplitBatch() {
        return speciesTabSplitBatch;
    }

    public JXTitledPanel getSpeciesTabSplitBatchReminderLabel() {
        return speciesTabSplitBatchReminderLabel;
    }

    public JPanel getSvgCanvasPanel() {
        return svgCanvasPanel;
    }

    public JTabbedPane getTabPane() {
        return tabPane;
    }

    public SwingValidator<EditCatchesUIModel> getValidator() {
        return validator;
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Other methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void registerHelpId(TuttiHelpBroker broker, Component component, String helpId) {
        broker.installUI(component, helpId);
    }

    @Override
    public void showHelp(String helpId) {
        getBroker().showHelp(this, helpId);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToAccidentalCaracteristicMapEditorReminderLabel() {
        if (!allComponentsCreated) {
            return;
        }
        accidentalCaracteristicMapEditorReminderLabel.add(accidentalCaracteristicMapEditor);
    }

    protected void addChildrenToAccidentalTabCreateBatchReminderLabel() {
        if (!allComponentsCreated) {
            return;
        }
        accidentalTabCreateBatchReminderLabel.add(accidentalTabCreateBatch);
    }

    protected void addChildrenToAccidentalTabFishingOperationReminderLabel() {
        if (!allComponentsCreated) {
            return;
        }
        accidentalTabFishingOperationReminderLabel.add(accidentalTabContent);
    }

    protected void addChildrenToAccidentalTabPanel() {
        if (!allComponentsCreated) {
            return;
        }
        accidentalTabPanel.add(accidentalTabFishingOperationReminderLabel, EditCatchesUIHandler.MAIN_CARD);
        accidentalTabPanel.add(accidentalTabCreateBatchReminderLabel, EditCatchesUIHandler.CREATE_BATCH_CARD);
        accidentalTabPanel.add(accidentalCaracteristicMapEditorReminderLabel, EditCatchesUIHandler.EDIT_CARACTERISTICS_CARD);
    }

    protected void addChildrenToBenthosTabAddSampleCategoryBatchReminderLabel() {
        if (!allComponentsCreated) {
            return;
        }
        benthosTabAddSampleCategoryBatchReminderLabel.add(benthosTabAddSampleCategoryBatch);
    }

    protected void addChildrenToBenthosTabCreateBatchReminderLabel() {
        if (!allComponentsCreated) {
            return;
        }
        benthosTabCreateBatchReminderLabel.add(benthosTabCreateBatch);
    }

    protected void addChildrenToBenthosTabFishingOperationReminderLabel() {
        if (!allComponentsCreated) {
            return;
        }
        benthosTabFishingOperationReminderLabel.add(benthosTabContent);
    }

    protected void addChildrenToBenthosTabFrequencyEditorReminderLabel() {
        if (!allComponentsCreated) {
            return;
        }
        benthosTabFrequencyEditorReminderLabel.add(benthosTabFrequencyEditor);
    }

    protected void addChildrenToBenthosTabPanel() {
        if (!allComponentsCreated) {
            return;
        }
        benthosTabPanel.add(benthosTabFishingOperationReminderLabel, EditCatchesUIHandler.MAIN_CARD);
        benthosTabPanel.add(benthosTabCreateBatchReminderLabel, EditCatchesUIHandler.CREATE_BATCH_CARD);
        benthosTabPanel.add(benthosTabSplitBatchReminderLabel, EditCatchesUIHandler.SPLIT_BATCH_CARD);
        benthosTabPanel.add(benthosTabAddSampleCategoryBatchReminderLabel, EditCatchesUIHandler.ADD_SAMPLE_CATEGORY_BATCH_CARD);
        benthosTabPanel.add(benthosTabFrequencyEditorReminderLabel, EditCatchesUIHandler.EDIT_FREQUENCY_CARD);
    }

    protected void addChildrenToBenthosTabSplitBatchReminderLabel() {
        if (!allComponentsCreated) {
            return;
        }
        benthosTabSplitBatchReminderLabel.add(benthosTabSplitBatch);
    }

    protected void addChildrenToCatchesCaracteristicsTabPane() {
        if (!allComponentsCreated) {
            return;
        }
        catchesCaracteristicsTabPane.add(svgCanvasPanel);
    }

    protected void addChildrenToCatchesCaracteristicsTabToolBar() {
        if (!allComponentsCreated) {
            return;
        }
        catchesCaracteristicsTabToolBar.add(menu);
        catchesCaracteristicsTabToolBar.add(catchesCaracteristicsAttachmentsButton);
    }

    protected void addChildrenToCreateFishingOperationActions() {
        if (!allComponentsCreated) {
            return;
        }
        createFishingOperationActions.add(cancelButton, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        createFishingOperationActions.add(saveButton, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        createFishingOperationActions.add(cleanSpeciesBatchButton, new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        createFishingOperationActions.add(computeSpeciesBatchButton, new GridBagConstraints(3, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    protected void addChildrenToEditCatchesTopPanel() {
        if (!allComponentsCreated) {
            return;
        }
        add(catchesCaracteristicsTabToolBar);
        add(tabPane, BorderLayout.CENTER);
        add(createFishingOperationActions, BorderLayout.SOUTH);
    }

    protected void addChildrenToIndividualObservationCaracteristicMapEditorReminderLabel() {
        if (!allComponentsCreated) {
            return;
        }
        individualObservationCaracteristicMapEditorReminderLabel.add(individualObservationCaracteristicMapEditor);
    }

    protected void addChildrenToIndividualObservationTabCreateBatchReminderLabel() {
        if (!allComponentsCreated) {
            return;
        }
        individualObservationTabCreateBatchReminderLabel.add(individualObservationTabCreateBatch);
    }

    protected void addChildrenToIndividualObservationTabFishingOperationReminderLabel() {
        if (!allComponentsCreated) {
            return;
        }
        individualObservationTabFishingOperationReminderLabel.add(individualObservationTabContent);
    }

    protected void addChildrenToIndividualObservationTabPanel() {
        if (!allComponentsCreated) {
            return;
        }
        individualObservationTabPanel.add(individualObservationTabFishingOperationReminderLabel, EditCatchesUIHandler.MAIN_CARD);
        individualObservationTabPanel.add(individualObservationTabCreateBatchReminderLabel, EditCatchesUIHandler.CREATE_BATCH_CARD);
        individualObservationTabPanel.add(individualObservationCaracteristicMapEditorReminderLabel, EditCatchesUIHandler.EDIT_CARACTERISTICS_CARD);
    }

    protected void addChildrenToMarineLitterTabCreateBatchReminderLabel() {
        if (!allComponentsCreated) {
            return;
        }
        marineLitterTabCreateBatchReminderLabel.add(marineLitterTabCreateBatch);
    }

    protected void addChildrenToMarineLitterTabFishingOperationReminderLabel() {
        if (!allComponentsCreated) {
            return;
        }
        marineLitterTabFishingOperationReminderLabel.add(marineLitterTabContent);
    }

    protected void addChildrenToMarineLitterTabPanel() {
        if (!allComponentsCreated) {
            return;
        }
        marineLitterTabPanel.add(marineLitterTabFishingOperationReminderLabel, EditCatchesUIHandler.MAIN_CARD);
        marineLitterTabPanel.add(marineLitterTabCreateBatchReminderLabel, EditCatchesUIHandler.CREATE_BATCH_CARD);
    }

    protected void addChildrenToMenu() {
        if (!allComponentsCreated) {
            return;
        }
        menu.add(menuAction);
    }

    protected void addChildrenToMenuAction() {
        if (!allComponentsCreated) {
            return;
        }
        menuAction.add(exportFishingOperationReportButton);
        menuAction.add(exportFishingOperationReportForSumatraButton);
        menuAction.add(importMultiPostButton);
        menuAction.add(exportMultiPostButton);
    }

    protected void addChildrenToSpeciesTabAddSampleCategoryBatchReminderLabel() {
        if (!allComponentsCreated) {
            return;
        }
        speciesTabAddSampleCategoryBatchReminderLabel.add(speciesTabAddSampleCategoryBatch);
    }

    protected void addChildrenToSpeciesTabCreateBatchReminderLabel() {
        if (!allComponentsCreated) {
            return;
        }
        speciesTabCreateBatchReminderLabel.add(speciesTabCreateBatch);
    }

    protected void addChildrenToSpeciesTabFishingOperationReminderLabel() {
        if (!allComponentsCreated) {
            return;
        }
        speciesTabFishingOperationReminderLabel.add(speciesTabContent);
    }

    protected void addChildrenToSpeciesTabFrequencyEditorReminderLabel() {
        if (!allComponentsCreated) {
            return;
        }
        speciesTabFrequencyEditorReminderLabel.add(speciesTabFrequencyEditor);
    }

    protected void addChildrenToSpeciesTabPanel() {
        if (!allComponentsCreated) {
            return;
        }
        speciesTabPanel.add(speciesTabFishingOperationReminderLabel, EditCatchesUIHandler.MAIN_CARD);
        speciesTabPanel.add(speciesTabCreateBatchReminderLabel, EditCatchesUIHandler.CREATE_BATCH_CARD);
        speciesTabPanel.add(speciesTabSplitBatchReminderLabel, EditCatchesUIHandler.SPLIT_BATCH_CARD);
        speciesTabPanel.add(speciesTabAddSampleCategoryBatchReminderLabel, EditCatchesUIHandler.ADD_SAMPLE_CATEGORY_BATCH_CARD);
        speciesTabPanel.add(speciesTabFrequencyEditorReminderLabel, EditCatchesUIHandler.EDIT_FREQUENCY_CARD);
    }

    protected void addChildrenToSpeciesTabSplitBatchReminderLabel() {
        if (!allComponentsCreated) {
            return;
        }
        speciesTabSplitBatchReminderLabel.add(speciesTabSplitBatch);
    }

    protected void addChildrenToTabPane() {
        if (!allComponentsCreated) {
            return;
        }
        tabPane.add(catchesCaracteristicsTabPane);
        tabPane.add(speciesTabPanel);
        tabPane.add(benthosTabPanel);
        tabPane.add(marineLitterTabPanel);
        tabPane.add(individualObservationTabPanel);
        tabPane.add(accidentalTabPanel);
        catchesCaracteristicsTab.addPropertyChangeListener(new TabInfoPropertyChangeListener(tabPane, 0));
        speciesTab.addPropertyChangeListener(new TabInfoPropertyChangeListener(tabPane, 1));
        benthosTab.addPropertyChangeListener(new TabInfoPropertyChangeListener(tabPane, 2));
        marineLitterTab.addPropertyChangeListener(new TabInfoPropertyChangeListener(tabPane, 3));
        tabPane.setTitleAt(3, t("tutti.label.tab.marineLitter"));
        individualObservationTab.addPropertyChangeListener(new TabInfoPropertyChangeListener(tabPane, 4));
        accidentalTab.addPropertyChangeListener(new TabInfoPropertyChangeListener(tabPane, 5));
    }

    protected void addChildrenToValidator() {
        if (!allComponentsCreated) {
            return;
        }
        validator.setUiClass(ImageValidationUI.class);
        validator.setBean(model);
    }

    protected void createAccidentalCaracteristicMapEditor() {
        $objectMap.put("accidentalCaracteristicMapEditor", accidentalCaracteristicMapEditor = new CaracteristicMapEditorUI(accidentalTabContent));
        
        accidentalCaracteristicMapEditor.setName("accidentalCaracteristicMapEditor");
    }

    protected void createAccidentalCaracteristicMapEditorReminderLabel() {
        $objectMap.put("accidentalCaracteristicMapEditorReminderLabel", accidentalCaracteristicMapEditorReminderLabel = new JXTitledPanel());
        
        accidentalCaracteristicMapEditorReminderLabel.setName("accidentalCaracteristicMapEditorReminderLabel");
    }

    protected void createAccidentalTab() {
        $objectMap.put("accidentalTab", accidentalTab = new TabInfo());
    }

    protected void createAccidentalTabContent() {
        $objectMap.put("accidentalTabContent", accidentalTabContent = new AccidentalBatchUI(this));
        
        accidentalTabContent.setName("accidentalTabContent");
    }

    protected void createAccidentalTabCreateBatch() {
        $objectMap.put("accidentalTabCreateBatch", accidentalTabCreateBatch = new CreateAccidentalBatchUI(this));
        
        accidentalTabCreateBatch.setName("accidentalTabCreateBatch");
    }

    protected void createAccidentalTabCreateBatchReminderLabel() {
        $objectMap.put("accidentalTabCreateBatchReminderLabel", accidentalTabCreateBatchReminderLabel = new JXTitledPanel());
        
        accidentalTabCreateBatchReminderLabel.setName("accidentalTabCreateBatchReminderLabel");
    }

    protected void createAccidentalTabFishingOperationReminderLabel() {
        $objectMap.put("accidentalTabFishingOperationReminderLabel", accidentalTabFishingOperationReminderLabel = new JXTitledPanel());
        
        accidentalTabFishingOperationReminderLabel.setName("accidentalTabFishingOperationReminderLabel");
    }

    protected void createAccidentalTabPanel() {
        $objectMap.put("accidentalTabPanel", accidentalTabPanel = new JPanel());
        
        accidentalTabPanel.setName("accidentalTabPanel");
        accidentalTabPanel.setLayout(accidentalTabPanelLayout);
    }

    protected void createAccidentalTabPanelLayout() {
        $objectMap.put("accidentalTabPanelLayout", accidentalTabPanelLayout = new CardLayout2Ext(this, "accidentalTabPanel"));
    }

    protected void createBenthosTab() {
        $objectMap.put("benthosTab", benthosTab = new TabInfo());
    }

    protected void createBenthosTabAddSampleCategoryBatch() {
        $objectMap.put("benthosTabAddSampleCategoryBatch", benthosTabAddSampleCategoryBatch = new SplitBenthosBatchUI(this));
        
        benthosTabAddSampleCategoryBatch.setName("benthosTabAddSampleCategoryBatch");
    }

    protected void createBenthosTabAddSampleCategoryBatchReminderLabel() {
        $objectMap.put("benthosTabAddSampleCategoryBatchReminderLabel", benthosTabAddSampleCategoryBatchReminderLabel = new JXTitledPanel());
        
        benthosTabAddSampleCategoryBatchReminderLabel.setName("benthosTabAddSampleCategoryBatchReminderLabel");
    }

    protected void createBenthosTabContent() {
        $objectMap.put("benthosTabContent", benthosTabContent = new BenthosBatchUI(this));
        
        benthosTabContent.setName("benthosTabContent");
    }

    protected void createBenthosTabCreateBatch() {
        $objectMap.put("benthosTabCreateBatch", benthosTabCreateBatch = new CreateBenthosBatchUI(this));
        
        benthosTabCreateBatch.setName("benthosTabCreateBatch");
    }

    protected void createBenthosTabCreateBatchReminderLabel() {
        $objectMap.put("benthosTabCreateBatchReminderLabel", benthosTabCreateBatchReminderLabel = new JXTitledPanel());
        
        benthosTabCreateBatchReminderLabel.setName("benthosTabCreateBatchReminderLabel");
    }

    protected void createBenthosTabFishingOperationReminderLabel() {
        $objectMap.put("benthosTabFishingOperationReminderLabel", benthosTabFishingOperationReminderLabel = new JXTitledPanel());
        
        benthosTabFishingOperationReminderLabel.setName("benthosTabFishingOperationReminderLabel");
    }

    protected void createBenthosTabFrequencyEditor() {
        $objectMap.put("benthosTabFrequencyEditor", benthosTabFrequencyEditor = new BenthosFrequencyUI(benthosTabContent));
        
        benthosTabFrequencyEditor.setName("benthosTabFrequencyEditor");
    }

    protected void createBenthosTabFrequencyEditorReminderLabel() {
        $objectMap.put("benthosTabFrequencyEditorReminderLabel", benthosTabFrequencyEditorReminderLabel = new JXTitledPanel());
        
        benthosTabFrequencyEditorReminderLabel.setName("benthosTabFrequencyEditorReminderLabel");
    }

    protected void createBenthosTabPanel() {
        $objectMap.put("benthosTabPanel", benthosTabPanel = new JPanel());
        
        benthosTabPanel.setName("benthosTabPanel");
        benthosTabPanel.setLayout(benthosTabPanelLayout);
    }

    protected void createBenthosTabPanelLayout() {
        $objectMap.put("benthosTabPanelLayout", benthosTabPanelLayout = new CardLayout2Ext(this, "benthosTabPanel"));
    }

    protected void createBenthosTabSplitBatch() {
        $objectMap.put("benthosTabSplitBatch", benthosTabSplitBatch = new SplitBenthosBatchUI(this));
        
        benthosTabSplitBatch.setName("benthosTabSplitBatch");
    }

    protected void createBenthosTabSplitBatchReminderLabel() {
        $objectMap.put("benthosTabSplitBatchReminderLabel", benthosTabSplitBatchReminderLabel = new JXTitledPanel());
        
        benthosTabSplitBatchReminderLabel.setName("benthosTabSplitBatchReminderLabel");
    }

    protected void createBroker() {
        $objectMap.put("broker", broker = new TuttiHelpBroker("tutti.editCatchBatch.help"));
    }

    protected void createCancelButton() {
        $objectMap.put("cancelButton", cancelButton = new JButton());
        
        cancelButton.setName("cancelButton");
        cancelButton.setText(t("tutti.editCatchBatch.action.cancelEditCatchBatch"));
        cancelButton.setToolTipText(t("tutti.editCatchBatch.action.cancelEditCatchBatch.tip"));
        cancelButton.putClientProperty("applicationAction", fr.ifremer.tutti.ui.swing.content.operation.catches.actions.CancelEditCatchBatchAction.class);
        cancelButton.putClientProperty("help", "tutti.editCatchBatch.action.cancelEditCatchBatch.help");
    }

    protected void createCatchesCaracteristicsAttachmentsButton() {
        $objectMap.put("catchesCaracteristicsAttachmentsButton", catchesCaracteristicsAttachmentsButton = new ButtonAttachment(getHandler().getContext(), getModel()));
        
        catchesCaracteristicsAttachmentsButton.setName("catchesCaracteristicsAttachmentsButton");
        catchesCaracteristicsAttachmentsButton.setFocusPainted(false);
        catchesCaracteristicsAttachmentsButton.setToolTipText(t("tutti.editCatchBatch.action.attachments.tip"));
    }

    protected void createCatchesCaracteristicsTab() {
        $objectMap.put("catchesCaracteristicsTab", catchesCaracteristicsTab = new TabInfo());
    }

    protected void createCatchesCaracteristicsTabPane() {
        $objectMap.put("catchesCaracteristicsTabPane", catchesCaracteristicsTabPane = new JXTitledPanel());
        
        catchesCaracteristicsTabPane.setName("catchesCaracteristicsTabPane");
    }

    protected void createCatchesCaracteristicsTabToolBar() {
        $objectMap.put("catchesCaracteristicsTabToolBar", catchesCaracteristicsTabToolBar = new JToolBar());
        
        catchesCaracteristicsTabToolBar.setName("catchesCaracteristicsTabToolBar");
        catchesCaracteristicsTabToolBar.setFloatable(false);
        catchesCaracteristicsTabToolBar.setOpaque(true);
        catchesCaracteristicsTabToolBar.setBorderPainted(false);
    }

    protected void createCleanSpeciesBatchButton() {
        $objectMap.put("cleanSpeciesBatchButton", cleanSpeciesBatchButton = new JButton());
        
        cleanSpeciesBatchButton.setName("cleanSpeciesBatchButton");
        cleanSpeciesBatchButton.setText(t("tutti.editCatchBatch.action.cleanWeights"));
        cleanSpeciesBatchButton.setToolTipText(t("tutti.editCatchBatch.action.cleanWeights.tip"));
        cleanSpeciesBatchButton.putClientProperty("applicationAction", fr.ifremer.tutti.ui.swing.content.operation.catches.actions.CleanBatchWeightsAction.class);
        cleanSpeciesBatchButton.putClientProperty("help", "tutti.editCatchBatch.action.cleanWeights.help");
    }

    protected void createComputeSpeciesBatchButton() {
        $objectMap.put("computeSpeciesBatchButton", computeSpeciesBatchButton = new JButton());
        
        computeSpeciesBatchButton.setName("computeSpeciesBatchButton");
        computeSpeciesBatchButton.setText(t("tutti.editCatchBatch.action.computeWeights"));
        computeSpeciesBatchButton.setToolTipText(t("tutti.editCatchBatch.action.computeWeights.tip"));
        computeSpeciesBatchButton.putClientProperty("applicationAction", fr.ifremer.tutti.ui.swing.content.operation.catches.actions.ComputeBatchWeightsAction.class);
        computeSpeciesBatchButton.putClientProperty("help", "tutti.editCatchBatch.action.computeWeights.help");
    }

    protected void createCreateFishingOperationActions() {
        $objectMap.put("createFishingOperationActions", createFishingOperationActions = new Table());
        
        createFishingOperationActions.setName("createFishingOperationActions");
    }

    protected void createExportFishingOperationReportButton() {
        $objectMap.put("exportFishingOperationReportButton", exportFishingOperationReportButton = new JMenuItem());
        
        exportFishingOperationReportButton.setName("exportFishingOperationReportButton");
        exportFishingOperationReportButton.setText(t("tutti.editCatchBatch.action.exportFishingOperationReport"));
        exportFishingOperationReportButton.setToolTipText(t("tutti.editCatchBatch.action.exportFishingOperationReport.tip"));
        exportFishingOperationReportButton.putClientProperty("applicationAction", fr.ifremer.tutti.ui.swing.content.operation.catches.actions.ExportFishingOperationReportAction.class);
        exportFishingOperationReportButton.putClientProperty("help", "tutti.editCatchBatch.action.exportFishingOperationReport.help");
    }

    protected void createExportFishingOperationReportForSumatraButton() {
        $objectMap.put("exportFishingOperationReportForSumatraButton", exportFishingOperationReportForSumatraButton = new JMenuItem());
        
        exportFishingOperationReportForSumatraButton.setName("exportFishingOperationReportForSumatraButton");
        exportFishingOperationReportForSumatraButton.setText(t("tutti.editCatchBatch.action.exportFishingOperationReportForSumatra"));
        exportFishingOperationReportForSumatraButton.setToolTipText(t("tutti.editCatchBatch.action.exportFishingOperationReportForSumatra.tip"));
        exportFishingOperationReportForSumatraButton.putClientProperty("applicationAction", fr.ifremer.tutti.ui.swing.content.operation.catches.actions.ExportFishingOperationForSumatraAction.class);
        exportFishingOperationReportForSumatraButton.putClientProperty("help", "tutti.editCatchBatch.action.exportFishingOperationReportForSumatra.help");
    }

    protected void createExportMultiPostButton() {
        $objectMap.put("exportMultiPostButton", exportMultiPostButton = new JMenuItem());
        
        exportMultiPostButton.setName("exportMultiPostButton");
        exportMultiPostButton.setText(t("tutti.editCatchBatch.action.exportMultiPost"));
        exportMultiPostButton.setToolTipText(t("tutti.editCatchBatch.action.exportMultiPost.tip"));
        exportMultiPostButton.putClientProperty("applicationAction", fr.ifremer.tutti.ui.swing.content.operation.catches.actions.ExportMultiPostCatchAction.class);
        exportMultiPostButton.putClientProperty("help", "tutti.editCatchBatch.action.exportMultiPost.help");
    }

    protected EditCatchesUIHandler createHandler() {
        return new EditCatchesUIHandler();
    }

    protected void createImportMultiPostButton() {
        $objectMap.put("importMultiPostButton", importMultiPostButton = new JMenuItem());
        
        importMultiPostButton.setName("importMultiPostButton");
        importMultiPostButton.setText(t("tutti.editCatchBatch.action.importMultiPost"));
        importMultiPostButton.setToolTipText(t("tutti.editCatchBatch.action.importMultiPost.tip"));
        importMultiPostButton.putClientProperty("applicationAction", fr.ifremer.tutti.ui.swing.content.operation.catches.actions.ImportMultiPostCatchAction.class);
        importMultiPostButton.putClientProperty("help", "tutti.editCatchBatch.action.importMultiPost.help");
    }

    protected void createIndividualObservationCaracteristicMapEditor() {
        $objectMap.put("individualObservationCaracteristicMapEditor", individualObservationCaracteristicMapEditor = new CaracteristicMapEditorUI(individualObservationTabContent));
        
        individualObservationCaracteristicMapEditor.setName("individualObservationCaracteristicMapEditor");
    }

    protected void createIndividualObservationCaracteristicMapEditorReminderLabel() {
        $objectMap.put("individualObservationCaracteristicMapEditorReminderLabel", individualObservationCaracteristicMapEditorReminderLabel = new JXTitledPanel());
        
        individualObservationCaracteristicMapEditorReminderLabel.setName("individualObservationCaracteristicMapEditorReminderLabel");
    }

    protected void createIndividualObservationTab() {
        $objectMap.put("individualObservationTab", individualObservationTab = new TabInfo());
    }

    protected void createIndividualObservationTabContent() {
        $objectMap.put("individualObservationTabContent", individualObservationTabContent = new IndividualObservationBatchUI(this));
        
        individualObservationTabContent.setName("individualObservationTabContent");
    }

    protected void createIndividualObservationTabCreateBatch() {
        $objectMap.put("individualObservationTabCreateBatch", individualObservationTabCreateBatch = new CreateIndividualObservationBatchUI(this));
        
        individualObservationTabCreateBatch.setName("individualObservationTabCreateBatch");
    }

    protected void createIndividualObservationTabCreateBatchReminderLabel() {
        $objectMap.put("individualObservationTabCreateBatchReminderLabel", individualObservationTabCreateBatchReminderLabel = new JXTitledPanel());
        
        individualObservationTabCreateBatchReminderLabel.setName("individualObservationTabCreateBatchReminderLabel");
    }

    protected void createIndividualObservationTabFishingOperationReminderLabel() {
        $objectMap.put("individualObservationTabFishingOperationReminderLabel", individualObservationTabFishingOperationReminderLabel = new JXTitledPanel());
        
        individualObservationTabFishingOperationReminderLabel.setName("individualObservationTabFishingOperationReminderLabel");
    }

    protected void createIndividualObservationTabPanel() {
        $objectMap.put("individualObservationTabPanel", individualObservationTabPanel = new JPanel());
        
        individualObservationTabPanel.setName("individualObservationTabPanel");
        individualObservationTabPanel.setLayout(individualObservationTabPanelLayout);
    }

    protected void createIndividualObservationTabPanelLayout() {
        $objectMap.put("individualObservationTabPanelLayout", individualObservationTabPanelLayout = new CardLayout2Ext(this, "individualObservationTabPanel"));
    }

    protected void createMarineLitterTab() {
        $objectMap.put("marineLitterTab", marineLitterTab = new TabInfo());
        
        marineLitterTab.setTitle(t("tutti.label.tab.marineLitter"));
    }

    protected void createMarineLitterTabContent() {
        $objectMap.put("marineLitterTabContent", marineLitterTabContent = new MarineLitterBatchUI(this));
        
        marineLitterTabContent.setName("marineLitterTabContent");
    }

    protected void createMarineLitterTabCreateBatch() {
        $objectMap.put("marineLitterTabCreateBatch", marineLitterTabCreateBatch = new CreateMarineLitterBatchUI(this));
        
        marineLitterTabCreateBatch.setName("marineLitterTabCreateBatch");
    }

    protected void createMarineLitterTabCreateBatchReminderLabel() {
        $objectMap.put("marineLitterTabCreateBatchReminderLabel", marineLitterTabCreateBatchReminderLabel = new JXTitledPanel());
        
        marineLitterTabCreateBatchReminderLabel.setName("marineLitterTabCreateBatchReminderLabel");
    }

    protected void createMarineLitterTabFishingOperationReminderLabel() {
        $objectMap.put("marineLitterTabFishingOperationReminderLabel", marineLitterTabFishingOperationReminderLabel = new JXTitledPanel());
        
        marineLitterTabFishingOperationReminderLabel.setName("marineLitterTabFishingOperationReminderLabel");
    }

    protected void createMarineLitterTabPanel() {
        $objectMap.put("marineLitterTabPanel", marineLitterTabPanel = new JPanel());
        
        marineLitterTabPanel.setName("marineLitterTabPanel");
        marineLitterTabPanel.setLayout(marineLitterTabPanelLayout);
    }

    protected void createMarineLitterTabPanelLayout() {
        $objectMap.put("marineLitterTabPanelLayout", marineLitterTabPanelLayout = new CardLayout2Ext(this, "marineLitterTabPanel"));
    }

    protected void createMenu() {
        $objectMap.put("menu", menu = new JMenuBar());
        
        menu.setName("menu");
    }

    protected void createMenuAction() {
        $objectMap.put("menuAction", menuAction = new JMenu());
        
        menuAction.setName("menuAction");
        menuAction.setText(t("tutti.toolbar.menu.action"));
        menuAction.setOpaque(true);
        menuAction.setToolTipText(t("tutti.toolbar.menu.action.tip"));
    }

    protected void createModel() {
        $objectMap.put("model", model = getContextValue(EditCatchesUIModel.class));
    }

    protected void createSaveButton() {
        $objectMap.put("saveButton", saveButton = new JButton());
        
        saveButton.setName("saveButton");
        saveButton.setText(t("tutti.editCatchBatch.action.saveCatchBatch"));
        saveButton.setToolTipText(t("tutti.editCatchBatch.action.saveCatchBatch.tip"));
        saveButton.putClientProperty("applicationAction", fr.ifremer.tutti.ui.swing.content.operation.catches.actions.SaveCatchBatchAction.class);
        saveButton.putClientProperty("help", "tutti.editCatchBatch.action.saveCatchBatch.help");
    }

    protected void createSpeciesTab() {
        $objectMap.put("speciesTab", speciesTab = new TabInfo());
    }

    protected void createSpeciesTabAddSampleCategoryBatch() {
        $objectMap.put("speciesTabAddSampleCategoryBatch", speciesTabAddSampleCategoryBatch = new SplitSpeciesBatchUI(this));
        
        speciesTabAddSampleCategoryBatch.setName("speciesTabAddSampleCategoryBatch");
    }

    protected void createSpeciesTabAddSampleCategoryBatchReminderLabel() {
        $objectMap.put("speciesTabAddSampleCategoryBatchReminderLabel", speciesTabAddSampleCategoryBatchReminderLabel = new JXTitledPanel());
        
        speciesTabAddSampleCategoryBatchReminderLabel.setName("speciesTabAddSampleCategoryBatchReminderLabel");
    }

    protected void createSpeciesTabContent() {
        $objectMap.put("speciesTabContent", speciesTabContent = new SpeciesBatchUI(this));
        
        speciesTabContent.setName("speciesTabContent");
    }

    protected void createSpeciesTabCreateBatch() {
        $objectMap.put("speciesTabCreateBatch", speciesTabCreateBatch = new CreateSpeciesBatchUI(this));
        
        speciesTabCreateBatch.setName("speciesTabCreateBatch");
    }

    protected void createSpeciesTabCreateBatchReminderLabel() {
        $objectMap.put("speciesTabCreateBatchReminderLabel", speciesTabCreateBatchReminderLabel = new JXTitledPanel());
        
        speciesTabCreateBatchReminderLabel.setName("speciesTabCreateBatchReminderLabel");
    }

    protected void createSpeciesTabFishingOperationReminderLabel() {
        $objectMap.put("speciesTabFishingOperationReminderLabel", speciesTabFishingOperationReminderLabel = new JXTitledPanel());
        
        speciesTabFishingOperationReminderLabel.setName("speciesTabFishingOperationReminderLabel");
    }

    protected void createSpeciesTabFrequencyEditor() {
        $objectMap.put("speciesTabFrequencyEditor", speciesTabFrequencyEditor = new SpeciesFrequencyUI(speciesTabContent));
        
        speciesTabFrequencyEditor.setName("speciesTabFrequencyEditor");
    }

    protected void createSpeciesTabFrequencyEditorReminderLabel() {
        $objectMap.put("speciesTabFrequencyEditorReminderLabel", speciesTabFrequencyEditorReminderLabel = new JXTitledPanel());
        
        speciesTabFrequencyEditorReminderLabel.setName("speciesTabFrequencyEditorReminderLabel");
    }

    protected void createSpeciesTabPanel() {
        $objectMap.put("speciesTabPanel", speciesTabPanel = new JPanel());
        
        speciesTabPanel.setName("speciesTabPanel");
        speciesTabPanel.setLayout(speciesTabPanelLayout);
    }

    protected void createSpeciesTabPanelLayout() {
        $objectMap.put("speciesTabPanelLayout", speciesTabPanelLayout = new CardLayout2Ext(this, "speciesTabPanel"));
    }

    protected void createSpeciesTabSplitBatch() {
        $objectMap.put("speciesTabSplitBatch", speciesTabSplitBatch = new SplitSpeciesBatchUI(this));
        
        speciesTabSplitBatch.setName("speciesTabSplitBatch");
    }

    protected void createSpeciesTabSplitBatchReminderLabel() {
        $objectMap.put("speciesTabSplitBatchReminderLabel", speciesTabSplitBatchReminderLabel = new JXTitledPanel());
        
        speciesTabSplitBatchReminderLabel.setName("speciesTabSplitBatchReminderLabel");
    }

    protected void createSvgCanvasPanel() {
        $objectMap.put("svgCanvasPanel", svgCanvasPanel = new JPanel());
        
        svgCanvasPanel.setName("svgCanvasPanel");
        svgCanvasPanel.setLayout(new BorderLayout());
    }

    protected void createTabPane() {
        $objectMap.put("tabPane", tabPane = new JTabbedPane());
        
        tabPane.setName("tabPane");
    }

    protected void createValidator() {
        $objectMap.put("validator", validator = SwingValidator.newValidator(EditCatchesUIModel.class, "validate"));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToEditCatchesTopPanel();
        addChildrenToValidator();
        addChildrenToCatchesCaracteristicsTabToolBar();
        addChildrenToMenu();
        addChildrenToMenuAction();
        addChildrenToTabPane();
        addChildrenToCatchesCaracteristicsTabPane();
        addChildrenToSpeciesTabPanel();
        addChildrenToSpeciesTabFishingOperationReminderLabel();
        addChildrenToSpeciesTabCreateBatchReminderLabel();
        addChildrenToSpeciesTabSplitBatchReminderLabel();
        addChildrenToSpeciesTabAddSampleCategoryBatchReminderLabel();
        addChildrenToSpeciesTabFrequencyEditorReminderLabel();
        addChildrenToBenthosTabPanel();
        addChildrenToBenthosTabFishingOperationReminderLabel();
        addChildrenToBenthosTabCreateBatchReminderLabel();
        addChildrenToBenthosTabSplitBatchReminderLabel();
        addChildrenToBenthosTabAddSampleCategoryBatchReminderLabel();
        addChildrenToBenthosTabFrequencyEditorReminderLabel();
        addChildrenToMarineLitterTabPanel();
        addChildrenToMarineLitterTabFishingOperationReminderLabel();
        addChildrenToMarineLitterTabCreateBatchReminderLabel();
        addChildrenToIndividualObservationTabPanel();
        addChildrenToIndividualObservationTabFishingOperationReminderLabel();
        addChildrenToIndividualObservationTabCreateBatchReminderLabel();
        addChildrenToIndividualObservationCaracteristicMapEditorReminderLabel();
        addChildrenToAccidentalTabPanel();
        addChildrenToAccidentalTabFishingOperationReminderLabel();
        addChildrenToAccidentalTabCreateBatchReminderLabel();
        addChildrenToAccidentalCaracteristicMapEditorReminderLabel();
        addChildrenToCreateFishingOperationActions();
        
        // apply 7 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 27 property setters
        menu.setBackground(javax.swing.UIManager.getColor("MenuBar.background"));
        menu.setBorder(null);
        menuAction.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.toolbar.menu.action.mnemonic"),'Z'));
        exportFishingOperationReportButton.setIcon(SwingUtil.createActionIcon("export"));
        exportFishingOperationReportButton.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.editCatchBatch.action.exportFishingOperationReport.mnemonic"),'Z'));
        exportFishingOperationReportForSumatraButton.setIcon(SwingUtil.createActionIcon("export"));
        exportFishingOperationReportForSumatraButton.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.editCatchBatch.action.exportFishingOperationReportForSumatra.mnemonic"),'Z'));
        importMultiPostButton.setIcon(SwingUtil.createActionIcon("import"));
        importMultiPostButton.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.editCatchBatch.action.importMultiPost.mnemonic"),'Z'));
        exportMultiPostButton.setIcon(SwingUtil.createActionIcon("export"));
        exportMultiPostButton.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.editCatchBatch.action.exportMultiPost.mnemonic"),'Z'));
        catchesCaracteristicsTabPane.setRightDecoration(catchesCaracteristicsTabToolBar);
        cancelButton.setIcon(SwingUtil.createActionIcon("cancel"));
        cancelButton.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.editCatchBatch.action.cancelEditCatchBatch.mnemonic"),'Z'));
        saveButton.setIcon(SwingUtil.createActionIcon("save"));
        saveButton.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.editCatchBatch.action.saveCatchBatch.mnemonic"),'Z'));
        cleanSpeciesBatchButton.setIcon(SwingUtil.createActionIcon("clean"));
        cleanSpeciesBatchButton.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.editCatchBatch.action.cleanWeights.mnemonic"),'Z'));
        computeSpeciesBatchButton.setIcon(SwingUtil.createActionIcon("generate"));
        computeSpeciesBatchButton.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.editCatchBatch.action.computeWeights.mnemonic"),'Z'));
        // late initializer
        // help broker setup
        TuttiHelpBroker _broker = getBroker();
        registerHelpId(_broker, editCatchesTopPanel, "tutti.editCatchBatch.help");
        registerHelpId(_broker, exportFishingOperationReportButton, "tutti.editCatchBatch.action.exportFishingOperationReport.help");
        registerHelpId(_broker, exportFishingOperationReportForSumatraButton, "tutti.editCatchBatch.action.exportFishingOperationReportForSumatra.help");
        registerHelpId(_broker, importMultiPostButton, "tutti.editCatchBatch.action.importMultiPost.help");
        registerHelpId(_broker, exportMultiPostButton, "tutti.editCatchBatch.action.exportMultiPost.help");
        registerHelpId(_broker, cancelButton, "tutti.editCatchBatch.action.cancelEditCatchBatch.help");
        registerHelpId(_broker, saveButton, "tutti.editCatchBatch.action.saveCatchBatch.help");
        registerHelpId(_broker, cleanSpeciesBatchButton, "tutti.editCatchBatch.action.cleanWeights.help");
        registerHelpId(_broker, computeSpeciesBatchButton, "tutti.editCatchBatch.action.computeWeights.help");
        _broker.prepareUI(this);
        // register 1 validator(s)
        validatorIds = SwingValidatorUtil.detectValidators(this);
        SwingValidatorUtil.installUI(this);
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        handler.beforeInit(this);
        $objectMap.put("editCatchesTopPanel", editCatchesTopPanel);
        createModel();
        createValidator();
        createSpeciesTabPanelLayout();
        createBenthosTabPanelLayout();
        createMarineLitterTabPanelLayout();
        createAccidentalTabPanelLayout();
        createIndividualObservationTabPanelLayout();
        createBroker();
        createCatchesCaracteristicsTabToolBar();
        createMenu();
        createMenuAction();
        createExportFishingOperationReportButton();
        createExportFishingOperationReportForSumatraButton();
        createImportMultiPostButton();
        createExportMultiPostButton();
        createCatchesCaracteristicsAttachmentsButton();
        createTabPane();
        createCatchesCaracteristicsTabPane();
        createSvgCanvasPanel();
        createSpeciesTabPanel();
        createSpeciesTabFishingOperationReminderLabel();
        createSpeciesTabContent();
        createSpeciesTabCreateBatchReminderLabel();
        createSpeciesTabCreateBatch();
        createSpeciesTabSplitBatchReminderLabel();
        createSpeciesTabSplitBatch();
        createSpeciesTabAddSampleCategoryBatchReminderLabel();
        createSpeciesTabAddSampleCategoryBatch();
        createSpeciesTabFrequencyEditorReminderLabel();
        createSpeciesTabFrequencyEditor();
        createBenthosTabPanel();
        createBenthosTabFishingOperationReminderLabel();
        createBenthosTabContent();
        createBenthosTabCreateBatchReminderLabel();
        createBenthosTabCreateBatch();
        createBenthosTabSplitBatchReminderLabel();
        createBenthosTabSplitBatch();
        createBenthosTabAddSampleCategoryBatchReminderLabel();
        createBenthosTabAddSampleCategoryBatch();
        createBenthosTabFrequencyEditorReminderLabel();
        createBenthosTabFrequencyEditor();
        createMarineLitterTabPanel();
        createMarineLitterTabFishingOperationReminderLabel();
        createMarineLitterTabContent();
        createMarineLitterTabCreateBatchReminderLabel();
        createMarineLitterTabCreateBatch();
        createIndividualObservationTabPanel();
        createIndividualObservationTabFishingOperationReminderLabel();
        createIndividualObservationTabContent();
        createIndividualObservationTabCreateBatchReminderLabel();
        createIndividualObservationTabCreateBatch();
        createIndividualObservationCaracteristicMapEditorReminderLabel();
        createIndividualObservationCaracteristicMapEditor();
        createAccidentalTabPanel();
        createAccidentalTabFishingOperationReminderLabel();
        createAccidentalTabContent();
        createAccidentalTabCreateBatchReminderLabel();
        createAccidentalTabCreateBatch();
        createAccidentalCaracteristicMapEditorReminderLabel();
        createAccidentalCaracteristicMapEditor();
        createCreateFishingOperationActions();
        createCancelButton();
        createSaveButton();
        createCleanSpeciesBatchButton();
        createComputeSpeciesBatchButton();
        createCatchesCaracteristicsTab();
        createSpeciesTab();
        createBenthosTab();
        createMarineLitterTab();
        createIndividualObservationTab();
        createAccidentalTab();
        // inline creation of editCatchesTopPanel
        setName("editCatchesTopPanel");
        setLayout(new BorderLayout());
        editCatchesTopPanel.putClientProperty("help", "tutti.editCatchBatch.help");
        
        // registers 7 data bindings
        $registerDefaultBindings();
        $completeSetup();
        handler.afterInit(this);
    }

    private void $registerDefaultBindings() {
        // register 7 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_CATCHES_CARACTERISTICS_ATTACHMENTS_BUTTON_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("objectId", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    catchesCaracteristicsAttachmentsButton.setEnabled(model.getObjectId() != null);
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("objectId", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SPECIES_TAB_FISHING_OPERATION_REMINDER_LABEL_RIGHT_DECORATION, true) {
        
            @Override
            public void applyDataBinding() {
                if (speciesTabContent != null) {
                    speciesTabContent.addPropertyChangeListener("speciesBatchTabToolBar", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (speciesTabContent != null) {
                    speciesTabFishingOperationReminderLabel.setRightDecoration(speciesTabContent.getSpeciesBatchTabToolBar());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (speciesTabContent != null) {
                    speciesTabContent.removePropertyChangeListener("speciesBatchTabToolBar", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_BENTHOS_TAB_FISHING_OPERATION_REMINDER_LABEL_RIGHT_DECORATION, true) {
        
            @Override
            public void applyDataBinding() {
                if (benthosTabContent != null) {
                    benthosTabContent.addPropertyChangeListener("benthosBatchTabToolBar", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (benthosTabContent != null) {
                    benthosTabFishingOperationReminderLabel.setRightDecoration(benthosTabContent.getBenthosBatchTabToolBar());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (benthosTabContent != null) {
                    benthosTabContent.removePropertyChangeListener("benthosBatchTabToolBar", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_MARINE_LITTER_TAB_FISHING_OPERATION_REMINDER_LABEL_RIGHT_DECORATION, true) {
        
            @Override
            public void applyDataBinding() {
                if (marineLitterTabContent != null) {
                    marineLitterTabContent.addPropertyChangeListener("marineLitterBatchTabToolBar", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (marineLitterTabContent != null) {
                    marineLitterTabFishingOperationReminderLabel.setRightDecoration(marineLitterTabContent.getMarineLitterBatchTabToolBar());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (marineLitterTabContent != null) {
                    marineLitterTabContent.removePropertyChangeListener("marineLitterBatchTabToolBar", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_INDIVIDUAL_OBSERVATION_TAB_FISHING_OPERATION_REMINDER_LABEL_RIGHT_DECORATION, true) {
        
            @Override
            public void applyDataBinding() {
                if (individualObservationTabContent != null) {
                    individualObservationTabContent.addPropertyChangeListener("individualObservationBatchTabToolBar", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (individualObservationTabContent != null) {
                    individualObservationTabFishingOperationReminderLabel.setRightDecoration(individualObservationTabContent.getIndividualObservationBatchTabToolBar());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (individualObservationTabContent != null) {
                    individualObservationTabContent.removePropertyChangeListener("individualObservationBatchTabToolBar", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_ACCIDENTAL_TAB_FISHING_OPERATION_REMINDER_LABEL_RIGHT_DECORATION, true) {
        
            @Override
            public void applyDataBinding() {
                if (accidentalTabContent != null) {
                    accidentalTabContent.addPropertyChangeListener("accidentalBatchTabToolBar", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (accidentalTabContent != null) {
                    accidentalTabFishingOperationReminderLabel.setRightDecoration(accidentalTabContent.getAccidentalBatchTabToolBar());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (accidentalTabContent != null) {
                    accidentalTabContent.removePropertyChangeListener("accidentalBatchTabToolBar", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SAVE_BUTTON_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("modify", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    saveButton.setEnabled(model.isModify());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("modify", this);
                }
            }
        });
    }

}