package fr.ifremer.tutti.ui.swing.content.operation.catches.individualobservation.create;

/*
 * #%L
 * Tutti :: UI
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2015 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.persistence.entities.referential.Caracteristic;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.ui.swing.TuttiHelpBroker;
import fr.ifremer.tutti.ui.swing.content.operation.catches.EditCatchesUI;
import fr.ifremer.tutti.ui.swing.util.TuttiUI;
import fr.ifremer.tutti.ui.swing.util.TuttiUIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.JAXXValidator;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.Table;
import jaxx.runtime.swing.editor.bean.BeanFilterableComboBox;
import jaxx.runtime.swing.help.JAXXHelpUI;
import jaxx.runtime.validator.swing.SwingValidator;
import jaxx.runtime.validator.swing.SwingValidatorUtil;
import jaxx.runtime.validator.swing.meta.Validator;
import jaxx.runtime.validator.swing.meta.ValidatorField;
import jaxx.runtime.validator.swing.ui.ImageValidationUI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.jaxx.widgets.number.NumberEditor;
import static org.nuiton.i18n.I18n.t;

public class CreateIndividualObservationBatchUI extends JPanel implements JAXXHelpUI<TuttiHelpBroker>, TuttiUI<CreateIndividualObservationBatchUIModel, CreateIndividualObservationBatchUIHandler>, JAXXObject, JAXXValidator {

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_INDIVIDUAL_OBSERVATION_CREATE_FROM_BATCH_ENABLED = "individualObservationCreateFromBatch.enabled";
    public static final String BINDING_INDIVIDUAL_OBSERVATION_CREATE_FROM_BATCH_SELECTED = "individualObservationCreateFromBatch.selected";
    public static final String BINDING_INDIVIDUAL_OBSERVATION_LENGTH_STEP_CARACTERISTIC_COMBO_BOX_SELECTED_ITEM = "individualObservationLengthStepCaracteristicComboBox.selectedItem";
    public static final String BINDING_INDIVIDUAL_OBSERVATION_SIZE_FIELD_NUMBER_VALUE = "individualObservationSizeField.numberValue";
    public static final String BINDING_INDIVIDUAL_OBSERVATION_SPECIES_COMBO_BOX_DATA = "individualObservationSpeciesComboBox.data";
    public static final String BINDING_INDIVIDUAL_OBSERVATION_SPECIES_COMBO_BOX_SELECTED_ITEM = "individualObservationSpeciesComboBox.selectedItem";
    public static final String BINDING_INDIVIDUAL_OBSERVATION_WEIGHT_FIELD_NUMBER_VALUE = "individualObservationWeightField.numberValue";
    public static final String BINDING_SAVE_AND_CLOSE_BUTTON_ENABLED = "saveAndCloseButton.enabled";
    public static final String BINDING_SAVE_AND_CONTINUE_BUTTON_ENABLED = "saveAndContinueButton.enabled";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "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";
    private static final Log log = LogFactory.getLog(CreateIndividualObservationBatchUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JButton addSpeciesButton;
    protected TuttiHelpBroker broker;
    protected JButton cancelButton;
    protected Table configurationPanel;
    protected CreateIndividualObservationBatchUI createIndividualObservationBatchTopPanel = this;
    protected final CreateIndividualObservationBatchUIHandler handler = createHandler();
    protected JCheckBox individualObservationCreateFromBatch;
    @ValidatorField( validatorId = "validator",  propertyName = "lengthStepCaracteristic",  editorName = "individualObservationLengthStepCaracteristicComboBox")
    protected BeanFilterableComboBox<Caracteristic> individualObservationLengthStepCaracteristicComboBox;
    protected JLabel individualObservationLengthStepCaracteristicLabel;
    @ValidatorField( validatorId = "validator",  propertyName = "size",  editorName = "individualObservationSizeField")
    protected NumberEditor individualObservationSizeField;
    protected JLabel individualObservationSizeLabel;
    @ValidatorField( validatorId = "validator",  propertyName = "species",  editorName = "individualObservationSpeciesComboBox")
    protected BeanFilterableComboBox<Species> individualObservationSpeciesComboBox;
    protected JLabel individualObservationSpeciesLabel;
    @ValidatorField( validatorId = "validator",  propertyName = "weight",  editorName = "individualObservationWeightField")
    protected NumberEditor individualObservationWeightField;
    protected JLabel individualObservationWeightLabel;
    protected CreateIndividualObservationBatchUIModel model;
    protected JButton saveAndCloseButton;
    protected JButton saveAndContinueButton;
    @Validator( validatorId = "validator")
    protected SwingValidator<CreateIndividualObservationBatchUIModel> validator;
    protected List<String> validatorIds = new ArrayList<String>();

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JPanel $JPanel0;

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public CreateIndividualObservationBatchUI(EditCatchesUI parentUI) {
        TuttiUIUtil.setParentUI(this, parentUI);
            $initialize();
    }

    public CreateIndividualObservationBatchUI(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public CreateIndividualObservationBatchUI(JAXXContext parentContext, LayoutManager param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public CreateIndividualObservationBatchUI(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public CreateIndividualObservationBatchUI(JAXXContext parentContext, LayoutManager param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public CreateIndividualObservationBatchUI(boolean param0) {
        super(param0);
        $initialize();
    }

    public CreateIndividualObservationBatchUI(JAXXContext parentContext, boolean param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public CreateIndividualObservationBatchUI() {
        $initialize();
    }

    public CreateIndividualObservationBatchUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*-------------------- JAXXValidator implementation  --------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public SwingValidator<?> getValidator(String validatorId) {
        return (SwingValidator<?>) (validatorIds.contains(validatorId) ? getObjectById(validatorId) : null);
    }

    @Override
    public List<String> getValidatorIds() {
        return validatorIds;
    }

    @Override
    public void registerValidatorFields() {
        SwingValidatorUtil.detectValidatorFields(this);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doItemStateChanged__on__individualObservationCreateFromBatch(ItemEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.setBoolean(event, "createFromBatch");
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JButton getAddSpeciesButton() {
        return addSpeciesButton;
    }

    public TuttiHelpBroker getBroker() {
        return broker;
    }

    public JButton getCancelButton() {
        return cancelButton;
    }

    public Table getConfigurationPanel() {
        return configurationPanel;
    }

    public CreateIndividualObservationBatchUIHandler getHandler() {
        return handler;
    }

    public JCheckBox getIndividualObservationCreateFromBatch() {
        return individualObservationCreateFromBatch;
    }

    public BeanFilterableComboBox<Caracteristic> getIndividualObservationLengthStepCaracteristicComboBox() {
        return individualObservationLengthStepCaracteristicComboBox;
    }

    public JLabel getIndividualObservationLengthStepCaracteristicLabel() {
        return individualObservationLengthStepCaracteristicLabel;
    }

    public NumberEditor getIndividualObservationSizeField() {
        return individualObservationSizeField;
    }

    public JLabel getIndividualObservationSizeLabel() {
        return individualObservationSizeLabel;
    }

    public BeanFilterableComboBox<Species> getIndividualObservationSpeciesComboBox() {
        return individualObservationSpeciesComboBox;
    }

    public JLabel getIndividualObservationSpeciesLabel() {
        return individualObservationSpeciesLabel;
    }

    public NumberEditor getIndividualObservationWeightField() {
        return individualObservationWeightField;
    }

    public JLabel getIndividualObservationWeightLabel() {
        return individualObservationWeightLabel;
    }

    public CreateIndividualObservationBatchUIModel getModel() {
        return model;
    }

    public JButton getSaveAndCloseButton() {
        return saveAndCloseButton;
    }

    public JButton getSaveAndContinueButton() {
        return saveAndContinueButton;
    }

    public SwingValidator<CreateIndividualObservationBatchUIModel> getValidator() {
        return validator;
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Other methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void registerHelpId(TuttiHelpBroker broker, Component component, String helpId) {
        broker.installUI(component, helpId);
    }

    @Override
    public void showHelp(String helpId) {
        getBroker().showHelp(this, helpId);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JPanel get$JPanel0() {
        return $JPanel0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToConfigurationPanel() {
        if (!allComponentsCreated) {
            return;
        }
        configurationPanel.add(individualObservationSpeciesLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        configurationPanel.add(SwingUtil.boxComponentWithJxLayer(individualObservationSpeciesComboBox), new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        configurationPanel.add(addSpeciesButton, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        configurationPanel.add(individualObservationCreateFromBatch, new GridBagConstraints(0, 1, 3, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        configurationPanel.add(individualObservationWeightLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        configurationPanel.add(SwingUtil.boxComponentWithJxLayer(individualObservationWeightField), new GridBagConstraints(1, 2, 2, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        configurationPanel.add(individualObservationSizeLabel, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        configurationPanel.add(SwingUtil.boxComponentWithJxLayer(individualObservationSizeField), new GridBagConstraints(1, 3, 2, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        configurationPanel.add(individualObservationLengthStepCaracteristicLabel, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        configurationPanel.add(SwingUtil.boxComponentWithJxLayer(individualObservationLengthStepCaracteristicComboBox), new GridBagConstraints(1, 4, 2, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void addChildrenToCreateIndividualObservationBatchTopPanel() {
        if (!allComponentsCreated) {
            return;
        }
        add(configurationPanel, BorderLayout.CENTER);
        add($JPanel0, BorderLayout.SOUTH);
    }

    protected void addChildrenToValidator() {
        if (!allComponentsCreated) {
            return;
        }
        validator.setUiClass(ImageValidationUI.class);
        validator.setBean(model);
    }

    protected void createAddSpeciesButton() {
        $objectMap.put("addSpeciesButton", addSpeciesButton = new JButton());
        
        addSpeciesButton.setName("addSpeciesButton");
        addSpeciesButton.setFocusable(false);
        addSpeciesButton.setText(t("tutti.createIndividualObservationBatch.action.addSpecies"));
        addSpeciesButton.setToolTipText(t("tutti.createIndividualObservationBatch.action.addSpecies.tip"));
        addSpeciesButton.putClientProperty("applicationAction", fr.ifremer.tutti.ui.swing.content.operation.catches.individualobservation.actions.SelectSpeciesForIndividualObservationBatchAction.class);
        addSpeciesButton.putClientProperty("help", "tutti.createIndividualObservationBatch.action.addSpecies.help");
    }

    protected void createBroker() {
        $objectMap.put("broker", broker = new TuttiHelpBroker("tutti.createIndividualObservationBatch.help"));
    }

    protected void createCancelButton() {
        $objectMap.put("cancelButton", cancelButton = new JButton());
        
        cancelButton.setName("cancelButton");
        cancelButton.setText(t("tutti.createIndividualObservationBatch.action.cancel"));
        cancelButton.setToolTipText(t("tutti.createIndividualObservationBatch.action.cancel.tip"));
        cancelButton.putClientProperty("help", "tutti.createIndividualObservationBatch.action.cancel.help");
        cancelButton.putClientProperty("simpleAction", fr.ifremer.tutti.ui.swing.content.operation.catches.individualobservation.create.actions.CreateIndividualObservationBatchCancelAction.class);
    }

    protected void createConfigurationPanel() {
        $objectMap.put("configurationPanel", configurationPanel = new Table());
        
        configurationPanel.setName("configurationPanel");
    }

    protected CreateIndividualObservationBatchUIHandler createHandler() {
        return new CreateIndividualObservationBatchUIHandler();
    }

    protected void createIndividualObservationCreateFromBatch() {
        $objectMap.put("individualObservationCreateFromBatch", individualObservationCreateFromBatch = new JCheckBox());
        
        individualObservationCreateFromBatch.setName("individualObservationCreateFromBatch");
        individualObservationCreateFromBatch.setText(t("tutti.createIndividualObservationBatch.field.createFromBatch"));
        individualObservationCreateFromBatch.setToolTipText(t("tutti.createIndividualObservationBatch.field.createFromBatch.tip"));
        individualObservationCreateFromBatch.addItemListener(JAXXUtil.getEventListener(ItemListener.class, "itemStateChanged", this, "doItemStateChanged__on__individualObservationCreateFromBatch"));
        individualObservationCreateFromBatch.putClientProperty("help", "tutti.createIndividualObservationBatch.field.createFromBatch.help");
    }

    protected void createIndividualObservationLengthStepCaracteristicComboBox() {
        $objectMap.put("individualObservationLengthStepCaracteristicComboBox", individualObservationLengthStepCaracteristicComboBox = new BeanFilterableComboBox<Caracteristic>(this));
        
        individualObservationLengthStepCaracteristicComboBox.setName("individualObservationLengthStepCaracteristicComboBox");
        individualObservationLengthStepCaracteristicComboBox.setProperty("lengthStepCaracteristic");
        individualObservationLengthStepCaracteristicComboBox.setShowReset(true);
        individualObservationLengthStepCaracteristicComboBox.putClientProperty("help", "tutti.createIndividualObservationBatch.field.individualObservationLengthStepCaracteristic.help");
    }

    protected void createIndividualObservationLengthStepCaracteristicLabel() {
        $objectMap.put("individualObservationLengthStepCaracteristicLabel", individualObservationLengthStepCaracteristicLabel = new JLabel());
        
        individualObservationLengthStepCaracteristicLabel.setName("individualObservationLengthStepCaracteristicLabel");
        individualObservationLengthStepCaracteristicLabel.setText(t("tutti.createIndividualObservationBatch.field.individualObservationLengthStepCaracteristic"));
        individualObservationLengthStepCaracteristicLabel.setToolTipText(t("tutti.createIndividualObservationBatch.field.individualObservationLengthStepCaracteristic.tip"));
        individualObservationLengthStepCaracteristicLabel.putClientProperty("help", "tutti.createIndividualObservationBatch.field.individualObservationLengthStepCaracteristic.help");
    }

    protected void createIndividualObservationSizeField() {
        $objectMap.put("individualObservationSizeField", individualObservationSizeField = new NumberEditor(this));
        
        individualObservationSizeField.setName("individualObservationSizeField");
        individualObservationSizeField.setProperty("size");
        individualObservationSizeField.setShowReset(true);
        individualObservationSizeField.putClientProperty("help", "tutti.createIndividualObservationBatch.field.individualObservationSize.help");
    }

    protected void createIndividualObservationSizeLabel() {
        $objectMap.put("individualObservationSizeLabel", individualObservationSizeLabel = new JLabel());
        
        individualObservationSizeLabel.setName("individualObservationSizeLabel");
        individualObservationSizeLabel.setText(t("tutti.createIndividualObservationBatch.field.individualObservationSize"));
        individualObservationSizeLabel.setToolTipText(t("tutti.createIndividualObservationBatch.field.individualObservationSize.tip"));
        individualObservationSizeLabel.putClientProperty("help", "tutti.createIndividualObservationBatch.field.individualObservationSize.help");
    }

    protected void createIndividualObservationSpeciesComboBox() {
        $objectMap.put("individualObservationSpeciesComboBox", individualObservationSpeciesComboBox = new BeanFilterableComboBox<Species>(this));
        
        individualObservationSpeciesComboBox.setName("individualObservationSpeciesComboBox");
        individualObservationSpeciesComboBox.setProperty("species");
        individualObservationSpeciesComboBox.setShowReset(true);
        individualObservationSpeciesComboBox.putClientProperty("help", "tutti.createIndividualObservationBatch.field.individualObservationSpecies.help");
    }

    protected void createIndividualObservationSpeciesLabel() {
        $objectMap.put("individualObservationSpeciesLabel", individualObservationSpeciesLabel = new JLabel());
        
        individualObservationSpeciesLabel.setName("individualObservationSpeciesLabel");
        individualObservationSpeciesLabel.setText(t("tutti.createIndividualObservationBatch.field.individualObservationSpecies"));
        individualObservationSpeciesLabel.setToolTipText(t("tutti.createIndividualObservationBatch.field.individualObservationSpecies.tip"));
        individualObservationSpeciesLabel.putClientProperty("help", "tutti.createIndividualObservationBatch.field.individualObservationSpecies.help");
    }

    protected void createIndividualObservationWeightField() {
        $objectMap.put("individualObservationWeightField", individualObservationWeightField = new NumberEditor(this));
        
        individualObservationWeightField.setName("individualObservationWeightField");
        individualObservationWeightField.setProperty("weight");
        individualObservationWeightField.setShowReset(true);
        individualObservationWeightField.putClientProperty("help", "tutti.createIndividualObservationBatch.field.individualObservationWeight.help");
    }

    protected void createIndividualObservationWeightLabel() {
        $objectMap.put("individualObservationWeightLabel", individualObservationWeightLabel = new JLabel());
        
        individualObservationWeightLabel.setName("individualObservationWeightLabel");
        individualObservationWeightLabel.setText(t("tutti.createIndividualObservationBatch.field.individualObservationWeight"));
        individualObservationWeightLabel.setToolTipText(t("tutti.createIndividualObservationBatch.field.individualObservationWeight.tip"));
        individualObservationWeightLabel.putClientProperty("help", "tutti.createIndividualObservationBatch.field.individualObservationWeight.help");
        individualObservationWeightLabel.putClientProperty("addWeightUnit", handler.getConfig().getIndividualObservationWeightUnit());
    }

    protected void createModel() {
        $objectMap.put("model", model = getContextValue(CreateIndividualObservationBatchUIModel.class));
    }

    protected void createSaveAndCloseButton() {
        $objectMap.put("saveAndCloseButton", saveAndCloseButton = new JButton());
        
        saveAndCloseButton.setName("saveAndCloseButton");
        saveAndCloseButton.setText(t("tutti.createIndividualObservationBatch.action.saveAndClose"));
        saveAndCloseButton.setToolTipText(t("tutti.createIndividualObservationBatch.action.saveAndClose.tip"));
        saveAndCloseButton.putClientProperty("help", "tutti.createIndividualObservationBatch.action.saveAndClose.help");
        saveAndCloseButton.putClientProperty("simpleAction", fr.ifremer.tutti.ui.swing.content.operation.catches.individualobservation.create.actions.CreateIndividualObservationBatchAndCloseAction.class);
    }

    protected void createSaveAndContinueButton() {
        $objectMap.put("saveAndContinueButton", saveAndContinueButton = new JButton());
        
        saveAndContinueButton.setName("saveAndContinueButton");
        saveAndContinueButton.setText(t("tutti.createIndividualObservationBatch.action.saveAndContinue"));
        saveAndContinueButton.setToolTipText(t("tutti.createIndividualObservationBatch.action.saveAndContinue.tip"));
        saveAndContinueButton.putClientProperty("help", "tutti.createIndividualObservationBatch.action.saveAndContinue.help");
        saveAndContinueButton.putClientProperty("simpleAction", fr.ifremer.tutti.ui.swing.content.operation.catches.individualobservation.create.actions.CreateIndividualObservationBatchAndContinueAction.class);
    }

    protected void createValidator() {
        $objectMap.put("validator", validator = SwingValidator.newValidator(CreateIndividualObservationBatchUIModel.class, null));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToCreateIndividualObservationBatchTopPanel();
        addChildrenToValidator();
        addChildrenToConfigurationPanel();
        // inline complete setup of $JPanel0
        $JPanel0.add(cancelButton);
        $JPanel0.add(saveAndContinueButton);
        $JPanel0.add(saveAndCloseButton);
        
        // apply 9 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 25 property setters
        individualObservationSpeciesComboBox.setBeanType(Species.class);
        individualObservationLengthStepCaracteristicComboBox.setBeanType(Caracteristic.class);
        individualObservationSpeciesLabel.setLabelFor(individualObservationSpeciesComboBox);
        individualObservationSpeciesComboBox.setBean(model);
        addSpeciesButton.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.createIndividualObservationBatch.action.addSpecies.mnemonic"),'Z'));
        individualObservationWeightLabel.setLabelFor(individualObservationWeightField);
        individualObservationWeightField.setBean(model);
        individualObservationWeightField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        individualObservationWeightField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        individualObservationWeightField.setNumberType(Float.class);
        individualObservationSizeLabel.setLabelFor(individualObservationSizeField);
        individualObservationSizeField.setBean(model);
        individualObservationSizeField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        individualObservationSizeField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        individualObservationSizeField.setNumberType(Float.class);
        individualObservationLengthStepCaracteristicLabel.setLabelFor(individualObservationLengthStepCaracteristicComboBox);
        individualObservationLengthStepCaracteristicComboBox.setBean(model);
        cancelButton.setIcon(SwingUtil.createActionIcon("cancel"));
        cancelButton.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.createIndividualObservationBatch.action.cancel.mnemonic"),'Z'));
        saveAndContinueButton.setIcon(SwingUtil.createActionIcon("save"));
        saveAndContinueButton.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.createIndividualObservationBatch.action.saveAndContinue.mnemonic"),'Z'));
        saveAndCloseButton.setIcon(SwingUtil.createActionIcon("save"));
        saveAndCloseButton.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.createIndividualObservationBatch.action.saveAndClose.mnemonic"),'Z'));
        // late initializer
        // help broker setup
        TuttiHelpBroker _broker = getBroker();
        registerHelpId(_broker, createIndividualObservationBatchTopPanel, "tutti.createIndividualObservationBatch.help");
        registerHelpId(_broker, individualObservationSpeciesLabel, "tutti.createIndividualObservationBatch.field.individualObservationSpecies.help");
        registerHelpId(_broker, individualObservationSpeciesComboBox, "tutti.createIndividualObservationBatch.field.individualObservationSpecies.help");
        registerHelpId(_broker, addSpeciesButton, "tutti.createIndividualObservationBatch.action.addSpecies.help");
        registerHelpId(_broker, individualObservationCreateFromBatch, "tutti.createIndividualObservationBatch.field.createFromBatch.help");
        registerHelpId(_broker, individualObservationWeightLabel, "tutti.createIndividualObservationBatch.field.individualObservationWeight.help");
        registerHelpId(_broker, individualObservationWeightField, "tutti.createIndividualObservationBatch.field.individualObservationWeight.help");
        registerHelpId(_broker, individualObservationSizeLabel, "tutti.createIndividualObservationBatch.field.individualObservationSize.help");
        registerHelpId(_broker, individualObservationSizeField, "tutti.createIndividualObservationBatch.field.individualObservationSize.help");
        registerHelpId(_broker, individualObservationLengthStepCaracteristicLabel, "tutti.createIndividualObservationBatch.field.individualObservationLengthStepCaracteristic.help");
        registerHelpId(_broker, individualObservationLengthStepCaracteristicComboBox, "tutti.createIndividualObservationBatch.field.individualObservationLengthStepCaracteristic.help");
        registerHelpId(_broker, cancelButton, "tutti.createIndividualObservationBatch.action.cancel.help");
        registerHelpId(_broker, saveAndContinueButton, "tutti.createIndividualObservationBatch.action.saveAndContinue.help");
        registerHelpId(_broker, saveAndCloseButton, "tutti.createIndividualObservationBatch.action.saveAndClose.help");
        _broker.prepareUI(this);
        // register 1 validator(s)
        validatorIds = SwingValidatorUtil.detectValidators(this);
        SwingValidatorUtil.installUI(this);
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        handler.beforeInit(this);
        $objectMap.put("createIndividualObservationBatchTopPanel", createIndividualObservationBatchTopPanel);
        createModel();
        createValidator();
        createBroker();
        createConfigurationPanel();
        createIndividualObservationSpeciesLabel();
        createIndividualObservationSpeciesComboBox();
        createAddSpeciesButton();
        createIndividualObservationCreateFromBatch();
        createIndividualObservationWeightLabel();
        createIndividualObservationWeightField();
        createIndividualObservationSizeLabel();
        createIndividualObservationSizeField();
        createIndividualObservationLengthStepCaracteristicLabel();
        createIndividualObservationLengthStepCaracteristicComboBox();
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new JPanel());
        
        $JPanel0.setName("$JPanel0");
        $JPanel0.setLayout(new GridLayout(1, 0));
        createCancelButton();
        createSaveAndContinueButton();
        createSaveAndCloseButton();
        // inline creation of createIndividualObservationBatchTopPanel
        setName("createIndividualObservationBatchTopPanel");
        setLayout(new BorderLayout());
        createIndividualObservationBatchTopPanel.putClientProperty("help", "tutti.createIndividualObservationBatch.help");
        
        // registers 9 data bindings
        $registerDefaultBindings();
        $completeSetup();
        handler.afterInit(this);
    }

    private void $registerDefaultBindings() {
        // register 9 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_INDIVIDUAL_OBSERVATION_SPECIES_COMBO_BOX_SELECTED_ITEM, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("species", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    individualObservationSpeciesComboBox.setSelectedItem(model.getSpecies());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("species", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_INDIVIDUAL_OBSERVATION_SPECIES_COMBO_BOX_DATA, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("availableSpecies", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    individualObservationSpeciesComboBox.setData(model.getAvailableSpecies());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("availableSpecies", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_INDIVIDUAL_OBSERVATION_CREATE_FROM_BATCH_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("speciesFromBatch", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    individualObservationCreateFromBatch.setEnabled(model.isSpeciesFromBatch());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("speciesFromBatch", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_INDIVIDUAL_OBSERVATION_CREATE_FROM_BATCH_SELECTED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("createFromBatch", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    individualObservationCreateFromBatch.setSelected(model.isCreateFromBatch());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("createFromBatch", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_INDIVIDUAL_OBSERVATION_WEIGHT_FIELD_NUMBER_VALUE, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("weight", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    individualObservationWeightField.setNumberValue(model.getWeight());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("weight", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_INDIVIDUAL_OBSERVATION_SIZE_FIELD_NUMBER_VALUE, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("size", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    individualObservationSizeField.setNumberValue(model.getSize());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("size", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_INDIVIDUAL_OBSERVATION_LENGTH_STEP_CARACTERISTIC_COMBO_BOX_SELECTED_ITEM, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("lengthStepCaracteristic", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    individualObservationLengthStepCaracteristicComboBox.setSelectedItem(model.getLengthStepCaracteristic());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("lengthStepCaracteristic", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SAVE_AND_CONTINUE_BUTTON_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("valid", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    saveAndContinueButton.setEnabled(model.isValid());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("valid", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SAVE_AND_CLOSE_BUTTON_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("valid", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    saveAndCloseButton.setEnabled(model.isValid());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("valid", this);
                }
            }
        });
    }

}