/*
 * Decompiled with CFR 0.152.
 */
package com.intel.bluetooth;

import com.intel.bluetooth.Utils;
import java.io.IOException;
import java.io.InputStream;
import javax.bluetooth.DataElement;
import javax.bluetooth.UUID;

class SDPInputStream
extends InputStream {
    private InputStream source;
    private long pos;

    public SDPInputStream(InputStream in) {
        this.source = in;
        this.pos = 0L;
    }

    public int read() throws IOException {
        return this.source.read();
    }

    private long readLong(int size) throws IOException {
        long result = 0L;
        for (int i = 0; i < size; ++i) {
            result = result << 8 | (long)this.read();
        }
        this.pos += (long)size;
        return result;
    }

    private String hexString(byte[] b) throws IOException {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < b.length; ++i) {
            buf.append(Integer.toHexString(b[i] >> 4 & 0xF));
            buf.append(Integer.toHexString(b[i] & 0xF));
        }
        return buf.toString();
    }

    private byte[] readBytes(int size) throws IOException {
        byte[] result = new byte[size];
        for (int i = 0; i < size; ++i) {
            result[i] = (byte)this.read();
        }
        this.pos += (long)size;
        return result;
    }

    public DataElement readElement() throws IOException {
        int header = this.read();
        int type = header >> 3 & 0x1F;
        int sizeDescriptor = header & 7;
        ++this.pos;
        switch (type) {
            case 0: {
                return new DataElement(0);
            }
            case 1: {
                switch (sizeDescriptor) {
                    case 0: {
                        return new DataElement(8, this.readLong(1));
                    }
                    case 1: {
                        return new DataElement(9, this.readLong(2));
                    }
                    case 2: {
                        return new DataElement(10, this.readLong(4));
                    }
                    case 3: {
                        return new DataElement(11, this.readBytes(8));
                    }
                    case 4: {
                        return new DataElement(12, this.readBytes(16));
                    }
                }
                throw new IOException();
            }
            case 2: {
                switch (sizeDescriptor) {
                    case 0: {
                        return new DataElement(16, (byte)this.readLong(1));
                    }
                    case 1: {
                        return new DataElement(17, (short)this.readLong(2));
                    }
                    case 2: {
                        return new DataElement(18, (int)this.readLong(4));
                    }
                    case 3: {
                        return new DataElement(19, this.readLong(8));
                    }
                    case 4: {
                        return new DataElement(20, this.readBytes(16));
                    }
                }
                throw new IOException();
            }
            case 3: {
                UUID uuid = null;
                switch (sizeDescriptor) {
                    case 1: {
                        uuid = new UUID(this.readLong(2));
                        break;
                    }
                    case 2: {
                        uuid = new UUID(this.readLong(4));
                        break;
                    }
                    case 4: {
                        uuid = new UUID(this.hexString(this.readBytes(16)), false);
                        break;
                    }
                    default: {
                        throw new IOException();
                    }
                }
                return new DataElement(24, uuid);
            }
            case 4: {
                int length = -1;
                switch (sizeDescriptor) {
                    case 5: {
                        length = (int)this.readLong(1);
                        break;
                    }
                    case 6: {
                        length = (int)this.readLong(2);
                        break;
                    }
                    case 7: {
                        length = (int)this.readLong(4);
                        break;
                    }
                    default: {
                        throw new IOException();
                    }
                }
                return new DataElement(32, Utils.newStringUTF8(this.readBytes(length)));
            }
            case 5: {
                return new DataElement(this.readLong(1) != 0L);
            }
            case 6: {
                long length;
                switch (sizeDescriptor) {
                    case 5: {
                        length = this.readLong(1);
                        break;
                    }
                    case 6: {
                        length = this.readLong(2);
                        break;
                    }
                    case 7: {
                        length = this.readLong(4);
                        break;
                    }
                    default: {
                        throw new IOException();
                    }
                }
                DataElement element = new DataElement(48);
                long started = this.pos;
                long end = this.pos + length;
                while (this.pos < end) {
                    element.addElement(this.readElement());
                }
                if (started + length != this.pos) {
                    throw new IOException("DATSEQ size corruption " + (started + length - this.pos));
                }
                return element;
            }
            case 7: {
                long length;
                switch (sizeDescriptor) {
                    case 5: {
                        length = this.readLong(1);
                        break;
                    }
                    case 6: {
                        length = this.readLong(2);
                        break;
                    }
                    case 7: {
                        length = this.readLong(4);
                        break;
                    }
                    default: {
                        throw new IOException();
                    }
                }
                DataElement element = new DataElement(56);
                long started = this.pos;
                long end = this.pos + length;
                while (this.pos < end) {
                    element.addElement(this.readElement());
                }
                if (started + length != this.pos) {
                    throw new IOException("DATALT size corruption " + (started + length - this.pos));
                }
                return element;
            }
            case 8: {
                int length;
                switch (sizeDescriptor) {
                    case 5: {
                        length = (int)this.readLong(1);
                        break;
                    }
                    case 6: {
                        length = (int)this.readLong(2);
                        break;
                    }
                    case 7: {
                        length = (int)this.readLong(4);
                        break;
                    }
                    default: {
                        throw new IOException();
                    }
                }
                return new DataElement(64, Utils.newStringASCII(this.readBytes(length)));
            }
        }
        throw new IOException("Unknown type " + type);
    }
}

