package fr.ifremer.tutti.ui.swing.content.cruise;

/*
 * #%L
 * Tutti :: UI
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2014 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.persistence.entities.referential.Caracteristic;
import fr.ifremer.tutti.ui.swing.util.TuttiUI;
import fr.ifremer.tutti.ui.swing.util.TuttiUIUtil;
import java.awt.Color;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.ListSelectionModel;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.Table;
import jaxx.runtime.swing.editor.bean.BeanFilterableComboBox;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXTable;
import static org.nuiton.i18n.I18n.t;

public class GearCaracteristicsEditorUI extends Table implements TuttiUI<GearCaracteristicsEditorUIModel, GearCaracteristicsEditorUIHandler>, JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_ADD_ROW_ENABLED = "addRow.enabled";
    public static final String BINDING_ADD_ROW_VISIBLE = "addRow.visible";
    public static final String BINDING_GEAR_CARACTERISTICS_EDITOR_TABLE_EDITABLE = "gearCaracteristicsEditorTable.editable";
    public static final String BINDING_NEW_ROW_KEY_ENABLED = "newRowKey.enabled";
    public static final String BINDING_NEW_ROW_KEY_VISIBLE = "newRowKey.visible";
    public static final String BINDING_REMOVE_CARACTERISTIC_MENU_ENABLED = "removeCaracteristicMenu.enabled";
    public static final String BINDING_SAVE_BUTTON_ENABLED = "saveButton.enabled";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAK1Wz28bRRSeOLHzsxQakhbSSkkIpZXohh4qQGlpazdpnDpJiQOKyKGMdyfOpOOZZfats1FUxJ8A/wHcuSBx44Q4cObABfEvIMSBK+LN7trrddYkJPFhZb0373vfe2+/t/PtHyTvaTKzR4PA0r4E3mDWysOtrfXaHrPhEfNszV1QmkS/vhzJbZNRp233gLyxXTHh83H4fEk1XCWZ7IheqJARDw4E83YZAyDX0hG2581X2+6FwPV1C7VNKgv167/+zH3pfPFNjpDARXajWMr0cVFJJQMVkuMOkEuYqUnnBZV1pKG5rCPfC8ZWEtTz1miDfUY+J4MVUnCpRjAgsycvOcQI4wMXyODcJq0J9g6Q0o62+I5mDaYt8AG45XPL28fslq0kIJhla597zHrMqC5RTW1gmnvAbW/R4Zjio7LrhsgFIPmGcpgAsnwOqKsGKoEeAcP4qXJ95D9p2hLEiCuhcZVJPzl9GXOrJkshmxNAJlKhxlYG1jBhF9vRw5Ltb6j9J+wAyJ3UJKMwFlK0aoxKq4iPJS4wieGHI6ipogoM0HAbr0AdB/GAjKeSF7EzSqaPXphbqdpaCfGUSjOfy6mIxJWOulbv0cZwzECmlK5be6iX56DcCCywVrZCr4GYaiMNza0YeIGpL6WbbKzprGM2lTYTSRmvm8dMMjKPNtlRryZTqZ6i7qxEd4kw+rZJXvtoBnJl+6hUN9AVifRKl0gNYOj9Z3L81x9+/36ppcxhzD2RebRjsaBiXK1cpoGb1BcjWfrAxfwqdRe2EYUJ3Erh1rmaQawau5Ec5nvFhFsm3Fqm3i5C5Ad/+/GnyU9/6Se5JTIiFHWWqDlfJsOwq7ELSjiBe/9ByGhsfwifLxtu+F6ib3+DeWZ5DYD2WYDVX82ovk2hNvzz3+PV7x60OtCHjF7reTzpQv4TUuBScMnC7RQvnsxtNOp6zHdUsmCyVg4xos2WSizaW+Hz9pGy+3FbMWkCcEe+fRguGIuHr7cx3rg5ff369ExbsMbVcOHgxs0XGNjkHg8F8GpGIB4YiieNOp+IpsqclIwC37C6E3bO/HuXdG4H9/9wX+jBPaFeZ1CNSZidhO6Ze9PSF+IkpYwgaa5k2exX0o8LJ4t6vIiO453HPRS1AxHNHgby5mEFG1LtNAqrWl57XFl8Vl2sLJY2y+trpqOe0hAtnfwOFfiqkvE21JLSrK6VL7EdFw5LSuASLVYelp686DxVpPbz1qnCYVz/EIuL7dGArGr/eyueoAnJ8O72GF7LunH0c7MYxYbDGQAWoGaXo2+hKaUsHd7kjk/Fes1juklN5WmuVjRRK+NT1jXusRoFe/cWUmGADRrjt9+TqxLDpDn64XlltRptzFFQSmxydzOsq3JuGYC7WZPs9Tk/wQzj1i+cimL0gevqdqFl7erzozOk6Nna+2cBxW6iDJ/t4j0K6R3OngXLgMxmyix1DThuIoVOVb11jKo+poKnBPT+qSow15CuGQ5Etq4JFk8N33N+904PmZpe8ZTTC5F6z67jinbc5PD+MWRuvJsHLnbupbsOBTpd40hF1j84gt1nnpMnwCwIeqB8MP6vslFmEeVfuGRHGyIOAAA=";
    private static final Log log = LogFactory.getLog(GearCaracteristicsEditorUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JButton addRow;
    protected JButton cancelButton;
    protected JXTable gearCaracteristicsEditorTable;
    protected final GearCaracteristicsEditorUIHandler handler = new GearCaracteristicsEditorUIHandler();
    protected GearCaracteristicsEditorUIModel model;
    protected BeanFilterableComboBox<Caracteristic> newRowKey;
    protected JMenuItem removeCaracteristicMenu;
    protected JButton saveButton;
    protected JPopupMenu tablePopup;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JPanel $JPanel0;
    private JScrollPane $JScrollPane0;
    private GearCaracteristicsEditorUI $Table0 = this;

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public GearCaracteristicsEditorUI(TuttiUI parentUI) {
        TuttiUIUtil.setParentUI(this, parentUI);
            $initialize();
    }

    public GearCaracteristicsEditorUI() {
        $initialize();
    }

    public GearCaracteristicsEditorUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__addRow(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.addRow();
    }

    public void doActionPerformed__on__cancelButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.cancel();
    }

    public void doActionPerformed__on__removeCaracteristicMenu(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.removeCaracteristic();
    }

    public void doActionPerformed__on__saveButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.save();
    }

    public void doKeyPressed__on__gearCaracteristicsEditorTable(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.openRowMenu(event, tablePopup);
    }

    public void doMouseClicked__on__gearCaracteristicsEditorTable(MouseEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.autoSelectRowInTable(event, tablePopup);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JButton getAddRow() {
        return addRow;
    }

    public JButton getCancelButton() {
        return cancelButton;
    }

    public JXTable getGearCaracteristicsEditorTable() {
        return gearCaracteristicsEditorTable;
    }

    public GearCaracteristicsEditorUIHandler getHandler() {
        return handler;
    }

    public GearCaracteristicsEditorUIModel getModel() {
        return model;
    }

    public BeanFilterableComboBox<Caracteristic> getNewRowKey() {
        return newRowKey;
    }

    public JMenuItem getRemoveCaracteristicMenu() {
        return removeCaracteristicMenu;
    }

    public JButton getSaveButton() {
        return saveButton;
    }

    public JPopupMenu getTablePopup() {
        return tablePopup;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JPanel get$JPanel0() {
        return $JPanel0;
    }

    protected JScrollPane get$JScrollPane0() {
        return $JScrollPane0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToTablePopup() {
        if (!allComponentsCreated) {
            return;
        }
        tablePopup.add(removeCaracteristicMenu);
    }

    protected void createAddRow() {
        $objectMap.put("addRow", addRow = new JButton());
        
        addRow.setName("addRow");
        addRow.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__addRow"));
    }

    protected void createCancelButton() {
        $objectMap.put("cancelButton", cancelButton = new JButton());
        
        cancelButton.setName("cancelButton");
        cancelButton.setText(t("tutti.editIndividualObservationCaracteristics.action.cancel"));
        cancelButton.setToolTipText(t("tutti.editIndividualObservationCaracteristics.action.cancel.tip"));
        cancelButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__cancelButton"));
        cancelButton.putClientProperty("help", "tutti.editIndividualObservationCaracteristics.action.cancel.help");
    }

    protected void createGearCaracteristicsEditorTable() {
        $objectMap.put("gearCaracteristicsEditorTable", gearCaracteristicsEditorTable = new JXTable());
        
        gearCaracteristicsEditorTable.setName("gearCaracteristicsEditorTable");
        gearCaracteristicsEditorTable.setSortable(false);
        gearCaracteristicsEditorTable.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyPressed", this, "doKeyPressed__on__gearCaracteristicsEditorTable"));
        gearCaracteristicsEditorTable.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseClicked", this, "doMouseClicked__on__gearCaracteristicsEditorTable"));
    }

    protected void createModel() {
        $objectMap.put("model", model = getContextValue(GearCaracteristicsEditorUIModel.class));
    }

    protected void createNewRowKey() {
        $objectMap.put("newRowKey", newRowKey = new BeanFilterableComboBox<Caracteristic>(this));
        
        newRowKey.setName("newRowKey");
        newRowKey.setProperty("selectedCaracteristic");
        newRowKey.setShowReset(true);
    }

    protected void createRemoveCaracteristicMenu() {
        $objectMap.put("removeCaracteristicMenu", removeCaracteristicMenu = new JMenuItem());
        
        removeCaracteristicMenu.setName("removeCaracteristicMenu");
        removeCaracteristicMenu.setText(t("tutti.editIndividualObservationCaracteristics.action.removeCaracteristic"));
        removeCaracteristicMenu.setToolTipText(t("tutti.editIndividualObservationCaracteristics.action.removeCaracteristic.tip"));
        removeCaracteristicMenu.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__removeCaracteristicMenu"));
    }

    protected void createSaveButton() {
        $objectMap.put("saveButton", saveButton = new JButton());
        
        saveButton.setName("saveButton");
        saveButton.setText(t("tutti.editIndividualObservationCaracteristics.action.save"));
        saveButton.setToolTipText(t("tutti.editIndividualObservationCaracteristics.action.save.tip"));
        saveButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__saveButton"));
        saveButton.putClientProperty("help", "tutti.editIndividualObservationCaracteristics.action.save.help");
    }

    protected void createTablePopup() {
        $objectMap.put("tablePopup", tablePopup = new JPopupMenu());
        
        tablePopup.setName("tablePopup");
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        // inline complete setup of $Table0
        add(newRowKey, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        add(addRow, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        add($JScrollPane0, new GridBagConstraints(0, 1, 2, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        add($JPanel0, new GridBagConstraints(0, 2, 2, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        addChildrenToTablePopup();
        // inline complete setup of $JScrollPane0
        $JScrollPane0.getViewport().add(gearCaracteristicsEditorTable);
        // inline complete setup of $JPanel0
        $JPanel0.add(cancelButton);
        $JPanel0.add(saveButton);
        
        // apply 7 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 12 property setters
        newRowKey.setBeanType(Caracteristic.class);
        removeCaracteristicMenu.setIcon(SwingUtil.createActionIcon("batch-delete"));
        removeCaracteristicMenu.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.editIndividualObservationCaracteristics.action.removeCaracteristic.mnemonic"),'Z'));
        addRow.setIcon(SwingUtil.createActionIcon("add"));
        gearCaracteristicsEditorTable.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
        gearCaracteristicsEditorTable.setSelectionForeground(Color.BLACK);
        gearCaracteristicsEditorTable.setSelectionBackground(null);
        cancelButton.setIcon(SwingUtil.createActionIcon("cancel"));
        cancelButton.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.editIndividualObservationCaracteristics.action.cancel.mnemonic"),'Z'));
        saveButton.setIcon(SwingUtil.createActionIcon("save"));
        saveButton.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.editIndividualObservationCaracteristics.action.save.mnemonic"),'Z'));
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        handler.beforeInit(this);
        $objectMap.put("$Table0", $Table0);
        createModel();
        createTablePopup();
        createRemoveCaracteristicMenu();
        createNewRowKey();
        createAddRow();
        // inline creation of $JScrollPane0
        $objectMap.put("$JScrollPane0", $JScrollPane0 = new JScrollPane());
        
        $JScrollPane0.setName("$JScrollPane0");
        createGearCaracteristicsEditorTable();
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new JPanel());
        
        $JPanel0.setName("$JPanel0");
        $JPanel0.setLayout(new GridLayout(1, 0));
        createCancelButton();
        createSaveButton();
        // inline creation of $Table0
        setName("$Table0");
        
        // registers 7 data bindings
        $registerDefaultBindings();
        $completeSetup();
        handler.afterInit(this);
    }

    private void $registerDefaultBindings() {
        // register 7 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_REMOVE_CARACTERISTIC_MENU_ENABLED, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("editable", this);
                }
                if (model != null) {
                    model.addPropertyChangeListener("removeCaracteristicEnabled", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    removeCaracteristicMenu.setEnabled(model.isEditable() && model.isRemoveCaracteristicEnabled());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("editable", this);
                }
                if (model != null) {
                    model.removePropertyChangeListener("removeCaracteristicEnabled", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_NEW_ROW_KEY_ENABLED, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("editable", this);
                }
                if (newRowKey != null) {
                    newRowKey.addPropertyChangeListener("empty", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null && newRowKey != null) {
                    newRowKey.setEnabled(model.isEditable() && !newRowKey.isEmpty());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("editable", this);
                }
                if (newRowKey != null) {
                    newRowKey.removePropertyChangeListener("empty", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_NEW_ROW_KEY_VISIBLE, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("editable", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    newRowKey.setVisible(model.isEditable());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("editable", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_ADD_ROW_ENABLED, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("editable", this);
                }
                if (newRowKey != null) {
                    newRowKey.addPropertyChangeListener("selectedItem", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null && newRowKey != null) {
                    addRow.setEnabled(model.isEditable() && newRowKey.getSelectedItem() != null);
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("editable", this);
                }
                if (newRowKey != null) {
                    newRowKey.removePropertyChangeListener("selectedItem", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_ADD_ROW_VISIBLE, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("editable", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    addRow.setVisible(model.isEditable());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("editable", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_GEAR_CARACTERISTICS_EDITOR_TABLE_EDITABLE, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("editable", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    gearCaracteristicsEditorTable.setEditable(model.isEditable());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("editable", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SAVE_BUTTON_ENABLED, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("editable", this);
                }
                if (model != null) {
                    model.addPropertyChangeListener("valid", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    saveButton.setEnabled(model.isEditable() && model.isValid());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("editable", this);
                }
                if (model != null) {
                    model.removePropertyChangeListener("valid", this);
                }
            }
        });
    }

}