/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.service.bigfin;

import fr.ifremer.adagio.core.dao.referential.pmfm.PmfmId;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.persistence.entities.referential.Speciess;
import fr.ifremer.tutti.service.TuttiCsvUtil;
import fr.ifremer.tutti.service.bigfin.BigfinDataRow;
import fr.ifremer.tutti.service.bigfin.Signs;
import java.text.ParseException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.nuiton.csv.Common;
import org.nuiton.csv.ValueParser;

public class BigfinDataRowModel
extends TuttiCsvUtil.AbstractTuttiImportModel<BigfinDataRow> {
    public BigfinDataRowModel(char separator, final Map<String, Species> speciesBySurveyCode) {
        super(separator);
        final HashMap foundSpecies = new HashMap();
        this.newMandatoryColumn("Record_id", "recordId");
        this.newMandatoryColumn("length(mm)", "length", (ValueParser)Common.PRIMITIVE_FLOAT);
        this.newMandatoryColumn("weight(g)", "weight", (ValueParser)Common.FLOAT);
        this.newMandatoryColumn("species", "species", (ValueParser)new ValueParser<Object>(){

            public Object parse(String value) throws ParseException {
                Species result = null;
                if (StringUtils.isNotBlank((CharSequence)value)) {
                    result = (Species)foundSpecies.get(value);
                    if (result == null) {
                        result = (Species)speciesBySurveyCode.get(value);
                    }
                    if (result == null) {
                        String alternativeSpeciesCode = value.substring(0, 4) + '-' + value.substring(4);
                        result = (Species)speciesBySurveyCode.get(alternativeSpeciesCode);
                    }
                    foundSpecies.put(value, result);
                }
                if (result == null) {
                    result = Speciess.newSpecies();
                    result.setExternalCode(value);
                }
                return result;
            }
        });
        this.newMandatoryColumn("station", "station", (ValueParser)Common.INTEGER);
        this.newMandatoryColumn("Dt", "dt", (ValueParser)new Common.DateValue("MM/dd/yy HH:mm"));
        this.newMandatoryColumn("sz class", "szClass", (ValueParser)new ValueParser<Signs>(){

            public Signs parse(String value) throws ParseException {
                Signs result = Signs.getSign(value.toUpperCase(), PmfmId.SIZE_CATEGORY.getValue());
                return result;
            }
        });
        this.newMandatoryColumn("gender", "gender", (ValueParser)new ValueParser<Signs>(){

            public Signs parse(String value) throws ParseException {
                Signs result = Signs.getSign(value.toUpperCase(), PmfmId.SEX.getValue());
                if (result == null) {
                    throw new ParseException("Could not parse Sign value: " + value, 0);
                }
                return result;
            }
        });
        this.newMandatoryColumn("text", "vracHorsVrac", (ValueParser)new ValueParser<Signs>(){

            public Signs parse(String value) throws ParseException {
                Signs result = Signs.getSign(value.toUpperCase(), PmfmId.SORTED_UNSORTED.getValue());
                if (result == null) {
                    result = Signs.VRAC;
                }
                return result;
            }
        });
        this.newIgnoredColumn("cruise");
        this.newIgnoredColumn("pan");
    }

    public BigfinDataRow newEmptyInstance() {
        return new BigfinDataRow();
    }
}

