/*
 * Decompiled with CFR 0.152.
 */
package jaxx.runtime.swing.table.filter;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumnModel;
import jaxx.runtime.swing.JAXXWidgetUtil;
import jaxx.runtime.swing.JSearchTextField;
import jaxx.runtime.swing.list.CheckListModel;
import jaxx.runtime.swing.list.filter.CheckListFilterType;
import jaxx.runtime.swing.list.filter.DefaultFilterableCheckListModel;
import jaxx.runtime.swing.list.filter.FilterableActionCheckListModel;
import jaxx.runtime.swing.list.filter.FilterableCheckList;
import jaxx.runtime.swing.table.filter.TableAwareCheckListRenderer;
import jaxx.runtime.swing.table.filter.TableFilter;
import org.apache.commons.collections4.CollectionUtils;
import org.nuiton.decorator.Decorator;
import org.nuiton.i18n.I18n;

class TableFilterColumnPopup
extends MouseAdapter {
    private boolean enabled = false;
    private final FilterableCheckList<Object> filterList = new FilterableCheckList();
    private final JSearchTextField searchField = new JSearchTextField();
    private final Map<Integer, ColumnAttrs> colAttrs = new HashMap<Integer, ColumnAttrs>();
    private int mColumnIndex = -1;
    private final TableFilter<?> filter;
    private boolean searchable;
    private Decorator<Object> decorator;
    private boolean actionsVisible = true;
    private boolean useTableRenderers = false;
    private final JPopupMenu menu;
    private Dimension defaultSize = new Dimension(100, 100);

    public TableFilterColumnPopup(TableFilter<?> filter) {
        this.menu = new ResizablePopupMenu(){
            private static final long serialVersionUID = 1L;

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                if (TableFilterColumnPopup.this.menu.getComponentCount() == 0) {
                    JComponent content = TableFilterColumnPopup.this.buildContent();
                    TableFilterColumnPopup.this.defaultSize = content.getPreferredSize();
                    TableFilterColumnPopup.this.menu.add(content);
                }
                TableFilterColumnPopup.this.beforeShow();
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                TableFilterColumnPopup.this.beforeHide();
            }
        };
        this.filter = filter;
        this.filterList.getList().setVisibleRowCount(8);
        this.setupTableHeader();
        ((Container)filter.getTable()).addPropertyChangeListener("tableHeader", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                TableFilterColumnPopup.this.setupTableHeader();
            }
        });
        ((Container)filter.getTable()).addPropertyChangeListener("model", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                TableFilterColumnPopup.this.colAttrs.clear();
            }
        });
        this.searchField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.perform(e);
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.perform(e);
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.perform(e);
            }

            private void perform(DocumentEvent e) {
                TableFilterColumnPopup.this.filterList.filter(TableFilterColumnPopup.this.searchField.getText(), (Decorator<Object>)TableFilterColumnPopup.this.decorator, CheckListFilterType.CONTAINS);
            }
        });
    }

    public final Dimension getDefaultSize() {
        return this.defaultSize;
    }

    public final Dimension getPreferredSize() {
        return this.menu.getPreferredSize();
    }

    public final void setPreferredSize(Dimension preferredSize) {
        this.menu.setPreferredSize(preferredSize);
    }

    public void show(Component invoker, int x, int y) {
        this.menu.show(invoker, x, y);
    }

    public void show(Component invoker, Point location) {
        this.show(invoker, location.x, location.y);
    }

    public final void hide() {
        this.menu.setVisible(false);
    }

    public void setSearchable(boolean searchable) {
        this.searchable = searchable;
    }

    public void searchDecorator(Decorator<Object> decorator) {
        this.decorator = decorator;
    }

    public void setActionsVisible(boolean actionsVisible) {
        this.actionsVisible = actionsVisible;
    }

    public void setUseTableRenderers(boolean reuseRenderers) {
        this.useTableRenderers = reuseRenderers;
    }

    private void setupTableHeader() {
        JTableHeader header = ((JTable)this.filter.getTable()).getTableHeader();
        if (header != null) {
            header.addMouseListener(this);
        }
    }

    protected JComponent buildContent() {
        JPanel owner = new JPanel(new BorderLayout(3, 3));
        owner.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        owner.setPreferredSize(new Dimension(250, 150));
        Box commands = new Box(2);
        JToolBar toolbar = new JToolBar();
        toolbar.setFloatable(false);
        toolbar.setOpaque(false);
        toolbar.add(new CommandAction(I18n.t((String)"jaxx.table.filter.popup.button.clearAll", (Object[])new Object[0]), JAXXWidgetUtil.createImageIcon((String)"funnel_delete.png")){

            @Override
            protected boolean perform() {
                return TableFilterColumnPopup.this.clearAllFilters();
            }
        });
        commands.add(toolbar);
        commands.add(Box.createHorizontalGlue());
        commands.add(new JButton(new CommandAction(I18n.t((String)"jaxx.table.filter.popup.button.apply", (Object[])new Object[0])){

            @Override
            protected boolean perform() {
                return TableFilterColumnPopup.this.applyColumnFilter();
            }
        }));
        commands.add(Box.createHorizontalStrut(5));
        commands.add(new JButton(new CommandAction(I18n.t((String)"jaxx.table.filter.popup.button.cancel", (Object[])new Object[0]))));
        commands.setBorder(BorderFactory.createEmptyBorder(3, 0, 3, 0));
        commands.setBackground(UIManager.getColor("Panel.background"));
        commands.setOpaque(true);
        if (this.searchable) {
            owner.add((Component)this.searchField, "North");
        }
        owner.add((Component)new JScrollPane(this.filterList.getList()), "Center");
        owner.add((Component)commands, "South");
        return owner;
    }

    private boolean applyColumnFilter() {
        Collection<Object> checked = this.filterList.getCheckedItems();
        CheckListModel model = this.filterList.getModel();
        model.filter("", this.decorator, CheckListFilterType.CONTAINS);
        this.filter.apply(this.mColumnIndex, checked);
        return true;
    }

    private boolean clearAllFilters() {
        this.filter.clear();
        return true;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (this.enabled && e.isPopupTrigger()) {
            this.showFilterPopup(e);
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (this.enabled && e.isPopupTrigger()) {
            this.showFilterPopup(e);
        }
    }

    private void showFilterPopup(MouseEvent e) {
        JTableHeader header = (JTableHeader)e.getSource();
        TableColumnModel colModel = ((JTable)this.filter.getTable()).getColumnModel();
        int vColumnIndex = colModel.getColumnIndexAtX(e.getX());
        if (vColumnIndex < 0) {
            return;
        }
        Rectangle headerRect = ((JTable)this.filter.getTable()).getTableHeader().getHeaderRect(vColumnIndex);
        if (vColumnIndex == 0) {
            headerRect.width -= 2;
        } else {
            headerRect.grow(-2, 0);
        }
        if (!headerRect.contains(e.getX(), e.getY())) {
            return;
        }
        this.mColumnIndex = ((JTable)this.filter.getTable()).convertColumnIndexToModel(vColumnIndex);
        this.setPreferredSize(this.getColumnAttrs((int)vColumnIndex).preferredSize);
        Collection<Object> distinctItems = this.filter.getDistinctColumnItems(this.mColumnIndex);
        if (distinctItems != null) {
            DefaultFilterableCheckListModel<Object> model = new DefaultFilterableCheckListModel<Object>(distinctItems);
            this.filterList.setModel(this.actionsVisible ? new FilterableActionCheckListModel<Object>(model) : model);
            Collection<Object> checked = this.filter.getFilterState(this.mColumnIndex);
            this.filterList.setCheckedItems(CollectionUtils.isEmpty(checked) ? distinctItems : checked);
            if (this.useTableRenderers) {
                this.filterList.getList().setCellRenderer(new TableAwareCheckListRenderer(this.decorator));
            }
            this.show(header, headerRect.x, header.getHeight());
        }
    }

    private ColumnAttrs getColumnAttrs(int column) {
        ColumnAttrs attrs = this.colAttrs.get(column);
        if (attrs == null) {
            attrs = new ColumnAttrs();
            this.colAttrs.put(column, attrs);
        }
        return attrs;
    }

    protected void beforeShow() {
        if (this.searchable) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    TableFilterColumnPopup.this.searchField.setText("");
                    TableFilterColumnPopup.this.searchField.requestFocusInWindow();
                }
            });
        }
    }

    public void beforeHide() {
        this.getColumnAttrs((int)this.mColumnIndex).preferredSize = this.getPreferredSize();
    }

    protected class PopupMenuResizer
    extends MouseAdapter {
        private final JPopupMenu menu;
        private static final int REZSIZE_SPOT_SIZE = 10;
        private Point mouseStart = new Point(Integer.MIN_VALUE, Integer.MIN_VALUE);
        private Dimension startSize;
        private boolean isResizing = false;

        public PopupMenuResizer(JPopupMenu menu) {
            this.menu = menu;
            this.menu.setLightWeightPopupEnabled(true);
            menu.addMouseListener(this);
            menu.addMouseMotionListener(this);
        }

        private boolean isInResizeSpot(Point point) {
            if (point == null) {
                return false;
            }
            Rectangle resizeSpot = new Rectangle(this.menu.getWidth() - 10, this.menu.getHeight() - 10, 10, 10);
            return resizeSpot.contains(point);
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            this.menu.setCursor(Cursor.getPredefinedCursor(this.isInResizeSpot(e.getPoint()) ? 5 : 0));
        }

        private Point toScreen(MouseEvent e) {
            Point p = e.getPoint();
            SwingUtilities.convertPointToScreen(p, e.getComponent());
            return p;
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.mouseStart = this.toScreen(e);
            this.startSize = this.menu.getSize();
            this.isResizing = this.isInResizeSpot(e.getPoint());
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.mouseStart = new Point(Integer.MIN_VALUE, Integer.MIN_VALUE);
            this.isResizing = false;
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (!this.isResizing) {
                return;
            }
            Point p = this.toScreen(e);
            int dx = p.x - this.mouseStart.x;
            int dy = p.y - this.mouseStart.y;
            Dimension minDim = this.menu.getMinimumSize();
            Dimension newDim = new Dimension(this.startSize.width + dx, this.startSize.height + dy);
            if (newDim.width >= minDim.width && newDim.height >= minDim.height) {
                this.menu.setPopupSize(newDim);
            }
        }
    }

    protected class ResizablePopupMenu
    extends JPopupMenu
    implements PopupMenuListener {
        private static final long serialVersionUID = 1L;
        private static final int DOT_SIZE = 2;
        private static final int DOT_START = 2;
        private static final int DOT_STEP = 4;

        public ResizablePopupMenu() {
            new PopupMenuResizer(this);
            this.addPopupMenuListener(this);
        }

        @Override
        public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
        }

        @Override
        public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
        }

        @Override
        public void popupMenuCanceled(PopupMenuEvent e) {
        }

        @Override
        public void paintChildren(Graphics g) {
            super.paintChildren(g);
            this.drawResizer(g);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void drawResizer(Graphics g) {
            int x = this.getWidth() - 2;
            int y = this.getHeight() - 2;
            Graphics g2 = g.create();
            try {
                int dy = 2;
                int j = 2;
                while (j > 0) {
                    int dx = 2;
                    int i = 0;
                    while (i < j) {
                        this.drawDot(g2, x - dx, y - dy);
                        ++i;
                        dx += 4;
                    }
                    --j;
                    dy += 4;
                }
            }
            finally {
                g2.dispose();
            }
        }

        private void drawDot(Graphics g, int x, int y) {
            g.setColor(Color.WHITE);
            g.fillRect(x, y, 2, 2);
            g.setColor(Color.LIGHT_GRAY);
            g.fillRect(x - 1, y - 1, 2, 2);
        }
    }

    protected class CommandAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public CommandAction(String name, Icon icon) {
            super(name, icon);
            if (icon != null) {
                this.putValue("ShortDescription", name);
                this.putValue("Name", null);
            }
        }

        public CommandAction(String name) {
            super(name);
        }

        @Override
        public final void actionPerformed(ActionEvent e) {
            if (this.perform()) {
                TableFilterColumnPopup.this.hide();
            }
        }

        protected boolean perform() {
            return true;
        }
    }

    static class ColumnAttrs {
        public Dimension preferredSize;

        ColumnAttrs() {
        }
    }
}

