/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.action;

import com.google.common.collect.Lists;
import fr.ifremer.tutti.persistence.entities.data.CatchBatch;
import fr.ifremer.tutti.persistence.entities.data.Cruise;
import fr.ifremer.tutti.persistence.entities.data.FishingOperation;
import fr.ifremer.tutti.service.catches.ValidateCruiseOperationsService;
import fr.ifremer.tutti.ui.swing.action.AbstractTuttiAction;
import fr.ifremer.tutti.ui.swing.content.cruise.ValidateCruiseUI;
import fr.ifremer.tutti.ui.swing.content.cruise.ValidateCruiseUIHandler;
import fr.ifremer.tutti.ui.swing.content.cruise.ValidateCruiseUIModel;
import fr.ifremer.tutti.ui.swing.content.operation.EditFishingOperationUIModel;
import fr.ifremer.tutti.ui.swing.content.operation.FishingOperationsUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.EditCatchesUIModel;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import org.nuiton.i18n.I18n;
import org.nuiton.validator.NuitonValidatorResult;

public class EditCruiseFishingOperationAction
extends AbstractTuttiAction<ValidateCruiseUIModel, ValidateCruiseUI, ValidateCruiseUIHandler> {
    private final ValidateCruiseOperationsService validationService;
    protected FishingOperation fishingOperation;
    protected final PropertyChangeListener editFishingOperationModelListener = new PropertyChangeListener(){
        protected final List<String> propertiesToIgnore = Lists.newArrayList((Object[])new String[]{"valid", "persisted"});

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            EditFishingOperationUIModel model = (EditFishingOperationUIModel)evt.getSource();
            if (!model.isLoadingData() && model.getFishingOperation() != null) {
                if ("modify".equals(evt.getPropertyName())) {
                    if (!model.isModify()) {
                        Cruise cruise = EditCruiseFishingOperationAction.this.getDataContext().reloadCruise();
                        ((ValidateCruiseUIModel)EditCruiseFishingOperationAction.this.getModel()).setCruise(cruise);
                    }
                } else if (!this.propertiesToIgnore.contains(evt.getPropertyName())) {
                    model.convertGearShootingCoordinatesToDD();
                    FishingOperation operation = (FishingOperation)model.toBean();
                    NuitonValidatorResult validationResult = EditCruiseFishingOperationAction.this.validationService.validateCruiseOperation(operation);
                    ValidateCruiseUIModel uiModel = (ValidateCruiseUIModel)EditCruiseFishingOperationAction.this.getModel();
                    uiModel.addValidatorResult(uiModel.getSelectedFishingOperation(), validationResult);
                    ((ValidateCruiseUIHandler)EditCruiseFishingOperationAction.this.getHandler()).updateCurrentOperationNode(validationResult);
                }
            }
        }
    };
    protected final PropertyChangeListener editCatchesModelListener = new PropertyChangeListener(){
        protected final List<String> propertiesToIgnore = Lists.newArrayList((Object[])new String[]{"valid", "catchTotalComputedWeight", "catchTotalSortedComputedWeight", "catchTotalUnsortedComputedWeight", "catchTotalRejectedComputedWeight", "speciesTotalComputedWeight", "speciesTotalSortedComputedWeight", "speciesTotalUnsortedComputedWeight", "speciesTotalSampleSortedComputedWeight", "speciesTotalInertComputedWeight", "speciesTotalLivingNotItemizedComputedWeight", "benthosTotalComputedWeight", "benthosTotalSortedComputedWeight", "benthosTotalUnsortedComputedWeight", "benthosTotalSampleSortedComputedWeight", "benthosTotalInertComputedWeight", "benthosTotalLivingNotItemizedComputedWeight"});

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            EditCatchesUIModel model = (EditCatchesUIModel)evt.getSource();
            if (!model.isLoadingData() && model.getFishingOperation() != null) {
                if ("modify".equals(evt.getPropertyName())) {
                    if (!model.isModify()) {
                        Cruise cruise = EditCruiseFishingOperationAction.this.getDataContext().reloadCruise();
                        ((ValidateCruiseUIModel)EditCruiseFishingOperationAction.this.getModel()).setCruise(cruise);
                    }
                } else if (!this.propertiesToIgnore.contains(evt.getPropertyName())) {
                    CatchBatch catchBatch = (CatchBatch)model.toBean();
                    NuitonValidatorResult validationResult = EditCruiseFishingOperationAction.this.validationService.validateCruiseOperation(catchBatch);
                    ValidateCruiseUIModel uiModel = (ValidateCruiseUIModel)EditCruiseFishingOperationAction.this.getModel();
                    uiModel.addValidatorResult(uiModel.getSelectedFishingOperation(), validationResult);
                    ((ValidateCruiseUIHandler)EditCruiseFishingOperationAction.this.getHandler()).updateCurrentOperationNode(validationResult);
                }
            }
        }
    };

    public EditCruiseFishingOperationAction(ValidateCruiseUIHandler handler) {
        super(handler, true);
        this.setActionDescription(I18n.t((String)"tutti.editFishingOperation.action.editFishingOperation.tip", (Object[])new Object[0]));
        this.validationService = this.getContext().getValidateCruiseOperationsService();
    }

    public void setFishingOperation(FishingOperation fishingOperation) {
        this.fishingOperation = fishingOperation;
    }

    public boolean prepareAction() throws Exception {
        FishingOperationsUI operationPanel = ((ValidateCruiseUI)this.getUI()).getOperationPanel();
        operationPanel.getFishingOperationTabContent().getModel().removePropertyChangeListener(this.editFishingOperationModelListener);
        operationPanel.getCatchesTabContent().getModel().removePropertyChangeListener(this.editCatchesModelListener);
        return super.prepareAction();
    }

    @Override
    public void doAction() throws Exception {
        ((ValidateCruiseUI)this.getUI()).getOperationPanel().getModel().setSelectedFishingOperation(this.fishingOperation);
    }

    public void postSuccessAction() {
        super.postSuccessAction();
        FishingOperationsUI operationPanel = ((ValidateCruiseUI)this.getUI()).getOperationPanel();
        operationPanel.getFishingOperationTabContent().getModel().addPropertyChangeListener(this.editFishingOperationModelListener);
        operationPanel.getCatchesTabContent().getModel().addPropertyChangeListener(this.editCatchesModelListener);
    }

    public void releaseAction() {
        super.releaseAction();
        this.fishingOperation = null;
    }
}

