/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.metadata;

import com.ibm.icu.util.ULocale;
import org.eclipse.birt.report.model.api.extension.IMessages;
import org.eclipse.birt.report.model.api.metadata.IArgumentInfo;
import org.eclipse.birt.report.model.api.metadata.IClassInfo;
import org.eclipse.birt.report.model.api.metadata.IElementDefn;
import org.eclipse.birt.report.model.api.scripts.IScriptableObjectClassInfo;
import org.eclipse.birt.report.model.api.scripts.ScriptableClassInfo;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.birt.report.model.i18n.ModelMessages;
import org.eclipse.birt.report.model.i18n.ThreadResources;
import org.eclipse.birt.report.model.metadata.PeerExtensionElementDefn;

public class ArgumentInfo
implements IArgumentInfo {
    protected IMessages messages;
    private String type;
    protected IClassInfo classType;
    protected String name = null;
    protected String displayNameKey = null;
    private IElementDefn elementDefn;

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDisplayName() {
        if (this.displayNameKey != null) {
            String displayName = null;
            if (this.messages == null) {
                displayName = ModelMessages.getMessage(this.displayNameKey);
            } else {
                ULocale locale = ThreadResources.getLocale();
                displayName = this.messages.getMessage(this.displayNameKey, locale);
            }
            if (displayName != null) {
                return displayName;
            }
        }
        return this.name;
    }

    public void setName(String theName) {
        this.name = theName;
    }

    @Override
    public String getDisplayNameKey() {
        return this.displayNameKey;
    }

    public void setDisplayNameKey(String id) {
        this.displayNameKey = id;
    }

    @Override
    public String getType() {
        return this.type;
    }

    void setElementDefn(IElementDefn elementDefn) {
        assert (elementDefn instanceof PeerExtensionElementDefn);
        this.elementDefn = elementDefn;
    }

    public void setClassType(IClassInfo classType) {
        this.classType = classType;
    }

    @Override
    public IClassInfo getClassType() {
        if (this.classType != null) {
            return this.classType;
        }
        IClassInfo tmpInfo = new ScriptableClassInfo().getClass(this.type);
        if (tmpInfo != null) {
            return tmpInfo;
        }
        if (this.elementDefn == null) {
            return null;
        }
        IScriptableObjectClassInfo factory = ((PeerExtensionElementDefn)this.elementDefn).getScriptableFactory();
        if (factory == null) {
            return null;
        }
        return factory.getScriptableClass(this.type);
    }

    public void setType(String type) {
        this.type = type;
    }

    public String toString() {
        if (!StringUtil.isBlank(this.getName())) {
            return this.getName();
        }
        return super.toString();
    }

    public void setMessages(IMessages messages) {
        this.messages = messages;
    }

    public IMessages getMessages() {
        return this.messages;
    }
}

