/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.css.engine;

import org.apache.batik.css.parser.Parser;
import org.eclipse.birt.report.engine.css.engine.BIRTPropertyManagerFactory;
import org.eclipse.birt.report.engine.css.engine.CSSContext;
import org.eclipse.birt.report.engine.css.engine.CSSEngine;
import org.eclipse.birt.report.engine.css.engine.SystemColorSupport;
import org.eclipse.birt.report.engine.css.engine.value.css.FontFamilyManager;
import org.w3c.dom.css.CSSValue;

public class BIRTCSSEngine
extends CSSEngine {
    public BIRTCSSEngine() {
        super((org.w3c.css.sac.Parser)new Parser(), new BIRTPropertyManagerFactory(), new BIRTContext());
    }

    static class BIRTContext
    implements CSSContext {
        BIRTContext() {
        }

        @Override
        public CSSValue getSystemColor(String ident) {
            return SystemColorSupport.getSystemColor(ident);
        }

        @Override
        public CSSValue getDefaultFontFamily() {
            return FontFamilyManager.DEFAULT_VALUE;
        }

        @Override
        public float getPixelUnitToMillimeter() {
            return 0.26458332f;
        }

        @Override
        public float getMediumFontSize() {
            return 12.0f;
        }

        @Override
        public float getLighterFontWeight(float f) {
            int weight = (int)((f + 50.0f) / 100.0f) * 100;
            switch (weight) {
                case 100: {
                    return 100.0f;
                }
                case 200: {
                    return 100.0f;
                }
                case 300: {
                    return 200.0f;
                }
                case 400: {
                    return 300.0f;
                }
                case 500: {
                    return 400.0f;
                }
                case 600: {
                    return 400.0f;
                }
                case 700: {
                    return 400.0f;
                }
                case 800: {
                    return 400.0f;
                }
                case 900: {
                    return 400.0f;
                }
            }
            throw new IllegalArgumentException("Bad Font Weight: " + f);
        }

        @Override
        public float getBolderFontWeight(float f) {
            int weight = (int)((f + 50.0f) / 100.0f) * 100;
            switch (weight) {
                case 100: {
                    return 600.0f;
                }
                case 200: {
                    return 600.0f;
                }
                case 300: {
                    return 600.0f;
                }
                case 400: {
                    return 600.0f;
                }
                case 500: {
                    return 600.0f;
                }
                case 600: {
                    return 700.0f;
                }
                case 700: {
                    return 800.0f;
                }
                case 800: {
                    return 900.0f;
                }
                case 900: {
                    return 900.0f;
                }
            }
            throw new IllegalArgumentException("Bad Font Weight: " + f);
        }
    }
}

