/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity;

import java.util.Properties;
import org.eclipse.datatools.connectivity.ConnectionProfileConstants;
import org.eclipse.datatools.connectivity.IConnection;
import org.eclipse.datatools.connectivity.IConnectionFactoryProvider;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.IServerVersionProvider;
import org.eclipse.datatools.connectivity.Version;
import org.eclipse.datatools.connectivity.internal.ConnectionProfile;
import org.eclipse.datatools.connectivity.internal.InternalProfileManager;

public abstract class VersionProviderConnection
implements IConnection,
IServerVersionProvider {
    private ConnectionProfile mProfile;
    private Class mFactoryClass;

    public VersionProviderConnection(IConnectionProfile profile, Class factoryClass) {
        this.mProfile = (ConnectionProfile)profile;
        this.mFactoryClass = factoryClass;
    }

    public IConnectionProfile getConnectionProfile() {
        return this.mProfile;
    }

    public Class getConnectionFactoryClass() {
        return this.mFactoryClass;
    }

    protected void updateVersionCache() {
        Properties props = this.mProfile.getProperties("org.eclipse.datatools.connectivity.versionInfo");
        boolean saveProps = this.updateTechnologyVersion(props);
        boolean bl = saveProps = this.updateServerVersion(props) || saveProps;
        if (saveProps) {
            this.mProfile.internalSetProperties("org.eclipse.datatools.connectivity.versionInfo", props);
            if (!InternalProfileManager.isTransientProfile(this.mProfile)) {
                InternalProfileManager.getInstance().saveChanges();
            }
        }
    }

    protected void clearVersionCache() {
        boolean saveProps = false;
        Properties props = this.mProfile.getProperties("org.eclipse.datatools.connectivity.versionInfo");
        IConnectionFactoryProvider icfp = this.mProfile.getProvider().getConnectionFactory("org.eclipse.datatools.connectivity.connectionFactory.pingFactory");
        String techRootKey = this.getTechnologyRootKey();
        if (techRootKey != null && techRootKey.length() > 0) {
            String techVersionKey = ConnectionProfileConstants.createTechnologyVersionKey(techRootKey);
            String techNameKey = ConnectionProfileConstants.createTechnologyNameKey(techRootKey);
            if (props.getProperty(techVersionKey, new String()).length() > 0) {
                props.remove(techVersionKey);
                saveProps = true;
            }
            if (props.getProperty(techNameKey, new String()).length() > 0) {
                props.remove(techNameKey);
                saveProps = true;
            }
        }
        if (icfp != null && icfp.getConnectionFactoryClass().equals(this.mFactoryClass)) {
            if (props.getProperty("server.version", new String()).length() > 0) {
                props.remove("server.version");
                saveProps = true;
            }
            if (props.getProperty("server.name", new String()).length() > 0) {
                props.remove("server.name");
                saveProps = true;
            }
        }
        if (saveProps) {
            this.mProfile.internalSetProperties("org.eclipse.datatools.connectivity.versionInfo", props);
        }
    }

    private boolean updateTechnologyVersion(Properties props) {
        boolean saveProps = false;
        String techRootKey = this.getTechnologyRootKey();
        if (techRootKey != null && techRootKey.length() > 0) {
            Version techVersion;
            String techVersionKey = ConnectionProfileConstants.createTechnologyVersionKey(techRootKey);
            String techNameKey = ConnectionProfileConstants.createTechnologyNameKey(techRootKey);
            String oldTechName = props.getProperty(techNameKey);
            String techName = this.getTechnologyName();
            Version oldTechVersion = Version.valueOf(props.getProperty(techVersionKey, new String()));
            if (!oldTechVersion.equals(techVersion = this.getTechnologyVersion())) {
                props.setProperty(techVersionKey, techVersion.toString());
                saveProps = true;
            }
            if (techName == null && oldTechName != null || techName != null && !techName.equals(oldTechName)) {
                if (techName == null) {
                    props.remove(techNameKey);
                } else {
                    props.setProperty(techNameKey, techName);
                }
                saveProps = true;
            }
        }
        return saveProps;
    }

    private boolean updateServerVersion(Properties props) {
        Version serverVersion;
        boolean saveProps = false;
        String oldServerName = props.getProperty("server.name");
        String serverName = this.getProviderName();
        Version oldServerVersion = Version.valueOf(props.getProperty("server.version", new String()));
        if (!oldServerVersion.equals(serverVersion = this.getProviderVersion())) {
            props.setProperty("server.version", serverVersion.toString());
            saveProps = true;
        }
        if (serverName == null && oldServerName != null || serverName != null && !serverName.equals(oldServerName)) {
            if (serverName == null) {
                props.remove("server.name");
            } else {
                props.setProperty("server.name", serverName);
            }
            saveProps = true;
        }
        return saveProps;
    }

    protected abstract String getTechnologyRootKey();
}

