/*
 * Decompiled with CFR 0.152.
 */
package liquibase.sqlgenerator.core;

import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import liquibase.database.Database;
import liquibase.database.structure.DatabaseObject;
import liquibase.database.typeconversion.TypeConverterFactory;
import liquibase.exception.LiquibaseException;
import liquibase.exception.ValidationErrors;
import liquibase.sql.Sql;
import liquibase.sql.UnparsedSql;
import liquibase.sqlgenerator.SqlGeneratorChain;
import liquibase.sqlgenerator.core.AbstractSqlGenerator;
import liquibase.sqlgenerator.core.InsertGenerator;
import liquibase.sqlgenerator.core.UpdateGenerator;
import liquibase.statement.core.InsertOrUpdateStatement;
import liquibase.statement.core.UpdateStatement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class InsertOrUpdateGenerator
extends AbstractSqlGenerator<InsertOrUpdateStatement> {
    protected abstract String getRecordCheck(InsertOrUpdateStatement var1, Database var2, String var3);

    protected abstract String getElse(Database var1);

    protected String getPostUpdateStatements() {
        return "";
    }

    @Override
    public int getPriority() {
        return 5;
    }

    @Override
    public ValidationErrors validate(InsertOrUpdateStatement statement, Database database, SqlGeneratorChain sqlGeneratorChain) {
        ValidationErrors validationErrors = new ValidationErrors();
        validationErrors.checkRequiredField("tableName", statement.getTableName());
        validationErrors.checkRequiredField("columns", statement.getColumnValues());
        validationErrors.checkRequiredField("primaryKey", statement.getPrimaryKey());
        return validationErrors;
    }

    protected String getWhereClause(InsertOrUpdateStatement insertOrUpdateStatement, Database database) {
        String[] pkColumns;
        StringBuffer where = new StringBuffer();
        for (String thisPkColumn : pkColumns = insertOrUpdateStatement.getPrimaryKey().split(",")) {
            where.append(database.escapeColumnName(insertOrUpdateStatement.getSchemaName(), insertOrUpdateStatement.getTableName(), thisPkColumn)).append(" = ");
            Object newValue = insertOrUpdateStatement.getColumnValues().get(thisPkColumn);
            if (newValue == null || newValue.toString().equals("NULL")) {
                where.append("NULL");
            } else if (newValue instanceof String && database.shouldQuoteValue((String)newValue)) {
                where.append("'").append(database.escapeStringForDatabase((String)newValue)).append("'");
            } else if (newValue instanceof Date) {
                where.append(database.getDateLiteral((Date)newValue));
            } else if (newValue instanceof Boolean) {
                if (((Boolean)newValue).booleanValue()) {
                    where.append(TypeConverterFactory.getInstance().findTypeConverter(database).getBooleanType().getTrueBooleanValue());
                } else {
                    where.append(TypeConverterFactory.getInstance().findTypeConverter(database).getBooleanType().getFalseBooleanValue());
                }
            } else {
                where.append(newValue);
            }
            where.append(" AND ");
        }
        where.delete(where.lastIndexOf(" AND "), where.lastIndexOf(" AND ") + " AND ".length());
        return where.toString();
    }

    protected String getInsertStatement(InsertOrUpdateStatement insertOrUpdateStatement, Database database, SqlGeneratorChain sqlGeneratorChain) {
        Sql[] insertSql;
        StringBuffer insertBuffer = new StringBuffer();
        InsertGenerator insert = new InsertGenerator();
        for (Sql s : insertSql = insert.generateSql(insertOrUpdateStatement, database, sqlGeneratorChain)) {
            insertBuffer.append(s.toSql());
            insertBuffer.append(";");
        }
        insertBuffer.append("\n");
        return insertBuffer.toString();
    }

    protected String getUpdateStatement(InsertOrUpdateStatement insertOrUpdateStatement, Database database, String whereClause, SqlGeneratorChain sqlGeneratorChain) throws LiquibaseException {
        Sql[] updateSql;
        StringBuffer updateSqlString = new StringBuffer();
        UpdateGenerator update = new UpdateGenerator();
        UpdateStatement updateStatement = new UpdateStatement(insertOrUpdateStatement.getSchemaName(), insertOrUpdateStatement.getTableName());
        updateStatement.setWhereClause(whereClause + ";\n");
        String[] pkFields = insertOrUpdateStatement.getPrimaryKey().split(",");
        HashSet<String> hashPkFields = new HashSet<String>(Arrays.asList(pkFields));
        for (String columnKey : insertOrUpdateStatement.getColumnValues().keySet()) {
            if (hashPkFields.contains(columnKey)) continue;
            updateStatement.addNewColumnValue(columnKey, insertOrUpdateStatement.getColumnValue(columnKey));
        }
        if (updateStatement.getNewColumnValues().isEmpty()) {
            throw new LiquibaseException("No fields to update in set clause");
        }
        for (Sql s : updateSql = update.generateSql(updateStatement, database, sqlGeneratorChain)) {
            updateSqlString.append(s.toSql());
            updateSqlString.append(";");
        }
        updateSqlString.deleteCharAt(updateSqlString.lastIndexOf(";"));
        updateSqlString.append("\n");
        return updateSqlString.toString();
    }

    @Override
    public Sql[] generateSql(InsertOrUpdateStatement insertOrUpdateStatement, Database database, SqlGeneratorChain sqlGeneratorChain) {
        StringBuffer completeSql = new StringBuffer();
        String whereClause = this.getWhereClause(insertOrUpdateStatement, database);
        completeSql.append(this.getRecordCheck(insertOrUpdateStatement, database, whereClause));
        completeSql.append(this.getInsertStatement(insertOrUpdateStatement, database, sqlGeneratorChain));
        try {
            String updateStatement = this.getUpdateStatement(insertOrUpdateStatement, database, whereClause, sqlGeneratorChain);
            completeSql.append(this.getElse(database));
            completeSql.append(updateStatement);
        }
        catch (LiquibaseException e) {
            // empty catch block
        }
        completeSql.append(this.getPostUpdateStatements());
        return new Sql[]{new UnparsedSql(completeSql.toString(), new DatabaseObject[0])};
    }
}

