/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.api.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.birt.core.data.ExpressionUtil;
import org.eclipse.birt.core.data.IDimLevel;
import org.eclipse.birt.core.exception.CoreException;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ErrorDetail;
import org.eclipse.birt.report.model.api.Expression;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.core.IDesignElement;
import org.eclipse.birt.report.model.api.metadata.IElementDefn;
import org.eclipse.birt.report.model.api.metadata.IElementPropertyDefn;
import org.eclipse.birt.report.model.api.util.IElementCopy;
import org.eclipse.birt.report.model.api.util.IPasteStatus;
import org.eclipse.birt.report.model.core.ContainerContext;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.elements.olap.Cube;
import org.eclipse.birt.report.model.elements.olap.Dimension;
import org.eclipse.birt.report.model.elements.olap.Level;
import org.eclipse.birt.report.model.elements.olap.Measure;
import org.eclipse.birt.report.model.metadata.ElementPropertyDefn;
import org.eclipse.birt.report.model.util.ContentExceptionFactory;
import org.eclipse.birt.report.model.util.LevelContentIterator;
import org.eclipse.birt.report.model.util.copy.ContextCopyPastePolicy;
import org.eclipse.birt.report.model.util.copy.PasteStatus;

public class CopyUtil {
    private static ContextCopyPastePolicy copyPastePolicy = new ContextCopyPastePolicy();

    public static IElementCopy copy(DesignElementHandle source) {
        return copyPastePolicy.createCopy(source.getElement(), source.getModule());
    }

    public static List paste(IElementCopy copy, DesignElementHandle container, int slotID) throws SemanticException {
        ContainerContext context = new ContainerContext(container.getElement(), slotID);
        Module root = container.getModule();
        if (!CopyUtil.canPaste(copy, container, slotID).canPaste()) {
            throw ContentExceptionFactory.createContentException(context, "Error.ContentException.CONTENT_NOT_ALLOWED_PASTED");
        }
        IDesignElement chosen = copyPastePolicy.preWorkForPaste(context, copy, root);
        if (chosen == null) {
            return Collections.EMPTY_LIST;
        }
        DesignElementHandle target = chosen.getHandle(root);
        List<String> oldNames = null;
        DesignElement targetElement = target.getElement();
        if (targetElement instanceof Cube) {
            oldNames = CopyUtil.collectOLAPNames(root, (Cube)targetElement);
        }
        container.getModuleHandle().rename(container, target);
        if (targetElement instanceof Cube) {
            CopyUtil.updateCubeMeasure(root, (Cube)targetElement, oldNames);
        }
        container.getSlot(slotID).add(target);
        copyPastePolicy.copyPropertyBindings(copy, target);
        return CopyUtil.checkPostPasteErrors(target.getElement(), root);
    }

    private static void updateCubeMeasure(Module module, Cube newCube, List<String> oldNames) {
        List<String> newNames = CopyUtil.collectOLAPNames(module, newCube);
        Map<String, String> nameMap = CopyUtil.buildOLAPNameMap(oldNames, newNames);
        CopyUtil.updateDerivedMeasure(module, newCube, nameMap);
    }

    private static void updateDerivedMeasure(Module module, Cube cube, Map<String, String> nameMap) {
        ArrayList<Measure> derivedMeasureList = new ArrayList<Measure>();
        LevelContentIterator iter = new LevelContentIterator(module, cube, 3);
        while (iter.hasNext()) {
            Measure measure;
            DesignElement innerElement = iter.next();
            if (!(innerElement instanceof Measure) || !(measure = (Measure)innerElement).getBooleanProperty(module, "isCalculated")) continue;
            derivedMeasureList.add(measure);
        }
        if (!derivedMeasureList.isEmpty()) {
            for (Measure derivedMeasure : derivedMeasureList) {
                Expression expr = (Expression)derivedMeasure.getProperty(module, "measureExpression");
                Expression newExpr = CopyUtil.getUpdatedExpression(expr, nameMap);
                if (newExpr == null) continue;
                derivedMeasure.setProperty("measureExpression", (Object)newExpr);
            }
        }
    }

    private static Expression getUpdatedExpression(Expression old, Map<String, String> nameMap) {
        String type;
        if (old == null) {
            return null;
        }
        String expr = old.getStringExpression();
        Map<String, String> updateMap = CopyUtil.getUpdateBindingMap(expr, nameMap, type = old.getType());
        if (updateMap != null && !updateMap.isEmpty()) {
            String newExpr = expr;
            for (Map.Entry<String, String> entry : updateMap.entrySet()) {
                String oldName = entry.getKey();
                String newName = entry.getValue();
                newExpr = newExpr.replaceAll("(\\W)" + oldName + "(\\W)", "$1" + newName + "$2");
            }
            return new Expression(newExpr, old.getUserDefinedType());
        }
        return null;
    }

    private static Map<String, String> getUpdateBindingMap(String expr, Map<String, String> nameMap, String type) {
        HashMap<String, String> updateMap;
        block8: {
            updateMap = new HashMap<String, String>();
            if (!"javascript".equalsIgnoreCase(type)) break block8;
            Set<String> measureNameSet = null;
            try {
                measureNameSet = ExpressionUtil.getAllReferencedMeasures(expr);
            }
            catch (CoreException coreException) {}
            if (measureNameSet != null && !measureNameSet.isEmpty()) {
                for (String measureName : measureNameSet) {
                    String newName = nameMap.get(measureName);
                    if (newName == null) continue;
                    updateMap.put(measureName, newName);
                }
            } else {
                Set<IDimLevel> tmpSet = null;
                try {
                    tmpSet = ExpressionUtil.getReferencedDimLevel(expr);
                }
                catch (CoreException coreException) {
                    return null;
                }
                for (IDimLevel tmpObj : tmpSet) {
                    String oldName = tmpObj.getDimensionName();
                    String newName = nameMap.get(oldName);
                    if (newName == null || newName.equals(oldName)) continue;
                    updateMap.put(oldName, newName);
                }
            }
        }
        return updateMap;
    }

    private static Map<String, String> buildOLAPNameMap(List<String> oldNames, List<String> newNames) {
        HashMap<String, String> retMap = new HashMap<String, String>();
        int i = 0;
        while (i < oldNames.size()) {
            String oldName = oldNames.get(i);
            String newName = newNames.get(i);
            retMap.put(oldName, newName);
            ++i;
        }
        return retMap;
    }

    private static List<String> collectOLAPNames(Module module, DesignElement cube) {
        ArrayList<String> retMap = new ArrayList<String>();
        LevelContentIterator iter = new LevelContentIterator(module, cube, 3);
        while (iter.hasNext()) {
            DesignElement innerElement = iter.next();
            if (innerElement instanceof Dimension || innerElement instanceof Measure) {
                retMap.add(innerElement.getName());
                continue;
            }
            if (!(innerElement instanceof Level)) continue;
            retMap.add(((Level)innerElement).getFullName());
        }
        return retMap;
    }

    public static List paste(IElementCopy copy, DesignElementHandle container, int slotID, int newPos) throws SemanticException {
        ContainerContext context = new ContainerContext(container.getElement(), slotID);
        Module root = container.getModule();
        if (!CopyUtil.canPaste(copy, container, slotID).canPaste()) {
            throw ContentExceptionFactory.createContentException(context, "Error.ContentException.CONTENT_NOT_ALLOWED_PASTED");
        }
        IDesignElement chosen = copyPastePolicy.preWorkForPaste(context, copy, root);
        if (chosen == null) {
            return Collections.EMPTY_LIST;
        }
        DesignElementHandle target = chosen.getHandle(root);
        List<String> oldNames = null;
        DesignElement targetElement = target.getElement();
        if (targetElement instanceof Cube) {
            oldNames = CopyUtil.collectOLAPNames(root, (Cube)targetElement);
        }
        container.getModuleHandle().rename(container, target);
        if (targetElement instanceof Cube) {
            CopyUtil.updateCubeMeasure(root, (Cube)targetElement, oldNames);
        }
        container.getSlot(slotID).add(target, newPos);
        copyPastePolicy.copyPropertyBindings(copy, target);
        return CopyUtil.checkPostPasteErrors(target.getElement(), root);
    }

    public static List paste(IElementCopy copy, DesignElementHandle container, String propName) throws SemanticException {
        ContainerContext context = new ContainerContext(container.getElement(), propName);
        Module root = container.getModule();
        if (!CopyUtil.canPaste(copy, container, propName).canPaste()) {
            throw ContentExceptionFactory.createContentException(context, "Error.ContentException.CONTENT_NOT_ALLOWED_PASTED");
        }
        IDesignElement chosen = copyPastePolicy.preWorkForPaste(context, copy, root);
        if (chosen == null) {
            return Collections.EMPTY_LIST;
        }
        DesignElementHandle target = chosen.getHandle(root);
        List<String> oldNames = null;
        DesignElement targetElement = target.getElement();
        if (targetElement instanceof Cube) {
            oldNames = CopyUtil.collectOLAPNames(root, (Cube)targetElement);
        }
        container.getModuleHandle().rename(container, target);
        if (targetElement instanceof Cube) {
            CopyUtil.updateCubeMeasure(root, (Cube)targetElement, oldNames);
        }
        container.add(propName, target);
        copyPastePolicy.copyPropertyBindings(copy, target);
        return CopyUtil.checkPostPasteErrors(target.getElement(), root);
    }

    public static List paste(IElementCopy copy, DesignElementHandle container, String propName, int newPos) throws SemanticException {
        ContainerContext context = new ContainerContext(container.getElement(), propName);
        Module root = container.getModule();
        if (!CopyUtil.canPaste(copy, container, propName).canPaste()) {
            throw ContentExceptionFactory.createContentException(context, "Error.ContentException.CONTENT_NOT_ALLOWED_PASTED");
        }
        IDesignElement chosen = copyPastePolicy.preWorkForPaste(context, copy, root);
        if (chosen == null) {
            return Collections.EMPTY_LIST;
        }
        DesignElementHandle target = chosen.getHandle(root);
        List<String> oldNames = null;
        DesignElement targetElement = target.getElement();
        if (targetElement instanceof Cube) {
            oldNames = CopyUtil.collectOLAPNames(root, (Cube)targetElement);
        }
        container.getModuleHandle().rename(container, target);
        if (targetElement instanceof Cube) {
            CopyUtil.updateCubeMeasure(root, (Cube)targetElement, oldNames);
        }
        container.add(propName, target, newPos);
        copyPastePolicy.copyPropertyBindings(copy, target);
        return CopyUtil.checkPostPasteErrors(target.getElement(), root);
    }

    public static IPasteStatus canPaste(IElementCopy copy, DesignElementHandle container, int slotID) {
        int tmpIndex = container.getElement().getSlotIndex(slotID);
        if (tmpIndex == -1) {
            PasteStatus status = new PasteStatus();
            status.setPaste(false);
            return status;
        }
        return copyPastePolicy.isValidCopy(new ContainerContext(container.getElement(), slotID), container.getModule(), copy);
    }

    public static IPasteStatus canPaste(IElementCopy copy, DesignElementHandle container, String propName) {
        ElementPropertyDefn propDefn = (ElementPropertyDefn)container.getPropertyDefn(propName);
        if (propDefn == null || !propDefn.isElementType()) {
            PasteStatus status = new PasteStatus();
            status.setPaste(false);
            return status;
        }
        return copyPastePolicy.isValidCopy(new ContainerContext(container.getElement(), propName), container.getModule(), copy);
    }

    private static List checkPostPasteErrors(DesignElement content, Module root) {
        CopyUtil.revisePropertyNameSpace(root, content, content.getDefn().getProperty("extends"));
        CopyUtil.reviseNameSpace(root, content);
        List<Exception> exceptionList = content.validateWithContents(root);
        List<ErrorDetail> errorDetailList = ErrorDetail.convertExceptionList(exceptionList);
        return errorDetailList;
    }

    private static void reviseNameSpace(Module module, DesignElement content) {
        Iterator<String> propNames = content.propertyWithLocalValueIterator();
        IElementDefn defn = content.getDefn();
        while (propNames.hasNext()) {
            String propName = propNames.next();
            ElementPropertyDefn propDefn = (ElementPropertyDefn)defn.getProperty(propName);
            CopyUtil.revisePropertyNameSpace(module, content, propDefn);
        }
        LevelContentIterator iter = new LevelContentIterator(module, content, 1);
        while (iter.hasNext()) {
            DesignElement item = (DesignElement)iter.next();
            CopyUtil.reviseNameSpace(module, item);
        }
    }

    private static void revisePropertyNameSpace(Module module, DesignElement content, IElementPropertyDefn propDefn) {
        if (propDefn == null || content == null) {
            return;
        }
        if (propDefn.getTypeCode() != 15 && propDefn.getTypeCode() != 17) {
            return;
        }
        content.getLocalProperty(module, (ElementPropertyDefn)propDefn);
    }
}

