/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.script;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.core.script.JavascriptEvalUtil;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.impl.DataSetRuntime;
import org.eclipse.birt.data.engine.odi.IResultObject;
import org.eclipse.birt.data.engine.script.JSColumnDefn;
import org.eclipse.birt.data.engine.script.JSColumnMetaData;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public class JSRowObject
extends ScriptableObject {
    private static final String DATA_SET = "dataSet";
    private static final String COLUMN_MD = "columnDefns";
    public static final String ROW_POSITION = "_rowPosition";
    private DataSetRuntime dataSet;
    private JSColumnMetaData cachedColumnMetaData;
    private static Logger logger = Logger.getLogger(JSRowObject.class.getName());
    private static final long serialVersionUID = 6087456639367600994L;

    public JSRowObject(DataSetRuntime dataSet) {
        logger.entering(JSRowObject.class.getName(), "JSRowObject");
        this.dataSet = dataSet;
    }

    public String getClassName() {
        return "DataRow";
    }

    public Object[] getIds() {
        IResultObject obj = this.dataSet.getCurrentRow();
        int columnCount = 0;
        if (obj != null) {
            columnCount = obj.getResultClass().getFieldCount();
        }
        int count = 4 + 2 * columnCount;
        int next = 0;
        Object[] ids = new Object[count];
        ids[next++] = DATA_SET;
        ids[next++] = COLUMN_MD;
        ids[next++] = 0;
        ids[next++] = ROW_POSITION;
        if (columnCount > 0) {
            int i = 1;
            while (i <= columnCount) {
                ids[next++] = i;
                try {
                    ids[next++] = obj.getResultClass().getFieldName(i);
                }
                catch (DataException e) {
                    logger.logp(Level.FINER, JSColumnDefn.class.getName(), "getIds", e.getMessage(), e);
                }
                ++i;
            }
        }
        return ids;
    }

    public boolean has(int index, Scriptable start) {
        logger.entering(JSRowObject.class.getName(), "has", index);
        IResultObject obj = this.dataSet.getCurrentRow();
        if (index >= 0 && obj != null && index <= obj.getResultClass().getFieldCount()) {
            logger.exiting(JSRowObject.class.getName(), "has", true);
            return true;
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(JSRowObject.class.getName(), "has", super.has(index, start));
        }
        return super.has(index, start);
    }

    public boolean has(String name, Scriptable start) {
        logger.entering(JSRowObject.class.getName(), "has", name);
        if (name.equals(DATA_SET) || name.endsWith(COLUMN_MD) || name.equals(ROW_POSITION)) {
            logger.exiting(JSRowObject.class.getName(), "has", true);
            return true;
        }
        IResultObject obj = this.dataSet.getCurrentRow();
        if (obj != null && obj.getResultClass().getFieldIndex(name) >= 0) {
            logger.exiting(JSRowObject.class.getName(), "has", true);
            return true;
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(JSRowObject.class.getName(), "has", super.has(name, start));
        }
        return super.has(name, start);
    }

    public Object get(int index, Scriptable start) {
        logger.entering(JSRowObject.class.getName(), "get", index);
        try {
            Object value = this.dataSet.getDataRow().getColumnValue(index);
            return JavascriptEvalUtil.convertToJavascriptValue(value, this.dataSet.getSharedScope());
        }
        catch (BirtException e) {
            logger.logp(Level.FINER, JSColumnDefn.class.getName(), "get", e.getMessage(), e);
            logger.exiting(JSRowObject.class.getName(), "get", null);
            return null;
        }
    }

    public Object get(String name, Scriptable start) {
        block12: {
            logger.entering(JSRowObject.class.getName(), "get", name);
            if (name.equals(DATA_SET)) {
                if (logger.isLoggable(Level.FINER)) {
                    logger.exiting(JSRowObject.class.getName(), "get");
                }
                try {
                    return this.dataSet.getJSDataSetObject();
                }
                catch (DataException e) {
                    throw new RuntimeException(e.getLocalizedMessage(), e);
                }
            }
            if (name.equals(COLUMN_MD)) {
                if (logger.isLoggable(Level.FINER)) {
                    logger.exiting(JSRowObject.class.getName(), "get", this.getColumnMetadataScriptable());
                }
                return this.getColumnMetadataScriptable();
            }
            if (name.equals(ROW_POSITION)) {
                try {
                    return this.dataSet.getCurrentRowIndex();
                }
                catch (DataException e) {
                    logger.logp(Level.FINER, JSColumnDefn.class.getName(), "get", e.getMessage(), e);
                }
            }
            try {
                if (this.dataSet.getCurrentRow() != null) break block12;
                return null;
            }
            catch (BirtException e) {
                logger.logp(Level.FINER, JSColumnDefn.class.getName(), "get", e.getMessage(), e);
                throw Context.reportRuntimeError((String)e.getLocalizedMessage());
            }
        }
        Object value = this.dataSet.getDataRow().getColumnValue(name);
        return JavascriptEvalUtil.convertToJavascriptValue(value, this.dataSet.getSharedScope());
    }

    Scriptable getColumnMetadataScriptable() {
        IResultObject obj = this.dataSet.getCurrentRow();
        if (obj == null || obj.getResultClass() == null) {
            return null;
        }
        if (this.cachedColumnMetaData == null || this.cachedColumnMetaData.getResultClass() != obj.getResultClass()) {
            this.cachedColumnMetaData = new JSColumnMetaData(obj.getResultClass());
        }
        return this.cachedColumnMetaData;
    }

    public void put(String name, Scriptable start, Object value) {
        logger.entering(JSRowObject.class.getName(), "put", name);
        if (name.equals(DATA_SET) || name.equals(COLUMN_MD)) {
            return;
        }
        value = JavascriptEvalUtil.convertJavascriptValue(value);
        try {
            this.dataSet.getDataRow().setColumnValue(name, value);
        }
        catch (BirtException e) {
            logger.logp(Level.FINER, JSColumnDefn.class.getName(), "put", e.getMessage(), e);
        }
        logger.exiting(JSRowObject.class.getName(), "put");
    }

    public void put(int index, Scriptable start, Object value) {
        logger.entering(JSRowObject.class.getName(), "put", index);
        value = JavascriptEvalUtil.convertJavascriptValue(value);
        try {
            this.dataSet.getDataRow().setColumnValue(index, value);
        }
        catch (BirtException e) {
            logger.logp(Level.FINER, JSColumnDefn.class.getName(), "put", e.getMessage(), e);
        }
        logger.exiting(JSRowObject.class.getName(), "put");
    }
}

