/*
 * Decompiled with CFR 0.152.
 */
package liquibase.integration.commandline;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Enumeration;
import liquibase.resource.ResourceAccessor;
import liquibase.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandLineResourceAccessor
implements ResourceAccessor {
    private ClassLoader loader;

    public CommandLineResourceAccessor(ClassLoader loader) {
        this.loader = loader;
    }

    @Override
    public InputStream getResourceAsStream(String file) throws IOException {
        URL resource = this.loader.getResource(file);
        if (resource == null) {
            throw new IOException(file + " could not be found");
        }
        return resource.openStream();
    }

    @Override
    public Enumeration<URL> getResources(String packageName) throws IOException {
        return this.loader.getResources(packageName);
    }

    @Override
    public ClassLoader toClassLoader() {
        return this.loader;
    }

    public String toString() {
        String description;
        if (this.loader instanceof URLClassLoader) {
            ArrayList<String> urls = new ArrayList<String>();
            for (URL url : ((URLClassLoader)this.loader).getURLs()) {
                urls.add(url.toExternalForm());
            }
            description = StringUtils.join(urls, ",");
        } else {
            description = this.loader.getClass().getName();
        }
        return this.getClass().getName() + "(" + description + ")";
    }
}

