/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jaxx.application.swing.util;

import jaxx.runtime.swing.JAXXRuntimeException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.jaxx.application.ApplicationTechnicalException;
import org.nuiton.jaxx.application.swing.util.ApplicationErrorHelper;

public class ApplicationExceptionHandler
implements Thread.UncaughtExceptionHandler {
    private static final Log log = LogFactory.getLog(ApplicationExceptionHandler.class);
    final ApplicationErrorHelper errorHelper;

    public ApplicationExceptionHandler(ApplicationErrorHelper errorHelper) {
        this.errorHelper = errorHelper;
    }

    @Override
    public void uncaughtException(Thread t, Throwable ex) {
        this.handleException(t.getName(), ex);
    }

    public void handle(Throwable thrown) {
        this.handleException(Thread.currentThread().getName(), thrown);
    }

    protected void handleException(String tname, Throwable ex) {
        if (log.isErrorEnabled()) {
            log.error((Object)("Global application exception [" + tname + "]"), ex);
        }
        Throwable cause = this.getCause(ex);
        this.showErrorDialog(cause.getMessage(), cause);
    }

    protected Throwable getCause(Throwable ex) {
        Throwable cause = ex;
        if (cause instanceof ApplicationTechnicalException) {
            cause = cause.getCause();
        }
        if (cause instanceof JAXXRuntimeException) {
            cause = cause.getCause();
        }
        return cause;
    }

    public void showErrorDialog(String message, Throwable cause) {
        this.errorHelper.showErrorDialog(message, cause);
    }
}

