/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.referential.actions;

import fr.ifremer.tutti.persistence.entities.referential.Person;
import fr.ifremer.tutti.service.referential.ReferentialImportResult;
import fr.ifremer.tutti.service.referential.ReferentialTemporaryPersonService;
import fr.ifremer.tutti.ui.swing.content.referential.ManageTemporaryReferentialUIHandler;
import fr.ifremer.tutti.ui.swing.content.referential.ManageTemporaryReferentialUIModel;
import fr.ifremer.tutti.ui.swing.content.referential.actions.ImportTemporaryActionSupport;
import java.io.File;
import org.nuiton.i18n.I18n;

public class ImportTemporaryPersonAction
extends ImportTemporaryActionSupport<Person> {
    public ImportTemporaryPersonAction(ManageTemporaryReferentialUIHandler handler) {
        super(handler);
    }

    @Override
    protected File chooseImportFile() {
        File file = this.chooseFile(I18n.t((String)"tutti.manageTemporaryReferential.title.choose.importTemporaryPersonFile", (Object[])new Object[0]), I18n.t((String)"tutti.manageTemporaryReferential.action.chooseReferentialPersonFile.import", (Object[])new Object[0]), new String[]{"^.*\\.csv", I18n.t((String)"tutti.common.file.csv", (Object[])new Object[0])});
        return file;
    }

    @Override
    protected ReferentialImportResult<Person> doImport(File file) {
        ReferentialTemporaryPersonService service = this.getContext().getReferentialTemporaryPersonService();
        ReferentialImportResult importResult = service.importTemporaryPerson(file);
        return importResult;
    }

    @Override
    public void postSuccessAction(File file, ReferentialImportResult<Person> result) {
        int nbRef = ((ManageTemporaryReferentialUIModel)this.getModel()).getNbTemporaryPersons();
        ((ManageTemporaryReferentialUIModel)this.getModel()).setNbTemporaryPersons(nbRef + result.getNbRefAdded() - result.getNbRefDeleted());
        this.getDataContext().resetPersons();
        this.reloadCruise();
        this.reloadFishingOperation();
        ((ManageTemporaryReferentialUIHandler)this.getHandler()).resetExportPersonAction();
        String title = I18n.t((String)"tutti.manageTemporaryReferential.action.chooseReferentialPersonFile.import.dialog.title", (Object[])new Object[0]);
        String message = I18n.t((String)"tutti.manageTemporaryReferential.action.chooseReferentialPersonFile.import.dialog.message", (Object[])new Object[]{result.getNbRefAdded(), result.getNbRefUpdated(), result.getNbRefDeleted()});
        this.displayInfoMessage(title, message);
        this.sendMessage(I18n.t((String)"tutti.manageTemporaryReferential.action.chooseReferentialPersonFile.import.success", (Object[])new Object[]{file}));
    }
}

