/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.operation.catches.individualobservation.create;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import fr.ifremer.tutti.persistence.entities.TuttiEntities;
import fr.ifremer.tutti.persistence.entities.protocol.SpeciesProtocol;
import fr.ifremer.tutti.persistence.entities.referential.Caracteristic;
import fr.ifremer.tutti.persistence.entities.referential.CaracteristicQualitativeValue;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.ui.swing.content.operation.catches.EditCatchesUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.individualobservation.IndividualObservationBatchRowModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.individualobservation.IndividualObservationBatchUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.individualobservation.IndividualObservationBatchUIModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.individualobservation.create.CreateIndividualObservationBatchUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.individualobservation.create.CreateIndividualObservationBatchUIModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.SpeciesBatchUIModel;
import fr.ifremer.tutti.ui.swing.util.AbstractTuttiBeanUIModel;
import fr.ifremer.tutti.ui.swing.util.AbstractTuttiUIHandler;
import fr.ifremer.tutti.ui.swing.util.TuttiUI;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextField;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.swing.Table;
import jaxx.runtime.swing.editor.bean.BeanFilterableComboBox;
import jaxx.runtime.validator.swing.SwingValidator;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.decorator.Decorator;
import org.nuiton.jaxx.application.bean.JavaBeanObjectUtil;
import org.nuiton.jaxx.application.swing.ApplicationUI;
import org.nuiton.jaxx.application.swing.util.Cancelable;
import org.nuiton.jaxx.widgets.number.NumberEditor;
import org.nuiton.validator.bean.simple.SimpleBeanValidator;

public class CreateIndividualObservationBatchUIHandler
extends AbstractTuttiUIHandler<CreateIndividualObservationBatchUIModel, CreateIndividualObservationBatchUI>
implements Cancelable {
    private static final Log log = LogFactory.getLog(CreateIndividualObservationBatchUIHandler.class);

    public void beforeInit(CreateIndividualObservationBatchUI ui) {
        super.beforeInit((ApplicationUI)ui);
        List defaultCaracteristic = this.getDataContext().getDefaultIndividualObservationCaracteristics();
        CreateIndividualObservationBatchUIModel model = new CreateIndividualObservationBatchUIModel(defaultCaracteristic);
        ui.setContextValue(model);
        this.listModelIsModify(model);
    }

    public void afterInit(CreateIndividualObservationBatchUI ui) {
        this.initUI(ui);
        this.initBeanFilterableComboBox(ui.getIndividualObservationSpeciesComboBox(), Lists.newArrayList((Iterable)this.getDataContext().getReferentSpeciesWithSurveyCode()), null, "fromProtocol");
        List lengthStepCaracteristics = this.getDataContext().getLengthStepCaracteristics();
        this.initBeanFilterableComboBox(ui.getIndividualObservationLengthStepCaracteristicComboBox(), Lists.newArrayList((Iterable)lengthStepCaracteristics), null);
        final HashSet editorComponents = Sets.newHashSet();
        editorComponents.add(ui.getIndividualObservationWeightField());
        editorComponents.add(ui.getIndividualObservationSizeField());
        editorComponents.add(ui.getIndividualObservationLengthStepCaracteristicComboBox());
        if (this.getDataContext().isProtocolFilled()) {
            final Map speciesProtocolMap = this.getContext().getPersistenceService().toSpeciesProtocolMap();
            final Map lengthStepCaracteristicMap = TuttiEntities.splitById(lengthStepCaracteristics);
            ((CreateIndividualObservationBatchUIModel)this.getModel()).addPropertyChangeListener("species", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    SpeciesProtocol speciesProtocol;
                    Species species = (Species)evt.getNewValue();
                    if (species != null && (speciesProtocol = (SpeciesProtocol)speciesProtocolMap.get(species.getReferenceTaxonId())) != null) {
                        String lengthStepPmfmId = speciesProtocol.getLengthStepPmfmId();
                        Caracteristic lengthStepCaracteristic = (Caracteristic)lengthStepCaracteristicMap.get(lengthStepPmfmId);
                        ((CreateIndividualObservationBatchUIModel)CreateIndividualObservationBatchUIHandler.this.getModel()).setLengthStepCaracteristic(lengthStepCaracteristic);
                    }
                }
            });
            List caracteristics = this.getDataContext().getDefaultIndividualObservationCaracteristics();
            Table configurationPanel = ui.getConfigurationPanel();
            Decorator<Caracteristic> caracteristicDecorator = this.getDecorator(Caracteristic.class, "parameterOnlyWithUnit");
            Decorator<Caracteristic> caracteristicTipDecorator = this.getDecorator(Caracteristic.class, "withUnit");
            int index = 6;
            for (Caracteristic caracteristic : caracteristics) {
                final CreateIndividualObservationBatchUIModel.CaracteristicMapPropertyEditor editorModel = ((CreateIndividualObservationBatchUIModel)this.getModel()).newCaracteristicEditor(caracteristic);
                JTextField editor = null;
                switch (caracteristic.getCaracteristicType()) {
                    case NUMBER: {
                        final NumberEditor numberEditor = new NumberEditor((JAXXContext)ui);
                        String name = caracteristic.getId() + "CaracteristicField";
                        numberEditor.setName(name);
                        numberEditor.setProperty("property");
                        numberEditor.setShowReset(Boolean.valueOf(true));
                        numberEditor.setBean((Serializable)((Object)editorModel));
                        numberEditor.setAutoPopup(Boolean.valueOf(this.getConfig().isAutoPopupNumberEditor()));
                        numberEditor.setShowPopupButton(Boolean.valueOf(this.getConfig().isShowNumberEditorButton()));
                        numberEditor.setNumberType(Float.class);
                        numberEditor.setNumberPattern("\\d{0,6}(\\.\\d{0,3})?");
                        editorModel.addPropertyChangeListener("property", new PropertyChangeListener(){

                            @Override
                            public void propertyChange(PropertyChangeEvent evt) {
                                numberEditor.setNumberValue((Number)evt.getNewValue());
                            }
                        });
                        editor = numberEditor;
                        ui.get$objectMap().put(name, editor);
                        this.initNumberEditor(numberEditor);
                        break;
                    }
                    case QUALITATIVE: {
                        final BeanFilterableComboBox qualitativeValuesEditor = new BeanFilterableComboBox((JAXXContext)ui);
                        String name = caracteristic.getId() + "CaracteristicComboBox";
                        qualitativeValuesEditor.setName(name);
                        qualitativeValuesEditor.setI18nPrefix("tutti.property.");
                        qualitativeValuesEditor.setProperty("property");
                        qualitativeValuesEditor.setShowReset(Boolean.valueOf(true));
                        qualitativeValuesEditor.setBeanType(CaracteristicQualitativeValue.class);
                        qualitativeValuesEditor.setBean((Object)editorModel);
                        editorModel.addPropertyChangeListener("property", new PropertyChangeListener(){

                            @Override
                            public void propertyChange(PropertyChangeEvent evt) {
                                qualitativeValuesEditor.setSelectedItem(evt.getNewValue());
                            }
                        });
                        editor = qualitativeValuesEditor;
                        ui.get$objectMap().put(name, editor);
                        this.initBeanFilterableComboBox(qualitativeValuesEditor, Lists.newArrayList(caracteristic.getQualitativeValue()), null);
                        break;
                    }
                    case TEXT: {
                        final JTextField textField = new JTextField();
                        String name = caracteristic.getId() + "TextField";
                        editorModel.addPropertyChangeListener("property", new PropertyChangeListener(){

                            @Override
                            public void propertyChange(PropertyChangeEvent evt) {
                                textField.setText((String)evt.getNewValue());
                            }
                        });
                        textField.addKeyListener(new KeyAdapter(){

                            @Override
                            public void keyReleased(KeyEvent e) {
                                String value = textField.getText();
                                JavaBeanObjectUtil.setProperty((Object)((Object)editorModel), (String)"property", (Object)value);
                            }
                        });
                        editor = textField;
                        ui.get$objectMap().put(name, editor);
                        this.initTextField(textField);
                    }
                }
                editorComponents.add(editor);
                JLabel jLabel = new JLabel();
                jLabel.setText(caracteristicDecorator.toString((Object)caracteristic));
                jLabel.setToolTipText(caracteristicTipDecorator.toString((Object)caracteristic));
                jLabel.setLabelFor(editor);
                jLabel.putClientProperty("help", "tutti.createIndividualObservationBatch.field.defaultCaracteristic.help");
                ui.registerHelpId(ui.getBroker(), (Component)jLabel, "tutti.createIndividualObservationBatch.field.defaultCaracteristic.help");
                configurationPanel.add((Component)jLabel, (Object)new GridBagConstraints(0, index, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
                configurationPanel.add((Component)SwingUtil.boxComponentWithJxLayer((JComponent)editor), (Object)new GridBagConstraints(1, index, 2, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
                ++index;
            }
        }
        ((CreateIndividualObservationBatchUIModel)this.getModel()).addPropertyChangeListener("species", new PropertyChangeListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                CreateIndividualObservationBatchUIModel source = (CreateIndividualObservationBatchUIModel)evt.getSource();
                Species species = (Species)evt.getNewValue();
                source.setValueIsAdjusting(true);
                try {
                    boolean enabled;
                    if (species == null || !source.isSpeciesFromBatch()) {
                        source.setCreateFromBatch(false);
                    }
                    boolean bl = enabled = species != null && (!source.isCreateFromBatch() || !source.isSpeciesFromBatch());
                    if (log.isInfoEnabled()) {
                        log.info((Object)("can edit? " + enabled + " (species changed: " + species + ")"));
                    }
                    for (JComponent editorComponent : editorComponents) {
                        editorComponent.setEnabled(enabled);
                    }
                }
                finally {
                    source.setValueIsAdjusting(false);
                }
            }
        });
        ((CreateIndividualObservationBatchUIModel)this.getModel()).addPropertyChangeListener("createFromBatch", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                boolean enabled;
                CreateIndividualObservationBatchUIModel source = (CreateIndividualObservationBatchUIModel)evt.getSource();
                Boolean newValue = (Boolean)evt.getNewValue();
                newValue = newValue != null && newValue != false;
                boolean bl = enabled = newValue == false || !source.isSpeciesFromBatch();
                if (log.isInfoEnabled()) {
                    log.info((Object)("can edit? " + enabled + " (createFromBatch changed: " + newValue + ")"));
                }
                for (JComponent editorComponent : editorComponents) {
                    editorComponent.setEnabled(enabled);
                }
            }
        });
        this.listenValidatorValid((SimpleBeanValidator)this.getValidator(), (AbstractTuttiBeanUIModel)this.getModel());
    }

    protected JComponent getComponentToFocus() {
        return ((CreateIndividualObservationBatchUI)this.getUI()).getIndividualObservationSpeciesComboBox();
    }

    public void onCloseUI() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("closing: " + this.ui));
        }
        this.getValidator().setBean(null);
        ((CreateIndividualObservationBatchUIModel)this.getModel()).setValid(false);
        EditCatchesUI parent = (EditCatchesUI)this.getParentContainer(EditCatchesUI.class);
        parent.getHandler().setIndividualObservationSelectedCard("main");
    }

    public SwingValidator<CreateIndividualObservationBatchUIModel> getValidator() {
        return ((CreateIndividualObservationBatchUI)this.ui).getValidator();
    }

    public void cancel() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Cancel UI " + this.ui));
        }
        this.closeUI((TuttiUI)this.ui);
    }

    public void openUI(IndividualObservationBatchUIModel batchModel) {
        List speciesList;
        Map<Object, Object> batchesSpeciesList;
        CreateIndividualObservationBatchUIModel model = (CreateIndividualObservationBatchUIModel)this.getModel();
        this.getValidator().setBean((Object)model);
        model.reset();
        List speciesListWithSurveyCode = this.getDataContext().getReferentSpeciesWithSurveyCode();
        EditCatchesUI parent = (EditCatchesUI)this.getParentContainer(EditCatchesUI.class);
        SpeciesBatchUIModel speciesBatchUIModel = parent.getSpeciesTabContent().getModel();
        boolean withSpeciesBatch = CollectionUtils.isNotEmpty(speciesBatchUIModel.getRows());
        if (withSpeciesBatch) {
            batchesSpeciesList = speciesBatchUIModel.getSpeciesCount();
            HashSet speciesSet = Sets.newHashSet(batchesSpeciesList.keySet());
            List rows = batchModel.getRows();
            if (CollectionUtils.isNotEmpty(rows)) {
                for (IndividualObservationBatchRowModel row : rows) {
                    Species species = row.getSpecies();
                    speciesSet.add(species);
                }
            }
            speciesList = Lists.newArrayList((Iterable)speciesSet);
            if (log.isInfoEnabled()) {
                log.info((Object)("Use speciesBatch + individualObservation species : " + speciesList.size()));
            }
        } else {
            batchesSpeciesList = Maps.newHashMap();
            if (this.getDataContext().isProtocolFilled()) {
                speciesList = Lists.newArrayList((Iterable)speciesListWithSurveyCode);
                List rows = batchModel.getRows();
                if (CollectionUtils.isNotEmpty(rows)) {
                    for (IndividualObservationBatchRowModel row : rows) {
                        Species species = row.getSpecies();
                        if (speciesList.contains(species)) continue;
                        speciesList.add(species);
                    }
                }
                if (log.isInfoEnabled()) {
                    log.info((Object)("Use protocol + individualObservation species : " + speciesList.size()));
                }
            } else {
                speciesList = speciesListWithSurveyCode;
                if (log.isInfoEnabled()) {
                    log.info((Object)("Use all species : " + speciesList.size()));
                }
            }
        }
        model.setBatchSpecies(batchesSpeciesList);
        model.setAvailableSpecies(speciesList);
        Species lastSpeciesUsed = batchModel.getLastSpeciesUsed();
        model.setSpecies(lastSpeciesUsed);
        model.setLengthStepCaracteristic(batchModel.getLastLengthStepCaracteristicUsed());
    }

    public void saveAndContinue() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Save And Continue UI " + this.ui));
        }
        EditCatchesUI parent = (EditCatchesUI)this.getParentContainer(EditCatchesUI.class);
        IndividualObservationBatchUI individualObservationTabContent = parent.getIndividualObservationTabContent();
        individualObservationTabContent.getHandler().addBatch((CreateIndividualObservationBatchUIModel)this.getModel());
        this.openUI(individualObservationTabContent.getModel());
        ((CreateIndividualObservationBatchUI)this.ui).getIndividualObservationWeightField().grabFocus();
    }

    public void saveAndClose() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Save And Close UI " + this.ui));
        }
        EditCatchesUI parent = (EditCatchesUI)this.getParentContainer(EditCatchesUI.class);
        parent.getIndividualObservationTabContent().getHandler().addBatch((CreateIndividualObservationBatchUIModel)this.getModel());
        this.closeUI((TuttiUI)this.ui);
    }
}

