/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.service;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import fr.ifremer.tutti.persistence.entities.TuttiEntities;
import fr.ifremer.tutti.persistence.entities.TuttiEntity;
import fr.ifremer.tutti.persistence.entities.referential.Caracteristic;
import fr.ifremer.tutti.persistence.entities.referential.CaracteristicQualitativeValue;
import fr.ifremer.tutti.persistence.entities.referential.Gear;
import fr.ifremer.tutti.persistence.entities.referential.Person;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.persistence.entities.referential.Vessel;
import java.io.Serializable;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.beanutils.BeanUtilsBean;
import org.apache.commons.beanutils.NestedNullException;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang3.StringUtils;
import org.nuiton.csv.Common;
import org.nuiton.csv.ExportModel;
import org.nuiton.csv.ExportableColumn;
import org.nuiton.csv.ImportRuntimeException;
import org.nuiton.csv.ValueFormatter;
import org.nuiton.csv.ValueGetter;
import org.nuiton.csv.ValueParser;
import org.nuiton.csv.ValueParserFormatter;
import org.nuiton.csv.ext.AbstractExportModel;
import org.nuiton.csv.ext.AbstractImportExportModel;
import org.nuiton.csv.ext.AbstractImportModel;
import org.nuiton.csv.ext.RepeatableExport;
import org.nuiton.decorator.Decorator;
import org.nuiton.i18n.I18n;

public class TuttiCsvUtil
extends Common {
    public static final ValueParserFormatter<Float> FLOAT_NULL_TO_9 = new Common.FloatParserFormatter(Float.valueOf(-9.0f), true){

        public String format(Float value) {
            if (value == null) {
                value = (Float)this.defaultValue;
            }
            return super.format(value);
        }

        protected Float parseNoneEmptyValue(String value) {
            Float aFloat = super.parseNoneEmptyValue(value);
            if (((Float)this.defaultValue).equals(aFloat)) {
                aFloat = null;
            }
            return aFloat;
        }
    };
    public static final ValueFormatter<Caracteristic> CARACTERISTIC_ID_FORMATTER = new ValueFormatter<Caracteristic>(){

        public String format(Caracteristic value) {
            return value != null ? value.getId() : "";
        }
    };
    public static final ValueFormatter<Species> SPECIES_REFERENCE_TAXON_ID_FORMATTER = new ValueFormatter<Species>(){

        public String format(Species value) {
            return value != null ? String.valueOf(value.getReferenceTaxonId()) : null;
        }
    };
    public static final ValueFormatter<Serializable> CARACTERISTIC_VALUE_FORMATTER2 = new ValueFormatter<Serializable>(){

        public String format(Serializable value) {
            String result = "";
            if (value != null) {
                if (CaracteristicQualitativeValue.class.isAssignableFrom(value.getClass())) {
                    CaracteristicQualitativeValue cqv = (CaracteristicQualitativeValue)value;
                    result = cqv.getId();
                } else {
                    result = String.valueOf(value);
                }
            }
            return result;
        }
    };
    public static ValueFormatter<CaracteristicQualitativeValue> CARACTERISTIC_QUALITATIVE_VALUE_FORMATTER = new ValueFormatter<CaracteristicQualitativeValue>(){

        public String format(CaracteristicQualitativeValue value) {
            String result = "";
            if (value != null) {
                result = value.getId();
            }
            return result;
        }
    };
    public static ValueParserFormatter<Float> WEIGHT_PARSER_FORMATTER = new Common.FloatParserFormatter(null, true){

        public String format(Float value) {
            if (value != null) {
                value = Float.valueOf(TuttiEntities.roundKiloGram((float)value.floatValue()));
            }
            return super.format(value);
        }

        protected Float parseNoneEmptyValue(String value) {
            Float aFloat = super.parseNoneEmptyValue(value);
            float result = TuttiEntities.roundKiloGram((float)aFloat.floatValue());
            return Float.valueOf(result);
        }
    };
    public static final ValueParserFormatter<Date> YEAR = new Common.DateValue("yyyy");
    public static final ValueFormatter<Serializable> CARACTERISTIC_VALUE_FORMATTER = new CaracteristicValueFormatter();
    public static final ValueFormatter<Vessel> VESSEL_VALUE_FORMATTER = new VesselFormatter();
    public static final ValueFormatter<List<Person>> LIST_PERSON_FORMATTER = new ListPersonValueFormatter();
    public static final ValueParserFormatter<List<Integer>> LIST_INTEGER_PARSER_FORMATTER = new ListIntegerValueFormatter();
    public static final ValueFormatter<List<Gear>> LIST_GEAR_FORMATTER = new ListGearValueFormatter();

    public static ValueParserFormatter<String> newStringParserFormatter2(String defaultValue, boolean nullAllowed) {
        return new StringParserFormatter2(defaultValue, nullAllowed);
    }

    public static ListVesselValueFormatter newListVesselFormatter(Decorator<Vessel> decorator) {
        return new ListVesselValueFormatter(decorator);
    }

    public static <E> BeanPropertyFormatter<E> newBeanFormatter(String propertyName, String defaultNullValue) {
        return new BeanPropertyFormatter(propertyName, defaultNullValue);
    }

    public static <E> DecoratorPropertyFormatter<E> newDecoratorFormatter(Decorator<E> decorator, String defaultNullValue) {
        return new DecoratorPropertyFormatter<E>(decorator, defaultNullValue);
    }

    public static <E> TuttiRepeatableExport<E> newRepeatableExport(ExportModel<E> model) {
        return new TuttiRepeatableExport<E>(model);
    }

    public static <E extends Enum<E>> ValueParserFormatter<E> newEnumByNameParserFormatter(Class<E> enumType, boolean mandatory) {
        return new EnumByNameParserFormatter<E>(enumType, mandatory);
    }

    protected TuttiCsvUtil() {
    }

    public static abstract class ImportModelWithHeader<M>
    extends AbstractTuttiImportModel<M> {
        protected ImportModelWithHeader(char separator) {
            super(separator);
        }

        public abstract String[] getHeader();
    }

    protected static class ListVesselValueFormatter
    implements ValueFormatter<List<Vessel>> {
        final Decorator<Vessel> decorator;

        public ListVesselValueFormatter(Decorator<Vessel> decorator) {
            this.decorator = decorator;
        }

        public String format(List<Vessel> value) {
            List decoratedValues = Lists.transform(value, (Function)new Function<Vessel, String>(){

                public String apply(Vessel input) {
                    return ListVesselValueFormatter.this.decorator.toString((Object)input);
                }
            });
            return Joiner.on((char)'|').join((Iterable)decoratedValues);
        }
    }

    protected static class ListGearValueFormatter
    implements ValueFormatter<List<Gear>> {
        protected ListGearValueFormatter() {
        }

        public String format(List<Gear> value) {
            List decoratedValues = Lists.transform(value, (Function)new Function<Gear, String>(){

                public String apply(Gear input) {
                    return input.getName();
                }
            });
            return Joiner.on((char)'|').join((Iterable)decoratedValues);
        }
    }

    protected static class ListPersonValueFormatter
    implements ValueFormatter<List<Person>> {
        protected ListPersonValueFormatter() {
        }

        public String format(List<Person> value) {
            List decoratedValues = Lists.transform(value, (Function)new Function<Person, String>(){

                public String apply(Person input) {
                    return input.getFirstName() + ' ' + input.getLastName();
                }
            });
            return Joiner.on((char)'|').join((Iterable)decoratedValues);
        }
    }

    protected static class ListIntegerValueFormatter
    implements ValueParserFormatter<List<Integer>> {
        protected ListIntegerValueFormatter() {
        }

        public String format(List<Integer> value) {
            List decoratedValues = Lists.transform(value, (Function)new Function<Integer, String>(){

                public String apply(Integer input) {
                    return input.toString();
                }
            });
            return Joiner.on((char)'|').join((Iterable)decoratedValues);
        }

        public List<Integer> parse(String value) throws ParseException {
            ArrayList result = Lists.newArrayList();
            if (StringUtils.isNotBlank((CharSequence)value)) {
                String[] split;
                for (String string : split = value.split("\\s*\\|\\s*")) {
                    result.add(Integer.valueOf(string));
                }
            }
            return result;
        }
    }

    protected static class CaracteristicValueFormatter
    implements ValueFormatter<Serializable> {
        ValueParserFormatter<Integer> integerDelegate = Common.INTEGER;
        ValueParserFormatter<Float> floatDelegate = Common.FLOAT;
        ValueParserFormatter<String> textDelegate = Common.STRING;

        protected CaracteristicValueFormatter() {
        }

        public String format(Serializable value) {
            if (value == null) {
                return "NA";
            }
            if (value instanceof Float) {
                return this.floatDelegate.format((Object)((Float)value));
            }
            if (value instanceof Integer) {
                return this.integerDelegate.format((Object)((Integer)value));
            }
            if (value instanceof String) {
                return this.textDelegate.format((Object)((String)((Object)value)));
            }
            CaracteristicQualitativeValue qv = (CaracteristicQualitativeValue)value;
            String result = qv.getName();
            if (!result.equals(qv.getDescription())) {
                result = result + " - " + qv.getDescription();
            }
            return result;
        }
    }

    public static class EnumByNameParserFormatter<E extends Enum<E>>
    implements ValueParserFormatter<E> {
        private final Class<E> enumType;
        private final boolean mandatory;

        public EnumByNameParserFormatter(Class<E> enumType, boolean mandatory) {
            this.enumType = enumType;
            this.mandatory = mandatory;
        }

        public E parse(String value) throws ParseException {
            E result = StringUtils.isBlank((CharSequence)value) ? null : (E)Enum.valueOf(this.enumType, value);
            if (this.mandatory && result == null) {
                throw new NullPointerException(I18n._((String)"tutti.service.cvs.mandatory.value", (Object[])new Object[0]));
            }
            return result;
        }

        public String format(E date) {
            String value = "";
            if (date != null) {
                value = ((Enum)date).name();
            }
            return value;
        }
    }

    public static class TuttiRepeatableExport<E>
    extends RepeatableExport<E> {
        public TuttiRepeatableExport(ExportModel<E> model) {
            super(model, Collections.emptyList(), true);
        }

        public void write(Iterable<E> data, Writer writer) throws Exception {
            this.data = data;
            this.write(writer);
        }
    }

    public static class DecoratorPropertyFormatter<E>
    implements ValueFormatter<E> {
        protected final String defaultNullValue;
        protected Decorator<E> decorator;

        DecoratorPropertyFormatter(Decorator<E> decorator, String defaultNullValue) {
            this.decorator = decorator;
            this.defaultNullValue = defaultNullValue;
        }

        public String format(E value) {
            if (value == null) {
                return this.defaultNullValue;
            }
            try {
                return this.decorator.toString(value);
            }
            catch (Exception e) {
                throw new ImportRuntimeException(I18n._((String)"tutti.service.cvs.format.error", (Object[])new Object[]{value}), (Throwable)e);
            }
        }
    }

    public static class BeanPropertyFormatter<E>
    implements ValueFormatter<E> {
        protected final String defaultNullValue;
        protected String propertyName;

        BeanPropertyFormatter(String propertyName, String defaultNullValue) {
            this.propertyName = propertyName;
            this.defaultNullValue = defaultNullValue;
        }

        public String format(E value) {
            if (value == null) {
                return this.defaultNullValue;
            }
            try {
                return (String)BeanUtilsBean.getInstance().getPropertyUtils().getNestedProperty(value, this.propertyName);
            }
            catch (Exception e) {
                throw new ImportRuntimeException(I18n._((String)"tutti.service.cvs.format.error", (Object[])new Object[0]), (Throwable)e);
            }
        }
    }

    public static class NotExistingKeyValue
    implements ValueParserFormatter<String> {
        protected final String propertyName;
        protected final Set<String> existingValues;
        protected final String errorMessage;

        public NotExistingKeyValue(String propertyName, Set<String> universe) {
            this(propertyName, universe, "tutti.service.csv.parse.entityAlreadyDefined");
        }

        public NotExistingKeyValue(String propertyName, Set<String> universe, String errorMessage) {
            this.propertyName = propertyName;
            this.existingValues = universe;
            this.errorMessage = errorMessage;
        }

        public String parse(String value) throws ParseException {
            if (StringUtils.isNotBlank((CharSequence)value) && this.existingValues.contains(value)) {
                throw new ImportRuntimeException(I18n._((String)this.errorMessage, (Object[])new Object[]{this.propertyName, value}));
            }
            return value;
        }

        public String format(String e) {
            return e;
        }
    }

    public static class BeanIndexNullableGetter<E, T>
    implements ValueGetter<E, T> {
        protected String collectionName;
        protected int order;
        protected String propertyName;

        BeanIndexNullableGetter(String collectionName, int order, String suffix) {
            this.collectionName = collectionName;
            this.order = order;
            this.propertyName = collectionName + "[" + order + "]." + suffix;
        }

        public T get(E object) throws Exception {
            Object value = null;
            try {
                Collection c = (Collection)PropertyUtils.getProperty(object, (String)this.collectionName);
                if (c != null && this.order < c.size()) {
                    value = PropertyUtils.getProperty(object, (String)this.propertyName);
                }
            }
            catch (NestedNullException e) {
                value = null;
            }
            catch (InvocationTargetException e) {
                if (e.getCause() instanceof NullPointerException) {
                    value = null;
                }
                throw e;
            }
            return (T)value;
        }
    }

    public static class BeanNullableGetter<E, T>
    implements ValueGetter<E, T> {
        protected String propertyName;

        BeanNullableGetter(String propertyName) {
            this.propertyName = propertyName;
        }

        public T get(E object) throws Exception {
            Object value;
            try {
                value = PropertyUtils.getProperty(object, (String)this.propertyName);
            }
            catch (NestedNullException e) {
                value = null;
            }
            catch (InvocationTargetException e) {
                if (e.getCause() instanceof NullPointerException) {
                    value = null;
                }
                throw e;
            }
            return (T)value;
        }
    }

    public static class ForeignKeyValue<E extends TuttiEntity>
    implements ValueParserFormatter<E> {
        protected final String propertyName;
        protected final Class<E> entityType;
        protected final Map<String, E> universe;

        public ForeignKeyValue(Class<E> entityType, String propertyName, Map<String, E> universe) {
            this.entityType = entityType;
            this.propertyName = propertyName;
            this.universe = universe;
        }

        public E parse(String value) throws ParseException {
            TuttiEntity result = null;
            if (StringUtils.isNotBlank((CharSequence)value) && (result = (TuttiEntity)this.universe.get(value)) == null) {
                throw new ImportRuntimeException(I18n._((String)"tutti.service.csv.parse.entityNotFound", (Object[])new Object[]{this.entityType.getSimpleName(), this.propertyName, value}));
            }
            return (E)result;
        }

        public String format(E e) {
            String value = "";
            if (e != null) {
                value = e.getId();
            }
            return value;
        }
    }

    public static class VesselFormatter
    implements ValueFormatter<Vessel> {
        public String format(Vessel value) {
            String result = "";
            if (value != null && (result = value.getRegistrationCode()) == null) {
                result = value.getInternationalRegistrationCode();
            }
            return result;
        }
    }

    public static class StringParserFormatter
    extends Common.NullableParserFormatter<String> {
        public StringParserFormatter(String defaultValue, boolean nullAllowed) {
            super((Object)defaultValue, nullAllowed);
        }

        public String format(String value) {
            String str = "";
            if (value != null) {
                str = String.valueOf(value);
            }
            return str;
        }

        protected String parseNoneEmptyValue(String value) {
            return value;
        }
    }

    public static class StringParserFormatter2
    extends Common.NullableParserFormatter<String> {
        public StringParserFormatter2(String defaultValue, boolean nullAllowed) {
            super((Object)defaultValue, nullAllowed);
        }

        public String format(String value) {
            String str = value == null ? (String)this.defaultValue : String.valueOf(value);
            return str;
        }

        protected String parseNoneEmptyValue(String value) {
            return value;
        }
    }

    public static abstract class AbstractTuttiExportModel<M>
    extends AbstractExportModel<M> {
        public AbstractTuttiExportModel(char separator) {
            super(separator);
        }

        public <T> ExportableColumn<M, T> newColumnForExportByDecorator(String headerName, String propertyName, Decorator<T> decorator) {
            return this.newColumnForExportByDecorator(headerName, propertyName, decorator, null);
        }

        public <T> ExportableColumn<M, T> newNullableColumnForExportByDecorator(String headerName, String propertyName, Decorator<T> decorator) {
            DecoratorPropertyFormatter<T> valueFormatter = TuttiCsvUtil.newDecoratorFormatter(decorator, "");
            return this.newNullableColumnForExport(headerName, propertyName, valueFormatter);
        }

        public <T> ExportableColumn<M, T> newColumnForExportByDecorator(String headerName, String propertyName, Decorator<T> decorator, String defaultNullValue) {
            DecoratorPropertyFormatter<T> valueFormatter = TuttiCsvUtil.newDecoratorFormatter(decorator, defaultNullValue);
            return this.modelBuilder.newColumnForExport(headerName, propertyName, valueFormatter);
        }

        public <T> ExportableColumn<M, T> newColumnForExport(String headerName, String propertyName, String formatterPropertyName) {
            return this.newColumnForExport(headerName, propertyName, formatterPropertyName, null);
        }

        public <T> ExportableColumn<M, T> newColumnForExport(String headerName, String propertyName, String formatterPropertyName, String defaultNullValue) {
            BeanPropertyFormatter valueFormatter = TuttiCsvUtil.newBeanFormatter(formatterPropertyName, defaultNullValue);
            return this.modelBuilder.newColumnForExport(headerName, propertyName, valueFormatter);
        }

        public <E extends TuttiEntity> ForeignKeyValue<E> newForeignKeyValue(Class<E> type, String propertyName, Map<String, E> universe) {
            return new ForeignKeyValue<E>(type, propertyName, universe);
        }

        public <T> ExportableColumn<M, T> newNullableColumnForExport(String headerName, String propertyName, ValueFormatter<T> valueFormatter) {
            return this.modelBuilder.newColumnForExport(headerName, new BeanNullableGetter(propertyName), valueFormatter);
        }

        public ExportableColumn<M, String> newNullableColumnForExport(String headerName, String propertyName, String nullValue) {
            return this.newNullableColumnForExport(headerName, propertyName, (ValueFormatter)TuttiCsvUtil.newStringParserFormatter2(nullValue, true));
        }

        public ExportableColumn<M, String> newNullableColumnForExport(String headerName, String propertyName) {
            return this.newNullableColumnForExport(headerName, propertyName, (ValueFormatter)STRING);
        }

        public <T> ExportableColumn<M, T> newIndexNullableColumnForExport(String headerName, String collectionName, int order, String propertyName, ValueFormatter<T> valueFormatter) {
            return this.modelBuilder.newColumnForExport(headerName, new BeanIndexNullableGetter(collectionName, order, propertyName), valueFormatter);
        }

        public ExportableColumn<M, String> newIndexNullableColumnForExport(String headerName, String collectionName, int order, String propertyName) {
            return this.newIndexNullableColumnForExport(headerName, collectionName, order, propertyName, (ValueFormatter)STRING);
        }
    }

    public static abstract class AbstractTuttiImportModel<M>
    extends AbstractImportModel<M> {
        public AbstractTuttiImportModel(char separator) {
            super(separator);
        }

        public <E extends TuttiEntity> void newForeignKeyColumn(String headerName, String propertyName, Class<E> entityType, String foreignKeyName, Map<String, E> universe) {
            this.newMandatoryColumn(headerName, propertyName, (ValueParser)this.newForeignKeyValue(entityType, foreignKeyName, universe));
        }

        public <E extends TuttiEntity> void newForeignKeyColumn(String propertyName, Class<E> entityType, String foreignKeyName, Map<String, E> universe) {
            this.newMandatoryColumn(propertyName, propertyName, (ValueParser)this.newForeignKeyValue(entityType, foreignKeyName, universe));
        }

        public <E extends TuttiEntity> ForeignKeyValue<E> newForeignKeyValue(Class<E> type, String propertyName, Map<String, E> universe) {
            return new ForeignKeyValue<E>(type, propertyName, universe);
        }

        public void newNotExistingValueColumn(String propertyName, Set<String> universe) {
            this.newNotExistingValueColumn(propertyName, propertyName, universe);
        }

        public void newNotExistingValueColumn(String headerName, String propertyName, Set<String> universe) {
            this.newMandatoryColumn(headerName, propertyName, (ValueParser)new NotExistingKeyValue(propertyName, universe));
        }

        public void newNotExistingValueColumn(String propertyName, Set<String> universe, String errorMessage) {
            this.newNotExistingValueColumn(propertyName, propertyName, universe, errorMessage);
        }

        public void newNotExistingValueColumn(String headerName, String propertyName, Set<String> universe, String errorMessage) {
            this.newMandatoryColumn(headerName, propertyName, (ValueParser)new NotExistingKeyValue(propertyName, universe, errorMessage));
        }
    }

    public static abstract class AbstractTuttiImportExportModel<M>
    extends AbstractImportExportModel<M> {
        public AbstractTuttiImportExportModel(char separator) {
            super(separator);
        }

        public <T> ExportableColumn<M, T> newColumnForExportByDecorator(String headerName, String propertyName, Decorator<T> decorator) {
            return this.newColumnForExportByDecorator(headerName, propertyName, decorator, null);
        }

        public <T> ExportableColumn<M, T> newColumnForExportByDecorator(String headerName, String propertyName, Decorator<T> decorator, String defaultNullValue) {
            DecoratorPropertyFormatter<T> valueFormatter = TuttiCsvUtil.newDecoratorFormatter(decorator, defaultNullValue);
            return this.modelBuilder.newColumnForExport(headerName, propertyName, valueFormatter);
        }

        public <T> ExportableColumn<M, T> newColumnForExport(String headerName, String propertyName, String formatterPropertyName) {
            return this.newColumnForExport(headerName, propertyName, formatterPropertyName, null);
        }

        public <T> ExportableColumn<M, T> newColumnForExport(String headerName, String propertyName, String formatterPropertyName, String defaultNullValue) {
            BeanPropertyFormatter valueFormatter = TuttiCsvUtil.newBeanFormatter(formatterPropertyName, defaultNullValue);
            return this.modelBuilder.newColumnForExport(headerName, propertyName, valueFormatter);
        }

        public <E extends TuttiEntity> void newForeignKeyColumn(String headerName, String propertyName, Class<E> entityType, String foreignKeyName, Map<String, E> universe) {
            this.newMandatoryColumn(headerName, propertyName, (ValueParser)this.newForeignKeyValue(entityType, foreignKeyName, universe));
        }

        public <E extends TuttiEntity> void newForeignKeyColumn(String propertyName, Class<E> entityType, String foreignKeyName, Map<String, E> universe) {
            this.newMandatoryColumn(propertyName, propertyName, (ValueParser)this.newForeignKeyValue(entityType, foreignKeyName, universe));
        }

        public void newSpeciesForeignKeyColumn(String propertyName, String foreignKeyName, List<Species> species) {
            if (species == null) {
                species = Lists.newArrayList();
            }
            Map universe = TuttiEntities.splitByTaxonId((Iterable)species);
            this.newForeignKeyColumn(propertyName, Species.class, foreignKeyName, universe);
        }

        public <E extends TuttiEntity> void newForeignKeyColumn(String propertyName, Class<E> entityType, String foreignKeyName, List<E> list) {
            if (list == null) {
                list = Lists.newArrayList();
            }
            ImmutableMap universe = Maps.uniqueIndex((Iterable)list, (Function)TuttiEntities.GET_ID);
            this.newMandatoryColumn(propertyName, propertyName, (ValueParser)this.newForeignKeyValue(entityType, foreignKeyName, (Map<String, E>)universe));
        }

        public <E extends TuttiEntity> ForeignKeyValue<E> newForeignKeyValue(Class<E> type, String propertyName, Map<String, E> universe) {
            return new ForeignKeyValue<E>(type, propertyName, universe);
        }

        public void newNotExistingValueColumn(String propertyName, Set<String> universe) {
            this.newNotExistingValueColumn(propertyName, propertyName, universe);
        }

        public void newNotExistingValueColumn(String headerName, String propertyName, Set<String> universe) {
            this.newMandatoryColumn(headerName, propertyName, (ValueParser)new NotExistingKeyValue(propertyName, universe));
        }

        public void newNotExistingValueColumn(String propertyName, Set<String> universe, String errorMessage) {
            this.newNotExistingValueColumn(propertyName, propertyName, universe, errorMessage);
        }

        public void newNotExistingValueColumn(String headerName, String propertyName, Set<String> universe, String errorMessage) {
            this.newMandatoryColumn(headerName, propertyName, (ValueParser)new NotExistingKeyValue(propertyName, universe, errorMessage));
        }
    }
}

