/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.util.caracteristics;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import fr.ifremer.tutti.persistence.entities.CaracteristicMap;
import fr.ifremer.tutti.persistence.entities.referential.Caracteristic;
import fr.ifremer.tutti.persistence.entities.referential.CaracteristicQualitativeValue;
import fr.ifremer.tutti.ui.swing.TuttiUIContext;
import fr.ifremer.tutti.ui.swing.util.AbstractTuttiUIHandler;
import fr.ifremer.tutti.ui.swing.util.TuttiUI;
import fr.ifremer.tutti.ui.swing.util.TuttiUIUtil;
import fr.ifremer.tutti.ui.swing.util.caracteristics.CaracteristicMapColumnRowModel;
import fr.ifremer.tutti.ui.swing.util.caracteristics.CaracteristicMapColumnUIHandler;
import fr.ifremer.tutti.ui.swing.util.caracteristics.CaracteristicMapEditorUI;
import fr.ifremer.tutti.ui.swing.util.caracteristics.CaracteristicMapEditorUIModel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractCellEditor;
import javax.swing.JTable;
import javax.swing.border.LineBorder;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import jaxx.runtime.SwingUtil;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.decorator.Decorator;
import org.nuiton.i18n.I18n;
import org.nuiton.jaxx.application.swing.table.AbstractApplicationTableModel;

public class CaracteristicMapCellComponent
extends DefaultTableCellRenderer {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(CaracteristicMapCellComponent.class);
    protected Decorator<Caracteristic> caracteristicDecorator;
    protected Decorator<CaracteristicQualitativeValue> valueDecorator;
    protected Color computedDataColor;

    public CaracteristicMapCellComponent(TuttiUIContext context) {
        this.caracteristicDecorator = context.getDecoratorService().getDecoratorByType(Caracteristic.class);
        this.valueDecorator = context.getDecoratorService().getDecoratorByType(CaracteristicQualitativeValue.class);
        this.computedDataColor = context.getConfig().getColorComputedWeights();
        this.setHorizontalAlignment(0);
        this.setIcon(SwingUtil.createActionIcon((String)"show-frequency"));
    }

    public void setText(CaracteristicMap map) {
        String s = "-";
        if (map != null && map.size() > 0) {
            s = String.valueOf(map.size());
        }
        this.setText(s);
        Font f = this.getFont();
        f = f.deriveFont(2);
        this.setFont(f);
        this.setForeground(this.computedDataColor);
    }

    public void setToolTipText(CaracteristicMap map) {
        StringBuilder builder = new StringBuilder();
        if (map != null) {
            builder.append("<html><ul>");
            if (MapUtils.isEmpty((Map)map)) {
                builder.append("<li>");
                builder.append(I18n.t((String)"tutti.caracteristicMapEditor.none.tip", (Object[])new Object[0]));
                builder.append("</li>");
            }
            for (Caracteristic caracteristic : map.keySet()) {
                builder.append("<li>");
                builder.append(this.caracteristicDecorator.toString((Object)caracteristic));
                builder.append(" : ");
                Serializable bean = (Serializable)map.get((Object)caracteristic);
                if (bean instanceof CaracteristicQualitativeValue) {
                    builder.append(this.valueDecorator.toString((Object)bean));
                } else {
                    builder.append(bean);
                }
                builder.append("</li>");
            }
            builder.append("</ul></html>");
        }
        this.setToolTipText(builder.toString());
    }

    public static TableCellRenderer newRender(TuttiUIContext context) {
        return new CaracteristicMapCellRenderer(context);
    }

    public static TableCellEditor newEditor(TuttiUI ui, Set<Caracteristic> caracteristicsToSkip) {
        return new CaracteristicMapCellEditor(ui, caracteristicsToSkip);
    }

    public static class CaracteristicMapCellRenderer
    implements TableCellRenderer {
        protected final CaracteristicMapCellComponent component;

        public CaracteristicMapCellRenderer(TuttiUIContext context) {
            this.component = new CaracteristicMapCellComponent(context);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            CaracteristicMapCellComponent result = (CaracteristicMapCellComponent)this.component.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            boolean editable = table.isCellEditable(row, column);
            result.setEnabled(editable);
            CaracteristicMap map = (CaracteristicMap)value;
            result.setText(map);
            result.setToolTipText(map);
            return result;
        }
    }

    public static class CaracteristicMapCellEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        private static final long serialVersionUID = 1L;
        protected final CaracteristicMapCellComponent component;
        protected final TuttiUI ui;
        protected JTable table;
        protected AbstractApplicationTableModel<CaracteristicMapColumnRowModel> tableModel;
        protected CaracteristicMapColumnRowModel editRow;
        protected Set<Caracteristic> caracteristicsUsed;
        protected Set<Caracteristic> caracteristicsToSkip;
        protected Integer rowIndex;
        protected Integer columnIndex;

        public CaracteristicMapCellEditor(TuttiUI ui, Set<Caracteristic> caracteristicsToSkip) {
            this.ui = ui;
            this.caracteristicsToSkip = caracteristicsToSkip;
            this.component = new CaracteristicMapCellComponent(((AbstractTuttiUIHandler)ui.getHandler()).getContext());
            this.component.setBorder(new LineBorder(Color.BLACK));
            this.component.addKeyListener(new KeyAdapter(){

                @Override
                public void keyReleased(KeyEvent e) {
                    if (e.getKeyCode() == 10 || e.getKeyCode() == 32) {
                        e.consume();
                        CaracteristicMapCellEditor.this.startEdit();
                    }
                }
            });
            this.component.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    e.consume();
                    CaracteristicMapCellEditor.this.startEdit();
                }
            });
        }

        protected void startEdit() {
            Preconditions.checkNotNull(this.tableModel, (Object)"No table model assigned.");
            Preconditions.checkNotNull((Object)this.editRow, (Object)"No editRow found.");
            if (log.isDebugEnabled()) {
                log.debug((Object)("Will edit frequencies for row: " + this.rowIndex));
            }
            if (this.caracteristicsUsed == null) {
                this.caracteristicsUsed = Sets.newHashSet();
                for (CaracteristicMapColumnRowModel row : this.tableModel.getRows()) {
                    CaracteristicMap map = row.getCaracteristics();
                    if (map == null) continue;
                    this.caracteristicsUsed.addAll(map.keySet());
                }
            }
            this.caracteristicsUsed.removeAll(this.caracteristicsToSkip);
            CaracteristicMapColumnUIHandler handler = (CaracteristicMapColumnUIHandler)this.ui.getHandler();
            CaracteristicMapEditorUI caracteristicMapEditor = handler.getCaracteristicMapEditor();
            caracteristicMapEditor.getModel().getAvailableCaracteristics().removeAll(this.caracteristicsToSkip);
            caracteristicMapEditor.getHandler().editBatch(this.editRow, this, this.caracteristicsUsed);
            handler.showCaracteristicMapEditor(this.editRow.getSpecies());
        }

        public void validateEdition(CaracteristicMapEditorUIModel caracteristicMapEditorModel) {
            CaracteristicMap map = caracteristicMapEditorModel.getCaracteristicMap();
            this.component.setText(map);
            this.component.setToolTipText(map);
            this.editRow.setCaracteristics(map);
            this.caracteristicsUsed.addAll(map.keySet());
            int r = this.rowIndex;
            int c = this.columnIndex;
            this.stopCellEditing();
            TuttiUIUtil.doSelectCell((JTable)this.table, (int)r, (int)c);
            this.table.requestFocus();
        }

        public void closeEditor() {
            CaracteristicMapColumnUIHandler handler = (CaracteristicMapColumnUIHandler)this.ui.getHandler();
            handler.hideCaracteristicMapEditor();
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.tableModel = (AbstractApplicationTableModel)table.getModel();
            this.table = table;
            this.rowIndex = row;
            this.columnIndex = column;
            this.editRow = (CaracteristicMapColumnRowModel)this.tableModel.getEntry(row);
            this.component.setText(this.editRow.getCaracteristics());
            this.component.setToolTipText(this.editRow.getCaracteristics());
            return this.component;
        }

        @Override
        public Object getCellEditorValue() {
            Preconditions.checkNotNull((Object)this.editRow, (Object)"No editRow found in editor.");
            CaracteristicMap result = this.editRow.getCaracteristics();
            return result;
        }

        @Override
        public void cancelCellEditing() {
            super.cancelCellEditing();
            this.rowIndex = null;
            this.columnIndex = null;
            this.editRow = null;
        }
    }
}

