/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.persistence.service;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import fr.ifremer.adagio.core.dao.administration.programStrategy.Program;
import fr.ifremer.adagio.core.dao.administration.programStrategy.ProgramDao;
import fr.ifremer.adagio.core.dao.referential.gear.GearClassification;
import fr.ifremer.adagio.core.dao.referential.gear.GearClassificationImpl;
import fr.ifremer.adagio.core.dao.referential.location.Location;
import fr.ifremer.adagio.core.dao.referential.location.LocationClassification;
import fr.ifremer.adagio.core.dao.referential.location.LocationDao;
import fr.ifremer.adagio.core.dao.referential.taxon.TaxonGroupType;
import fr.ifremer.adagio.core.dao.referential.taxon.TaxonGroupTypeImpl;
import fr.ifremer.tutti.persistence.entities.data.Program;
import fr.ifremer.tutti.persistence.entities.data.Programs;
import fr.ifremer.tutti.persistence.entities.referential.TuttiLocation;
import fr.ifremer.tutti.persistence.entities.referential.TuttiLocations;
import fr.ifremer.tutti.persistence.service.AbstractPersistenceService;
import fr.ifremer.tutti.persistence.service.ProgramPersistenceService;
import fr.ifremer.tutti.persistence.service.ReferentialPersistenceService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.type.IntegerType;
import org.hibernate.type.StringType;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataRetrievalFailureException;
import org.springframework.stereotype.Service;

@Service(value="programPersistenceService")
public class ProgramPersistenceServiceImpl
extends AbstractPersistenceService
implements ProgramPersistenceService {
    private static final Log log = LogFactory.getLog(ProgramPersistenceServiceImpl.class);
    @Autowired
    protected ReferentialPersistenceService referentialService;
    @Resource(name="programDao")
    protected ProgramDao programDao;
    @Resource(name="locationDao")
    protected LocationDao locationDao;
    protected final int maxCodeLengthInDatabase = 40;

    @Override
    public List<Program> getAllProgram() {
        String codePattern = "%";
        if (this.enumeration.PROGRAM_CODE_SCIENTIFIC_CRUISE_PREFIX != null) {
            codePattern = this.enumeration.PROGRAM_CODE_SCIENTIFIC_CRUISE_PREFIX + codePattern;
        }
        Iterator<Object[]> list = this.queryList("allPrograms", "codePattern", StringType.INSTANCE, codePattern, "locationLevelId", IntegerType.INSTANCE, this.enumeration.LOCATION_LEVEL_ID_PROGRAM, "locationClassificationId", IntegerType.INSTANCE, this.enumeration.LOCATION_CLASSIFICATION_ID_SECTOR);
        ArrayList result = Lists.newArrayList();
        while (list.hasNext()) {
            Object[] source = list.next();
            Program target = Programs.newProgram();
            this.loadProgram(target, source);
            result.add(target);
        }
        return Collections.unmodifiableList(result);
    }

    @Override
    public Program getProgram(String id) {
        Program result;
        Iterator<Object[]> list = this.queryList("program", "programCode", StringType.INSTANCE, id, "locationLevelId", IntegerType.INSTANCE, this.enumeration.LOCATION_LEVEL_ID_PROGRAM, "locationClassificationId", IntegerType.INSTANCE, this.enumeration.LOCATION_CLASSIFICATION_ID_SECTOR);
        if (list.hasNext()) {
            Object[] source = list.next();
            result = Programs.newProgram();
            this.loadProgram(result, source);
        } else {
            result = null;
        }
        return result;
    }

    @Override
    public Program createProgram(Program bean) {
        Preconditions.checkNotNull((Object)bean);
        Preconditions.checkNotNull((Object)bean.getName());
        Preconditions.checkNotNull((Object)bean.getDescription());
        Preconditions.checkArgument((bean.getId() == null ? 1 : 0) != 0);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Create program with name: " + bean.getName()));
        }
        fr.ifremer.adagio.core.dao.administration.programStrategy.Program program = Program.Factory.newInstance();
        this.programToEntity(bean, program);
        program = this.programDao.create(program);
        bean.setId(String.valueOf(program.getCode()));
        return bean;
    }

    @Override
    public Program saveProgram(Program bean) {
        fr.ifremer.adagio.core.dao.administration.programStrategy.Program program;
        Preconditions.checkNotNull((Object)bean);
        Preconditions.checkNotNull((Object)bean.getName());
        Preconditions.checkNotNull((Object)bean.getId());
        Preconditions.checkNotNull((Object)bean.getDescription());
        if (log.isDebugEnabled()) {
            log.debug((Object)("Save program with name: " + bean.getName()));
        }
        if ((program = this.programDao.load(bean.getId())) == null) {
            throw new DataRetrievalFailureException("Could not retrieve program with code=" + bean.getId());
        }
        this.programToEntity(bean, program);
        this.programDao.update(program);
        return bean;
    }

    protected void loadProgram(Program result, Object[] source) {
        result.setId((String)source[0]);
        result.setName((String)source[1]);
        result.setDescription((String)source[2]);
        if (source[3] != null) {
            TuttiLocation zone = TuttiLocations.newTuttiLocation();
            zone.setId(String.valueOf(source[3]));
            zone.setLabel((String)source[4]);
            zone.setName((String)source[5]);
            result.setZone(zone);
        }
    }

    protected void programToEntity(Program source, fr.ifremer.adagio.core.dao.administration.programStrategy.Program target) {
        if (target.getCode() == null && source.getName() != null) {
            String programCode = source.getName().toUpperCase().replaceAll(" ", "_");
            if (this.enumeration.PROGRAM_CODE_SCIENTIFIC_CRUISE_PREFIX != null) {
                programCode = this.enumeration.PROGRAM_CODE_SCIENTIFIC_CRUISE_PREFIX + programCode;
            }
            if (programCode.length() > 40) {
                programCode = programCode.substring(0, 39);
            }
            target.setCode(programCode);
            target.setGearClassification((GearClassification)this.load(GearClassificationImpl.class, this.enumeration.GEAR_CLASSIFICIATION_ID_SCIENTIFIC));
            target.setTaxonGroupType((TaxonGroupType)this.load(TaxonGroupTypeImpl.class, (Serializable)((Object)this.enumeration.TAXON_GROUP_TYPE_ID_COMMERCIAL_SPECIES)));
            target.setCreationDate(this.newCreateDate());
        }
        target.setName(source.getName());
        target.setDescription(source.getDescription());
        if (source.getZone() == null) {
            if (target.getLocationClassifications() != null) {
                target.getLocationClassifications().clear();
            }
            if (target.getLocations() != null) {
                target.getLocations().clear();
            }
        } else if (source.getZone() != null && source.getZone().getId() != null) {
            Location location = this.locationDao.load(Integer.valueOf(source.getZone().getId()));
            if (target.getLocationClassifications() == null) {
                target.setLocationClassifications((Collection)Lists.newArrayList((Object[])new LocationClassification[]{location.getLocationClassification()}));
            } else {
                target.getLocationClassifications().clear();
                target.getLocationClassifications().add(location.getLocationClassification());
            }
            if (target.getLocations() == null) {
                target.setLocations((Collection)Lists.newArrayList((Object[])new Location[]{location}));
            } else {
                target.getLocations().clear();
                target.getLocations().add(location);
            }
        }
    }

    public int getProgramNameMaxLength() {
        int maxCodeLengthInDatabase = 40;
        if (this.enumeration.PROGRAM_CODE_SCIENTIFIC_CRUISE_PREFIX == null || this.enumeration.PROGRAM_CODE_SCIENTIFIC_CRUISE_PREFIX.trim().isEmpty()) {
            return maxCodeLengthInDatabase;
        }
        return maxCodeLengthInDatabase - this.enumeration.PROGRAM_CODE_SCIENTIFIC_CRUISE_PREFIX.length();
    }
}

