/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.persistence.entities.data;

import com.google.common.base.Preconditions;
import com.google.common.primitives.Ints;
import fr.ifremer.tutti.persistence.TuttiPersistence;
import fr.ifremer.tutti.persistence.entities.referential.Caracteristic;
import java.io.Serializable;
import org.apache.commons.lang3.StringUtils;

public class SampleCategoryModelEntry
implements Comparable<SampleCategoryModelEntry>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String label;
    protected String canonicalLabel;
    protected Integer categoryId;
    protected int order;
    protected transient Caracteristic caracteristic;

    public void load(TuttiPersistence service) {
        Preconditions.checkNotNull((Object)this.categoryId, (Object)"Can't have a null category id");
        this.caracteristic = service.getCaracteristic(this.categoryId);
        Preconditions.checkNotNull((Object)this.caracteristic, (Object)("Could not find category if id: " + this.categoryId));
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
        this.canonicalLabel = null;
    }

    public String getCanonicalLabel() {
        if (this.canonicalLabel == null) {
            this.canonicalLabel = "";
            if (StringUtils.isNotEmpty((CharSequence)this.label)) {
                for (int i = 0; i < this.label.length(); ++i) {
                    char a = this.label.charAt(i);
                    if (!Character.isLetterOrDigit(a)) {
                        a = '_';
                    }
                    this.canonicalLabel = this.canonicalLabel + a;
                }
            }
        }
        return this.canonicalLabel;
    }

    public Caracteristic getCaracteristic() {
        return this.caracteristic;
    }

    public void setCaracteristic(Caracteristic caracteristic) {
        this.caracteristic = caracteristic;
    }

    public Integer getCategoryId() {
        return this.categoryId;
    }

    public void setCategoryId(Integer categoryId) {
        this.categoryId = categoryId;
    }

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    @Override
    public int compareTo(SampleCategoryModelEntry o) {
        return Ints.compare((int)this.order, (int)o.getOrder());
    }

    public String toString() {
        return this.categoryId + "," + (StringUtils.isBlank((CharSequence)this.label) ? "" : this.label);
    }
}

