/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.service.pupitri;

import com.google.common.collect.Maps;
import fr.ifremer.tutti.persistence.entities.TuttiEntities;
import fr.ifremer.tutti.persistence.entities.referential.Caracteristic;
import fr.ifremer.tutti.persistence.entities.referential.CaracteristicQualitativeValue;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.persistence.service.TuttiEnumerationFile;
import java.io.Serializable;
import java.util.Map;
import org.apache.commons.lang3.mutable.MutableFloat;

public class PupitriCatch
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected Species species;
    protected boolean sorted;
    protected Map<Signs, MutableFloat> weightBySign = Maps.newHashMap();

    public PupitriCatch(Species species, boolean sorted) {
        this.species = species;
        this.sorted = sorted;
    }

    public Species getSpecies() {
        return this.species;
    }

    public boolean isSorted() {
        return this.sorted;
    }

    public Map<Signs, MutableFloat> getWeightBySign() {
        return this.weightBySign;
    }

    public void addToSign(String sign, Float weight) {
        Signs s = Signs.getSign(sign);
        MutableFloat f = this.weightBySign.get((Object)s);
        if (f == null) {
            f = new MutableFloat();
            this.weightBySign.put(s, f);
        }
        f.add((Number)weight);
    }

    public int hashCode() {
        int speciesHashCode = this.species != null ? this.species.hashCode() : 0;
        int sortedHashCode = this.sorted ? 0x55555555 : 0x2AAAAAAA;
        return speciesHashCode ^ sortedHashCode;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PupitriCatch other = (PupitriCatch)obj;
        if (!(this.species == other.species || this.species != null && this.species.equals(other.species))) {
            return false;
        }
        return this.sorted == other.sorted;
    }

    public static enum Signs {
        DEFAULT("0"){

            @Override
            public Integer getCategory(TuttiEnumerationFile enumerationFile) {
                return enumerationFile.PMFM_ID_SEX;
            }

            @Override
            public Integer getQualitativeValueId(TuttiEnumerationFile enumerationFile) {
                return enumerationFile.QUALITATIVE_SEX_UNDEFINED_ID;
            }
        }
        ,
        MALE("1"){

            @Override
            public Integer getCategory(TuttiEnumerationFile enumerationFile) {
                return enumerationFile.PMFM_ID_SEX;
            }

            @Override
            public Integer getQualitativeValueId(TuttiEnumerationFile enumerationFile) {
                return enumerationFile.QUALITATIVE_SEX_MALE_ID;
            }
        }
        ,
        FEMALE("2"){

            @Override
            public Integer getCategory(TuttiEnumerationFile enumerationFile) {
                return enumerationFile.PMFM_ID_SEX;
            }

            @Override
            public Integer getQualitativeValueId(TuttiEnumerationFile enumerationFile) {
                return enumerationFile.QUALITATIVE_SEX_FEMALE_ID;
            }
        }
        ,
        SMALL("P"){

            @Override
            public Integer getCategory(TuttiEnumerationFile enumerationFile) {
                return enumerationFile.PMFM_ID_SIZE_CATEGORY;
            }

            @Override
            public Integer getQualitativeValueId(TuttiEnumerationFile enumerationFile) {
                return enumerationFile.QUALITATIVE_SIZE_SMALL_ID;
            }
        }
        ,
        MEDIUM("M"){

            @Override
            public Integer getCategory(TuttiEnumerationFile enumerationFile) {
                return enumerationFile.PMFM_ID_SIZE_CATEGORY;
            }

            @Override
            public Integer getQualitativeValueId(TuttiEnumerationFile enumerationFile) {
                return enumerationFile.QUALITATIVE_SIZE_MEDIUM_ID;
            }
        }
        ,
        BIG("G"){

            @Override
            public Integer getCategory(TuttiEnumerationFile enumerationFile) {
                return enumerationFile.PMFM_ID_SIZE_CATEGORY;
            }

            @Override
            public Integer getQualitativeValueId(TuttiEnumerationFile enumerationFile) {
                return enumerationFile.QUALITATIVE_SIZE_MEDIUM_ID;
            }
        };

        private String sign;

        private Signs(String sign) {
            this.sign = sign;
        }

        public static Signs getSign(String sign) {
            Signs result = null;
            for (Signs s : Signs.values()) {
                if (!s.sign.equals(sign)) continue;
                result = s;
                break;
            }
            return result;
        }

        public abstract Integer getCategory(TuttiEnumerationFile var1);

        public abstract Integer getQualitativeValueId(TuttiEnumerationFile var1);

        public void registerSign(TuttiEnumerationFile enumerationFile, Caracteristic caracteristic, Map<Signs, CaracteristicQualitativeValue> map) {
            Integer valueId = this.getQualitativeValueId(enumerationFile);
            CaracteristicQualitativeValue result = TuttiEntities.getQualitativeValue((Caracteristic)caracteristic, (Integer)valueId);
            map.put(this, result);
        }
    }
}

