/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.service.export.generic;

import fr.ifremer.tutti.persistence.entities.CaracteristicMap;
import fr.ifremer.tutti.persistence.entities.data.AccidentalBatch;
import fr.ifremer.tutti.persistence.entities.data.Cruise;
import fr.ifremer.tutti.persistence.entities.data.FishingOperation;
import fr.ifremer.tutti.persistence.entities.referential.Caracteristic;
import fr.ifremer.tutti.service.PersistenceService;
import fr.ifremer.tutti.service.TuttiCsvUtil;
import fr.ifremer.tutti.service.export.generic.AccidentalCatchExportRow;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.nuiton.csv.ValueFormatter;

public class AccidentalCatchExportModel
extends TuttiCsvUtil.AbstractTuttiExportModel<AccidentalCatchExportRow> {
    protected final Caracteristic caracteristicDeadOrAliveSize;
    protected final Caracteristic caracteristicGender;
    protected final Caracteristic caracteristicWeight;
    protected final Caracteristic caracteristicPmfmId;

    public AccidentalCatchExportModel(char separator, Caracteristic caracteristicDeadOrAliveSize, Caracteristic caracteristicGender, Caracteristic caracteristicWeight, Caracteristic caracteristicPmfmId) {
        super(separator);
        this.caracteristicDeadOrAliveSize = caracteristicDeadOrAliveSize;
        this.caracteristicGender = caracteristicGender;
        this.caracteristicWeight = caracteristicWeight;
        this.caracteristicPmfmId = caracteristicPmfmId;
        this.newColumnForExport("Annee", "beginDate", (ValueFormatter)TuttiCsvUtil.YEAR);
        this.newColumnForExport("Serie", "program", "name");
        this.newColumnForExport("Serie_Partielle", "surveyPart");
        this.newNullableColumnForExport("Engin", "gear.name");
        this.newColumnForExport("Code_station", "stationNumber");
        this.newColumnForExport("Numero_Trait", "fishingOperationNumber", (ValueFormatter)TuttiCsvUtil.INTEGER);
        this.newColumnForExport("Poche", "multirigAggregation");
        this.newColumnForExport("Navire", "vessel", TuttiCsvUtil.VESSEL_VALUE_FORMATTER);
        this.newColumnForExport("BatchId", "batchId", (ValueFormatter)TuttiCsvUtil.PRIMITIVE_INTEGER);
        this.newColumnForExport("ReferenceTaxonId", "species.referenceTaxonId", (ValueFormatter)TuttiCsvUtil.PRIMITIVE_INTEGER);
        this.newColumnForExport("ReferenceTaxonName", "species.name");
        this.newColumnForExport("Commentaire", "comment");
        this.newColumnForExport("CaracteristicId", "caracteristic", "id");
        this.newColumnForExport("CaracteristicValue", "caracteristicValue", TuttiCsvUtil.CARACTERISTIC_VALUE_FORMATTER);
    }

    public void prepareRows(PersistenceService persistenceService, List<AccidentalCatchExportRow> rows, Cruise cruise, FishingOperation operation) {
        List<AccidentalBatch> observations = persistenceService.getAllAccidentalBatch(operation.getId());
        if (CollectionUtils.isNotEmpty(observations)) {
            for (AccidentalBatch child : observations) {
                CaracteristicMap caracteristics;
                this.addCaracteristicRow(rows, cruise, operation, child, this.caracteristicDeadOrAliveSize, (Serializable)child.getDeadOrAlive());
                this.addCaracteristicRow(rows, cruise, operation, child, this.caracteristicGender, (Serializable)child.getGender());
                this.addCaracteristicRow(rows, cruise, operation, child, this.caracteristicWeight, child.getWeight());
                if (child.getLengthStepCaracteristic() != null) {
                    this.addCaracteristicRow(rows, cruise, operation, child, this.caracteristicPmfmId, child.getLengthStepCaracteristic().getIdAsInt());
                    this.addCaracteristicRow(rows, cruise, operation, child, child.getLengthStepCaracteristic(), child.getSize());
                }
                if (!MapUtils.isNotEmpty((Map)(caracteristics = child.getCaracteristics()))) continue;
                for (Map.Entry entry : caracteristics.entrySet()) {
                    this.addCaracteristicRow(rows, cruise, operation, child, (Caracteristic)entry.getKey(), (Serializable)entry.getValue());
                }
            }
        }
    }

    private void addCaracteristicRow(List<AccidentalCatchExportRow> rows, Cruise cruise, FishingOperation operation, AccidentalBatch child, Caracteristic caracteristic, Serializable caracteristicValue) {
        if (caracteristicValue != null) {
            AccidentalCatchExportRow row = new AccidentalCatchExportRow();
            row.setCruise(cruise);
            row.setFishingOperation(operation);
            row.setBatch(child);
            row.setCaracteristic(caracteristic);
            row.setCaracteristicValue(caracteristicValue);
            rows.add(row);
        }
    }
}

