/*
 * Decompiled with CFR 0.152.
 */
package jaxx.runtime.validator.swing.ui;

import com.google.common.collect.Sets;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.util.Collection;
import java.util.EnumMap;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import jaxx.runtime.validator.swing.SwingValidatorUtil;
import jaxx.runtime.validator.swing.ui.AbstractBeanValidatorUI;
import org.jdesktop.jxlayer.JXLayer;
import org.nuiton.validator.NuitonValidatorScope;

public class ImageValidationUI
extends AbstractBeanValidatorUI {
    private static final long serialVersionUID = 1L;
    protected EnumMap<NuitonValidatorScope, BufferedImage> icons = new EnumMap(NuitonValidatorScope.class);

    public ImageValidationUI(String fields) {
        this(Sets.newHashSet((Object[])new String[]{fields}));
    }

    public ImageValidationUI(Collection<String> fields) {
        super(fields);
        for (NuitonValidatorScope scope : NuitonValidatorScope.values()) {
            BufferedImage image = ImageValidationUI.prepareIcon(SwingValidatorUtil.getIcon(scope));
            this.icons.put(scope, image);
        }
    }

    protected static BufferedImage prepareIcon(ImageIcon image) {
        BufferedImage icon = new BufferedImage(image.getIconWidth(), image.getIconHeight(), 2);
        Graphics2D g2 = (Graphics2D)icon.getGraphics();
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        g2.drawImage(image.getImage(), 0, 0, null);
        g2.dispose();
        return icon;
    }

    public void installUI(JComponent c) {
        super.installUI(c);
        c.setBorder(BorderFactory.createEmptyBorder(2, 0, 0, 3));
    }

    public void uninstallUI(JComponent c) {
        super.uninstallUI(c);
        c.setBorder(null);
    }

    protected void paintLayer(Graphics2D g2, JXLayer<? extends JComponent> l) {
        super.paintLayer(g2, l);
        NuitonValidatorScope scope = this.getScope();
        if (scope != null) {
            BufferedImage icon = this.icons.get(scope);
            g2.drawImage((Image)icon, l.getWidth() - icon.getWidth() - 1, 0, null);
        }
    }
}

