/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.persistence.service.synchro;

import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import fr.ifremer.tutti.persistence.ProgressionModel;
import fr.ifremer.tutti.persistence.entities.TuttiEntities;
import fr.ifremer.tutti.persistence.service.synchro.ReferentialSynchronizeResult;
import fr.ifremer.tutti.persistence.service.synchro.TuttiAssociationTableMetadata;
import fr.ifremer.tutti.persistence.service.synchro.TuttiDatabaseMetadata;
import fr.ifremer.tutti.persistence.service.synchro.TuttiEntityTableMetadata;
import fr.ifremer.tutti.persistence.service.synchro.TuttiTable;
import fr.ifremer.tutti.persistence.service.synchro.TuttiTableMetadata;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.SortedSet;
import org.apache.commons.lang3.time.DateUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.dialect.Dialect;
import org.hibernate.tool.hbm2ddl.ColumnMetadata;
import org.nuiton.i18n.I18n;
import org.springframework.dao.DataRetrievalFailureException;
import org.springframework.jdbc.support.JdbcUtils;
import org.springframework.stereotype.Component;

@Component(value="referentialSynchronizeHelper")
public class ReferentialSynchronizeHelper {
    private static final Log log = LogFactory.getLog(ReferentialSynchronizeHelper.class);
    public static final Predicate<TuttiTableMetadata> IS_ENTITY_TABLE = new Predicate<TuttiTableMetadata>(){

        public boolean apply(TuttiTableMetadata input) {
            return input instanceof TuttiEntityTableMetadata;
        }
    };
    public static final Predicate<TuttiTableMetadata> IS_ASSOCIATION_TABLE = new Predicate<TuttiTableMetadata>(){

        public boolean apply(TuttiTableMetadata input) {
            return input instanceof TuttiAssociationTableMetadata;
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prepare(Properties localProperties, Properties remoteProperties, Dialect dialect, ReferentialSynchronizeResult result) {
        Connection remoteConnection;
        Connection localConnection;
        block12: {
            result.setLocalUrl(TuttiEntities.getUrl(localProperties));
            result.setRemoteUrl(TuttiEntities.getUrl(remoteProperties));
            localConnection = null;
            remoteConnection = null;
            try {
                ProgressionModel progressionModel = result.getProgressionModel();
                progressionModel.setMessage(I18n._((String)"tutti.persistence.synchronizeReferential.prepare.step1", (Object[])new Object[0]));
                localConnection = TuttiEntities.createConnection(localProperties);
                progressionModel.setMessage(I18n._((String)"tutti.persistence.synchronizeReferential.prepare.step2", (Object[])new Object[0]));
                remoteConnection = TuttiEntities.createConnection(remoteProperties);
                TuttiDatabaseMetadata localMeta = this.loadDatabaseMetadata(localConnection, dialect);
                TuttiDatabaseMetadata remoteMeta = this.loadDatabaseMetadata(remoteConnection, dialect);
                progressionModel.setMessage(I18n._((String)"tutti.persistence.synchronizeReferential.prepare.step3", (Object[])new Object[0]));
                try {
                    this.checkSchemas(localMeta, remoteMeta);
                }
                catch (DataRetrievalFailureException e) {
                    result.setError((Exception)((Object)e));
                }
                if (!result.isSuccess()) break block12;
                for (TuttiTable tuttiTable : TuttiTable.values()) {
                    String tableName = tuttiTable.name();
                    progressionModel.setMessage(I18n._((String)"tutti.persistence.synchronizeReferential.prepare.step4", (Object[])new Object[]{tableName}));
                    TuttiTableMetadata table = remoteMeta.getTable(tableName);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Prepare table: " + tableName));
                    }
                    this.prepareTable(table, localConnection, remoteConnection, result);
                }
                long totalRows = result.getTotalRows();
                if (log.isInfoEnabled()) {
                    log.info((Object)("Total rows to update: " + totalRows));
                }
                localConnection.rollback();
            }
            catch (SQLException e) {
                try {
                    try {
                        if (localConnection != null) {
                            localConnection.rollback();
                        }
                    }
                    catch (SQLException e1) {
                        // empty catch block
                    }
                    result.setError(e);
                }
                catch (Throwable throwable) {
                    JdbcUtils.closeConnection(remoteConnection);
                    JdbcUtils.closeConnection(localConnection);
                    throw throwable;
                }
                JdbcUtils.closeConnection(remoteConnection);
                JdbcUtils.closeConnection((Connection)localConnection);
            }
        }
        JdbcUtils.closeConnection((Connection)remoteConnection);
        JdbcUtils.closeConnection((Connection)localConnection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReferentialSynchronizeResult synchronize(Properties localProperties, Properties remoteProperties, Dialect dialect, ReferentialSynchronizeResult result) {
        Connection localConnection = null;
        Connection remoteConnection = null;
        try {
            localConnection = TuttiEntities.createConnection(localProperties);
            remoteConnection = TuttiEntities.createConnection(remoteProperties);
            TuttiDatabaseMetadata remoteMeta = this.loadDatabaseMetadata(remoteConnection, dialect);
            ProgressionModel progressionModel = result.getProgressionModel();
            progressionModel.setTotal(result.getTotalRows());
            ReferentialSynchronizeHelper.prepareSynch(localConnection);
            try {
                for (TuttiTable tuttiTable : TuttiTable.values()) {
                    String tableName = tuttiTable.name();
                    progressionModel.setMessage(I18n._((String)"tutti.persistence.synchronizeReferential.synchronize.step1", (Object[])new Object[]{tableName}));
                    TuttiTableMetadata table = remoteMeta.getTable(tableName);
                    if (log.isInfoEnabled()) {
                        log.info((Object)("Synchronize table: " + tableName));
                    }
                    this.synchronizeTable(table, localConnection, remoteConnection, result);
                }
                if (log.isInfoEnabled()) {
                    long totalInserts = result.getTotalInserts();
                    long totalUpdates = result.getTotalUpdates();
                    log.info((Object)("Total rows to treat: " + result.getTotalRows()));
                    log.info((Object)("Total rows inserted: " + totalInserts));
                    log.info((Object)("Total rows  updated: " + totalUpdates));
                    log.info((Object)("Total rows  treated: " + (totalInserts + totalUpdates)));
                }
            }
            finally {
                ReferentialSynchronizeHelper.releaseSynch(localConnection);
            }
            progressionModel.setMessage(I18n._((String)"tutti.persistence.synchronizeReferential.synchronize.step2", (Object[])new Object[0]));
            localConnection.commit();
        }
        catch (SQLException e) {
            try {
                try {
                    if (localConnection != null) {
                        localConnection.rollback();
                    }
                }
                catch (SQLException e1) {
                    // empty catch block
                }
                result.setError(e);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeConnection(remoteConnection);
                JdbcUtils.closeConnection((Connection)localConnection);
                throw throwable;
            }
            JdbcUtils.closeConnection((Connection)remoteConnection);
            JdbcUtils.closeConnection((Connection)localConnection);
        }
        JdbcUtils.closeConnection((Connection)remoteConnection);
        JdbcUtils.closeConnection((Connection)localConnection);
        return result;
    }

    public TuttiDatabaseMetadata loadDatabaseMetadata(Connection connection, Dialect dialect) {
        TuttiDatabaseMetadata result = new TuttiDatabaseMetadata(connection, dialect);
        for (TuttiTable tuttiTable : TuttiTable.values()) {
            String tableName = tuttiTable.name();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Load metas of table: " + tableName));
            }
            result.getTable(tableName);
        }
        return result;
    }

    public void checkSchemas(TuttiDatabaseMetadata schema1, TuttiDatabaseMetadata schema2) {
        Set<String> externalSchemaTableNames;
        Set<String> internalSchemaTableNames = schema1.getTableNames();
        if (!internalSchemaTableNames.equals(externalSchemaTableNames = schema2.getTableNames())) {
            throw new DataRetrievalFailureException("Incompatible schemas");
        }
        for (String tableName : internalSchemaTableNames) {
            SortedSet<String> externalColumnNames;
            TuttiTableMetadata internalTable = schema1.getTable(tableName);
            TuttiTableMetadata externalTable = schema2.getTable(tableName);
            SortedSet<String> internalColumnNames = internalTable.getColumnNames();
            if (!internalColumnNames.equals(externalColumnNames = externalTable.getColumnNames())) {
                throw new DataRetrievalFailureException("Incompatible schema of table: " + tableName);
            }
            for (String columnName : internalColumnNames) {
                String externalColumnTypeName;
                ColumnMetadata internalColumn = internalTable.getColumnMetadata(columnName);
                ColumnMetadata externalColumn = externalTable.getColumnMetadata(columnName);
                String internalColumnTypeName = internalColumn.getTypeName();
                if (internalColumnTypeName.equals(externalColumnTypeName = externalColumn.getTypeName())) continue;
                throw new DataRetrievalFailureException("Incompatible column type of table / column: " + tableName + " / " + columnName);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Timestamp getLastUpdateDate(Connection connection, TuttiTableMetadata table) throws SQLException {
        Timestamp result = null;
        if (table.isWithUpdateDateColumn()) {
            String sql = table.getMaxUpdateDateQuery();
            PreparedStatement statement = connection.prepareStatement(sql);
            try {
                ResultSet resultSet = statement.executeQuery();
                if (resultSet.next()) {
                    result = resultSet.getTimestamp(1);
                }
                statement.close();
            }
            finally {
                TuttiEntities.closeSilently(statement);
            }
        }
        return result;
    }

    public ResultSet getDataToUpdate(Connection connection, TuttiTableMetadata table, Date fromDate) throws SQLException {
        String sql = fromDate == null ? table.getDataToUpdateQueryWithNull() : table.getDataToUpdateQuery();
        PreparedStatement statement = connection.prepareStatement(sql);
        if (table.useUpdateDateColumn() && table.isWithUpdateDateColumn() && fromDate != null) {
            statement.setTimestamp(1, new Timestamp(fromDate.getTime()));
        }
        statement.setFetchSize(1000);
        ResultSet result = statement.executeQuery();
        return result;
    }

    public long getCountDataToUpdate(Connection connection, TuttiTableMetadata table, Date fromDate) throws SQLException {
        String sql = fromDate == null ? table.getCountDataToUpdateQueryWithNull() : table.getCountDataToUpdateQuery();
        PreparedStatement statement = connection.prepareStatement(sql);
        if (table.useUpdateDateColumn() && table.isWithUpdateDateColumn() && fromDate != null) {
            statement.setTimestamp(1, new Timestamp(fromDate.getTime()));
        }
        ResultSet queryResult = statement.executeQuery();
        queryResult.next();
        long result = queryResult.getLong(1);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<List<String>> getExistingPrimaryKeys(Connection connection, TuttiTableMetadata table) throws SQLException {
        Set<String> pkNames = table.getPkNames();
        int pkCount = pkNames.size();
        String sql = table.getExistingPrimaryKeysQuery();
        PreparedStatement statement = connection.prepareStatement(sql);
        HashSet result = Sets.newHashSet();
        try {
            ResultSet resultSet = statement.executeQuery();
            while (resultSet.next()) {
                ArrayList pk = Lists.newArrayListWithCapacity((int)pkCount);
                for (int i = 1; i <= pkCount; ++i) {
                    pk.add(String.valueOf(resultSet.getObject(i)));
                }
                result.add(pk);
            }
            statement.close();
            HashSet hashSet = result;
            return hashSet;
        }
        finally {
            TuttiEntities.closeSilently(statement);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long countTable(Connection connection, TuttiTableMetadata table) throws SQLException {
        String sql = table.getCountQuery();
        PreparedStatement statement = connection.prepareStatement(sql);
        try {
            ResultSet resultSet = statement.executeQuery();
            resultSet.next();
            long result = resultSet.getLong(1);
            statement.close();
            long l = result;
            return l;
        }
        finally {
            TuttiEntities.closeSilently(statement);
        }
    }

    protected List<String> getPk(ResultSet incomingData, int[] pkIndexs) throws SQLException {
        ArrayList result = Lists.newArrayListWithCapacity((int)pkIndexs.length);
        for (int pkIndex : pkIndexs) {
            Object pk = incomingData.getObject(pkIndex);
            result.add(pk == null ? null : String.valueOf(pk));
        }
        return result;
    }

    public void updateTable(Connection connection, TuttiTableMetadata table, Set<List<String>> existingIds, ResultSet incomingData, ReferentialSynchronizeResult result) throws SQLException {
        int columnCount = table.getColumnsCount();
        String tableName = table.getName();
        String tablePrefix = this.getTablePrefix(table) + " - " + result.getNbRows(tableName);
        int[] pkIndex = table.getPkIndexs();
        String insertSql = table.getInsertQuery();
        String updateSql = table.getUpdateQuery();
        PreparedStatement insertStatement = connection.prepareStatement(insertSql);
        PreparedStatement updateStatement = connection.prepareStatement(updateSql);
        result.addTableName(tableName);
        int countR = 0;
        int insertCount = 0;
        int updateCount = 0;
        while (incomingData.next()) {
            String sql;
            PreparedStatement statement;
            List<String> pk = this.getPk(incomingData, pkIndex);
            boolean doUpdate = existingIds.contains(pk);
            if (doUpdate) {
                statement = updateStatement;
                sql = updateSql;
                ++updateCount;
            } else {
                sql = insertSql;
                statement = insertStatement;
                ++insertCount;
            }
            for (int c = 1; c <= columnCount; ++c) {
                statement.setObject(c, incomingData.getObject(c));
            }
            if (doUpdate) {
                int columnCountIndex = columnCount + 1;
                for (String pkColumn : pk) {
                    statement.setObject(columnCountIndex++, pkColumn);
                }
            }
            if (log.isDebugEnabled()) {
                String pkAsString = pk.toString();
                log.debug((Object)String.format("%s Execute query %s (pk:%s)", tablePrefix, sql, pkAsString));
            }
            statement.addBatch();
            if (++countR % 1000 == 0) {
                result.getProgressionModel().increments(1000);
            }
            if (insertCount > 0 && insertCount % 1000 == 0) {
                insertStatement.executeBatch();
                insertStatement.clearBatch();
            }
            if (updateCount > 0 && updateCount % 1000 == 0) {
                updateStatement.executeBatch();
                updateStatement.clearBatch();
            }
            if (countR % 10000 != 0 || !log.isInfoEnabled()) continue;
            log.info((Object)String.format("%s Done: %s (inserts: %s, updates: %s)", tablePrefix, countR, insertCount, updateCount));
        }
        result.addInserts(tableName, insertCount);
        result.addUpdates(tableName, updateCount);
        if (log.isInfoEnabled()) {
            log.info((Object)String.format("%s done: %s (inserts: %s, updates: %s)", tablePrefix, countR, insertCount, updateCount));
        }
        if (insertCount > 0 && insertCount % 1000 != 0) {
            insertStatement.executeBatch();
        }
        if (updateCount > 0 && updateCount % 1000 != 0) {
            updateStatement.executeBatch();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("%s INSERT count: %s", tablePrefix, result.getNbInserts(tableName)));
            log.debug((Object)String.format("%s UPDATE count: %s", tablePrefix, result.getNbUpdates(tableName)));
        }
        result.getProgressionModel().increments(countR % 1000);
    }

    protected String getTablePrefix(TuttiTableMetadata table) {
        return "[" + table.getName() + "(" + IS_ASSOCIATION_TABLE.apply((Object)table) + ")]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void synchronizeTable(TuttiTableMetadata table, Connection localConnection, Connection remoteConnection, ReferentialSynchronizeResult result) throws SQLException {
        String tableName = table.getName();
        result.getProgressionModel().setMessage(I18n._((String)"tutti.persistence.synchronizeReferential.synchronizeTable", (Object[])new Object[]{tableName}));
        String tablePrefix = this.getTablePrefix(table);
        Timestamp updateDate = result.getUpdateDate(tableName);
        long countToUpdate = result.getNbRows(tableName);
        if (countToUpdate > 0L) {
            ResultSet dataToUpdate = this.getDataToUpdate(remoteConnection, table, updateDate);
            try {
                TuttiTable tuttiTable = TuttiTable.valueOf(tableName);
                if (tuttiTable.isAssociation()) {
                    PreparedStatement deleteStatement = localConnection.prepareStatement("DELETE FROM " + tableName);
                    deleteStatement.execute();
                    if (log.isInfoEnabled()) {
                        log.info((Object)(tablePrefix + " Delete association table"));
                    }
                }
                Set<List<String>> existingIds = this.getExistingPrimaryKeys(localConnection, table);
                if (log.isDebugEnabled()) {
                    log.debug((Object)(tablePrefix + " existingIds: " + existingIds.size()));
                }
                this.updateTable(localConnection, table, existingIds, dataToUpdate, result);
                dataToUpdate.close();
            }
            finally {
                JdbcUtils.closeResultSet((ResultSet)dataToUpdate);
            }
        }
    }

    public void prepareTable(TuttiTableMetadata table, Connection localConnection, Connection remoteConnection, ReferentialSynchronizeResult result) throws SQLException {
        String tablePrefix = this.getTablePrefix(table);
        String tableName = table.getName();
        Timestamp updateDate = this.getLastUpdateDate(localConnection, table);
        if (updateDate != null) {
            updateDate = new Timestamp(DateUtils.setMilliseconds((Date)updateDate, (int)0).getTime());
            updateDate = new Timestamp(DateUtils.addSeconds((Date)updateDate, (int)1).getTime());
        }
        long countToUpdate = this.getCountDataToUpdate(remoteConnection, table, updateDate);
        if (log.isInfoEnabled()) {
            log.info((Object)String.format("%s nb rows to update: %s", tablePrefix, countToUpdate));
        }
        result.setUpdateDate(tableName, updateDate);
        result.addRows(tableName, (int)countToUpdate);
    }

    public static void prepareSynch(Connection connection) throws SQLException {
        PreparedStatement statement = connection.prepareStatement("SET REFERENTIAL_INTEGRITY FALSE;");
        statement.executeUpdate();
    }

    public static void releaseSynch(Connection connection) throws SQLException {
        PreparedStatement statement = connection.prepareStatement("SET REFERENTIAL_INTEGRITY TRUE;");
        statement.executeUpdate();
    }
}

