/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.serialize;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Hashtable;
import org.apache.xerces.dom.DOMErrorImpl;
import org.apache.xerces.dom.DOMMessageFormatter;
import org.apache.xerces.dom3.DOMConfiguration;
import org.apache.xerces.dom3.DOMErrorHandler;
import org.apache.xerces.dom3.DOMStringList;
import org.apache.xerces.util.NamespaceSupport;
import org.apache.xerces.util.SymbolTable;
import org.apache.xml.serialize.XML11Serializer;
import org.apache.xml.serialize.XMLSerializer;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.ls.LSOutput;
import org.w3c.dom.ls.LSSerializer;
import org.w3c.dom.ls.LSSerializerFilter;

public class DOMSerializerImpl
implements LSSerializer,
DOMConfiguration {
    private XMLSerializer serializer = new XMLSerializer();
    private XML11Serializer xml11Serializer;

    public DOMSerializerImpl() {
        this.initSerializer(this.serializer);
    }

    public DOMConfiguration getConfig() {
        return this;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setParameter(String string, Object object) throws DOMException {
        if (this.serializer.fFeatures.containsKey(string)) {
            if (!(object instanceof Boolean)) {
                String string2 = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "TYPE_MISMATCH_ERR", new Object[]{string});
                throw new DOMException(8, string2);
            }
            boolean bl = (Boolean)object;
            if (string.equals("xml-declaration")) {
                this.serializer._format.setOmitXMLDeclaration(!bl);
                this.serializer.fFeatures.put(string, object);
                return;
            }
            if (string.equals("namespaces")) {
                this.serializer.fNamespaces = bl;
                this.serializer.fFeatures.put(string, object);
                return;
            }
            if (string.equals("split-cdata-sections") || string.equals("discard-default-content")) {
                this.serializer.fFeatures.put(string, object);
                return;
            }
            if (string.equals("canonical-form") || string.equals("validate-if-schema") || string.equals("validate") || string.equals("check-character-normalization") || string.equals("datatype-normalization") || string.equals("format-pretty-print") || string.equals("normalize-characters") || string.equals("well-formed")) {
                if (!bl) return;
                String string3 = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "FEATURE_NOT_SUPPORTED", new Object[]{string});
                throw new DOMException(9, string3);
            }
            if (!(string.equals("infoset") || string.equals("namespace-declarations") || string.equals("whitespace-in-element-content") || string.equals("ignore-unknown-character-denomalizations") || string.equals("entities") || string.equals("cdata-sections") || string.equals("comments"))) {
                String string4 = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "FEATURE_NOT_FOUND", new Object[]{string});
                throw new DOMException(9, string4);
            }
            if (bl) return;
            String string5 = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "FEATURE_NOT_SUPPORTED", new Object[]{string});
            throw new DOMException(9, string5);
        }
        if (string.equals("error-handler")) {
            if (object instanceof DOMErrorHandler) {
                this.serializer.fDOMErrorHandler = (DOMErrorHandler)object;
                return;
            }
            String string6 = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "TYPE_MISMATCH_ERR", new Object[]{string});
            throw new DOMException(8, string6);
        }
        if (!(string.equals("resource-resolver") || string.equals("schema-location") || string.equals("schema-type"))) {
            String string7 = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "FEATURE_NOT_FOUND", new Object[]{string});
            throw new DOMException(8, string7);
        }
        String string8 = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "FEATURE_NOT_SUPPORTED", new Object[]{string});
        throw new DOMException(9, string8);
    }

    public boolean canSetParameter(String string, Object object) {
        if (object instanceof Boolean) {
            boolean bl = (Boolean)object;
            if (string.equals("namespaces") || string.equals("split-cdata-sections") || string.equals("discard-default-content") || string.equals("xml-declaration")) {
                return true;
            }
            if (string.equals("canonical-form") || string.equals("validate-if-schema") || string.equals("validate") || string.equals("check-character-normalization") || string.equals("datatype-normalization") || string.equals("format-pretty-print") || string.equals("normalize-characters") || string.equals("well-formed")) {
                return !bl;
            }
            if (string.equals("infoset") || string.equals("namespace-declarations") || string.equals("whitespace-in-element-content") || string.equals("ignore-unknown-character-denomalizations") || string.equals("entities") || string.equals("cdata-sections") || string.equals("comments")) {
                return bl;
            }
        } else if (string.equals("error-handler")) {
            return true;
        }
        return false;
    }

    public DOMStringList getParameterNames() {
        return null;
    }

    public Object getParameter(String string) throws DOMException {
        Object v = this.serializer.fFeatures.get(string);
        if (v == null) {
            if (string.equals("error-handler")) {
                return this.serializer.fDOMErrorHandler;
            }
            if (string.equals("resource-resolver") || string.equals("schema-location") || string.equals("schema-type")) {
                String string2 = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "FEATURE_NOT_SUPPORTED", new Object[]{string});
                throw new DOMException(9, string2);
            }
            String string3 = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "FEATURE_NOT_FOUND", new Object[]{string});
            throw new DOMException(8, string3);
        }
        return (Boolean)v;
    }

    public String writeToString(Node node) throws DOMException {
        StringWriter stringWriter;
        block12: {
            Document document = node.getNodeType() == 9 ? (Document)node : node.getOwnerDocument();
            Method method = null;
            XMLSerializer xMLSerializer = null;
            String string = null;
            try {
                method = document.getClass().getMethod("getXmlVersion", new Class[0]);
                if (method != null) {
                    string = (String)method.invoke((Object)document, null);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (string != null && string.equals("1.1")) {
                if (this.xml11Serializer == null) {
                    this.xml11Serializer = new XML11Serializer();
                    this.initSerializer(this.xml11Serializer);
                }
                this.copySettings(this.serializer, this.xml11Serializer);
                xMLSerializer = this.xml11Serializer;
            } else {
                xMLSerializer = this.serializer;
            }
            this.checkAllFeatures(xMLSerializer);
            stringWriter = new StringWriter();
            try {
                xMLSerializer.reset();
                xMLSerializer.setOutputCharStream(stringWriter);
                if (node == null) {
                    return null;
                }
                if (node.getNodeType() == 9) {
                    xMLSerializer.serialize((Document)node);
                    break block12;
                }
                if (node.getNodeType() == 11) {
                    xMLSerializer.serialize((DocumentFragment)node);
                    break block12;
                }
                if (node.getNodeType() == 1) {
                    xMLSerializer.serialize((Element)node);
                    break block12;
                }
                return null;
            }
            catch (IOException iOException) {
                String string2 = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "STRING_TOO_LONG", new Object[]{iOException.getMessage()});
                throw new DOMException(2, string2);
            }
        }
        return stringWriter.toString();
    }

    public void setNewLine(String string) {
        this.serializer._format.setLineSeparator(string);
    }

    public String getNewLine() {
        return this.serializer._format.getLineSeparator();
    }

    public LSSerializerFilter getFilter() {
        return this.serializer.fDOMFilter;
    }

    public void setFilter(LSSerializerFilter lSSerializerFilter) {
        this.serializer.fDOMFilter = lSSerializerFilter;
    }

    private void checkAllFeatures(XMLSerializer xMLSerializer) {
        if (this.getParameter("whitespace-in-element-content") == Boolean.TRUE) {
            xMLSerializer._format.setPreserveSpace(true);
        } else {
            xMLSerializer._format.setPreserveSpace(false);
        }
    }

    private void initSerializer(XMLSerializer xMLSerializer) {
        xMLSerializer.fNamespaces = true;
        xMLSerializer.fNSBinder = new NamespaceSupport();
        xMLSerializer.fLocalNSBinder = new NamespaceSupport();
        xMLSerializer.fSymbolTable = new SymbolTable();
        xMLSerializer.fFeatures = new Hashtable();
        xMLSerializer.fFeatures.put("namespaces", Boolean.TRUE);
        xMLSerializer.fFeatures.put("normalize-characters", Boolean.FALSE);
        xMLSerializer.fFeatures.put("validate-if-schema", Boolean.FALSE);
        xMLSerializer.fFeatures.put("validate", Boolean.FALSE);
        xMLSerializer.fFeatures.put("entities", Boolean.TRUE);
        xMLSerializer.fFeatures.put("split-cdata-sections", Boolean.TRUE);
        xMLSerializer.fFeatures.put("cdata-sections", Boolean.TRUE);
        xMLSerializer.fFeatures.put("comments", Boolean.TRUE);
        xMLSerializer.fFeatures.put("whitespace-in-element-content", Boolean.TRUE);
        xMLSerializer.fFeatures.put("discard-default-content", Boolean.TRUE);
        xMLSerializer.fFeatures.put("canonical-form", Boolean.FALSE);
        xMLSerializer.fFeatures.put("format-pretty-print", Boolean.FALSE);
        xMLSerializer.fFeatures.put("xml-declaration", Boolean.TRUE);
        xMLSerializer.fFeatures.put("check-character-normalization", Boolean.FALSE);
        xMLSerializer.fFeatures.put("datatype-normalization", Boolean.FALSE);
        xMLSerializer.fFeatures.put("normalize-characters", Boolean.FALSE);
        xMLSerializer.fFeatures.put("well-formed", Boolean.FALSE);
        xMLSerializer.fFeatures.put("infoset", Boolean.FALSE);
        xMLSerializer.fFeatures.put("namespace-declarations", Boolean.TRUE);
        xMLSerializer.fFeatures.put("whitespace-in-element-content", Boolean.TRUE);
        xMLSerializer.fFeatures.put("ignore-unknown-character-denomalizations", Boolean.TRUE);
    }

    private void copySettings(XMLSerializer xMLSerializer, XMLSerializer xMLSerializer2) {
        xMLSerializer2._format.setOmitXMLDeclaration(xMLSerializer._format.getOmitXMLDeclaration());
        xMLSerializer2.fNamespaces = xMLSerializer.fNamespaces;
        xMLSerializer2.fDOMErrorHandler = xMLSerializer.fDOMErrorHandler;
        xMLSerializer2._format.setEncoding(xMLSerializer._format.getEncoding());
        xMLSerializer2._format.setLineSeparator(xMLSerializer._format.getLineSeparator());
        xMLSerializer2.fDOMFilter = xMLSerializer.fDOMFilter;
        Enumeration enumeration = xMLSerializer.fFeatures.keys();
        while (enumeration.hasMoreElements()) {
            Object k = enumeration.nextElement();
            Object v = xMLSerializer.fFeatures.get(k);
            xMLSerializer2.fFeatures.put(k, v);
        }
    }

    public boolean write(Node node, LSOutput lSOutput) {
        block28: {
            Object object;
            if (node == null) {
                return false;
            }
            Method method = null;
            XMLSerializer xMLSerializer = null;
            String string = null;
            Document document = node.getNodeType() == 9 ? (Document)node : node.getOwnerDocument();
            try {
                method = document.getClass().getMethod("getXmlVersion", new Class[0]);
                if (method != null) {
                    string = (String)method.invoke((Object)document, null);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (string != null && string.equals("1.1")) {
                if (this.xml11Serializer == null) {
                    this.xml11Serializer = new XML11Serializer();
                    this.initSerializer(this.xml11Serializer);
                }
                this.copySettings(this.serializer, this.xml11Serializer);
                xMLSerializer = this.xml11Serializer;
            } else {
                xMLSerializer = this.serializer;
            }
            this.checkAllFeatures(xMLSerializer);
            String string2 = null;
            string2 = lSOutput.getEncoding();
            if (string2 == null) {
                try {
                    object = document.getClass().getMethod("getActualEncoding", new Class[0]);
                    if (object != null) {
                        string2 = (String)((Method)object).invoke((Object)document, null);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (string2 == null) {
                    try {
                        object = document.getClass().getMethod("getXmlEncoding", new Class[0]);
                        if (object != null) {
                            string2 = (String)((Method)object).invoke((Object)document, null);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (string2 == null) {
                        string2 = "UTF-8";
                    }
                }
            }
            try {
                xMLSerializer.reset();
                this.serializer._format.setEncoding(string2);
                object = lSOutput.getByteStream();
                Writer writer = lSOutput.getCharacterStream();
                String string3 = lSOutput.getSystemId();
                if (writer == null) {
                    if (object == null) {
                        if (string3 == null) {
                            if (xMLSerializer.fDOMErrorHandler != null) {
                                DOMErrorImpl dOMErrorImpl = new DOMErrorImpl();
                                dOMErrorImpl.fType = "no-output-specified";
                                dOMErrorImpl.fMessage = "no-output-specified";
                                dOMErrorImpl.fSeverity = (short)3;
                                xMLSerializer.fDOMErrorHandler.handleError(dOMErrorImpl);
                            }
                            return false;
                        }
                        FileOutputStream fileOutputStream = new FileOutputStream(new File(string3));
                        xMLSerializer.setOutputCharStream(new OutputStreamWriter((OutputStream)fileOutputStream, string2));
                    } else {
                        xMLSerializer.setOutputByteStream((OutputStream)object);
                    }
                } else {
                    xMLSerializer.setOutputCharStream(writer);
                }
                if (node.getNodeType() == 9) {
                    xMLSerializer.serialize((Document)node);
                    break block28;
                }
                if (node.getNodeType() == 11) {
                    xMLSerializer.serialize((DocumentFragment)node);
                    break block28;
                }
                if (node.getNodeType() == 1) {
                    xMLSerializer.serialize((Element)node);
                    break block28;
                }
                return false;
            }
            catch (Exception exception) {
                if (xMLSerializer.fDOMErrorHandler != null) {
                    DOMErrorImpl dOMErrorImpl = new DOMErrorImpl();
                    dOMErrorImpl.fException = exception;
                    dOMErrorImpl.fMessage = exception.getMessage();
                    dOMErrorImpl.fSeverity = (short)2;
                    xMLSerializer.fDOMErrorHandler.handleError(dOMErrorImpl);
                }
                return false;
            }
        }
        return true;
    }

    public boolean writeToURI(Node node, String string) {
        block21: {
            Object object;
            if (node == null) {
                return false;
            }
            Method method = null;
            XMLSerializer xMLSerializer = null;
            String string2 = null;
            String string3 = null;
            Document document = node.getNodeType() == 9 ? (Document)node : node.getOwnerDocument();
            try {
                method = document.getClass().getMethod("getXmlVersion", new Class[0]);
                if (method != null) {
                    string2 = (String)method.invoke((Object)document, null);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (string2 != null && string2.equals("1.1")) {
                if (this.xml11Serializer == null) {
                    this.xml11Serializer = new XML11Serializer();
                    this.initSerializer(this.xml11Serializer);
                }
                this.copySettings(this.serializer, this.xml11Serializer);
                xMLSerializer = this.xml11Serializer;
            } else {
                xMLSerializer = this.serializer;
            }
            this.checkAllFeatures(xMLSerializer);
            try {
                object = document.getClass().getMethod("getActualEncoding", new Class[0]);
                if (object != null) {
                    string3 = (String)((Method)object).invoke((Object)document, null);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (string3 == null) {
                try {
                    object = document.getClass().getMethod("getXmlEncoding", new Class[0]);
                    if (object != null) {
                        string3 = (String)((Method)object).invoke((Object)document, null);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (string3 == null) {
                    string3 = "UTF-8";
                }
            }
            try {
                xMLSerializer.reset();
                object = new FileOutputStream(new File(string));
                xMLSerializer.setOutputCharStream(new OutputStreamWriter((OutputStream)object, string3));
                if (node.getNodeType() == 9) {
                    xMLSerializer.serialize((Document)node);
                    break block21;
                }
                if (node.getNodeType() == 11) {
                    xMLSerializer.serialize((DocumentFragment)node);
                    break block21;
                }
                if (node.getNodeType() == 1) {
                    xMLSerializer.serialize((Element)node);
                    break block21;
                }
                return false;
            }
            catch (Exception exception) {
                if (xMLSerializer.fDOMErrorHandler != null) {
                    DOMErrorImpl dOMErrorImpl = new DOMErrorImpl();
                    dOMErrorImpl.fException = exception;
                    dOMErrorImpl.fMessage = exception.getMessage();
                    dOMErrorImpl.fSeverity = (short)2;
                    xMLSerializer.fDOMErrorHandler.handleError(dOMErrorImpl);
                }
                return false;
            }
        }
        return true;
    }
}

