/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.dom;

import java.util.Vector;
import org.apache.xerces.dom.AttrImpl;
import org.apache.xerces.dom.AttributeMap;
import org.apache.xerces.dom.CoreDOMImplementationImpl;
import org.apache.xerces.dom.CoreDocumentImpl;
import org.apache.xerces.dom.DOMConfigurationImpl;
import org.apache.xerces.dom.DOMErrorImpl;
import org.apache.xerces.dom.DOMLocatorImpl;
import org.apache.xerces.dom.DocumentTypeImpl;
import org.apache.xerces.dom.ElementImpl;
import org.apache.xerces.dom.EntityReferenceImpl;
import org.apache.xerces.dom.PSVIAttrNSImpl;
import org.apache.xerces.dom.PSVIElementNSImpl;
import org.apache.xerces.dom.TextImpl;
import org.apache.xerces.dom3.DOMErrorHandler;
import org.apache.xerces.impl.RevalidationHandler;
import org.apache.xerces.impl.dv.XSSimpleType;
import org.apache.xerces.impl.xs.util.SimpleLocator;
import org.apache.xerces.util.AugmentationsImpl;
import org.apache.xerces.util.NamespaceSupport;
import org.apache.xerces.util.SymbolTable;
import org.apache.xerces.util.XML11Char;
import org.apache.xerces.util.XMLChar;
import org.apache.xerces.util.XMLSymbols;
import org.apache.xerces.xni.Augmentations;
import org.apache.xerces.xni.NamespaceContext;
import org.apache.xerces.xni.QName;
import org.apache.xerces.xni.XMLAttributes;
import org.apache.xerces.xni.XMLDocumentHandler;
import org.apache.xerces.xni.XMLLocator;
import org.apache.xerces.xni.XMLResourceIdentifier;
import org.apache.xerces.xni.XMLString;
import org.apache.xerces.xni.XNIException;
import org.apache.xerces.xni.parser.XMLComponent;
import org.apache.xerces.xni.parser.XMLDocumentSource;
import org.apache.xerces.xs.AttributePSVI;
import org.apache.xerces.xs.ElementPSVI;
import org.apache.xerces.xs.XSTypeDefinition;
import org.w3c.dom.Attr;
import org.w3c.dom.Comment;
import org.w3c.dom.Element;
import org.w3c.dom.Entity;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;

public class DOMNormalizer
implements XMLDocumentHandler {
    protected static final boolean DEBUG_ND = false;
    protected static final boolean DEBUG = false;
    protected static final boolean DEBUG_EVENTS = false;
    protected static final String PREFIX = "NS";
    protected DOMConfigurationImpl fConfiguration = null;
    protected CoreDocumentImpl fDocument = null;
    protected final XMLAttributesProxy fAttrProxy = new XMLAttributesProxy();
    protected final QName fQName = new QName();
    protected RevalidationHandler fValidationHandler;
    protected SymbolTable fSymbolTable;
    protected DOMErrorHandler fErrorHandler;
    private final DOMErrorImpl fError = new DOMErrorImpl();
    protected boolean fNamespaceValidation = false;
    protected boolean fPSVI = false;
    protected final NamespaceContext fNamespaceContext = new NamespaceSupport();
    protected final NamespaceContext fLocalNSBinder = new NamespaceSupport();
    protected final Vector fAttributeList = new Vector(5, 10);
    protected final DOMLocatorImpl fLocator = new DOMLocatorImpl();
    protected Node fCurrentNode = null;
    private QName fAttrQName = new QName();
    final XMLString fNormalizedValue = new XMLString(new char[16], 0, 0);
    private static final RuntimeException abort = new RuntimeException();

    protected void normalizeDocument(CoreDocumentImpl coreDocumentImpl, DOMConfigurationImpl dOMConfigurationImpl) {
        this.fDocument = coreDocumentImpl;
        this.fConfiguration = dOMConfigurationImpl;
        this.fSymbolTable = (SymbolTable)this.fConfiguration.getProperty("http://apache.org/xml/properties/internal/symbol-table");
        this.fNamespaceContext.reset();
        this.fNamespaceContext.declarePrefix(XMLSymbols.EMPTY_STRING, XMLSymbols.EMPTY_STRING);
        if ((this.fConfiguration.features & 0x40) != 0) {
            this.fValidationHandler = CoreDOMImplementationImpl.singleton.getValidator("http://www.w3.org/2001/XMLSchema");
            this.fConfiguration.setFeature("http://xml.org/sax/features/validation", true);
            this.fConfiguration.setFeature("http://apache.org/xml/features/validation/schema", true);
            this.fNamespaceValidation = true;
            this.fPSVI = (this.fConfiguration.features & 0x80) != 0;
            this.fDocument.clearIdentifiers();
            ((XMLComponent)((Object)this.fValidationHandler)).reset(this.fConfiguration);
        }
        this.fErrorHandler = (DOMErrorHandler)this.fConfiguration.getParameter("error-handler");
        if (this.fValidationHandler != null) {
            this.fValidationHandler.setDocumentHandler(this);
            this.fValidationHandler.startDocument(new SimpleLocator(this.fDocument.fDocumentURI, this.fDocument.fDocumentURI, -1, -1), this.fDocument.encoding, this.fNamespaceContext, null);
        }
        try {
            Node node = this.fDocument.getFirstChild();
            while (node != null) {
                Node node2 = node.getNextSibling();
                if ((node = this.normalizeNode(node)) != null) {
                    node2 = node;
                }
                node = node2;
            }
            if (this.fValidationHandler != null) {
                this.fValidationHandler.endDocument(null);
                CoreDOMImplementationImpl.singleton.releaseValidator("http://www.w3.org/2001/XMLSchema", this.fValidationHandler);
                this.fValidationHandler = null;
            }
        }
        catch (RuntimeException runtimeException) {
            if (runtimeException == abort) {
                return;
            }
            throw runtimeException;
        }
    }

    /*
     * Unable to fully structure code
     */
    protected Node normalizeNode(Node var1_1) {
        var2_2 = var1_1.getNodeType();
        switch (var2_2) {
            case 10: {
                if ((this.fConfiguration.features & 4) != 0) break;
                ((DocumentTypeImpl)var1_1).entities.removeAll();
                break;
            }
            case 1: {
                if ((this.fConfiguration.features & 256) != 0 && this.fDocument.isXMLVersionChanged()) {
                    if (this.fNamespaceValidation) {
                        this.fDocument.checkQName(var1_1.getPrefix(), var1_1.getLocalName());
                    } else {
                        this.fDocument.isXMLName(var1_1.getNodeName(), this.fDocument.isXML11Version());
                    }
                }
                this.fNamespaceContext.pushContext();
                this.fLocalNSBinder.reset();
                var3_3 = (ElementImpl)var1_1;
                if (var3_3.needsSyncChildren()) {
                    var3_3.synchronizeChildren();
                }
                v0 = var4_9 = var3_3.hasAttributes() != false ? (AttributeMap)var3_3.getAttributes() : null;
                if (var4_9 != null) {
                    var5_15 = 0;
                    while (var5_15 < var4_9.getLength()) {
                        var6_20 = (Attr)var4_9.item(var5_15);
                        var7_22 = var6_20.getChildNodes();
                        var8_23 = 0;
                        while (var8_23 < var7_22.getLength()) {
                            var9_24 = var7_22.item(var8_23);
                            if (var9_24.getNodeType() == 5) {
                                var10_25 = var6_20.getOwnerDocument();
                                var11_26 = null;
                                if (var10_25 != null && (var12_27 = var10_25.getDoctype()) != null) {
                                    var13_28 = var12_27.getEntities();
                                    var11_26 = (Entity)var13_28.getNamedItemNS("*", var9_24.getNodeName());
                                }
                                if (var11_26 == null && this.fErrorHandler != null) {
                                    this.reportDOMError("The attribute " + var6_20.getNodeName() + " value '" + var9_24.getNodeValue() + "' referenced an entity that was not declared", (short)3, var6_20, null);
                                }
                            }
                            ++var8_23;
                        }
                        ++var5_15;
                    }
                }
                if ((this.fConfiguration.features & 1) != 0) {
                    this.namespaceFixUp(var3_3, var4_9);
                } else if (var4_9 != null) {
                    var5_15 = 0;
                    while (var5_15 < var4_9.getLength()) {
                        var6_20 = (Attr)var4_9.item(var5_15);
                        var6_20.normalize();
                        if ((this.fConfiguration.features & 256) != 0 && this.fDocument.isXMLVersionChanged()) {
                            this.fDocument.isXMLName(var1_1.getNodeName(), this.fDocument.isXML11Version());
                        }
                        ++var5_15;
                    }
                }
                if (this.fValidationHandler != null) {
                    this.fAttrProxy.setAttributes(var4_9, this.fDocument, var3_3);
                    this.updateQName(var3_3, this.fQName);
                    this.fConfiguration.fErrorHandlerWrapper.fCurrentNode = var1_1;
                    this.fCurrentNode = var1_1;
                    this.fValidationHandler.startElement(this.fQName, this.fAttrProxy, null);
                }
                var5_16 = var3_3.getFirstChild();
                while (var5_16 != null) {
                    var6_20 = var5_16.getNextSibling();
                    if ((var5_16 = this.normalizeNode(var5_16)) != null) {
                        var6_20 = var5_16;
                    }
                    var5_16 = var6_20;
                }
                if (this.fValidationHandler != null) {
                    this.updateQName(var3_3, this.fQName);
                    this.fConfiguration.fErrorHandlerWrapper.fCurrentNode = var1_1;
                    this.fCurrentNode = var1_1;
                    this.fValidationHandler.endElement(this.fQName, null);
                }
                this.fNamespaceContext.popContext();
                break;
            }
            case 8: {
                if ((this.fConfiguration.features & 32) != 0) ** GOTO lbl85
                var3_4 = var1_1.getPreviousSibling();
                var4_10 = var1_1.getParentNode();
                var4_10.removeChild(var1_1);
                if (var3_4 != null && var3_4.getNodeType() == 3 && (var5_17 = var3_4.getNextSibling()) != null && var5_17.getNodeType() == 3) {
                    ((TextImpl)var5_17).insertData(0, var3_4.getNodeValue());
                    var4_10.removeChild((Node)var3_4);
                    return var5_17;
                }
                ** GOTO lbl88
lbl85:
                // 1 sources

                if ((this.fConfiguration.features & 256) != 0) {
                    var3_4 = ((Comment)var1_1).getData();
                    this.checkInValidXMLCharacters((String)var3_4, this.fDocument.isXML11Version());
                }
            }
lbl88:
            // 5 sources

            case 5: {
                if ((this.fConfiguration.features & 256) != 0 && this.fDocument.isXMLVersionChanged()) {
                    this.fDocument.isXMLName(var1_1.getNodeName(), this.fDocument.isXML11Version());
                }
                if ((this.fConfiguration.features & 4) != 0) break;
                var3_4 = var1_1.getPreviousSibling();
                var4_10 = var1_1.getParentNode();
                ((EntityReferenceImpl)var1_1).setReadOnly(false, true);
                this.expandEntityRef(var1_1, var4_10, var1_1);
                var4_10.removeChild(var1_1);
                v1 = var5_17 = var3_4 != null ? var3_4.getNextSibling() : var4_10.getFirstChild();
                if (var3_4 != null && var3_4.getNodeType() == 3 && var5_17.getNodeType() == 3) {
                    return var3_4;
                }
                return var5_17;
            }
            case 4: {
                if ((this.fConfiguration.features & 256) != 0) {
                    this.checkInValidXMLCharacters(var1_1.getNodeValue(), this.fDocument.isXML11Version());
                }
                if ((this.fConfiguration.features & 8) == 0) {
                    var3_5 = this.fDocument.createTextNode(var1_1.getNodeValue());
                    var4_11 = var1_1.getParentNode();
                    var5_18 = var1_1.getPreviousSibling();
                    var1_1 = var4_11.replaceChild(var3_5, var1_1);
                    if (var5_18 != null && var5_18.getNodeType() == 3) {
                        var3_5.insertData(0, var5_18.getNodeValue());
                        var4_11.removeChild(var5_18);
                    }
                    return var3_5;
                }
                if (this.fValidationHandler != null) {
                    this.fConfiguration.fErrorHandlerWrapper.fCurrentNode = var1_1;
                    this.fCurrentNode = var1_1;
                    this.fValidationHandler.startCDATA(null);
                    this.fValidationHandler.characterData(var1_1.getNodeValue(), null);
                    this.fValidationHandler.endCDATA(null);
                }
                if ((this.fConfiguration.features & 16) == 0) break;
                var3_6 = var1_1.getNodeValue();
                var5_19 = var1_1.getParentNode();
                while ((var4_12 = var3_6.indexOf("]]>")) >= 0) {
                    var1_1.setNodeValue(var3_6.substring(0, var4_12 + 2));
                    var3_6 = var3_6.substring(var4_12 + 2);
                    var6_21 = this.fDocument.createCDATASection(var3_6);
                    var5_19.insertBefore(var6_21, var1_1.getNextSibling());
                    var1_1 = var6_21;
                    this.reportDOMError("CDATA sections containing the CDATA section termination marker ']]>'", (short)1, var1_1, "cdata-sections-splitted");
                }
                break;
            }
            case 3: {
                var3_7 = var1_1.getNextSibling();
                if (var3_7 != null && var3_7.getNodeType() == 3) {
                    ((Text)var1_1).appendData(var3_7.getNodeValue());
                    var1_1.getParentNode().removeChild(var3_7);
                    if ((this.fConfiguration.features & 256) != 0) {
                        this.checkInValidXMLCharacters(var1_1.getNodeValue(), this.fDocument.isXML11Version());
                    }
                    return var1_1;
                }
                if (var1_1.getNodeValue().length() == 0) {
                    var1_1.getParentNode().removeChild(var1_1);
                    break;
                }
                if ((this.fConfiguration.features & 256) != 0) {
                    this.checkInValidXMLCharacters(var1_1.getNodeValue(), this.fDocument.isXML11Version());
                }
                if (this.fValidationHandler == null) break;
                v2 = var4_13 = var3_7 != null ? (int)var3_7.getNodeType() : -1;
                if ((this.fConfiguration.features & 4) == 0 && var4_13 == 6 || (this.fConfiguration.features & 32) == 0 && var4_13 == 8 || (this.fConfiguration.features & 8) == 0 && var4_13 == 4) break;
                this.fConfiguration.fErrorHandlerWrapper.fCurrentNode = var1_1;
                this.fCurrentNode = var1_1;
                this.fValidationHandler.characterData(var1_1.getNodeValue(), null);
                break;
            }
            case 7: {
                if ((this.fConfiguration.features & 256) == 0) break;
                var3_8 = (ProcessingInstruction)var1_1;
                var4_14 = var3_8.getTarget();
                if (this.fDocument.isXML11Version()) {
                    if (!XML11Char.isXML11ValidName(var4_14)) {
                        this.reportDOMError("Invalid Character in node name", (short)3, var1_1, "wf-invalid-character-in-node-name");
                    }
                } else if (!XMLChar.isValidName(var4_14)) {
                    this.reportDOMError("Invalid Character in node name", (short)3, var1_1, "wf-invalid-character-in-node-name");
                }
                this.checkInValidXMLCharacters(var3_8.getData(), this.fDocument.isXML11Version());
            }
        }
        return null;
    }

    protected final void expandEntityRef(Node node, Node node2, Node node3) {
        Node node4 = node.getFirstChild();
        while (node4 != null) {
            Node node5 = node4.getNextSibling();
            if (node.getNodeType() == 3) {
                this.expandEntityRef(node4, node2, node3);
            } else {
                node2.insertBefore(node4, node3);
            }
            node4 = node5;
        }
    }

    protected final void namespaceFixUp(ElementImpl elementImpl, AttributeMap attributeMap) {
        String string;
        String string2;
        String string3;
        String string4;
        Attr attr;
        int n;
        if (attributeMap != null) {
            n = 0;
            while (n < attributeMap.getLength()) {
                attr = (Attr)attributeMap.getItem(n);
                if ((this.fConfiguration.features & 0x100) != 0 && this.fDocument.isXMLVersionChanged()) {
                    this.fDocument.checkQName(attr.getPrefix(), attr.getLocalName());
                }
                if ((string4 = attr.getNamespaceURI()) != null && string4.equals(NamespaceContext.XMLNS_URI)) {
                    string3 = attr.getNodeValue();
                    if (string3 == null) {
                        string3 = XMLSymbols.EMPTY_STRING;
                    }
                    if (string3.equals(NamespaceContext.XMLNS_URI)) {
                        this.reportDOMError("No prefix other than 'xmlns' can be bound to 'http://www.w3.org/2000/xmlns/' namespace name", (short)2, attr, null);
                    } else {
                        string2 = attr.getPrefix();
                        string2 = string2 == null || string2.length() == 0 ? XMLSymbols.EMPTY_STRING : this.fSymbolTable.addSymbol(string2);
                        string = this.fSymbolTable.addSymbol(attr.getLocalName());
                        if (string2 == XMLSymbols.PREFIX_XMLNS) {
                            if ((string3 = this.fSymbolTable.addSymbol(string3)).length() != 0) {
                                this.fNamespaceContext.declarePrefix(string, string3);
                            }
                        } else {
                            string3 = this.fSymbolTable.addSymbol(string3);
                            this.fNamespaceContext.declarePrefix(XMLSymbols.EMPTY_STRING, string3);
                        }
                    }
                }
                ++n;
            }
        }
        string4 = elementImpl.getNamespaceURI();
        string2 = elementImpl.getPrefix();
        if (string4 != null) {
            string4 = this.fSymbolTable.addSymbol(string4);
            String string5 = string2 = string2 == null || string2.length() == 0 ? XMLSymbols.EMPTY_STRING : this.fSymbolTable.addSymbol(string2);
            if (this.fNamespaceContext.getURI(string2) != string4) {
                this.addNamespaceDecl(string2, string4, elementImpl);
                this.fLocalNSBinder.declarePrefix(string2, string4);
                this.fNamespaceContext.declarePrefix(string2, string4);
            }
        } else if (elementImpl.getLocalName() == null) {
            if (this.fNamespaceValidation) {
                this.reportDOMError("DOM Level 1 node: " + elementImpl.getNodeName(), (short)3, elementImpl, null);
            } else {
                this.reportDOMError("DOM Level 1 node: " + elementImpl.getNodeName(), (short)2, elementImpl, null);
            }
        } else {
            string4 = this.fNamespaceContext.getURI(XMLSymbols.EMPTY_STRING);
            if (string4 != null && string4.length() > 0) {
                this.addNamespaceDecl(XMLSymbols.EMPTY_STRING, XMLSymbols.EMPTY_STRING, elementImpl);
                this.fLocalNSBinder.declarePrefix(XMLSymbols.EMPTY_STRING, XMLSymbols.EMPTY_STRING);
                this.fNamespaceContext.declarePrefix(XMLSymbols.EMPTY_STRING, XMLSymbols.EMPTY_STRING);
            }
        }
        if (attributeMap != null) {
            attributeMap.cloneMap(this.fAttributeList);
            n = 0;
            while (n < this.fAttributeList.size()) {
                attr = (Attr)this.fAttributeList.elementAt(n);
                attr.normalize();
                string3 = attr.getValue();
                String string6 = attr.getNodeName();
                string4 = attr.getNamespaceURI();
                if (string3 == null) {
                    string3 = XMLSymbols.EMPTY_STRING;
                }
                if (string4 != null) {
                    string2 = attr.getPrefix();
                    string2 = string2 == null || string2.length() == 0 ? XMLSymbols.EMPTY_STRING : this.fSymbolTable.addSymbol(string2);
                    this.fSymbolTable.addSymbol(attr.getLocalName());
                    if (string4 == null || !string4.equals(NamespaceContext.XMLNS_URI)) {
                        ((AttrImpl)attr).setIdAttribute(false);
                        string4 = this.fSymbolTable.addSymbol(string4);
                        string = this.fNamespaceContext.getURI(string2);
                        if (string2 == XMLSymbols.EMPTY_STRING || string != string4) {
                            string6 = attr.getNodeName();
                            String string7 = this.fNamespaceContext.getPrefix(string4);
                            if (string7 != null && string7 != XMLSymbols.EMPTY_STRING) {
                                string2 = string7;
                            } else {
                                if (string2 == XMLSymbols.EMPTY_STRING || this.fLocalNSBinder.getURI(string2) != null) {
                                    int n2 = 1;
                                    string2 = this.fSymbolTable.addSymbol(PREFIX + n2++);
                                    while (this.fLocalNSBinder.getURI(string2) != null) {
                                        string2 = this.fSymbolTable.addSymbol(PREFIX + n2++);
                                    }
                                }
                                this.addNamespaceDecl(string2, string4, elementImpl);
                                string3 = this.fSymbolTable.addSymbol(string3);
                                this.fLocalNSBinder.declarePrefix(string2, string3);
                                this.fNamespaceContext.declarePrefix(string2, string4);
                            }
                            attr.setPrefix(string2);
                        }
                    }
                } else {
                    ((AttrImpl)attr).setIdAttribute(false);
                    if (attr.getLocalName() == null) {
                        if (this.fNamespaceValidation) {
                            this.reportDOMError("DOM Level 1 node: " + string6, (short)3, attr, null);
                        } else {
                            this.reportDOMError("DOM Level 1 node: " + string6, (short)2, attr, null);
                        }
                    }
                }
                ++n;
            }
        }
    }

    public void checkInValidXMLCharacters(String string, boolean bl) {
        if (string == null || string.length() == 0) {
            return;
        }
        char[] cArray = string.toCharArray();
        int n = cArray.length;
        if (bl) {
            int n2 = 0;
            while (n2 < n) {
                if (!XML11Char.isXML11Invalid(cArray[n2++])) continue;
                String string2 = "Invalid XML Character '" + Integer.toString(cArray[n2 - 1], 16) + "'" + "in the DOM.";
                this.reportDOMError(string2, (short)3, null, "wf-invalid-character");
            }
        } else {
            int n3 = 0;
            while (n3 < n) {
                if (!XMLChar.isInvalid(cArray[n3++])) continue;
                String string3 = "Invalid XML Character '" + Integer.toString(cArray[n3 - 1], 16) + "'" + "in the DOM.";
                this.reportDOMError(string3, (short)3, null, "wf-invalid-character");
            }
        }
    }

    protected final void addNamespaceDecl(String string, String string2, ElementImpl elementImpl) {
        if (string == XMLSymbols.EMPTY_STRING) {
            elementImpl.setAttributeNS(NamespaceContext.XMLNS_URI, XMLSymbols.PREFIX_XMLNS, string2);
        } else {
            elementImpl.setAttributeNS(NamespaceContext.XMLNS_URI, "xmlns:" + string, string2);
        }
    }

    protected final void reportDOMError(String string, short s, Node node, String string2) {
        if (this.fErrorHandler != null) {
            this.fError.reset();
            this.fError.fMessage = string;
            this.fError.fSeverity = s;
            this.fError.fLocator = this.fLocator;
            this.fError.fType = string2;
            this.fLocator.fRelatedNode = node;
            if (!this.fErrorHandler.handleError(this.fError)) {
                throw abort;
            }
        }
        if (s == 3) {
            throw abort;
        }
    }

    protected final void updateQName(Node node, QName qName) {
        String string = node.getPrefix();
        String string2 = node.getNamespaceURI();
        String string3 = node.getLocalName();
        qName.prefix = string != null && string.length() != 0 ? this.fSymbolTable.addSymbol(string) : null;
        qName.localpart = string3 != null ? this.fSymbolTable.addSymbol(string3) : null;
        qName.rawname = this.fSymbolTable.addSymbol(node.getNodeName());
        qName.uri = string2 != null ? this.fSymbolTable.addSymbol(string2) : null;
    }

    final String normalizeAttributeValue(String string, Attr attr) {
        if (!attr.getSpecified()) {
            return string;
        }
        int n = string.length();
        if (this.fNormalizedValue.ch.length < n) {
            this.fNormalizedValue.ch = new char[n];
        }
        this.fNormalizedValue.length = 0;
        boolean bl = false;
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            if (c == '\t' || c == '\n') {
                this.fNormalizedValue.ch[this.fNormalizedValue.length++] = 32;
                bl = true;
            } else if (c == '\r') {
                bl = true;
                this.fNormalizedValue.ch[this.fNormalizedValue.length++] = 32;
                int n3 = n2 + 1;
                if (n3 < n && string.charAt(n3) == '\n') {
                    n2 = n3;
                }
            } else {
                this.fNormalizedValue.ch[this.fNormalizedValue.length++] = c;
            }
            ++n2;
        }
        if (bl) {
            string = this.fNormalizedValue.toString();
            attr.setValue(string);
        }
        return string;
    }

    public void startDocument(XMLLocator xMLLocator, String string, NamespaceContext namespaceContext, Augmentations augmentations) throws XNIException {
    }

    public void xmlDecl(String string, String string2, String string3, Augmentations augmentations) throws XNIException {
    }

    public void doctypeDecl(String string, String string2, String string3, Augmentations augmentations) throws XNIException {
    }

    public void comment(XMLString xMLString, Augmentations augmentations) throws XNIException {
    }

    public void processingInstruction(String string, XMLString xMLString, Augmentations augmentations) throws XNIException {
    }

    public void startElement(QName qName, XMLAttributes xMLAttributes, Augmentations augmentations) throws XNIException {
        Element element = (Element)this.fCurrentNode;
        int n = xMLAttributes.getLength();
        int n2 = 0;
        while (n2 < n) {
            xMLAttributes.getName(n2, this.fAttrQName);
            Attr attr = null;
            attr = element.getAttributeNodeNS(this.fAttrQName.uri, this.fAttrQName.localpart);
            AttributePSVI attributePSVI = (AttributePSVI)xMLAttributes.getAugmentations(n2).getItem("ATTRIBUTE_PSVI");
            if (attributePSVI != null) {
                XSTypeDefinition xSTypeDefinition = attributePSVI.getMemberTypeDefinition();
                boolean bl = false;
                if (xSTypeDefinition != null) {
                    bl = ((XSSimpleType)xSTypeDefinition).isIDType();
                } else {
                    xSTypeDefinition = attributePSVI.getTypeDefinition();
                    if (xSTypeDefinition != null) {
                        bl = ((XSSimpleType)xSTypeDefinition).isIDType();
                    }
                }
                if (bl) {
                    ((ElementImpl)element).setIdAttributeNode(attr, true);
                }
                if (this.fPSVI) {
                    ((PSVIAttrNSImpl)attr).setPSVI(attributePSVI);
                }
                if ((this.fConfiguration.features & 2) != 0) {
                    boolean bl2 = attr.getSpecified();
                    attr.setValue(attributePSVI.getSchemaNormalizedValue());
                    if (!bl2) {
                        ((AttrImpl)attr).setSpecified(bl2);
                    }
                }
            }
            ++n2;
        }
    }

    public void emptyElement(QName qName, XMLAttributes xMLAttributes, Augmentations augmentations) throws XNIException {
        this.startElement(qName, xMLAttributes, augmentations);
        this.endElement(qName, augmentations);
    }

    public void startGeneralEntity(String string, XMLResourceIdentifier xMLResourceIdentifier, String string2, Augmentations augmentations) throws XNIException {
    }

    public void textDecl(String string, String string2, Augmentations augmentations) throws XNIException {
    }

    public void endGeneralEntity(String string, Augmentations augmentations) throws XNIException {
    }

    public void characters(XMLString xMLString, Augmentations augmentations) throws XNIException {
    }

    public void ignorableWhitespace(XMLString xMLString, Augmentations augmentations) throws XNIException {
    }

    public void endElement(QName qName, Augmentations augmentations) throws XNIException {
        ElementPSVI elementPSVI = (ElementPSVI)augmentations.getItem("ELEMENT_PSVI");
        if (elementPSVI != null) {
            ElementImpl elementImpl = (ElementImpl)this.fCurrentNode;
            if (this.fPSVI) {
                ((PSVIElementNSImpl)this.fCurrentNode).setPSVI(elementPSVI);
            }
            String string = elementPSVI.getSchemaNormalizedValue();
            if ((this.fConfiguration.features & 2) != 0) {
                if (string != null) {
                    elementImpl.setTextContent(string);
                }
            } else {
                String string2 = elementImpl.getTextContent();
                if (string2.length() == 0 && string != null) {
                    elementImpl.setTextContent(string);
                }
            }
        }
    }

    public void startCDATA(Augmentations augmentations) throws XNIException {
    }

    public void endCDATA(Augmentations augmentations) throws XNIException {
    }

    public void endDocument(Augmentations augmentations) throws XNIException {
    }

    public void setDocumentSource(XMLDocumentSource xMLDocumentSource) {
    }

    public XMLDocumentSource getDocumentSource() {
        return null;
    }

    protected final class XMLAttributesProxy
    implements XMLAttributes {
        protected AttributeMap fAttributes;
        protected CoreDocumentImpl fDocument;
        protected ElementImpl fElement;
        protected final Vector fAugmentations = new Vector(5);

        protected XMLAttributesProxy() {
        }

        public void setAttributes(AttributeMap attributeMap, CoreDocumentImpl coreDocumentImpl, ElementImpl elementImpl) {
            this.fDocument = coreDocumentImpl;
            this.fAttributes = attributeMap;
            this.fElement = elementImpl;
            if (attributeMap != null) {
                int n = attributeMap.getLength();
                this.fAugmentations.setSize(n);
                int n2 = 0;
                while (n2 < n) {
                    this.fAugmentations.setElementAt(new AugmentationsImpl(), n2);
                    ++n2;
                }
            } else {
                this.fAugmentations.setSize(0);
            }
        }

        public int addAttribute(QName qName, String string, String string2) {
            int n = this.fElement.getXercesAttribute(qName.uri, qName.localpart);
            if (n < 0) {
                AttrImpl attrImpl = (AttrImpl)((CoreDocumentImpl)this.fElement.getOwnerDocument()).createAttributeNS(qName.uri, qName.rawname, qName.localpart);
                n = this.fElement.setXercesAttributeNode(attrImpl);
                attrImpl.setNodeValue(string2);
                this.fAugmentations.insertElementAt(new AugmentationsImpl(), n);
                attrImpl.setSpecified(false);
            }
            return n;
        }

        public void removeAllAttributes() {
        }

        public void removeAttributeAt(int n) {
        }

        public int getLength() {
            return this.fAttributes != null ? this.fAttributes.getLength() : 0;
        }

        public int getIndex(String string) {
            return -1;
        }

        public int getIndex(String string, String string2) {
            return -1;
        }

        public void setName(int n, QName qName) {
        }

        public void getName(int n, QName qName) {
            if (this.fAttributes != null) {
                DOMNormalizer.this.updateQName((Node)this.fAttributes.getItem(n), qName);
            }
        }

        public String getPrefix(int n) {
            return null;
        }

        public String getURI(int n) {
            return null;
        }

        public String getLocalName(int n) {
            return null;
        }

        public String getQName(int n) {
            return null;
        }

        public void setType(int n, String string) {
        }

        public String getType(int n) {
            return "CDATA";
        }

        public String getType(String string) {
            return "CDATA";
        }

        public String getType(String string, String string2) {
            return "CDATA";
        }

        public void setValue(int n, String string) {
            if (this.fAttributes != null) {
                AttrImpl attrImpl = (AttrImpl)this.fAttributes.getItem(n);
                boolean bl = attrImpl.getSpecified();
                attrImpl.setValue(string);
                attrImpl.setSpecified(bl);
            }
        }

        public String getValue(int n) {
            return this.fAttributes != null ? this.fAttributes.item(n).getNodeValue() : "";
        }

        public String getValue(String string) {
            return null;
        }

        public String getValue(String string, String string2) {
            if (this.fAttributes != null) {
                Node node = this.fAttributes.getNamedItemNS(string, string2);
                return node != null ? node.getNodeValue() : null;
            }
            return null;
        }

        public void setNonNormalizedValue(int n, String string) {
        }

        public String getNonNormalizedValue(int n) {
            return null;
        }

        public void setSpecified(int n, boolean bl) {
            AttrImpl attrImpl = (AttrImpl)this.fAttributes.getItem(n);
            attrImpl.setSpecified(bl);
        }

        public boolean isSpecified(int n) {
            return ((Attr)this.fAttributes.getItem(n)).getSpecified();
        }

        public Augmentations getAugmentations(int n) {
            return (Augmentations)this.fAugmentations.elementAt(n);
        }

        public Augmentations getAugmentations(String string, String string2) {
            return null;
        }

        public Augmentations getAugmentations(String string) {
            return null;
        }

        public void setAugmentations(int n, Augmentations augmentations) {
            this.fAugmentations.setElementAt(augmentations, n);
        }
    }
}

