/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.mapping;

import java.util.Iterator;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.Mapping;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Constraint;
import org.hibernate.mapping.Index;
import org.hibernate.util.StringHelper;

public class UniqueKey
extends Constraint {
    public String sqlConstraintString(Dialect dialect) {
        StringBuffer buf = new StringBuffer("unique (");
        boolean hadNullableColumn = false;
        Iterator iter = this.getColumnIterator();
        while (iter.hasNext()) {
            Column column = (Column)iter.next();
            if (!hadNullableColumn && column.isNullable()) {
                hadNullableColumn = true;
            }
            buf.append(column.getQuotedName(dialect));
            if (!iter.hasNext()) continue;
            buf.append(", ");
        }
        return !hadNullableColumn || dialect.supportsNotNullUnique() ? buf.append(')').toString() : null;
    }

    public String sqlConstraintString(Dialect dialect, String constraintName, String defaultCatalog, String defaultSchema) {
        StringBuffer buf = new StringBuffer(dialect.getAddPrimaryKeyConstraintString(constraintName)).append('(');
        Iterator iter = this.getColumnIterator();
        boolean nullable = false;
        while (iter.hasNext()) {
            Column column = (Column)iter.next();
            if (!nullable && column.isNullable()) {
                nullable = true;
            }
            buf.append(column.getQuotedName(dialect));
            if (!iter.hasNext()) continue;
            buf.append(", ");
        }
        return !nullable || dialect.supportsNotNullUnique() ? StringHelper.replace(buf.append(')').toString(), "primary key", "unique") : null;
    }

    public String sqlCreateString(Dialect dialect, Mapping p, String defaultCatalog, String defaultSchema) {
        if (dialect.supportsUniqueConstraintInCreateAlterTable()) {
            return super.sqlCreateString(dialect, p, defaultCatalog, defaultSchema);
        }
        return Index.buildSqlCreateIndexString(dialect, this.getName(), this.getTable(), this.getColumnIterator(), true, defaultCatalog, defaultSchema);
    }

    public String sqlDropString(Dialect dialect, String defaultCatalog, String defaultSchema) {
        if (dialect.supportsUniqueConstraintInCreateAlterTable()) {
            return super.sqlDropString(dialect, defaultCatalog, defaultSchema);
        }
        return Index.buildSqlDropIndexString(dialect, this.getTable(), this.getName(), defaultCatalog, defaultSchema);
    }

    public boolean isGenerated(Dialect dialect) {
        if (dialect.supportsNotNullUnique()) {
            return true;
        }
        Iterator iter = this.getColumnIterator();
        while (iter.hasNext()) {
            if (!((Column)iter.next()).isNullable()) continue;
            return false;
        }
        return true;
    }
}

