/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.db;

import fr.ifremer.tutti.TuttiBusinessException;
import fr.ifremer.tutti.persistence.ProgressionModel;
import fr.ifremer.tutti.persistence.config.TuttiPersistenceConfig;
import fr.ifremer.tutti.service.PersistenceService;
import fr.ifremer.tutti.ui.swing.TuttiScreen;
import fr.ifremer.tutti.ui.swing.content.AbstractChangeScreenAction;
import fr.ifremer.tutti.ui.swing.content.MainUI;
import fr.ifremer.tutti.ui.swing.content.MainUIHandler;
import fr.ifremer.tutti.ui.swing.content.db.CloseDbAction;
import fr.ifremer.tutti.ui.swing.content.db.ExportDbAction;
import fr.ifremer.tutti.ui.swing.util.action.TuttiActionHelper;
import fr.ifremer.tutti.ui.swing.util.action.TuttiUIAction;
import java.io.File;
import java.util.Date;
import javax.swing.JOptionPane;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.util.Version;

public class OpenDbAction
extends AbstractChangeScreenAction {
    private static final Log log = LogFactory.getLog(OpenDbAction.class);
    protected Version dbVersion;
    protected Version applicationVersion;
    protected File file;
    protected boolean updateSchema;
    protected boolean closeDb;
    protected String jdbcUrl;

    public OpenDbAction(MainUIHandler handler) {
        super(handler, true, TuttiScreen.SELECT_CRUISE);
        this.setActionDescription(I18n._((String)"tutti.dbManager.action.openDb.tip", (Object[])new Object[0]));
    }

    @Override
    public boolean prepareAction() throws Exception {
        boolean canContinue = super.prepareAction();
        if (canContinue) {
            this.jdbcUrl = null;
            this.applicationVersion = null;
            this.dbVersion = null;
            this.file = null;
            this.updateSchema = false;
            this.closeDb = false;
        }
        return canContinue;
    }

    @Override
    public void doAction() throws Exception {
        String message;
        if (log.isDebugEnabled()) {
            log.debug((Object)"Will open db...");
        }
        this.jdbcUrl = TuttiPersistenceConfig.getInstance().getJdbcUrl();
        ProgressionModel progressionModel = new ProgressionModel();
        this.setProgressionModel(progressionModel);
        progressionModel.setTotal(3);
        progressionModel.increments(I18n._((String)"tutti.openDb.step.open", (Object[])new Object[]{this.jdbcUrl}));
        try {
            this.getContext().setDbLoaded(true);
            ((MainUIHandler)this.getHandler()).reloadPersistenceService();
        }
        catch (Exception e) {
            if (log.isErrorEnabled()) {
                log.error((Object)"Could not open db", (Throwable)e);
            }
            this.getContext().setDbLoaded(false);
            ((MainUIHandler)this.getHandler()).reloadPersistenceService();
            throw new TuttiBusinessException(I18n._((String)"tutti.dbManager.action.openDb.couldNotOpen", (Object[])new Object[0]));
        }
        progressionModel.increments(I18n._((String)"tutti.openDb.step.checkSchemaVersion", (Object[])new Object[0]));
        PersistenceService persistenceService = ((MainUIHandler)this.getHandler()).getPersistenceService();
        this.dbVersion = persistenceService.getDbVersion();
        if (log.isInfoEnabled()) {
            log.info((Object)("Detected database version: " + this.dbVersion));
        }
        this.applicationVersion = persistenceService.getApplicationVersion();
        if (log.isInfoEnabled()) {
            log.info((Object)("Detected schema application version:" + this.applicationVersion));
        }
        if (this.dbVersion.equals((Object)this.applicationVersion)) {
            if (log.isInfoEnabled()) {
                log.info((Object)("Database schema is up-to-date at version: " + this.dbVersion));
            }
        } else if (this.dbVersion.compareTo(this.applicationVersion) < 0) {
            boolean continueAction;
            message = I18n._((String)"tutti.dbManager.action.upgradeDb.schema.to.update.message", (Object[])new Object[]{this.dbVersion, this.applicationVersion});
            String htmlMessage = String.format("<html>%s<hr/><br/>%s</html>", message, I18n._((String)"tutti.dbManager.action.upgradeDb.schema.to.update.message.help", (Object[])new Object[0]));
            int i = JOptionPane.showConfirmDialog(((MainUIHandler)this.getHandler()).getTopestUI(), htmlMessage, I18n._((String)"tutti.dbManager.title.schema.toupdate", (Object[])new Object[0]), 2, 3);
            boolean bl = continueAction = i == 0;
            if (continueAction) {
                this.file = this.saveFile(this.getConfig().getServiceConfig().getPersistenceConfig().getDbBackupDirectory(), "tutti-db-" + ExportDbAction.df.format(new Date()), "zip", I18n._((String)"tutti.dbManager.title.choose.dbBackupFile", (Object[])new Object[0]), I18n._((String)"tutti.dbManager.action.chooseDbBackupFile", (Object[])new Object[0]), "^.*\\.zip", I18n._((String)"tutti.common.file.zip", (Object[])new Object[0]));
                if (this.file == null) {
                    this.closeDb = true;
                    this.displayWarningMessage(I18n._((String)"tutti.dbManager.title.choose.dbBackupFile", (Object[])new Object[0]), I18n._((String)"tutti.dbManager.action.upgradeDb.no.backup.db.choosen", (Object[])new Object[0]));
                } else {
                    this.updateSchema = true;
                }
            } else {
                this.closeDb = true;
            }
        } else {
            this.displayWarningMessage(I18n._((String)"tutti.dbManager.title.schema.toupdate", (Object[])new Object[0]), I18n._((String)"tutti.dbManager.action.upgradeDb.schema.not.update.message", (Object[])new Object[]{this.dbVersion, this.applicationVersion}));
        }
        if (this.closeDb) {
            progressionModel.increments(I18n._((String)"tutti.importDb.step.closeDb", (Object[])new Object[0]));
            TuttiActionHelper.runInternalAction(this.getHandler(), CloseDbAction.class);
            this.setScreen(TuttiScreen.MANAGE_DB);
            super.doAction();
            return;
        }
        if (this.updateSchema) {
            progressionModel.adaptTotal(progressionModel.getTotal() + 3 + 1);
            TuttiUIAction<ExportDbAction> backupAction = TuttiActionHelper.createUIAction(this.getHandler(), ExportDbAction.class);
            backupAction.getLogicAction().setProgressionModel(this.getProgressionModel());
            backupAction.getLogicAction().setFile(this.file);
            TuttiActionHelper.runInternalAction(backupAction.getLogicAction());
            String message2 = I18n._((String)"tutti.openDb.step.will.migrateSchema", (Object[])new Object[]{this.dbVersion, this.applicationVersion});
            progressionModel.increments(message2);
            this.sendMessage(message2);
            ((MainUIHandler)this.getHandler()).getPersistenceService().updateSchema();
        }
        message = I18n._((String)"tutti.openDb.step.check.dbContext", (Object[])new Object[]{this.dbVersion, this.applicationVersion});
        this.getProgressionModel().increments(message);
        if (log.isDebugEnabled()) {
            log.debug((Object)"Check db context");
        }
        this.getContext().checkDbContext();
        super.doAction();
    }

    @Override
    public void postSuccessAction() {
        ((MainUI)this.getUI()).getHandler().changeTitle();
        if (this.closeDb) {
            this.sendMessage(I18n._((String)"tutti.flash.info.db.not.opened", (Object[])new Object[]{this.jdbcUrl}));
        } else {
            if (this.updateSchema) {
                this.sendMessage(I18n._((String)"tutti.flash.info.db.schema.updated", (Object[])new Object[]{this.dbVersion, this.applicationVersion}));
            }
            this.sendMessage(I18n._((String)"tutti.flash.info.db.opened", (Object[])new Object[]{this.jdbcUrl}));
        }
    }
}

