/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.operation.catches.individualobservation.create;

import com.google.common.collect.Lists;
import fr.ifremer.tutti.persistence.entities.CaracteristicMap;
import fr.ifremer.tutti.persistence.entities.TuttiBeanFactory;
import fr.ifremer.tutti.persistence.entities.data.IndividualObservationBatch;
import fr.ifremer.tutti.persistence.entities.referential.Caracteristic;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.ui.swing.util.AbstractTuttiBeanUIModel;
import java.io.Serializable;
import java.util.List;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.beans.AbstractSerializableBean;

public class CreateIndividualObservationBatchUIModel
extends AbstractTuttiBeanUIModel<IndividualObservationBatch, CreateIndividualObservationBatchUIModel> {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(CreateIndividualObservationBatchUIModel.class);
    public static final String PROPERTY_AVAILABLE_SPECIES = "availableSpecies";
    public static final String PROPERTY_CARACTERISTICS = "caracteristics";
    protected List<Species> availableSpecies;
    protected final IndividualObservationBatch editObject = TuttiBeanFactory.newIndividualObservationBatch();
    protected final List<Caracteristic> defaultCaracteristic;
    protected final List<CaracteristicMapPropertyEditor> caracteristicEditors = Lists.newArrayList();

    public CreateIndividualObservationBatchUIModel(List<Caracteristic> defaultCaracteristic) {
        super(IndividualObservationBatch.class, null, null);
        this.defaultCaracteristic = defaultCaracteristic;
        this.editObject.setCaracteristics(new CaracteristicMap());
    }

    public Species getSpecies() {
        return this.editObject.getSpecies();
    }

    public void setSpecies(Species individualObservationSpecies) {
        Species oldValue = this.getSpecies();
        this.editObject.setSpecies(individualObservationSpecies);
        this.firePropertyChange("species", oldValue, individualObservationSpecies);
    }

    public Float getWeight() {
        return this.editObject.getWeight();
    }

    public void setWeight(Float individualObservationWeight) {
        Float oldValue = this.getWeight();
        this.editObject.setWeight(individualObservationWeight);
        this.firePropertyChange("weight", oldValue, individualObservationWeight);
    }

    public Float getSize() {
        return this.editObject.getSize();
    }

    public void setSize(Float individualObservationSize) {
        Float oldValue = this.getSize();
        this.editObject.setSize(individualObservationSize);
        this.firePropertyChange("size", oldValue, individualObservationSize);
    }

    public Caracteristic getLengthStepCaracteristic() {
        return this.editObject.getLengthStepCaracteristic();
    }

    public void setLengthStepCaracteristic(Caracteristic individualObservationLengthStepCaracteristic) {
        Caracteristic oldValue = this.getLengthStepCaracteristic();
        this.editObject.setLengthStepCaracteristic(individualObservationLengthStepCaracteristic);
        this.firePropertyChange("lengthStepCaracteristic", oldValue, individualObservationLengthStepCaracteristic);
    }

    public CaracteristicMap getCaracteristics() {
        return this.editObject.getCaracteristics();
    }

    public void setCaracteristics(CaracteristicMap caracteristics) {
        this.editObject.setCaracteristics(caracteristics);
        this.firePropertyChange(PROPERTY_CARACTERISTICS, null, caracteristics);
    }

    public List<Species> getAvailableSpecies() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("getAvailableSpecies " + this.availableSpecies));
        }
        return this.availableSpecies;
    }

    public void setAvailableSpecies(List<Species> availableSpecies) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("setAvailableSpecies " + availableSpecies));
        }
        this.availableSpecies = availableSpecies;
        this.firePropertyChange(PROPERTY_AVAILABLE_SPECIES, null, availableSpecies);
    }

    @Override
    protected IndividualObservationBatch newEntity() {
        return TuttiBeanFactory.newIndividualObservationBatch();
    }

    public void reset() {
        this.setAvailableSpecies(Lists.newArrayList());
        this.setSpecies(null);
        this.setWeight(null);
        this.setSize(null);
        this.setLengthStepCaracteristic(null);
        for (CaracteristicMapPropertyEditor editor : this.caracteristicEditors) {
            editor.setProperty(null);
        }
        this.getCaracteristics().clear();
    }

    public CaracteristicMapPropertyEditor newCaracteristicEditor(Caracteristic caracteristic) {
        CaracteristicMapPropertyEditor editor = new CaracteristicMapPropertyEditor(caracteristic);
        this.caracteristicEditors.add(editor);
        return editor;
    }

    public class CaracteristicMapPropertyEditor
    extends AbstractSerializableBean {
        private static final long serialVersionUID = 1L;
        public static final String PROPERTY_PROPERTY = "property";
        private final Caracteristic caracteristic;
        protected Serializable property;

        public Serializable getProperty() {
            return this.property;
        }

        public void setProperty(Serializable property) {
            Serializable oldValue = this.getProperty();
            this.property = property;
            CreateIndividualObservationBatchUIModel.this.getCaracteristics().put(this.caracteristic, property);
            if (ObjectUtils.notEqual((Object)oldValue, (Object)property)) {
                this.firePropertyChange(PROPERTY_PROPERTY, oldValue, property);
                CreateIndividualObservationBatchUIModel.this.firePropertyChanged(CreateIndividualObservationBatchUIModel.PROPERTY_CARACTERISTICS, null, CreateIndividualObservationBatchUIModel.this.getCaracteristics());
            }
        }

        public CaracteristicMapPropertyEditor(Caracteristic caracteristic) {
            this.caracteristic = caracteristic;
        }
    }
}

