/*
 * Decompiled with CFR 0.152.
 */
package liquibase.change.core;

import java.util.ArrayList;
import liquibase.change.AbstractChange;
import liquibase.change.Change;
import liquibase.change.ColumnConfig;
import liquibase.change.core.DropPrimaryKeyChange;
import liquibase.database.Database;
import liquibase.database.core.DB2Database;
import liquibase.database.core.SQLiteDatabase;
import liquibase.database.structure.Index;
import liquibase.statement.SqlStatement;
import liquibase.statement.core.AddPrimaryKeyStatement;
import liquibase.statement.core.ReorganizeTableStatement;
import liquibase.util.StringUtils;

public class AddPrimaryKeyChange
extends AbstractChange {
    private String schemaName;
    private String tableName;
    private String tablespace;
    private String columnNames;
    private String constraintName;

    public AddPrimaryKeyChange() {
        super("addPrimaryKey", "Add Primary Key", 1);
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public void setSchemaName(String schemaName) {
        this.schemaName = StringUtils.trimToNull(schemaName);
    }

    public String getColumnNames() {
        return this.columnNames;
    }

    public void setColumnNames(String columnNames) {
        this.columnNames = columnNames;
    }

    public String getConstraintName() {
        return this.constraintName;
    }

    public void setConstraintName(String constraintName) {
        this.constraintName = constraintName;
    }

    public String getTablespace() {
        return this.tablespace;
    }

    public void setTablespace(String tablespace) {
        this.tablespace = tablespace;
    }

    public SqlStatement[] generateStatements(Database database) {
        String schemaName = this.getSchemaName() == null ? database.getDefaultSchemaName() : this.getSchemaName();
        AddPrimaryKeyStatement statement = new AddPrimaryKeyStatement(schemaName, this.getTableName(), this.getColumnNames(), this.getConstraintName());
        statement.setTablespace(this.getTablespace());
        if (database instanceof DB2Database) {
            return new SqlStatement[]{statement, new ReorganizeTableStatement(schemaName, this.getTableName())};
        }
        return new SqlStatement[]{statement};
    }

    private SqlStatement[] generateStatementsForSQLiteDatabase(Database database) {
        ArrayList<SqlStatement> statements = new ArrayList<SqlStatement>();
        SQLiteDatabase.AlterTableVisitor rename_alter_visitor = new SQLiteDatabase.AlterTableVisitor(){

            public ColumnConfig[] getColumnsToAdd() {
                return new ColumnConfig[0];
            }

            public boolean copyThisColumn(ColumnConfig column) {
                return true;
            }

            public boolean createThisColumn(ColumnConfig column) {
                String[] split_columns;
                for (String split_column : split_columns = AddPrimaryKeyChange.this.getColumnNames().split("[ ]*,[ ]*")) {
                    if (!column.getName().equals(split_column)) continue;
                    column.getConstraints().setPrimaryKey(true);
                }
                return true;
            }

            public boolean createThisIndex(Index index) {
                return true;
            }
        };
        try {
            statements.addAll(SQLiteDatabase.getAlterTableStatements(rename_alter_visitor, database, this.getSchemaName(), this.getTableName()));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return statements.toArray(new SqlStatement[statements.size()]);
    }

    protected Change[] createInverses() {
        DropPrimaryKeyChange inverse = new DropPrimaryKeyChange();
        inverse.setSchemaName(this.getSchemaName());
        inverse.setTableName(this.getTableName());
        inverse.setConstraintName(this.getConstraintName());
        return new Change[]{inverse};
    }

    public String getConfirmationMessage() {
        return "Primary key added to " + this.getTableName() + " (" + this.getColumnNames() + ")";
    }
}

