/*
 * Decompiled with CFR 0.152.
 */
package org.andromda.core.translation.library;

import java.io.BufferedReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.lang.reflect.Method;
import java.util.LinkedHashMap;
import java.util.Map;
import org.andromda.core.common.ComponentContainer;
import org.andromda.core.common.ExceptionUtils;
import org.andromda.core.common.XmlObjectFactory;
import org.andromda.core.templateengine.TemplateEngine;
import org.andromda.core.translation.Translator;
import org.andromda.core.translation.library.Fragment;
import org.andromda.core.translation.library.Library;
import org.andromda.core.translation.library.LibraryException;
import org.andromda.core.translation.library.Translation;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.log4j.Logger;

public class LibraryTranslation {
    private static final Logger logger = Logger.getLogger((Class)(class$org$andromda$core$translation$library$LibraryTranslation == null ? (class$org$andromda$core$translation$library$LibraryTranslation = LibraryTranslation.class$("org.andromda.core.translation.library.LibraryTranslation")) : class$org$andromda$core$translation$library$LibraryTranslation));
    private Library library;
    private Translation translation;
    private String name;
    private String template;
    private String variable;
    private String translatorClass;
    static /* synthetic */ Class class$org$andromda$core$translation$library$LibraryTranslation;
    static /* synthetic */ Class class$org$andromda$core$translation$Translator;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$org$andromda$core$translation$library$Translation;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getTemplate() {
        return this.template;
    }

    public void setTemplate(String template) {
        this.template = template;
    }

    public Library getLibrary() {
        return this.library;
    }

    public void setLibrary(Library library) {
        this.library = library;
    }

    public String getVariable() {
        return this.variable;
    }

    public void setVariable(String variable) {
        this.variable = variable;
    }

    public void setTranslator(String translatorClass) {
        this.translatorClass = translatorClass;
        ComponentContainer container = ComponentContainer.instance();
        container.unregisterComponent(translatorClass);
        container.registerComponentType(translatorClass);
    }

    public Translator getTranslator() {
        String methodName = "LibraryTranslation.getTranslator";
        Translator translator = (Translator)ComponentContainer.instance().findComponent(this.translatorClass, class$org$andromda$core$translation$Translator == null ? (class$org$andromda$core$translation$Translator = LibraryTranslation.class$("org.andromda.core.translation.Translator")) : class$org$andromda$core$translation$Translator);
        if (translator == null) {
            throw new LibraryException("LibraryTranslation.getTranslator - a translator implementation must be defined,  please check your translator library --> '" + this.library.getResource() + "'");
        }
        return translator;
    }

    public void handleTranslationFragment(String name, String kind, Object node) {
        ExceptionUtils.checkNull("node", node);
        if (this.translation != null && this.getTranslator() != null) {
            String handlerMethod;
            String translation = this.getTranslationFragment(name, kind);
            Fragment fragment = this.translation.getFragment(name);
            if (fragment != null && StringUtils.isNotEmpty((String)(handlerMethod = fragment.getHandlerMethod()))) {
                Object[] argTypes = new Class[]{class$java$lang$String == null ? (class$java$lang$String = LibraryTranslation.class$("java.lang.String")) : class$java$lang$String, class$java$lang$Object == null ? (class$java$lang$Object = LibraryTranslation.class$("java.lang.Object")) : class$java$lang$Object};
                try {
                    Method method = this.getTranslator().getClass().getMethod(handlerMethod, (Class<?>[])argTypes);
                    Object[] args = new Object[]{translation, node};
                    method.invoke((Object)this.getTranslator(), args);
                }
                catch (NoSuchMethodException exception) {
                    String errMsg = "the translator '" + this.getTranslator().getClass() + "' must implement the method '" + handlerMethod + "'" + StringUtils.join((Object[])argTypes, (String)",") + "'" + " in order to handle processing of the fragment --> '" + name + "'";
                    logger.error((Object)errMsg);
                }
                catch (Throwable throwable) {
                    throw new LibraryException(throwable);
                }
            }
        }
    }

    public String getTranslationFragment(String name, String kind) {
        String fragment = null;
        if (this.translation != null) {
            fragment = this.translation.getTranslated(name, kind);
        }
        return fragment;
    }

    protected void setTranslation(Reader translationInput) {
        ExceptionUtils.checkNull("translationInput", translationInput);
        try {
            this.translation = (Translation)XmlObjectFactory.getInstance(class$org$andromda$core$translation$library$Translation == null ? (class$org$andromda$core$translation$library$Translation = LibraryTranslation.class$("org.andromda.core.translation.library.Translation")) : class$org$andromda$core$translation$library$Translation).getObject(translationInput);
            this.translation.setLibraryTranslation(this);
        }
        catch (Throwable throwable) {
            throw new LibraryException(throwable);
        }
    }

    public Translation processTranslation(Map templateContext) {
        logger.debug((Object)("processing translation template --> '" + this.getTemplate() + "'" + "' with templateContext --> '" + templateContext + "'"));
        if (this.getTemplate() != null) {
            if (templateContext == null) {
                templateContext = new LinkedHashMap();
            }
            this.getLibrary().populateTemplateContext(templateContext);
            try {
                TemplateEngine engine = this.getLibrary().getTemplateEngine();
                StringWriter output = new StringWriter();
                engine.processTemplate(this.getTemplate(), templateContext, output);
                String outputString = output.toString();
                BufferedReader input = new BufferedReader(new StringReader(outputString));
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("processed output --> '" + outputString + "'"));
                }
                this.setTranslation(input);
            }
            catch (Throwable throwable) {
                throw new LibraryException(throwable);
            }
        }
        return this.translation;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

