package fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency;

/*
 * #%L
 * Tutti :: UI
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2013 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.persistence.entities.referential.Caracteristic;
import fr.ifremer.tutti.ui.swing.TuttiHelpBroker;
import fr.ifremer.tutti.ui.swing.TuttiUIContext;
import fr.ifremer.tutti.ui.swing.content.operation.catches.EditCatchesUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.SpeciesBatchRowModel;
import fr.ifremer.tutti.ui.swing.util.TuttiUI;
import fr.ifremer.tutti.ui.swing.util.TuttiUIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.SwingConstants;
import javax.swing.border.TitledBorder;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.JAXXValidator;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.CardLayout2Ext;
import jaxx.runtime.swing.JAXXButtonGroup;
import jaxx.runtime.swing.Table;
import jaxx.runtime.swing.VBox;
import jaxx.runtime.swing.editor.NumberEditor;
import jaxx.runtime.swing.editor.bean.BeanFilterableComboBox;
import jaxx.runtime.swing.help.JAXXHelpUI;
import jaxx.runtime.validator.swing.SwingValidator;
import jaxx.runtime.validator.swing.SwingValidatorUtil;
import jaxx.runtime.validator.swing.meta.Validator;
import jaxx.runtime.validator.swing.meta.ValidatorField;
import jaxx.runtime.validator.swing.ui.ImageValidationUI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXTable;
import static jaxx.runtime.SwingUtil.getStringValue;
import static org.nuiton.i18n.I18n._;

public class SpeciesFrequencyUI extends JPanel implements JAXXHelpUI<TuttiHelpBroker>, TuttiUI<SpeciesFrequencyUIModel, SpeciesFrequencyUIHandler>, JAXXObject, JAXXValidator {

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_AUTO_GEN_MODE_BUTTON_SELECTED = "autoGenModeButton.selected";
    public static final String BINDING_BATCH_CATEGORY_TEXT = "batchCategory.text";
    public static final String BINDING_BATCH_SPECIES_TEXT = "batchSpecies.text";
    public static final String BINDING_DATA_FIELD_LAYOUT_SELECTED = "dataFieldLayout.selected";
    public static final String BINDING_DATA_IN_FREQUENCIES_WARNING_CONTAINER_VISIBLE = "dataInFrequenciesWarningContainer.visible";
    public static final String BINDING_GENERATE_BUTTON_ENABLED = "generateButton.enabled";
    public static final String BINDING_LENGTHSTEP_SETTINGS_BLOCK_VISIBLE = "lengthstepSettingsBlock.visible";
    public static final String BINDING_LENGTH_STEP_CARACTERISTIC_COMBO_BOX_ENABLED = "lengthStepCaracteristicComboBox.enabled";
    public static final String BINDING_LENGTH_STEP_CARACTERISTIC_COMBO_BOX_SELECTED_ITEM = "lengthStepCaracteristicComboBox.selectedItem";
    public static final String BINDING_LENGTH_STEP_CARACTERISTIC_LABEL_ENABLED = "lengthStepCaracteristicLabel.enabled";
    public static final String BINDING_MAX_STEP_FIELD_MODEL = "maxStepField.model";
    public static final String BINDING_MAX_STEP_FIELD_NUMBER_PATTERN = "maxStepField.numberPattern";
    public static final String BINDING_MIN_STEP_FIELD_MODEL = "minStepField.model";
    public static final String BINDING_MIN_STEP_FIELD_NUMBER_PATTERN = "minStepField.numberPattern";
    public static final String BINDING_MODE_CONFIGURATION_LAYOUT_SELECTED = "modeConfigurationLayout.selected";
    public static final String BINDING_RAFALE_MODE_BUTTON_SELECTED = "rafaleModeButton.selected";
    public static final String BINDING_RAFALE_STEP_FIELD_ENABLED = "rafaleStepField.enabled";
    public static final String BINDING_RAFALE_STEP_FIELD_NUMBER_PATTERN = "rafaleStepField.numberPattern";
    public static final String BINDING_SAVE_BUTTON_ENABLED = "saveButton.enabled";
    public static final String BINDING_SIMPLE_COUNTING_FIELD_MODEL = "simpleCountingField.model";
    public static final String BINDING_SIMPLE_COUNTING_MODE_BUTTON_SELECTED = "simpleCountingModeButton.selected";
    public static final String BINDING_SIMPLE_MODE_BUTTON_SELECTED = "simpleModeButton.selected";
    public static final String BINDING_STEP_FIELD_ENABLED = "stepField.enabled";
    public static final String BINDING_STEP_FIELD_MODEL = "stepField.model";
    public static final String BINDING_STEP_FIELD_NUMBER_PATTERN = "stepField.numberPattern";
    public static final String BINDING_STEP_LABEL_ENABLED = "stepLabel.enabled";
    public static final String BINDING_TABLE_ENABLED = "table.enabled";
    public static final String BINDING_TOTAL_NUMBER_FIELD_TEXT = "totalNumberField.text";
    public static final String BINDING_TOTAL_NUMBER_LABEL_ENABLED = "totalNumberLabel.enabled";
    public static final String BINDING_TOTAL_WEIGHT_FIELD_TEXT = "totalWeightField.text";
    public static final String BINDING_TOTAL_WEIGHT_LABEL_ENABLED = "totalWeightLabel.enabled";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "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";
    private static final Log log = LogFactory.getLog(SpeciesFrequencyUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JPanel actionPanel;
    protected JRadioButton autoGenModeButton;
    protected JPanel autoGenModePanel;
    protected JTextField batchCategory;
    protected JLabel batchCategoryLabel;
    protected JTextField batchSpecies;
    protected JLabel batchSpeciesLabel;
    protected TuttiHelpBroker broker;
    protected JButton cancelButton;
    protected JPanel configurationPanel;
    protected CardLayout2Ext dataFieldLayout;
    protected JPanel dataFieldPanel;
    protected JLabel dataInFrequenciesWarning;
    protected JPanel dataInFrequenciesWarningContainer;
    protected SpeciesFrequencyUI editSpeciesFrequenciesTopPanel = this;
    protected JButton generateButton;
    protected SpeciesFrequencyUIHandler handler;
    @ValidatorField( validatorId = "validator",  propertyName = "lengthStepCaracteristic",  editorName = "lengthStepCaracteristicComboBox")
    protected BeanFilterableComboBox<Caracteristic> lengthStepCaracteristicComboBox;
    protected JLabel lengthStepCaracteristicLabel;
    protected Table lengthstepSettingsBlock;
    protected NumberEditor maxStepField;
    protected JLabel maxStepLabel;
    protected NumberEditor minStepField;
    protected JLabel minStepLabel;
    protected JAXXButtonGroup mode;
    protected CardLayout2Ext modeConfigurationLayout;
    protected JPanel modeConfigurationPanel;
    protected VBox modePanel;
    protected SpeciesFrequencyUIModel model;
    protected JRadioButton rafaleModeButton;
    protected JPanel rafaleModePanel;
    protected NumberEditor rafaleStepField;
    protected JLabel rafaleStepLabel;
    protected JButton saveButton;
    protected NumberEditor simpleCountingField;
    protected JLabel simpleCountingLabel;
    protected JRadioButton simpleCountingModeButton;
    protected JLabel simpleCountingModeLabel;
    protected JPanel simpleCountingModePanel;
    protected JRadioButton simpleModeButton;
    protected JLabel simpleModeLabel;
    protected JPanel simpleModePanel;
    @ValidatorField( validatorId = "validator",  propertyName = "step",  editorName = "stepField")
    protected NumberEditor stepField;
    protected JLabel stepLabel;
    protected JXTable table;
    @ValidatorField( validatorId = "validator",  propertyName = "rows",  editorName = "tableScrollPane")
    protected JScrollPane tableScrollPane;
    protected JTextField totalNumberField;
    protected JLabel totalNumberLabel;
    protected JTextField totalWeightField;
    protected JLabel totalWeightLabel;
    @Validator( validatorId = "validator")
    protected SwingValidator<SpeciesFrequencyUIModel> validator;
    protected List<String> validatorIds = new ArrayList<String>();

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JPanel $JPanel0;
    private JPanel $JPanel1;
    private JSeparator $JSeparator0;
    private JSeparator $JSeparator1;
    private Table $Table0;
    private Table $Table1;
    private Table $Table2;
    private Table $Table3;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/
    
    
          protected void $afterCompleteSetup() {
              handler.afterInitUI();
          }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public SpeciesFrequencyUI(TuttiUI parentUI) {
        JAXXUtil.initContext(this, parentUI);
                  SpeciesFrequencyUIHandler handler = new SpeciesFrequencyUIHandler(parentUI.getHandler().getContext(), this);
                  setContextValue(handler);
                  handler.beforeInitUI();
            $initialize();
    }

    public SpeciesFrequencyUI() {
        $initialize();
    }

    public SpeciesFrequencyUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public SpeciesFrequencyUI(boolean param0) {
        super(param0);
        $initialize();
    }

    public SpeciesFrequencyUI(JAXXContext parentContext, boolean param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public SpeciesFrequencyUI(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public SpeciesFrequencyUI(JAXXContext parentContext, LayoutManager param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public SpeciesFrequencyUI(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public SpeciesFrequencyUI(JAXXContext parentContext, LayoutManager param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*-------------------- JAXXValidator implementation  --------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public SwingValidator<?> getValidator(String validatorId) {
        return (SwingValidator<?>) (validatorIds.contains(validatorId) ? getObjectById(validatorId) : null);
    }

    @Override
    public List<String> getValidatorIds() {
        return validatorIds;
    }

    @Override
    public void registerValidatorFields() {
        SwingValidatorUtil.detectValidatorFields(this);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__autoGenModeButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        model.setConfigurationMode(SpeciesFrequencyUIModel.ConfigurationMode.AUTO_GEN);
    }

    public void doActionPerformed__on__cancelButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.cancel();
    }

    public void doActionPerformed__on__generateButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.generateLengthSteps();
    }

    public void doActionPerformed__on__rafaleModeButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        model.setConfigurationMode(SpeciesFrequencyUIModel.ConfigurationMode.RAFALE);
    }

    public void doActionPerformed__on__saveButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.save();
    }

    public void doActionPerformed__on__simpleCountingModeButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        model.setConfigurationMode(SpeciesFrequencyUIModel.ConfigurationMode.SIMPLE_COUNTING);
    }

    public void doActionPerformed__on__simpleModeButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        model.setConfigurationMode(SpeciesFrequencyUIModel.ConfigurationMode.SIMPLE);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JPanel getActionPanel() {
        return actionPanel;
    }

    public JRadioButton getAutoGenModeButton() {
        return autoGenModeButton;
    }

    public JPanel getAutoGenModePanel() {
        return autoGenModePanel;
    }

    public JTextField getBatchCategory() {
        return batchCategory;
    }

    public JLabel getBatchCategoryLabel() {
        return batchCategoryLabel;
    }

    public JTextField getBatchSpecies() {
        return batchSpecies;
    }

    public JLabel getBatchSpeciesLabel() {
        return batchSpeciesLabel;
    }

    public TuttiHelpBroker getBroker() {
        return broker;
    }

    public JButton getCancelButton() {
        return cancelButton;
    }

    public JPanel getConfigurationPanel() {
        return configurationPanel;
    }

    public CardLayout2Ext getDataFieldLayout() {
        return dataFieldLayout;
    }

    public JPanel getDataFieldPanel() {
        return dataFieldPanel;
    }

    public JLabel getDataInFrequenciesWarning() {
        return dataInFrequenciesWarning;
    }

    public JPanel getDataInFrequenciesWarningContainer() {
        return dataInFrequenciesWarningContainer;
    }

    public JButton getGenerateButton() {
        return generateButton;
    }

    public SpeciesFrequencyUIHandler getHandler() {
        return handler;
    }

    public BeanFilterableComboBox<Caracteristic> getLengthStepCaracteristicComboBox() {
        return lengthStepCaracteristicComboBox;
    }

    public JLabel getLengthStepCaracteristicLabel() {
        return lengthStepCaracteristicLabel;
    }

    public Table getLengthstepSettingsBlock() {
        return lengthstepSettingsBlock;
    }

    public NumberEditor getMaxStepField() {
        return maxStepField;
    }

    public JLabel getMaxStepLabel() {
        return maxStepLabel;
    }

    public NumberEditor getMinStepField() {
        return minStepField;
    }

    public JLabel getMinStepLabel() {
        return minStepLabel;
    }

    public JAXXButtonGroup getMode() {
        return mode;
    }

    public CardLayout2Ext getModeConfigurationLayout() {
        return modeConfigurationLayout;
    }

    public JPanel getModeConfigurationPanel() {
        return modeConfigurationPanel;
    }

    public VBox getModePanel() {
        return modePanel;
    }

    public SpeciesFrequencyUIModel getModel() {
        return model;
    }

    public JRadioButton getRafaleModeButton() {
        return rafaleModeButton;
    }

    public JPanel getRafaleModePanel() {
        return rafaleModePanel;
    }

    public NumberEditor getRafaleStepField() {
        return rafaleStepField;
    }

    public JLabel getRafaleStepLabel() {
        return rafaleStepLabel;
    }

    public JButton getSaveButton() {
        return saveButton;
    }

    public NumberEditor getSimpleCountingField() {
        return simpleCountingField;
    }

    public JLabel getSimpleCountingLabel() {
        return simpleCountingLabel;
    }

    public JRadioButton getSimpleCountingModeButton() {
        return simpleCountingModeButton;
    }

    public JLabel getSimpleCountingModeLabel() {
        return simpleCountingModeLabel;
    }

    public JPanel getSimpleCountingModePanel() {
        return simpleCountingModePanel;
    }

    public JRadioButton getSimpleModeButton() {
        return simpleModeButton;
    }

    public JLabel getSimpleModeLabel() {
        return simpleModeLabel;
    }

    public JPanel getSimpleModePanel() {
        return simpleModePanel;
    }

    public NumberEditor getStepField() {
        return stepField;
    }

    public JLabel getStepLabel() {
        return stepLabel;
    }

    public JXTable getTable() {
        return table;
    }

    public JScrollPane getTableScrollPane() {
        return tableScrollPane;
    }

    public JTextField getTotalNumberField() {
        return totalNumberField;
    }

    public JLabel getTotalNumberLabel() {
        return totalNumberLabel;
    }

    public JTextField getTotalWeightField() {
        return totalWeightField;
    }

    public JLabel getTotalWeightLabel() {
        return totalWeightLabel;
    }

    public SwingValidator<SpeciesFrequencyUIModel> getValidator() {
        return validator;
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Other methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void registerHelpId(TuttiHelpBroker broker, Component component, String helpId) {
        broker.installUI(component, helpId);
    }

    @Override
    public void showHelp(String helpId) {
        getBroker().showHelp(this, helpId);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JPanel get$JPanel0() {
        return $JPanel0;
    }

    protected JPanel get$JPanel1() {
        return $JPanel1;
    }

    protected JSeparator get$JSeparator0() {
        return $JSeparator0;
    }

    protected JSeparator get$JSeparator1() {
        return $JSeparator1;
    }

    protected Table get$Table0() {
        return $Table0;
    }

    protected Table get$Table1() {
        return $Table1;
    }

    protected Table get$Table2() {
        return $Table2;
    }

    protected Table get$Table3() {
        return $Table3;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToActionPanel() {
        if (!allComponentsCreated) {
            return;
        }
        actionPanel.add(cancelButton);
        actionPanel.add(saveButton);
    }

    protected void addChildrenToAutoGenModeButton() {
        if (!allComponentsCreated) {
            return;
        }
        { ButtonGroup $buttonGroup = mode; autoGenModeButton.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add(autoGenModeButton); }
    }

    protected void addChildrenToAutoGenModePanel() {
        if (!allComponentsCreated) {
            return;
        }
        autoGenModePanel.add($Table1, BorderLayout.SOUTH);
    }

    protected void addChildrenToConfigurationPanel() {
        if (!allComponentsCreated) {
            return;
        }
        configurationPanel.add($Table0, BorderLayout.NORTH);
        configurationPanel.add($JPanel0, BorderLayout.CENTER);
        configurationPanel.add(lengthstepSettingsBlock, BorderLayout.SOUTH);
    }

    protected void addChildrenToDataFieldPanel() {
        if (!allComponentsCreated) {
            return;
        }
        dataFieldPanel.add(SwingUtil.boxComponentWithJxLayer(tableScrollPane), "lengthCaracteristicPmfm");
        dataFieldPanel.add($Table3, "noLengthCaracteristicPmfm");
    }

    protected void addChildrenToDataInFrequenciesWarningContainer() {
        if (!allComponentsCreated) {
            return;
        }
        dataInFrequenciesWarningContainer.add(dataInFrequenciesWarning, BorderLayout.CENTER);
    }

    protected void addChildrenToEditSpeciesFrequenciesTopPanel() {
        if (!allComponentsCreated) {
            return;
        }
        add(configurationPanel, BorderLayout.NORTH);
        add(dataFieldPanel, BorderLayout.CENTER);
        add(actionPanel, BorderLayout.SOUTH);
    }

    protected void addChildrenToLengthstepSettingsBlock() {
        if (!allComponentsCreated) {
            return;
        }
        lengthstepSettingsBlock.add($JSeparator1, new GridBagConstraints(0, 0, 6, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        lengthstepSettingsBlock.add(lengthStepCaracteristicLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        lengthstepSettingsBlock.add(SwingUtil.boxComponentWithJxLayer(lengthStepCaracteristicComboBox), new GridBagConstraints(1, 1, 5, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        lengthstepSettingsBlock.add(stepLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        lengthstepSettingsBlock.add(SwingUtil.boxComponentWithJxLayer(stepField), new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        lengthstepSettingsBlock.add(totalNumberLabel, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        lengthstepSettingsBlock.add(totalNumberField, new GridBagConstraints(3, 2, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        lengthstepSettingsBlock.add(totalWeightLabel, new GridBagConstraints(4, 2, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        lengthstepSettingsBlock.add(totalWeightField, new GridBagConstraints(5, 2, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void addChildrenToModeConfigurationPanel() {
        if (!allComponentsCreated) {
            return;
        }
        modeConfigurationPanel.add(simpleModePanel, "simpleMode");
        modeConfigurationPanel.add(autoGenModePanel, "autoGenMode");
        modeConfigurationPanel.add(rafaleModePanel, "rafaleMode");
        modeConfigurationPanel.add(simpleCountingModePanel, "simpleCountingMode");
    }

    protected void addChildrenToModePanel() {
        if (!allComponentsCreated) {
            return;
        }
        modePanel.add(simpleModeButton);
        modePanel.add(autoGenModeButton);
        modePanel.add(rafaleModeButton);
        modePanel.add(simpleCountingModeButton);
    }

    protected void addChildrenToRafaleModeButton() {
        if (!allComponentsCreated) {
            return;
        }
        { ButtonGroup $buttonGroup = mode; rafaleModeButton.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add(rafaleModeButton); }
    }

    protected void addChildrenToRafaleModePanel() {
        if (!allComponentsCreated) {
            return;
        }
        rafaleModePanel.add($Table2, BorderLayout.SOUTH);
    }

    protected void addChildrenToSimpleCountingModeButton() {
        if (!allComponentsCreated) {
            return;
        }
        { ButtonGroup $buttonGroup = mode; simpleCountingModeButton.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add(simpleCountingModeButton); }
    }

    protected void addChildrenToSimpleCountingModePanel() {
        if (!allComponentsCreated) {
            return;
        }
        simpleCountingModePanel.add(simpleCountingModeLabel, BorderLayout.CENTER);
    }

    protected void addChildrenToSimpleModeButton() {
        if (!allComponentsCreated) {
            return;
        }
        { ButtonGroup $buttonGroup = mode; simpleModeButton.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add(simpleModeButton); }
    }

    protected void addChildrenToSimpleModePanel() {
        if (!allComponentsCreated) {
            return;
        }
        simpleModePanel.add(simpleModeLabel, BorderLayout.CENTER);
    }

    protected void addChildrenToTableScrollPane() {
        if (!allComponentsCreated) {
            return;
        }
        tableScrollPane.getViewport().add(table);
    }

    protected void addChildrenToValidator() {
        if (!allComponentsCreated) {
            return;
        }
        validator.setUiClass(ImageValidationUI.class);
        validator.setBean(model);
    }

    protected void createActionPanel() {
        $objectMap.put("actionPanel", actionPanel = new JPanel());
        
        actionPanel.setName("actionPanel");
        actionPanel.setLayout(new GridLayout(1, 0));
    }

    protected void createAutoGenModeButton() {
        $objectMap.put("autoGenModeButton", autoGenModeButton = new JRadioButton());
        
        autoGenModeButton.setName("autoGenModeButton");
        autoGenModeButton.setText(_("tutti.editSpeciesFrequencies.field.mode.autoGen"));
        { autoGenModeButton.putClientProperty("$value", "autoGenMode");  Object $buttonGroup = autoGenModeButton.getClientProperty("$buttonGroup"); if ($buttonGroup instanceof JAXXButtonGroup) { ((JAXXButtonGroup) $buttonGroup).updateSelectedValue(); } }
        
        autoGenModeButton.setToolTipText(_("tutti.editSpeciesFrequencies.field.mode.autoGen.tip"));
        autoGenModeButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__autoGenModeButton"));
        autoGenModeButton.putClientProperty("help", "tutti.editSpeciesFrequencies.field.mode.autoGen.help");
    }

    protected void createAutoGenModePanel() {
        $objectMap.put("autoGenModePanel", autoGenModePanel = new JPanel());
        
        autoGenModePanel.setName("autoGenModePanel");
    }

    protected void createBatchCategory() {
        $objectMap.put("batchCategory", batchCategory = new JTextField());
        
        batchCategory.setName("batchCategory");
        batchCategory.setColumns(15);
        batchCategory.setEnabled(false);
        batchCategory.setEditable(false);
    }

    protected void createBatchCategoryLabel() {
        $objectMap.put("batchCategoryLabel", batchCategoryLabel = new JLabel());
        
        batchCategoryLabel.setName("batchCategoryLabel");
        batchCategoryLabel.setText(_("tutti.editSpeciesFrequencies.batchCategory"));
    }

    protected void createBatchSpecies() {
        $objectMap.put("batchSpecies", batchSpecies = new JTextField());
        
        batchSpecies.setName("batchSpecies");
        batchSpecies.setColumns(15);
        batchSpecies.setEnabled(false);
        batchSpecies.setEditable(false);
    }

    protected void createBatchSpeciesLabel() {
        $objectMap.put("batchSpeciesLabel", batchSpeciesLabel = new JLabel());
        
        batchSpeciesLabel.setName("batchSpeciesLabel");
        batchSpeciesLabel.setText(_("tutti.editSpeciesFrequencies.batchSpecies"));
    }

    protected void createBroker() {
        $objectMap.put("broker", broker = new TuttiHelpBroker("tutti.editSpeciesFrequencies.help"));
    }

    protected void createCancelButton() {
        $objectMap.put("cancelButton", cancelButton = new JButton());
        
        cancelButton.setName("cancelButton");
        cancelButton.setText(_("tutti.editSpeciesFrequencies.action.cancel"));
        cancelButton.setToolTipText(_("tutti.editSpeciesFrequencies.action.cancel.tip"));
        cancelButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__cancelButton"));
        cancelButton.putClientProperty("help", "tutti.editSpeciesFrequencies.action.cancel.help");
    }

    protected void createConfigurationPanel() {
        $objectMap.put("configurationPanel", configurationPanel = new JPanel());
        
        configurationPanel.setName("configurationPanel");
        configurationPanel.setLayout(new BorderLayout());
    }

    protected void createDataFieldLayout() {
        $objectMap.put("dataFieldLayout", dataFieldLayout = new CardLayout2Ext(this, "dataFieldPanel"));
    }

    protected void createDataFieldPanel() {
        $objectMap.put("dataFieldPanel", dataFieldPanel = new JPanel());
        
        dataFieldPanel.setName("dataFieldPanel");
        dataFieldPanel.setLayout(dataFieldLayout);
    }

    protected void createDataInFrequenciesWarning() {
        $objectMap.put("dataInFrequenciesWarning", dataInFrequenciesWarning = new JLabel());
        
        dataInFrequenciesWarning.setName("dataInFrequenciesWarning");
        dataInFrequenciesWarning.setText(_("tutti.editSpeciesFrequencies.simpleCountingAndFrequencies"));
    }

    protected void createDataInFrequenciesWarningContainer() {
        $objectMap.put("dataInFrequenciesWarningContainer", dataInFrequenciesWarningContainer = new JPanel());
        
        dataInFrequenciesWarningContainer.setName("dataInFrequenciesWarningContainer");
        dataInFrequenciesWarningContainer.setLayout(new BorderLayout(10, 10));
    }

    protected void createGenerateButton() {
        $objectMap.put("generateButton", generateButton = new JButton());
        
        generateButton.setName("generateButton");
        generateButton.setText(_("tutti.editSpeciesFrequencies.action.generate"));
        generateButton.setToolTipText(_("tutti.editSpeciesFrequencies.action.generate.tip"));
        generateButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__generateButton"));
        generateButton.putClientProperty("help", "tutti.editSpeciesFrequencies.action.generate.help");
    }

    protected void createHandler() {
        $objectMap.put("handler", handler = getContextValue(SpeciesFrequencyUIHandler.class));
    }

    protected void createLengthStepCaracteristicComboBox() {
        $objectMap.put("lengthStepCaracteristicComboBox", lengthStepCaracteristicComboBox = new BeanFilterableComboBox<Caracteristic>(this));
        
        lengthStepCaracteristicComboBox.setName("lengthStepCaracteristicComboBox");
        lengthStepCaracteristicComboBox.setI18nPrefix("tutti.property.");
        lengthStepCaracteristicComboBox.setProperty("lengthStepCaracteristic");
        lengthStepCaracteristicComboBox.setShowReset(true);
        lengthStepCaracteristicComboBox.putClientProperty("validatorLabel", _("tutti.editSpeciesFrequencies.field.lengthStepCaracteristic"));
    }

    protected void createLengthStepCaracteristicLabel() {
        $objectMap.put("lengthStepCaracteristicLabel", lengthStepCaracteristicLabel = new JLabel());
        
        lengthStepCaracteristicLabel.setName("lengthStepCaracteristicLabel");
        lengthStepCaracteristicLabel.setText(_("tutti.editSpeciesFrequencies.field.lengthStepCaracteristic"));
        lengthStepCaracteristicLabel.setToolTipText(_("tutti.editSpeciesFrequencies.field.lengthStepCaracteristic.tip"));
        lengthStepCaracteristicLabel.putClientProperty("help", "tutti.editSpeciesFrequencies.field.lengthStepCaracteristic.help");
    }

    protected void createLengthstepSettingsBlock() {
        $objectMap.put("lengthstepSettingsBlock", lengthstepSettingsBlock = new Table());
        
        lengthstepSettingsBlock.setName("lengthstepSettingsBlock");
    }

    protected void createMaxStepField() {
        $objectMap.put("maxStepField", maxStepField = new NumberEditor(this));
        
        maxStepField.setName("maxStepField");
        maxStepField.setProperty("maxStep");
        maxStepField.setUseFloat(true);
        maxStepField.setShowReset(true);
        maxStepField.putClientProperty("selectOnFocus", true);
    }

    protected void createMaxStepLabel() {
        $objectMap.put("maxStepLabel", maxStepLabel = new JLabel());
        
        maxStepLabel.setName("maxStepLabel");
        maxStepLabel.setText(_("tutti.editSpeciesFrequencies.field.maxStep"));
        maxStepLabel.setToolTipText(_("tutti.editSpeciesFrequencies.field.maxStep.tip"));
        maxStepLabel.putClientProperty("help", "tutti.editSpeciesFrequencies.field.maxStep.help");
    }

    protected void createMinStepField() {
        $objectMap.put("minStepField", minStepField = new NumberEditor(this));
        
        minStepField.setName("minStepField");
        minStepField.setProperty("minStep");
        minStepField.setUseFloat(true);
        minStepField.setShowReset(true);
        minStepField.putClientProperty("selectOnFocus", true);
    }

    protected void createMinStepLabel() {
        $objectMap.put("minStepLabel", minStepLabel = new JLabel());
        
        minStepLabel.setName("minStepLabel");
        minStepLabel.setText(_("tutti.editSpeciesFrequencies.field.minStep"));
        minStepLabel.setToolTipText(_("tutti.editSpeciesFrequencies.field.minStep.tip"));
        minStepLabel.putClientProperty("help", "tutti.editSpeciesFrequencies.field.minStep.help");
    }

    protected void createMode() {
        $objectMap.put("mode", mode = new JAXXButtonGroup());
    }

    protected void createModeConfigurationLayout() {
        $objectMap.put("modeConfigurationLayout", modeConfigurationLayout = new CardLayout2Ext(this, "modeConfigurationPanel"));
    }

    protected void createModeConfigurationPanel() {
        $objectMap.put("modeConfigurationPanel", modeConfigurationPanel = new JPanel());
        
        modeConfigurationPanel.setName("modeConfigurationPanel");
        modeConfigurationPanel.setLayout(modeConfigurationLayout);
    }

    protected void createModePanel() {
        $objectMap.put("modePanel", modePanel = new VBox());
        
        modePanel.setName("modePanel");
    }

    protected void createModel() {
        $objectMap.put("model", model = getContextValue(SpeciesFrequencyUIModel.class));
    }

    protected void createRafaleModeButton() {
        $objectMap.put("rafaleModeButton", rafaleModeButton = new JRadioButton());
        
        rafaleModeButton.setName("rafaleModeButton");
        rafaleModeButton.setText(_("tutti.editSpeciesFrequencies.field.mode.rafale"));
        { rafaleModeButton.putClientProperty("$value", "rafaleMode");  Object $buttonGroup = rafaleModeButton.getClientProperty("$buttonGroup"); if ($buttonGroup instanceof JAXXButtonGroup) { ((JAXXButtonGroup) $buttonGroup).updateSelectedValue(); } }
        
        rafaleModeButton.setToolTipText(_("tutti.editSpeciesFrequencies.field.mode.rafale.tip"));
        rafaleModeButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__rafaleModeButton"));
        rafaleModeButton.putClientProperty("help", "tutti.editSpeciesFrequencies.field.mode.rafale.help");
    }

    protected void createRafaleModePanel() {
        $objectMap.put("rafaleModePanel", rafaleModePanel = new JPanel());
        
        rafaleModePanel.setName("rafaleModePanel");
    }

    protected void createRafaleStepField() {
        $objectMap.put("rafaleStepField", rafaleStepField = new NumberEditor(this));
        
        rafaleStepField.setName("rafaleStepField");
        rafaleStepField.setUseFloat(true);
        rafaleStepField.setShowReset(true);
        rafaleStepField.putClientProperty("selectOnFocus", true);
    }

    protected void createRafaleStepLabel() {
        $objectMap.put("rafaleStepLabel", rafaleStepLabel = new JLabel());
        
        rafaleStepLabel.setName("rafaleStepLabel");
        rafaleStepLabel.setText(_("tutti.editSpeciesFrequencies.field.rafaleStep"));
        rafaleStepLabel.setToolTipText(_("tutti.editSpeciesFrequencies.field.rafaleStep.tip"));
        rafaleStepLabel.putClientProperty("help", "tutti.editSpeciesFrequencies.field.rafaleStep.help");
    }

    protected void createSaveButton() {
        $objectMap.put("saveButton", saveButton = new JButton());
        
        saveButton.setName("saveButton");
        saveButton.setText(_("tutti.editSpeciesFrequencies.action.save"));
        saveButton.setToolTipText(_("tutti.editSpeciesFrequencies.action.save.tip"));
        saveButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__saveButton"));
        saveButton.putClientProperty("help", "tutti.editSpeciesFrequencies.action.save.help");
    }

    protected void createSimpleCountingField() {
        $objectMap.put("simpleCountingField", simpleCountingField = new NumberEditor(this));
        
        simpleCountingField.setName("simpleCountingField");
        simpleCountingField.setProperty("simpleCount");
        simpleCountingField.setUseFloat(false);
        simpleCountingField.setShowReset(true);
    }

    protected void createSimpleCountingLabel() {
        $objectMap.put("simpleCountingLabel", simpleCountingLabel = new JLabel());
        
        simpleCountingLabel.setName("simpleCountingLabel");
        simpleCountingLabel.setText(_("tutti.editSpeciesFrequencies.field.simpleCounting"));
        simpleCountingLabel.setToolTipText(_("tutti.editSpeciesFrequencies.field.simpleCounting.tip"));
        simpleCountingLabel.putClientProperty("help", "tutti.editSpeciesFrequencies.field.simpleCounting.help");
    }

    protected void createSimpleCountingModeButton() {
        $objectMap.put("simpleCountingModeButton", simpleCountingModeButton = new JRadioButton());
        
        simpleCountingModeButton.setName("simpleCountingModeButton");
        simpleCountingModeButton.setText(_("tutti.editSpeciesFrequencies.field.mode.simpleCounting"));
        { simpleCountingModeButton.putClientProperty("$value", "simpleCountingMode");  Object $buttonGroup = simpleCountingModeButton.getClientProperty("$buttonGroup"); if ($buttonGroup instanceof JAXXButtonGroup) { ((JAXXButtonGroup) $buttonGroup).updateSelectedValue(); } }
        
        simpleCountingModeButton.setToolTipText(_("tutti.editSpeciesFrequencies.field.mode.simpleCounting.tip"));
        simpleCountingModeButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__simpleCountingModeButton"));
        simpleCountingModeButton.putClientProperty("help", "tutti.editSpeciesFrequencies.field.mode.simpleCounting.help");
    }

    protected void createSimpleCountingModeLabel() {
        $objectMap.put("simpleCountingModeLabel", simpleCountingModeLabel = new JLabel());
        
        simpleCountingModeLabel.setName("simpleCountingModeLabel");
        simpleCountingModeLabel.setEnabled(false);
        simpleCountingModeLabel.setText(_("tutti.editSpeciesFrequencies.label.no.configuration"));
    }

    protected void createSimpleCountingModePanel() {
        $objectMap.put("simpleCountingModePanel", simpleCountingModePanel = new JPanel());
        
        simpleCountingModePanel.setName("simpleCountingModePanel");
        simpleCountingModePanel.setLayout(new BorderLayout());
    }

    protected void createSimpleModeButton() {
        $objectMap.put("simpleModeButton", simpleModeButton = new JRadioButton());
        
        simpleModeButton.setName("simpleModeButton");
        simpleModeButton.setText(_("tutti.editSpeciesFrequencies.field.mode.simple"));
        { simpleModeButton.putClientProperty("$value", "simpleMode");  Object $buttonGroup = simpleModeButton.getClientProperty("$buttonGroup"); if ($buttonGroup instanceof JAXXButtonGroup) { ((JAXXButtonGroup) $buttonGroup).updateSelectedValue(); } }
        
        simpleModeButton.setToolTipText(_("tutti.editSpeciesFrequencies.field.mode.simple.tip"));
        simpleModeButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__simpleModeButton"));
        simpleModeButton.putClientProperty("help", "tutti.editSpeciesFrequencies.field.mode.simple.help");
    }

    protected void createSimpleModeLabel() {
        $objectMap.put("simpleModeLabel", simpleModeLabel = new JLabel());
        
        simpleModeLabel.setName("simpleModeLabel");
        simpleModeLabel.setEnabled(false);
        simpleModeLabel.setText(_("tutti.editSpeciesFrequencies.label.no.configuration"));
    }

    protected void createSimpleModePanel() {
        $objectMap.put("simpleModePanel", simpleModePanel = new JPanel());
        
        simpleModePanel.setName("simpleModePanel");
        simpleModePanel.setLayout(new BorderLayout());
    }

    protected void createStepField() {
        $objectMap.put("stepField", stepField = new NumberEditor(this));
        
        stepField.setName("stepField");
        stepField.setProperty("step");
        stepField.setUseFloat(true);
        stepField.putClientProperty("validatorLabel", _("tutti.editSpeciesFrequencies.field.step"));
        stepField.putClientProperty("selectOnFocus", true);
    }

    protected void createStepLabel() {
        $objectMap.put("stepLabel", stepLabel = new JLabel());
        
        stepLabel.setName("stepLabel");
        stepLabel.setText(_("tutti.editSpeciesFrequencies.field.step"));
        stepLabel.setToolTipText(_("tutti.editSpeciesFrequencies.field.step.tip"));
        stepLabel.putClientProperty("help", "tutti.editSpeciesFrequencies.field.step.help");
    }

    protected void createTable() {
        $objectMap.put("table", table = new JXTable());
        
        table.setName("table");
        table.setSortable(false);
    }

    protected void createTableScrollPane() {
        $objectMap.put("tableScrollPane", tableScrollPane = new JScrollPane());
        
        tableScrollPane.setName("tableScrollPane");
        tableScrollPane.putClientProperty("validatorLabel", _("tutti.editSpeciesFrequencies.field.rows"));
    }

    protected void createTotalNumberField() {
        $objectMap.put("totalNumberField", totalNumberField = new JTextField());
        
        totalNumberField.setName("totalNumberField");
        totalNumberField.setColumns(15);
        totalNumberField.setEnabled(false);
        totalNumberField.putClientProperty("computed", true);
    }

    protected void createTotalNumberLabel() {
        $objectMap.put("totalNumberLabel", totalNumberLabel = new JLabel());
        
        totalNumberLabel.setName("totalNumberLabel");
        totalNumberLabel.setText(_("tutti.editSpeciesFrequencies.field.totalNumber"));
        totalNumberLabel.setToolTipText(_("tutti.editSpeciesFrequencies.field.totalNumber.tip"));
        totalNumberLabel.putClientProperty("help", "tutti.editSpeciesFrequencies.field.totalNumber.help");
    }

    protected void createTotalWeightField() {
        $objectMap.put("totalWeightField", totalWeightField = new JTextField());
        
        totalWeightField.setName("totalWeightField");
        totalWeightField.setColumns(15);
        totalWeightField.setEnabled(false);
        totalWeightField.putClientProperty("computed", true);
    }

    protected void createTotalWeightLabel() {
        $objectMap.put("totalWeightLabel", totalWeightLabel = new JLabel());
        
        totalWeightLabel.setName("totalWeightLabel");
        totalWeightLabel.setText(_("tutti.editSpeciesFrequencies.field.totalWeight"));
        totalWeightLabel.setToolTipText(_("tutti.editSpeciesFrequencies.field.totalWeight.tip"));
        totalWeightLabel.putClientProperty("help", "tutti.editSpeciesFrequencies.field.totalWeight.help");
    }

    protected void createValidator() {
        $objectMap.put("validator", validator = SwingValidator.newValidator(SpeciesFrequencyUIModel.class, null));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToEditSpeciesFrequenciesTopPanel();
        addChildrenToValidator();
        addChildrenToConfigurationPanel();
        // inline complete setup of $Table0
        $Table0.add(batchSpeciesLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(batchSpecies, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(batchCategoryLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(batchCategory, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JSeparator0, new GridBagConstraints(0, 2, 2, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $JPanel0
        $JPanel0.add(modePanel, BorderLayout.WEST);
        $JPanel0.add(modeConfigurationPanel, BorderLayout.CENTER);
        addChildrenToModePanel();
        addChildrenToSimpleModeButton();
        addChildrenToAutoGenModeButton();
        addChildrenToRafaleModeButton();
        addChildrenToSimpleCountingModeButton();
        addChildrenToModeConfigurationPanel();
        addChildrenToSimpleModePanel();
        addChildrenToAutoGenModePanel();
        // inline complete setup of $Table1
        $Table1.add(minStepLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(minStepField, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(maxStepLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(maxStepField, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add($JPanel1, new GridBagConstraints(0, 2, 2, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $JPanel1
        $JPanel1.add(generateButton);
        addChildrenToRafaleModePanel();
        // inline complete setup of $Table2
        $Table2.add(rafaleStepLabel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table2.add(rafaleStepField, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        addChildrenToSimpleCountingModePanel();
        addChildrenToLengthstepSettingsBlock();
        addChildrenToDataFieldPanel();
        addChildrenToTableScrollPane();
        // inline complete setup of $Table3
        $Table3.add(dataInFrequenciesWarningContainer, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table3.add(simpleCountingLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table3.add(simpleCountingField, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        addChildrenToDataInFrequenciesWarningContainer();
        addChildrenToActionPanel();
        
        // apply 31 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 52 property setters
        modePanel.setVerticalAlignment(SwingConstants.CENTER);
        lengthStepCaracteristicComboBox.setBeanType(Caracteristic.class);
        configurationPanel.setBorder(new TitledBorder(null, null));
        simpleModeLabel.setHorizontalAlignment(JLabel.CENTER);
        minStepLabel.setLabelFor(minStepField);
        minStepField.setBean(model);
        minStepField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        minStepField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        maxStepLabel.setLabelFor(maxStepField);
        maxStepField.setBean(model);
        maxStepField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        maxStepField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        generateButton.setIcon(SwingUtil.createActionIcon("generate"));
        generateButton.setMnemonic(SwingUtil.getFirstCharAt(_("tutti.editSpeciesFrequencies.action.generate.mnemonic"),'Z'));
        rafaleStepLabel.setLabelFor(rafaleStepField);
        rafaleStepField.setModelType(Float.class);
        rafaleStepField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        rafaleStepField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        simpleCountingModeLabel.setHorizontalAlignment(JLabel.CENTER);
        lengthStepCaracteristicLabel.setLabelFor(lengthStepCaracteristicComboBox);
        lengthStepCaracteristicComboBox.setBean(model);
        stepLabel.setLabelFor(stepField);
        stepField.setBean(model);
        stepField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        stepField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        totalNumberLabel.setLabelFor(totalNumberField);
        totalWeightLabel.setLabelFor(totalWeightField);
        table.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
        table.setSelectionForeground(Color.BLACK);
        table.setSelectionBackground(null);
        dataInFrequenciesWarningContainer.setBackground(new java.awt.Color(245, 218, 88));
        dataInFrequenciesWarning.setIcon(SwingUtil.createActionIcon("warning"));
        dataInFrequenciesWarning.setBorder(new javax.swing.border.EmptyBorder(5, 10, 5, 10));
        simpleCountingLabel.setLabelFor(simpleCountingField);
        simpleCountingField.setBean(model);
        simpleCountingField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        simpleCountingField.setNumberPattern(TuttiUI.INT_6_DIGITS_PATTERN);
        simpleCountingField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        cancelButton.setIcon(SwingUtil.createActionIcon("cancel"));
        cancelButton.setMnemonic(SwingUtil.getFirstCharAt(_("tutti.editSpeciesFrequencies.action.cancel.mnemonic"),'Z'));
        saveButton.setIcon(SwingUtil.createActionIcon("save"));
        saveButton.setMnemonic(SwingUtil.getFirstCharAt(_("tutti.editSpeciesFrequencies.action.save.mnemonic"),'Z'));
        // late initializer
        // help broker setup
        TuttiHelpBroker _broker = getBroker();
        registerHelpId(_broker, editSpeciesFrequenciesTopPanel, "tutti.editSpeciesFrequencies.help");
        registerHelpId(_broker, simpleModeButton, "tutti.editSpeciesFrequencies.field.mode.simple.help");
        registerHelpId(_broker, autoGenModeButton, "tutti.editSpeciesFrequencies.field.mode.autoGen.help");
        registerHelpId(_broker, rafaleModeButton, "tutti.editSpeciesFrequencies.field.mode.rafale.help");
        registerHelpId(_broker, simpleCountingModeButton, "tutti.editSpeciesFrequencies.field.mode.simpleCounting.help");
        registerHelpId(_broker, minStepLabel, "tutti.editSpeciesFrequencies.field.minStep.help");
        registerHelpId(_broker, maxStepLabel, "tutti.editSpeciesFrequencies.field.maxStep.help");
        registerHelpId(_broker, generateButton, "tutti.editSpeciesFrequencies.action.generate.help");
        registerHelpId(_broker, rafaleStepLabel, "tutti.editSpeciesFrequencies.field.rafaleStep.help");
        registerHelpId(_broker, lengthStepCaracteristicLabel, "tutti.editSpeciesFrequencies.field.lengthStepCaracteristic.help");
        registerHelpId(_broker, stepLabel, "tutti.editSpeciesFrequencies.field.step.help");
        registerHelpId(_broker, totalNumberLabel, "tutti.editSpeciesFrequencies.field.totalNumber.help");
        registerHelpId(_broker, totalWeightLabel, "tutti.editSpeciesFrequencies.field.totalWeight.help");
        registerHelpId(_broker, simpleCountingLabel, "tutti.editSpeciesFrequencies.field.simpleCounting.help");
        registerHelpId(_broker, cancelButton, "tutti.editSpeciesFrequencies.action.cancel.help");
        registerHelpId(_broker, saveButton, "tutti.editSpeciesFrequencies.action.save.help");
        _broker.prepareUI(this);
        // register 1 validator(s)
        validatorIds = SwingValidatorUtil.detectValidators(this);
        SwingValidatorUtil.installUI(this);
        
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("editSpeciesFrequenciesTopPanel", editSpeciesFrequenciesTopPanel);
        createHandler();
        createModel();
        createValidator();
        createBroker();
        createModeConfigurationLayout();
        createDataFieldLayout();
        createConfigurationPanel();
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new Table());
        
        $Table0.setName("$Table0");
        createBatchSpeciesLabel();
        createBatchSpecies();
        createBatchCategoryLabel();
        createBatchCategory();
        // inline creation of $JSeparator0
        $objectMap.put("$JSeparator0", $JSeparator0 = new JSeparator());
        
        $JSeparator0.setName("$JSeparator0");
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new JPanel());
        
        $JPanel0.setName("$JPanel0");
        $JPanel0.setLayout(new BorderLayout());
        createModePanel();
        createSimpleModeButton();
        createAutoGenModeButton();
        createRafaleModeButton();
        createSimpleCountingModeButton();
        createModeConfigurationPanel();
        createSimpleModePanel();
        createSimpleModeLabel();
        createAutoGenModePanel();
        // inline creation of $Table1
        $objectMap.put("$Table1", $Table1 = new Table());
        
        $Table1.setName("$Table1");
        createMinStepLabel();
        createMinStepField();
        createMaxStepLabel();
        createMaxStepField();
        // inline creation of $JPanel1
        $objectMap.put("$JPanel1", $JPanel1 = new JPanel());
        
        $JPanel1.setName("$JPanel1");
        $JPanel1.setLayout(new GridLayout(1, 0));
        createGenerateButton();
        createRafaleModePanel();
        // inline creation of $Table2
        $objectMap.put("$Table2", $Table2 = new Table());
        
        $Table2.setName("$Table2");
        createRafaleStepLabel();
        createRafaleStepField();
        createSimpleCountingModePanel();
        createSimpleCountingModeLabel();
        createLengthstepSettingsBlock();
        // inline creation of $JSeparator1
        $objectMap.put("$JSeparator1", $JSeparator1 = new JSeparator());
        
        $JSeparator1.setName("$JSeparator1");
        createLengthStepCaracteristicLabel();
        createLengthStepCaracteristicComboBox();
        createStepLabel();
        createStepField();
        createTotalNumberLabel();
        createTotalNumberField();
        createTotalWeightLabel();
        createTotalWeightField();
        createDataFieldPanel();
        createTableScrollPane();
        createTable();
        // inline creation of $Table3
        $objectMap.put("$Table3", $Table3 = new Table());
        
        $Table3.setName("$Table3");
        createDataInFrequenciesWarningContainer();
        createDataInFrequenciesWarning();
        createSimpleCountingLabel();
        createSimpleCountingField();
        createActionPanel();
        createCancelButton();
        createSaveButton();
        createMode();
        // inline creation of editSpeciesFrequenciesTopPanel
        setName("editSpeciesFrequenciesTopPanel");
        setLayout(new BorderLayout());
        editSpeciesFrequenciesTopPanel.putClientProperty("help", "tutti.editSpeciesFrequencies.help");
        
        // registers 31 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 31 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_MODE_CONFIGURATION_LAYOUT_SELECTED, true) {
        
            @Override
            public void applyDataBinding() {
                if (mode != null) {
                    mode.addPropertyChangeListener("selectedValue", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (mode != null) {
                    modeConfigurationLayout.setSelected(String.valueOf(mode.getSelectedValue()));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (mode != null) {
                    mode.removePropertyChangeListener("selectedValue", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_DATA_FIELD_LAYOUT_SELECTED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("simpleCountingMode", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    dataFieldLayout.setSelected(model.isSimpleCountingMode() ? "noLengthCaracteristicPmfm" : "lengthCaracteristicPmfm");
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("simpleCountingMode", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_BATCH_SPECIES_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("batch", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    SwingUtil.setText(batchSpecies,  handler.decorateSpecies(model.getBatch()) );
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("batch", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_BATCH_CATEGORY_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("batch", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    SwingUtil.setText(batchCategory,  handler.decorateCategory(model.getBatch()) );
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("batch", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SIMPLE_MODE_BUTTON_SELECTED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("simpleMode", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    simpleModeButton.setSelected(model.isSimpleMode());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("simpleMode", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_AUTO_GEN_MODE_BUTTON_SELECTED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("autoGenMode", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    autoGenModeButton.setSelected(model.isAutoGenMode());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("autoGenMode", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_RAFALE_MODE_BUTTON_SELECTED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("rafaleMode", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    rafaleModeButton.setSelected(model.isRafaleMode());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("rafaleMode", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SIMPLE_COUNTING_MODE_BUTTON_SELECTED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("simpleCountingMode", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    simpleCountingModeButton.setSelected(model.isSimpleCountingMode());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("simpleCountingMode", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_MIN_STEP_FIELD_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("minStep", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    minStepField.setModel(model.getMinStep());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("minStep", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_MIN_STEP_FIELD_NUMBER_PATTERN, true ,"DECIMAL1_PATTERN") {
        
            @Override
            public void processDataBinding() {
                minStepField.setNumberPattern(DECIMAL1_PATTERN);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_MAX_STEP_FIELD_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("maxStep", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    maxStepField.setModel(model.getMaxStep());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("maxStep", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_MAX_STEP_FIELD_NUMBER_PATTERN, true ,"DECIMAL1_PATTERN") {
        
            @Override
            public void processDataBinding() {
                maxStepField.setNumberPattern(DECIMAL1_PATTERN);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_GENERATE_BUTTON_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("canGenerate", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    generateButton.setEnabled(model.isCanGenerate());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("canGenerate", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_RAFALE_STEP_FIELD_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("lengthStepCaracteristic", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    rafaleStepField.setEnabled(model.getLengthStepCaracteristic() != null);
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("lengthStepCaracteristic", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_RAFALE_STEP_FIELD_NUMBER_PATTERN, true ,"DECIMAL1_PATTERN") {
        
            @Override
            public void processDataBinding() {
                rafaleStepField.setNumberPattern(DECIMAL1_PATTERN);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_LENGTHSTEP_SETTINGS_BLOCK_VISIBLE, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("simpleCountingMode", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    lengthstepSettingsBlock.setVisible(!model.isSimpleCountingMode());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("simpleCountingMode", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_LENGTH_STEP_CARACTERISTIC_LABEL_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("simpleCountingMode", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    lengthStepCaracteristicLabel.setEnabled(!model.isSimpleCountingMode());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("simpleCountingMode", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_LENGTH_STEP_CARACTERISTIC_COMBO_BOX_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("simpleCountingMode", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    lengthStepCaracteristicComboBox.setEnabled(!model.isSimpleCountingMode());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("simpleCountingMode", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_LENGTH_STEP_CARACTERISTIC_COMBO_BOX_SELECTED_ITEM, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("lengthStepCaracteristic", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    lengthStepCaracteristicComboBox.setSelectedItem(model.getLengthStepCaracteristic());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("lengthStepCaracteristic", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_STEP_LABEL_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("simpleCountingMode", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    stepLabel.setEnabled(!model.isSimpleCountingMode());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("simpleCountingMode", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_STEP_FIELD_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("simpleCountingMode", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    stepField.setEnabled(!model.isSimpleCountingMode());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("simpleCountingMode", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_STEP_FIELD_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("step", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    stepField.setModel(model.getStep());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("step", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_STEP_FIELD_NUMBER_PATTERN, true ,"DECIMAL1_PATTERN") {
        
            @Override
            public void processDataBinding() {
                stepField.setNumberPattern(DECIMAL1_PATTERN);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_TOTAL_NUMBER_LABEL_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("simpleCountingMode", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    totalNumberLabel.setEnabled(!model.isSimpleCountingMode());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("simpleCountingMode", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_TOTAL_NUMBER_FIELD_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("totalNumber", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    SwingUtil.setText(totalNumberField, getStringValue(model.getTotalNumber()));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("totalNumber", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_TOTAL_WEIGHT_LABEL_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("totalWeight", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    totalWeightLabel.setEnabled(model.getTotalWeight() != null);
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("totalWeight", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_TOTAL_WEIGHT_FIELD_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("totalWeight", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    SwingUtil.setText(totalWeightField, TuttiUIUtil.getWeightStringValue(model.getTotalWeight()));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("totalWeight", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_TABLE_ENABLED, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("lengthStepCaracteristic", this);
                }
                if (model != null) {
                    model.addPropertyChangeListener("step", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    table.setEnabled(model.getLengthStepCaracteristic() != null && model.getStep() > 0f);
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("lengthStepCaracteristic", this);
                }
                if (model != null) {
                    model.removePropertyChangeListener("step", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_DATA_IN_FREQUENCIES_WARNING_CONTAINER_VISIBLE, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("rowsInError", this);
                }
                if (model != null) {
                    model.addPropertyChangeListener("rows", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null && model.getRows() != null && model.getRowsInError() != null) {
                    dataInFrequenciesWarningContainer.setVisible(model.getRowsInError().size() != model.getRows().size());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("rowsInError", this);
                }
                if (model != null) {
                    model.removePropertyChangeListener("rows", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SIMPLE_COUNTING_FIELD_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("simpleCount", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    simpleCountingField.setModel(model.getSimpleCount());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("simpleCount", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SAVE_BUTTON_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("valid", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    saveButton.setEnabled(model.isValid());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("valid", this);
                }
            }
        });
    }

}