package fr.ifremer.tutti.ui.swing.content.db;

/*
 * #%L
 * Tutti :: UI
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2013 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.ui.swing.TuttiHelpBroker;
import fr.ifremer.tutti.ui.swing.TuttiUIContext;
import fr.ifremer.tutti.ui.swing.content.UpdateDbAction;
import fr.ifremer.tutti.ui.swing.util.TuttiUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.help.JAXXHelpUI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static org.nuiton.i18n.I18n._;

public class DbManagerUI extends JPanel implements JAXXHelpUI<TuttiHelpBroker>, TuttiUI<TuttiUIContext, DbManagerUIHandler>, JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_EXPORT_AND_CLEAN_DB_BUTTON_ENABLED = "exportAndCleanDbButton.enabled";
    public static final String BINDING_EXPORT_DB_BUTTON_ENABLED = "exportDbButton.enabled";
    public static final String BINDING_INFORMATION_LABEL_TEXT = "informationLabel.text";
    public static final String BINDING_NO_DB_ACTIONS_VISIBLE = "noDbActions.visible";
    public static final String BINDING_UPGRADE_DB_BUTTON_ENABLED = "upgradeDbButton.enabled";
    public static final String BINDING_WITH_DB_ACTIONS_VISIBLE = "withDbActions.visible";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAK1Wz28bRRSeuLWN7aRpE4hSGmiaIGELug7iUFBQaWoniiunoMaRKnwos96JPWU9u8zONlusIP4E/gS4c+HHjRPiwJkDF8S/gBCHXhFvdte79nrX6yjJYRW/ed97b77Z79v57m+UtTi69RQ7jsJtJmifKA92Hj/+SH1KOqJOrA6npjA48v7mMijTRiUtiFsCbbabEl714dWa0TcNRtgIeruJipZ4rhOrR4gQ6LVxRMeyqofB8rZj2nxYNRgqruo3//6T+Vr76tsMQo4J0y3AVtbTUOFOLjdRhmoCLUGnZ7iqY9aFMThlXZh3QcZqOrash7hPPkdfonwT5UzMoZhAG7Nv2a3h4h1ToGuaeoAZ7hLeMsyPMSO6QFvHXKHHnPQJV4QtBFVsqlgnMIfSMZiAsoqmKvUh8Khhmm7BnED5HmaaTrhAd85aZN9DhrWyfUOT45STK7Xkz6NGTRZ0RAjNqdz4TE5RScHuE9287+aG4KuUHRu8jwU1WBOrcoQlSb7jAx+4QZlcCDClDmyIcJ/A8XQ3GElnRl3d6cgObuhV+VgNlhcpswTW9bp6H4aEzaHlsYpeVCbfCDBXKBw5F0OIjN4cz1g4oaI3ta1tdjnWyESNjbALcWK7hBkrXsYO02o6wSwuk6MbY6IAuSmh3EI9zLVRltsQFmi1PanQR7DkaXM1ok1Z0F39b2X5j5//+mlvVJCvxKaO+AkIxeSGCa8Pla0XPTXagurVA2xut1HBIjqYkWs2azGDHfrLMBz0uybhioQr+9jqQYls/s9ffl359PdLKLOHirqBtT0s8xuoIHocWDB0zTE/vOdONH/yEjyvytlAEk968MICHYMN720O1KvIhY1TB9hYi2EjGEkt/PZi+fD7e0NG5mDC64npISvZT1COMp0y4pqU7z+xplQyLWJrRugzcc6D4qzH9EVYdZ/vTjBwCYTQMzj9AiSB9R2ddlnftb/FgSdKpbb7sLX76FSgy9IQBLo78A1JsU0NC3JALAs6ll1rUahVV3cdaoly5e31MNSEEyFauVKBOkXsyqUhPQuVRpzBseWMd1wK5X/voxjnSNsQHGn+GbWoqsN7//Lg1sRYp3FtRt0jrUMuoGI9+sZ4O1MCr4lstugv3NZgZf6Ji/aagsgHRy6dwzGUjjxaoGuevvMeO2CkbzDaAftN66n0g9ySMAy9Rc2WO+0bqUgBn7VAEJVJQUwAhgqZJDTqt7OTejOpq2/GEU4LXjye0oaPmU5pOaVjIqObacAxQsvJhA7zk/mMfIvOpILlwWwiGP+apbXIQwvCMHTQpNAmtX6aqpPg4xg50yXPWW5zckzkZYxi/cL1EvQ+s15C5Ix6CQFT9BK5KFwg+0mCGt47ooLy4vGC2nXOI6hhxzMLKgDOKKggf4qgxq9dF8j3m1OHCm9xs/P+us97iJ3O/9aMEySew1uzFhg7j62U8xjBJZ9LwmV3BsPL6fi5AcnoygdgDHhdpUyDu/3diS5z8llMrSjDP8jHj/EVrp+7wtq5K2xChf8BSGTAMOEPAAA=";
    private static final Log log = LogFactory.getLog(DbManagerUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected TuttiHelpBroker broker;
    protected JPanel centerPanel;
    protected DbManagerUI dbManagerTopPanel = this;
    protected JButton exportAndCleanDbButton;
    protected JButton exportDbButton;
    protected DbManagerUIHandler handler;
    protected JButton importDbButton;
    protected JLabel informationLabel;
    protected JButton installDbButton;
    protected TuttiUIContext model;
    protected JPanel noDbActions;
    protected JButton upgradeDbButton;
    protected JPanel withDbActions;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/
    
    
        protected void $afterCompleteSetup() {
            handler.afterInitUI();
        }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public DbManagerUI(TuttiUI parentUI) {
        JAXXUtil.initContext(this, parentUI);
                DbManagerUIHandler handler = new DbManagerUIHandler(parentUI.getHandler().getContext(), this);
                setContextValue(handler);
                handler.beforeInitUI();
            $initialize();
    }

    public DbManagerUI() {
        $initialize();
    }

    public DbManagerUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public DbManagerUI(boolean param0) {
        super(param0);
        $initialize();
    }

    public DbManagerUI(JAXXContext parentContext, boolean param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public DbManagerUI(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public DbManagerUI(JAXXContext parentContext, LayoutManager param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public DbManagerUI(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public DbManagerUI(JAXXContext parentContext, LayoutManager param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public TuttiHelpBroker getBroker() {
        return broker;
    }

    public JPanel getCenterPanel() {
        return centerPanel;
    }

    public JButton getExportAndCleanDbButton() {
        return exportAndCleanDbButton;
    }

    public JButton getExportDbButton() {
        return exportDbButton;
    }

    public DbManagerUIHandler getHandler() {
        return handler;
    }

    public JButton getImportDbButton() {
        return importDbButton;
    }

    public JLabel getInformationLabel() {
        return informationLabel;
    }

    public JButton getInstallDbButton() {
        return installDbButton;
    }

    public TuttiUIContext getModel() {
        return model;
    }

    public JPanel getNoDbActions() {
        return noDbActions;
    }

    public JButton getUpgradeDbButton() {
        return upgradeDbButton;
    }

    public JPanel getWithDbActions() {
        return withDbActions;
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Other methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void registerHelpId(TuttiHelpBroker broker, Component component, String helpId) {
        broker.installUI(component, helpId);
    }

    @Override
    public void showHelp(String helpId) {
        getBroker().showHelp(this, helpId);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToCenterPanel() {
        if (!allComponentsCreated) {
            return;
        }
        centerPanel.add(noDbActions, BorderLayout.CENTER);
        centerPanel.add(withDbActions, BorderLayout.SOUTH);
    }

    protected void addChildrenToDbManagerTopPanel() {
        if (!allComponentsCreated) {
            return;
        }
        add(informationLabel, BorderLayout.CENTER);
        add(centerPanel, BorderLayout.SOUTH);
    }

    protected void addChildrenToNoDbActions() {
        if (!allComponentsCreated) {
            return;
        }
        noDbActions.add(installDbButton);
        noDbActions.add(importDbButton);
    }

    protected void addChildrenToWithDbActions() {
        if (!allComponentsCreated) {
            return;
        }
        withDbActions.add(upgradeDbButton);
        withDbActions.add(exportDbButton);
        withDbActions.add(exportAndCleanDbButton);
    }

    protected void createBroker() {
        $objectMap.put("broker", broker = new TuttiHelpBroker("tutti.dbManager.help"));
    }

    protected void createCenterPanel() {
        $objectMap.put("centerPanel", centerPanel = new JPanel());
        
        centerPanel.setName("centerPanel");
        centerPanel.setLayout(new BorderLayout());
    }

    protected void createExportAndCleanDbButton() {
        $objectMap.put("exportAndCleanDbButton", exportAndCleanDbButton = new JButton());
        
        exportAndCleanDbButton.setName("exportAndCleanDbButton");
        exportAndCleanDbButton.setText(_("tutti.dbManager.action.exportAndCleanDb"));
        exportAndCleanDbButton.setToolTipText(_("tutti.dbManager.action.exportAndCleanDb.tip"));
        exportAndCleanDbButton.putClientProperty("help", "tutti.dbManager.action.exportAndCleanDb.help");
        exportAndCleanDbButton.putClientProperty("tuttiAction", ExportAndCleanDbAction.class);
    }

    protected void createExportDbButton() {
        $objectMap.put("exportDbButton", exportDbButton = new JButton());
        
        exportDbButton.setName("exportDbButton");
        exportDbButton.setText(_("tutti.dbManager.action.exportDb"));
        exportDbButton.setToolTipText(_("tutti.dbManager.action.exportDb.tip"));
        exportDbButton.putClientProperty("help", "tutti.dbManager.action.exportDb.help");
        exportDbButton.putClientProperty("tuttiAction", ExportDbAction.class);
    }

    protected void createHandler() {
        $objectMap.put("handler", handler = getContextValue(DbManagerUIHandler.class));
    }

    protected void createImportDbButton() {
        $objectMap.put("importDbButton", importDbButton = new JButton());
        
        importDbButton.setName("importDbButton");
        importDbButton.setText(_("tutti.dbManager.action.importDb"));
        importDbButton.setToolTipText(_("tutti.dbManager.action.importDb.tip"));
        importDbButton.putClientProperty("help", "tutti.dbManager.action.importDb.help");
        importDbButton.putClientProperty("tuttiAction", ImportDbAction.class);
    }

    protected void createInformationLabel() {
        $objectMap.put("informationLabel", informationLabel = new JLabel());
        
        informationLabel.setName("informationLabel");
    }

    protected void createInstallDbButton() {
        $objectMap.put("installDbButton", installDbButton = new JButton());
        
        installDbButton.setName("installDbButton");
        installDbButton.setText(_("tutti.dbManager.action.installDb"));
        installDbButton.setToolTipText(_("tutti.dbManager.action.installDb.tip"));
        installDbButton.putClientProperty("help", "tutti.dbManager.action.installDb.help");
        installDbButton.putClientProperty("tuttiAction", UpdateDbAction.class);
    }

    protected void createModel() {
        $objectMap.put("model", model = getContextValue(TuttiUIContext.class));
    }

    protected void createNoDbActions() {
        $objectMap.put("noDbActions", noDbActions = new JPanel());
        
        noDbActions.setName("noDbActions");
        noDbActions.setLayout(new GridLayout(0, 1));
    }

    protected void createUpgradeDbButton() {
        $objectMap.put("upgradeDbButton", upgradeDbButton = new JButton());
        
        upgradeDbButton.setName("upgradeDbButton");
        upgradeDbButton.setText(_("tutti.dbManager.action.upgradeDb"));
        upgradeDbButton.setToolTipText(_("tutti.dbManager.action.upgradeDb.tip"));
        upgradeDbButton.putClientProperty("help", "tutti.dbManager.action.upgradeDb.help");
        upgradeDbButton.putClientProperty("tuttiAction", UpdateDbAction.class);
    }

    protected void createWithDbActions() {
        $objectMap.put("withDbActions", withDbActions = new JPanel());
        
        withDbActions.setName("withDbActions");
        withDbActions.setLayout(new GridLayout(0, 1));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToDbManagerTopPanel();
        addChildrenToCenterPanel();
        addChildrenToNoDbActions();
        addChildrenToWithDbActions();
        
        // apply 6 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 16 property setters
        informationLabel.setHorizontalAlignment(JLabel.CENTER);
        informationLabel.setIcon(SwingUtil.createActionIcon("information"));
        installDbButton.setIcon(SwingUtil.createActionIcon("install-db"));
        installDbButton.setMnemonic(SwingUtil.getFirstCharAt(_("tutti.dbManager.action.installDb.mnemonic"),'Z'));
        importDbButton.setIcon(SwingUtil.createActionIcon("import-db"));
        importDbButton.setMnemonic(SwingUtil.getFirstCharAt(_("tutti.dbManager.action.importDb.mnemonic"),'Z'));
        upgradeDbButton.setIcon(SwingUtil.createActionIcon("update-referential"));
        upgradeDbButton.setMnemonic(SwingUtil.getFirstCharAt(_("tutti.dbManager.action.upgradeDb.mnemonic"),'Z'));
        exportDbButton.setIcon(SwingUtil.createActionIcon("export-db"));
        exportDbButton.setMnemonic(SwingUtil.getFirstCharAt(_("tutti.dbManager.action.exportDb.mnemonic"),'Z'));
        exportAndCleanDbButton.setIcon(SwingUtil.createActionIcon("export-db"));
        exportAndCleanDbButton.setMnemonic(SwingUtil.getFirstCharAt(_("tutti.dbManager.action.exportAndCleanDb.mnemonic"),'Z'));
        // late initializer
        // help broker setup
        TuttiHelpBroker _broker = getBroker();
        registerHelpId(_broker, dbManagerTopPanel, "tutti.dbManager.help");
        registerHelpId(_broker, installDbButton, "tutti.dbManager.action.installDb.help");
        registerHelpId(_broker, importDbButton, "tutti.dbManager.action.importDb.help");
        registerHelpId(_broker, upgradeDbButton, "tutti.dbManager.action.upgradeDb.help");
        registerHelpId(_broker, exportDbButton, "tutti.dbManager.action.exportDb.help");
        registerHelpId(_broker, exportAndCleanDbButton, "tutti.dbManager.action.exportAndCleanDb.help");
        _broker.prepareUI(this);
        
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("dbManagerTopPanel", dbManagerTopPanel);
        createHandler();
        createModel();
        createBroker();
        createInformationLabel();
        createCenterPanel();
        createNoDbActions();
        createInstallDbButton();
        createImportDbButton();
        createWithDbActions();
        createUpgradeDbButton();
        createExportDbButton();
        createExportAndCleanDbButton();
        // inline creation of dbManagerTopPanel
        setName("dbManagerTopPanel");
        setLayout(new BorderLayout());
        dbManagerTopPanel.putClientProperty("help", "tutti.dbManager.help");
        
        // registers 6 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 6 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_INFORMATION_LABEL_TEXT, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("dbExist", this);
                }
                if (model != null) {
                    model.addPropertyChangeListener("dbLoaded", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    informationLabel.setText(_(handler.updateMessage(model.isDbExist(), model.isDbLoaded())));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("dbExist", this);
                }
                if (model != null) {
                    model.removePropertyChangeListener("dbLoaded", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_NO_DB_ACTIONS_VISIBLE, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("dbExist", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    noDbActions.setVisible(!model.isDbExist());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("dbExist", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_WITH_DB_ACTIONS_VISIBLE, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("dbExist", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    withDbActions.setVisible(model.isDbExist());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("dbExist", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_UPGRADE_DB_BUTTON_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("dbLoaded", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    upgradeDbButton.setEnabled(model.isDbLoaded());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("dbLoaded", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_EXPORT_DB_BUTTON_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("dbLoaded", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    exportDbButton.setEnabled(model.isDbLoaded());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("dbLoaded", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_EXPORT_AND_CLEAN_DB_BUTTON_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("dbLoaded", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    exportAndCleanDbButton.setEnabled(model.isDbLoaded());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("dbLoaded", this);
                }
            }
        });
    }

}