package fr.ifremer.tutti.ui.swing.content;

/*
 * #%L
 * Tutti :: UI
 * $Id: UpdateDbAction.java 998 2013-05-23 16:23:44Z tchemit $
 * $HeadURL: http://svn.forge.codelutin.com/svn/tutti/tags/tutti-2.3/tutti-ui-swing/src/main/java/fr/ifremer/tutti/ui/swing/content/UpdateDbAction.java $
 * %%
 * Copyright (C) 2012 - 2013 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.TuttiBusinessException;
import fr.ifremer.tutti.persistence.ProgressionModel;
import fr.ifremer.tutti.ui.swing.TuttiApplicationUpdaterCallBack;
import fr.ifremer.tutti.ui.swing.TuttiUIContext;
import fr.ifremer.tutti.ui.swing.config.TuttiApplicationConfig;
import fr.ifremer.tutti.ui.swing.content.db.OpenDbAction;
import fr.ifremer.tutti.ui.swing.util.TuttiUIUtil;
import fr.ifremer.tutti.ui.swing.util.action.TuttiActionHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.util.updater.ApplicationUpdater;

import java.io.File;

import static org.nuiton.i18n.I18n._;
import static org.nuiton.i18n.I18n.n_;

/**
 * To update - install database.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 1.0
 */
public class UpdateDbAction extends AbstractMainUITuttiAction {

    /** Logger. */
    private static final Log log =
            LogFactory.getLog(UpdateDbAction.class);

    public UpdateDbAction(MainUIHandler handler) {
        super(handler, true);
        setActionDescription(_("tutti.dbManager.action.upgradeDb.tip"));
    }

    @Override
    protected boolean prepareAction() throws Exception {
        TuttiUIContext context = getContext();
        TuttiApplicationConfig config = context.getConfig();
        String url = config.getUpdateUrl();

        try {
            TuttiUIUtil.tryToConnectToUpdateUrl(
                    url,
                    n_("tutti.error.update.could.not.reach.url")
            );
        } catch (TuttiBusinessException e) {
            TuttiUIContext.getErrorHelper().showWarningDialog(e.getMessage());
            return false;
        }

        return super.prepareAction();
    }

    @Override
    protected void doAction() {
        TuttiUIContext context = getContext();
        TuttiApplicationConfig config = context.getConfig();

        File current = config.getDataDirectory();
        String url = config.getUpdateUrl();

        if (log.isInfoEnabled()) {
            log.info(String.format("Try to install / update db (current data location: %s), using update url: %s", current, url));
        }

        File dest = new File(config.getTuttiBasedir(), "NEW");
        ProgressionModel progressionModel = new ProgressionModel();
        context.getActionUI().getModel().setProgressionModel(progressionModel);
        progressionModel.setMessage(_("tutti.dbManager.action.upgradeDb.check"));
        TuttiApplicationUpdaterCallBack callback =
                new TuttiApplicationUpdaterCallBack(this, progressionModel);
        callback.setTypes(TuttiApplicationUpdaterCallBack.UpdateType.DB);
        ApplicationUpdater up = new ApplicationUpdater();
        up.update(url,
                  current,
                  dest,
                  false,
                  callback,
                  progressionModel);

        if (callback.isDbInstalled()) {

            progressionModel.setMessage(_("tutti.dbManager.action.upgradeDb.opening"));

            getContext().setDbExist(true);

            // open db
            TuttiActionHelper.runInternalAction(getHandler(), OpenDbAction.class);

        } else if (callback.isDbUpdated()) {

            progressionModel.setMessage(_("tutti.dbManager.action.upgradeDb.reloading"));

            // open db
            TuttiActionHelper.runInternalAction(getHandler(), OpenDbAction.class);

        } else {
            sendMessage(_("tutti.dbManager.action.upgradeDb.upToDate"));
        }
    }
}