/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.persistence.service;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import fr.ifremer.adagio.core.dao.administration.programStrategy.Program;
import fr.ifremer.adagio.core.dao.administration.user.Department;
import fr.ifremer.adagio.core.dao.administration.user.DepartmentImpl;
import fr.ifremer.adagio.core.dao.administration.user.Person;
import fr.ifremer.adagio.core.dao.administration.user.PersonImpl;
import fr.ifremer.adagio.core.dao.data.batch.Batch;
import fr.ifremer.adagio.core.dao.data.batch.CatchBatch;
import fr.ifremer.adagio.core.dao.data.operation.FishingOperationImpl;
import fr.ifremer.adagio.core.dao.data.sample.Sample;
import fr.ifremer.adagio.core.dao.referential.QualityFlag;
import fr.ifremer.adagio.core.dao.referential.QualityFlagImpl;
import fr.ifremer.adagio.core.dao.referential.pmfm.Matrix;
import fr.ifremer.adagio.core.dao.referential.pmfm.MatrixImpl;
import fr.ifremer.adagio.core.dao.referential.taxon.ReferenceTaxon;
import fr.ifremer.adagio.core.dao.referential.taxon.ReferenceTaxonImpl;
import fr.ifremer.adagio.core.dao.technical.synchronization.SynchronizationStatus;
import fr.ifremer.tutti.persistence.entities.CaracteristicMap;
import fr.ifremer.tutti.persistence.entities.TuttiBeanFactory;
import fr.ifremer.tutti.persistence.entities.TuttiEntities;
import fr.ifremer.tutti.persistence.entities.data.FishingOperation;
import fr.ifremer.tutti.persistence.entities.data.IndividualObservationBatch;
import fr.ifremer.tutti.persistence.entities.referential.Caracteristic;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.persistence.service.AbstractPersistenceService;
import fr.ifremer.tutti.persistence.service.AttachmentPersistenceService;
import fr.ifremer.tutti.persistence.service.IndividualObservationBatchPersistenceService;
import fr.ifremer.tutti.persistence.service.ReferentialPersistenceService;
import fr.ifremer.tutti.persistence.service.SamplePersistenceHelper;
import fr.ifremer.tutti.persistence.service.batch.BatchPersistenceHelper;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.type.IntegerType;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataRetrievalFailureException;
import org.springframework.stereotype.Service;

@Service(value="individualObservationBatchPersistenceService")
public class IndividualObservationBatchPersistenceServiceImpl
extends AbstractPersistenceService
implements IndividualObservationBatchPersistenceService {
    private static final Log log = LogFactory.getLog(IndividualObservationBatchPersistenceServiceImpl.class);
    @Autowired
    protected ReferentialPersistenceService referentialService;
    @Autowired
    protected AttachmentPersistenceService attachmentPersistenceService;
    @Resource(name="samplePersistenceHelper")
    protected SamplePersistenceHelper samplePersistenceHelper;
    @Resource(name="batchPersistenceHelper")
    protected BatchPersistenceHelper batchHelper;

    @Override
    public List<IndividualObservationBatch> getAllIndividualObservationBatch(String fishingOperationId) {
        Preconditions.checkNotNull((Object)fishingOperationId);
        Integer operationId = Integer.valueOf(fishingOperationId);
        Batch catchBatch = this.getBatch(operationId);
        Iterator<Object[]> list = this.queryList("allFishingOperationSamplesWithBatch", "fishingOperationId", IntegerType.INSTANCE, operationId, "batchId", IntegerType.INSTANCE, catchBatch.getId());
        ArrayList result = Lists.newArrayList();
        while (list.hasNext()) {
            Object[] source = list.next();
            IndividualObservationBatch batch = TuttiBeanFactory.newIndividualObservationBatch();
            int colIndex = 0;
            batch.setId((Integer)source[colIndex++]);
            Integer taxonId = (Integer)source[colIndex++];
            Species species = this.referentialService.getSpeciesByReferenceTaxonId(taxonId);
            batch.setSpecies(species);
            batch.setComment((String)source[colIndex]);
            batch.setCaracteristics(new CaracteristicMap());
            this.fillSampleMeasurements(batch);
            result.add(batch);
        }
        return Collections.unmodifiableList(result);
    }

    @Override
    public IndividualObservationBatch createIndividualObservationBatch(IndividualObservationBatch bean) {
        Preconditions.checkNotNull((Object)bean);
        Preconditions.checkState((boolean)TuttiEntities.isNew(bean));
        Preconditions.checkNotNull((Object)bean.getSpecies());
        Preconditions.checkNotNull((Object)bean.getSize());
        Preconditions.checkNotNull((Object)bean.getLengthStepCaracteristic());
        FishingOperation fishingOperation = bean.getFishingOperation();
        Preconditions.checkNotNull((Object)fishingOperation);
        Preconditions.checkState((!TuttiEntities.isNew(fishingOperation) ? 1 : 0) != 0);
        Batch catchBatch = this.getBatch(fishingOperation.getIdAsInt());
        Sample sample = Sample.Factory.newInstance();
        this.beanToEntity(bean, sample, catchBatch);
        this.samplePersistenceHelper.create(sample);
        bean.setId(String.valueOf(sample.getId()));
        return bean;
    }

    @Override
    public IndividualObservationBatch saveIndividualObservationBatch(IndividualObservationBatch bean) {
        Preconditions.checkNotNull((Object)bean);
        Preconditions.checkState((!TuttiEntities.isNew(bean) ? 1 : 0) != 0);
        Preconditions.checkNotNull((Object)bean.getSpecies());
        Preconditions.checkNotNull((Object)bean.getSize());
        Preconditions.checkNotNull((Object)bean.getLengthStepCaracteristic());
        FishingOperation fishingOperation = bean.getFishingOperation();
        Preconditions.checkNotNull((Object)fishingOperation);
        Preconditions.checkState((!TuttiEntities.isNew(fishingOperation) ? 1 : 0) != 0);
        Batch catchBatch = this.getBatch(fishingOperation.getIdAsInt());
        Sample sample = this.samplePersistenceHelper.load(bean.getIdAsInt());
        if (sample == null) {
            throw new DataRetrievalFailureException("Could not retrieve sample id: " + bean.getId());
        }
        this.beanToEntity(bean, sample, catchBatch);
        this.samplePersistenceHelper.update(sample);
        return bean;
    }

    @Override
    public void deleteIndividualObservationBatch(String id) {
        Preconditions.checkNotNull((Object)id);
        Integer batchId = Integer.valueOf(id);
        if (log.isInfoEnabled()) {
            log.info((Object)("Will delete individual observation batch: " + batchId));
        }
        this.samplePersistenceHelper.deleteSample(batchId);
    }

    @Override
    public void deleteIndividualObservationBatchForFishingOperation(String fishingOperationId) {
        Preconditions.checkNotNull((Object)fishingOperationId);
        List<IndividualObservationBatch> batches = this.getAllIndividualObservationBatch(fishingOperationId);
        if (CollectionUtils.isNotEmpty(batches)) {
            for (IndividualObservationBatch batch : batches) {
                this.deleteIndividualObservationBatch(batch.getId());
            }
        }
    }

    protected void beanToEntity(IndividualObservationBatch source, Sample target, Batch vracSpeciesBatch) {
        Caracteristic caracteristic;
        if (TuttiEntities.isNew(source)) {
            fr.ifremer.adagio.core.dao.data.operation.FishingOperation fishingOperation = (fr.ifremer.adagio.core.dao.data.operation.FishingOperation)this.load(FishingOperationImpl.class, source.getFishingOperation().getIdAsInt());
            fishingOperation.getSamples().add(target);
            target.setFishingOperation(fishingOperation);
            String label = fishingOperation.getId() + "_" + source.getSpecies().getReferenceTaxonId();
            target.setLabel(label);
            Matrix matrix = (Matrix)this.load(MatrixImpl.class, this.enumeration.MATRIX_ID_PRODUCT_BATCH);
            target.setMatrix(matrix);
            target.setIndividualCount(Short.valueOf((short)1));
            target.setQualityFlag((QualityFlag)this.load(QualityFlagImpl.class, (Serializable)((Object)this.enumeration.QUALITY_FLAG_CODE_NOT_QUALIFIED)));
            if (target.getSampleDate() == null) {
                target.setSampleDate(fishingOperation.getFishingStartDateTime());
            }
            target.setCreationDate(fishingOperation.getFishingStartDateTime());
            target.setRecorderDepartment((Department)this.load(DepartmentImpl.class, this.enumeration.DEPARTMENT_ID_UNKNOWN_RECORDER_DEPARTMENT));
            target.setRecorderPerson((Person)this.load(PersonImpl.class, this.enumeration.PERSON_ID_UNKNOWN_RECORDER_PERSON));
            Program program = fishingOperation.getFishingTrip().getProgram();
            target.setProgram(program);
        }
        target.setId(source.getIdAsInt());
        target.setBatch(vracSpeciesBatch);
        target.setSynchronizationStatus(SynchronizationStatus.DIRTY.getValue());
        target.setComments(source.getComment());
        Species species = source.getSpecies();
        Integer referenceTaxonId = species.getReferenceTaxonId();
        target.setReferenceTaxon((ReferenceTaxon)this.load(ReferenceTaxonImpl.class, referenceTaxonId));
        CaracteristicMap caracteristics = CaracteristicMap.copy(source.getCaracteristics());
        if (source.getSamplingCode() != null) {
            caracteristic = this.referentialService.getSampleIdCaracteristic();
            caracteristics.put(caracteristic, source.getSamplingCode());
        }
        if (source.getCalcifiedPieceSamplingCode() != null) {
            caracteristic = this.referentialService.getOtolitheIdCaracteristic();
            caracteristics.put(caracteristic, source.getCalcifiedPieceSamplingCode());
        }
        if (source.getWeight() != null) {
            caracteristic = this.referentialService.getWeightMeasuredCaracteristic();
            caracteristics.put(caracteristic, source.getWeight());
        }
        if (source.getLengthStepCaracteristic() != null) {
            caracteristic = this.referentialService.getPmfmIdCaracteristic();
            caracteristics.put(caracteristic, source.getLengthStepCaracteristic().getId());
            caracteristics.put(source.getLengthStepCaracteristic(), source.getSize());
        }
        this.samplePersistenceHelper.setSampleMeasurements(target, caracteristics);
    }

    protected Batch getBatch(Integer operationId) {
        Preconditions.checkNotNull((Object)operationId);
        CatchBatch catchBatch = this.batchHelper.getRootCatchBatchByFishingOperationId(operationId.toString(), false);
        return catchBatch;
    }

    protected void fillSampleMeasurements(IndividualObservationBatch batch) {
        String lengthClassId;
        Float weight;
        CaracteristicMap result = batch.getCaracteristics();
        this.samplePersistenceHelper.fillSampleMeasurements(result, batch.getIdAsInt());
        String sampleCode = (String)result.remove(this.referentialService.getSampleIdCaracteristic());
        if (sampleCode != null) {
            batch.setSamplingCode(sampleCode);
        }
        String calcifiedPieceSampleCode = (String)result.remove(this.referentialService.getOtolitheIdCaracteristic());
        if (sampleCode != null) {
            batch.setCalcifiedPieceSamplingCode(calcifiedPieceSampleCode);
        }
        if ((weight = (Float)result.remove(this.referentialService.getWeightMeasuredCaracteristic())) != null) {
            batch.setWeight(weight);
        }
        if ((lengthClassId = (String)result.remove(this.referentialService.getPmfmIdCaracteristic())) != null) {
            Caracteristic lengthStepCaracteristic = this.referentialService.getCaracteristic(Integer.valueOf(lengthClassId));
            batch.setLengthStepCaracteristic(lengthStepCaracteristic);
            Serializable length = (Serializable)result.remove(lengthStepCaracteristic);
            batch.setSize((Float)length);
        }
    }
}

